/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReplaceGetClassWithClassLiteralFix
extends LocalQuickFixAndIntentionActionOnPsiElement
implements HighPriorityAction {
    private String myText;

    public ReplaceGetClassWithClassLiteralFix(PsiMethodCallExpression expression2) {
        super((PsiElement)expression2);
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            ReplaceGetClassWithClassLiteralFix.$$$reportNull$$$0(0);
        }
        if (file == null) {
            ReplaceGetClassWithClassLiteralFix.$$$reportNull$$$0(1);
        }
        if (startElement == null) {
            ReplaceGetClassWithClassLiteralFix.$$$reportNull$$$0(2);
        }
        if (endElement == null) {
            ReplaceGetClassWithClassLiteralFix.$$$reportNull$$$0(3);
        }
        PsiClass aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)startElement, PsiClass.class);
        assert (aClass != null);
        PsiExpression classLiteral = JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText(aClass.getName() + ".class", startElement);
        new CommentTracker().replaceAndRestoreComments(startElement, (PsiElement)classLiteral);
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiClass aClass;
        if (project == null) {
            ReplaceGetClassWithClassLiteralFix.$$$reportNull$$$0(4);
        }
        if (file == null) {
            ReplaceGetClassWithClassLiteralFix.$$$reportNull$$$0(5);
        }
        if (startElement == null) {
            ReplaceGetClassWithClassLiteralFix.$$$reportNull$$$0(6);
        }
        if (endElement == null) {
            ReplaceGetClassWithClassLiteralFix.$$$reportNull$$$0(7);
        }
        if ((aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)startElement, PsiClass.class)) == null) {
            return false;
        }
        String className2 = aClass.getName();
        if (className2 == null) {
            return false;
        }
        this.myText = "Replace with " + className2 + ".class";
        return super.isAvailable(project, file, startElement, endElement);
    }

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            ReplaceGetClassWithClassLiteralFix.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JavaAnalysisBundle.message((String)"replace.get.class.with.class.literal", (Object[])new Object[0]);
        if (string == null) {
            ReplaceGetClassWithClassLiteralFix.$$$reportNull$$$0(9);
        }
        return string;
    }

    public static void registerFix(PsiMethodCallExpression callExpression, HighlightInfo errorResult) {
        PsiMethod method;
        if (callExpression.getMethodExpression().getQualifierExpression() == null && (method = callExpression.resolveMethod()) != null && PsiTypesUtil.isGetClass((PsiMethod)method)) {
            QuickFixAction.registerQuickFixAction((HighlightInfo)errorResult, (IntentionAction)new ReplaceGetClassWithClassLiteralFix(callExpression));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/ReplaceGetClassWithClassLiteralFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/ReplaceGetClassWithClassLiteralFix";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

