/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReplaceWithListAccessFix
implements IntentionAction {
    private final PsiArrayAccessExpression myArrayAccessExpression;

    public ReplaceWithListAccessFix(@NotNull PsiArrayAccessExpression arrayAccessExpression) {
        if (arrayAccessExpression == null) {
            ReplaceWithListAccessFix.$$$reportNull$$$0(0);
        }
        this.myArrayAccessExpression = arrayAccessExpression;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("replace.with.list.access.text", new Object[0]);
        if (string == null) {
            ReplaceWithListAccessFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            ReplaceWithListAccessFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        PsiExpression lExpression;
        if (project == null) {
            ReplaceWithListAccessFix.$$$reportNull$$$0(3);
        }
        if (!this.myArrayAccessExpression.isValid()) {
            return false;
        }
        if (!TypeConversionUtil.areTypesAssignmentCompatible((PsiType)PsiType.INT, (PsiExpression)this.myArrayAccessExpression.getIndexExpression())) {
            return false;
        }
        PsiElement parent = this.myArrayAccessExpression.getParent();
        if (parent instanceof PsiAssignmentExpression && (lExpression = ((PsiAssignmentExpression)parent).getLExpression()).equals(this.myArrayAccessExpression) && !(parent.getParent() instanceof PsiExpressionStatement)) {
            return false;
        }
        PsiExpression arrayExpression = this.myArrayAccessExpression.getArrayExpression();
        PsiType type2 = arrayExpression.getType();
        PsiType listType = this.createUtilListType(project);
        if (type2 == null || listType == null) {
            return false;
        }
        return listType.isAssignableFrom(type2);
    }

    @Nullable
    private PsiType createUtilListType(@NotNull Project project) {
        if (project == null) {
            ReplaceWithListAccessFix.$$$reportNull$$$0(4);
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        PsiClass listClass = JavaPsiFacade.getInstance((Project)project).findClass("java.util.List", this.myArrayAccessExpression.getResolveScope());
        if (listClass == null) {
            return null;
        }
        PsiElementFactory factory = facade.getElementFactory();
        return factory.createType(listClass);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            ReplaceWithListAccessFix.$$$reportNull$$$0(5);
        }
        PsiExpression arrayExpression = this.myArrayAccessExpression.getArrayExpression();
        PsiExpression indexExpression = this.myArrayAccessExpression.getIndexExpression();
        if (indexExpression == null) {
            return;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        PsiElement parent = this.myArrayAccessExpression.getParent();
        if (parent instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
            PsiExpression lExpression = assignmentExpression.getLExpression();
            PsiExpression rExpression = assignmentExpression.getRExpression();
            if (lExpression.equals(this.myArrayAccessExpression) && parent.getParent() instanceof PsiExpressionStatement && rExpression != null) {
                ReplaceWithListAccessFix.replaceWithSet(factory, codeStyleManager, arrayExpression, indexExpression, rExpression, (PsiElement)assignmentExpression);
                return;
            }
        }
        ReplaceWithListAccessFix.replaceWithGet(factory, codeStyleManager, arrayExpression, indexExpression, (PsiElement)this.myArrayAccessExpression);
    }

    @NotNull
    private static PsiElement replaceWithGet(@NotNull PsiElementFactory factory, @NotNull CodeStyleManager codeStyleManager, @NotNull PsiExpression arrayExpression, @NotNull PsiExpression indexExpression, @NotNull PsiElement anchor) {
        if (factory == null) {
            ReplaceWithListAccessFix.$$$reportNull$$$0(6);
        }
        if (codeStyleManager == null) {
            ReplaceWithListAccessFix.$$$reportNull$$$0(7);
        }
        if (arrayExpression == null) {
            ReplaceWithListAccessFix.$$$reportNull$$$0(8);
        }
        if (indexExpression == null) {
            ReplaceWithListAccessFix.$$$reportNull$$$0(9);
        }
        if (anchor == null) {
            ReplaceWithListAccessFix.$$$reportNull$$$0(10);
        }
        PsiExpression listAccess = factory.createExpressionFromText(arrayExpression.getText() + ".get(" + indexExpression.getText() + ")", anchor);
        PsiElement psiElement = anchor.replace(codeStyleManager.reformat((PsiElement)listAccess));
        if (psiElement == null) {
            ReplaceWithListAccessFix.$$$reportNull$$$0(11);
        }
        return psiElement;
    }

    private static PsiElement replaceWithSet(@NotNull PsiElementFactory factory, @NotNull CodeStyleManager codeStyleManager, @NotNull PsiExpression arrayExpression, @NotNull PsiExpression indexExpression, @NotNull PsiExpression expression2, @NotNull PsiElement anchor) {
        if (factory == null) {
            ReplaceWithListAccessFix.$$$reportNull$$$0(12);
        }
        if (codeStyleManager == null) {
            ReplaceWithListAccessFix.$$$reportNull$$$0(13);
        }
        if (arrayExpression == null) {
            ReplaceWithListAccessFix.$$$reportNull$$$0(14);
        }
        if (indexExpression == null) {
            ReplaceWithListAccessFix.$$$reportNull$$$0(15);
        }
        if (expression2 == null) {
            ReplaceWithListAccessFix.$$$reportNull$$$0(16);
        }
        if (anchor == null) {
            ReplaceWithListAccessFix.$$$reportNull$$$0(17);
        }
        PsiExpression listAccess = factory.createExpressionFromText(arrayExpression.getText() + ".set(" + indexExpression.getText() + "," + expression2.getText() + ")", anchor);
        return anchor.replace(codeStyleManager.reformat((PsiElement)listAccess));
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayAccessExpression";
                break;
            }
            case 1: 
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/ReplaceWithListAccessFix";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeStyleManager";
                break;
            }
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayExpression";
                break;
            }
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexExpression";
                break;
            }
            case 10: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/ReplaceWithListAccessFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceWithGet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 11: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createUtilListType";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "replaceWithGet";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "replaceWithSet";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

