/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.smartEnter.Fixer;
import com.intellij.codeInsight.editorActions.smartEnter.JavaSmartEnterProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.util.IncorrectOperationException;

public class MissingArrayConstructorBracketFixer
implements Fixer {
    @Override
    public void apply(Editor editor, JavaSmartEnterProcessor processor, PsiElement psiElement) throws IncorrectOperationException {
        if (!(psiElement instanceof PsiNewExpression)) {
            return;
        }
        PsiNewExpression expr2 = (PsiNewExpression)psiElement;
        int count = 0;
        for (PsiElement element = expr2.getFirstChild(); element != null; element = element.getNextSibling()) {
            if (element.getNode().getElementType() == JavaTokenType.LBRACKET) {
                ++count;
                continue;
            }
            if (element.getNode().getElementType() != JavaTokenType.RBRACKET) continue;
            --count;
        }
        if (count > 0) {
            editor.getDocument().insertString(psiElement.getTextRange().getEndOffset(), (CharSequence)"]");
        }
    }
}

