/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.generation.GenerationInfo;
import com.intellij.codeInsight.generation.GenerationInfoBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiGenerationInfo<T extends PsiMember>
extends GenerationInfoBase
implements GenerationInfo {
    private SmartPsiElementPointer<T> myMember;
    private final boolean myMergeIfExists;
    private static final Logger LOG = Logger.getInstance(PsiGenerationInfo.class);

    public PsiGenerationInfo(@NotNull T member) {
        if (member == null) {
            PsiGenerationInfo.$$$reportNull$$$0(0);
        }
        this(member, true);
    }

    public PsiGenerationInfo(@NotNull T member, boolean mergeIfExists) {
        if (member == null) {
            PsiGenerationInfo.$$$reportNull$$$0(1);
        }
        this.setMember(member);
        this.myMergeIfExists = mergeIfExists;
    }

    private void setMember(@NotNull T member) {
        if (member == null) {
            PsiGenerationInfo.$$$reportNull$$$0(2);
        }
        this.myMember = SmartPointerManager.getInstance((Project)member.getProject()).createSmartPsiElementPointer(member);
    }

    public final T getPsiMember() {
        return (T)((PsiMember)this.myMember.getElement());
    }

    @Override
    public void insert(@NotNull PsiClass aClass, @Nullable PsiElement anchor, boolean before2) throws IncorrectOperationException {
        PsiMember member;
        Object existingMember;
        if (aClass == null) {
            PsiGenerationInfo.$$$reportNull$$$0(3);
        }
        if ((existingMember = (member = (PsiMember)Objects.requireNonNull(this.getPsiMember())) instanceof PsiField ? aClass.findFieldByName(member.getName(), false) : (member instanceof PsiMethod ? aClass.findMethodBySignature((PsiMethod)member, false) : null)) == null || !existingMember.isPhysical() || !this.myMergeIfExists) {
            PsiElement newMember = GenerateMembersUtil.insert(aClass, member, anchor, before2);
            member = (PsiMember)JavaCodeStyleManager.getInstance((Project)aClass.getProject()).shortenClassReferences(newMember);
            LOG.assertTrue(member.isValid(), (Object)member);
        } else {
            PsiModifierList modifierList = member.getModifierList();
            PsiModifierList existingModifierList = existingMember.getModifierList();
            if (modifierList != null && existingModifierList != null) {
                PsiElement annoAnchor;
                PsiAnnotation[] psiAnnotations = modifierList.getAnnotations();
                Object object = annoAnchor = existingModifierList.getAnnotations().length > 0 ? existingModifierList.getAnnotations()[0] : existingModifierList.getFirstChild();
                if (psiAnnotations.length > 0) {
                    for (PsiAnnotation annotation : psiAnnotations) {
                        PsiAnnotation existingAnno = existingModifierList.findAnnotation(annotation.getQualifiedName());
                        if (existingAnno != null) {
                            annoAnchor = existingAnno.replace((PsiElement)annotation);
                            continue;
                        }
                        existingModifierList.addBefore((PsiElement)annotation, annoAnchor);
                    }
                }
            }
            if (!(member = existingMember).isValid()) {
                LOG.error("invalid member: " + member + " existing member: " + existingMember.isValid() + " self modified list: " + modifierList + " existing modified list: " + existingModifierList);
            }
        }
        this.setMember(member);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/generation/PsiGenerationInfo";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setMember";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "insert";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

