/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.MemberChooserObject;
import com.intellij.codeInsight.generation.PsiDocCommentOwnerMemberChooserObject;
import com.intellij.openapi.project.Project;
import com.intellij.pom.PomNamedTarget;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.ui.SimpleColoredComponent;
import javax.swing.JTree;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class RecordConstructorMember
implements ClassMember {
    private final PsiClass myRecord;
    private final boolean myCompact;

    public RecordConstructorMember(PsiClass aRecord, boolean compact) {
        this.myRecord = aRecord;
        this.myCompact = compact;
    }

    public MemberChooserObject getParentNodeDelegate() {
        String text2 = PsiFormatUtil.formatClass((PsiClass)this.myRecord, (int)2049);
        return new PsiDocCommentOwnerMemberChooserObject((PsiDocCommentOwner)this.myRecord, text2, this.myRecord.getIcon(0));
    }

    public void renderTreeNode(SimpleColoredComponent component, JTree tree) {
    }

    public boolean isCompact() {
        return this.myCompact;
    }

    @NotNull
    public String getText() {
        return this.myCompact ? "Compact constructor" : "Canonical constructor";
    }

    @NotNull
    public PsiMethod generateRecordConstructor() {
        String constructor;
        if (this.myCompact) {
            constructor = "public " + this.myRecord.getName() + "{\n}";
        } else {
            Object[] components = this.myRecord.getRecordComponents();
            String parameters2 = StreamEx.of((Object[])components).map(PsiElement::getText).joining((CharSequence)",", (CharSequence)"(", (CharSequence)")");
            String body2 = StreamEx.of((Object[])components).map(PomNamedTarget::getName).map(name2 -> "this." + name2 + "=" + name2 + ";\n").joining((CharSequence)"", (CharSequence)"{", (CharSequence)"}");
            constructor = "public " + this.myRecord.getName() + parameters2 + body2;
        }
        Project project = this.myRecord.getProject();
        PsiMethod ctor = JavaPsiFacade.getElementFactory((Project)project).createMethodFromText(constructor, (PsiElement)this.myRecord);
        if (!this.myCompact) {
            JavaCodeStyleSettings settings = JavaCodeStyleSettings.getInstance(this.myRecord.getContainingFile());
            boolean finalParameters = settings.isGenerateFinalParameters();
            PsiParameterList parameterList = ctor.getParameterList();
            for (PsiParameter parameter2 : parameterList.getParameters()) {
                PsiModifierList modifierList = parameter2.getModifierList();
                if (modifierList == null) continue;
                modifierList.setModifierProperty("final", finalParameters);
                PsiAnnotation.TargetType[] targets = AnnotationTargetUtil.getTargetsForLocation((PsiAnnotationOwner)modifierList);
                for (PsiAnnotation annotation : parameter2.getAnnotations()) {
                    PsiAnnotation.TargetType applicable = AnnotationTargetUtil.findAnnotationTarget((PsiAnnotation)annotation, (PsiAnnotation.TargetType[])targets);
                    if (applicable != null) continue;
                    annotation.delete();
                }
            }
        }
        CodeStyleManager.getInstance((Project)project).reformat((PsiElement)ctor);
        PsiMethod psiMethod = ctor;
        if (psiMethod == null) {
            RecordConstructorMember.$$$reportNull$$$0(0);
        }
        return psiMethod;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/generation/RecordConstructorMember", "generateRecordConstructor"));
    }
}

