/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerFactoryBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.impl.light.LightRecordMember;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightRecordComponentsRecordFactory
extends HighlightUsagesHandlerFactoryBase {
    @Nullable
    public HighlightUsagesHandlerBase<?> createHighlightUsagesHandler(@NotNull Editor editor, @NotNull PsiFile file, @NotNull PsiElement target) {
        if (editor == null) {
            HighlightRecordComponentsRecordFactory.$$$reportNull$$$0(0);
        }
        if (file == null) {
            HighlightRecordComponentsRecordFactory.$$$reportNull$$$0(1);
        }
        if (target == null) {
            HighlightRecordComponentsRecordFactory.$$$reportNull$$$0(2);
        }
        if (!(target instanceof PsiIdentifier)) {
            return null;
        }
        PsiElement parent = target.getParent();
        if (!(parent instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiElement resolved = ((PsiReferenceExpression)parent).resolve();
        if (!(resolved instanceof LightRecordMember)) {
            return null;
        }
        LightRecordMember member = (LightRecordMember)resolved;
        PsiRecordComponent component = member.getRecordComponent();
        return new RecordComponentHighlightUsagesHandler(editor, file, component);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "target";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/highlighting/HighlightRecordComponentsRecordFactory";
        objectArray[2] = "createHighlightUsagesHandler";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class RecordComponentHighlightUsagesHandler
    extends HighlightUsagesHandlerBase<PsiRecordComponent> {
        private final PsiRecordComponent myComponent;

        RecordComponentHighlightUsagesHandler(Editor editor, PsiFile file, PsiRecordComponent component) {
            super(editor, file);
            this.myComponent = component;
        }

        public List<PsiRecordComponent> getTargets() {
            return Collections.singletonList(this.myComponent);
        }

        protected void selectTargets(List<PsiRecordComponent> targets, Consumer<List<PsiRecordComponent>> selectionConsumer) {
            selectionConsumer.consume(targets);
        }

        public void computeUsages(List<PsiRecordComponent> targets) {
            assert (targets.size() == 1);
            PsiRecordComponent record = targets.get(0);
            PsiIdentifier nameIdentifier = record.getNameIdentifier();
            if (nameIdentifier != null) {
                this.addOccurrence((PsiElement)nameIdentifier);
                final String name2 = nameIdentifier.getText();
                final Consumer onOccurence = expr2 -> this.addOccurrence((PsiElement)expr2);
                JavaRecursiveElementWalkingVisitor visitor2 = new JavaRecursiveElementWalkingVisitor(){

                    public void visitReferenceExpression(PsiReferenceExpression expression2) {
                        super.visitReferenceExpression(expression2);
                        if (this.isReferenceToRecordComponent(name2, expression2)) {
                            onOccurence.consume((Object)expression2);
                        }
                    }
                };
                this.myComponent.getContainingFile().accept((PsiElementVisitor)visitor2);
            }
        }

        private boolean isReferenceToRecordComponent(String name2, PsiReferenceExpression referenceExpression) {
            if (!name2.equals(referenceExpression.getReferenceName())) {
                return false;
            }
            LightRecordMember recordMember = (LightRecordMember)ObjectUtils.tryCast((Object)referenceExpression.resolve(), LightRecordMember.class);
            if (recordMember == null) {
                return false;
            }
            return recordMember.getRecordComponent() == this.myComponent;
        }
    }
}

