/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.daemon.impl.analysis.AnnotationsHighlightUtil;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.lang.findUsages.LanguageFindUsages;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddAnnotationPsiFix
extends LocalQuickFixOnPsiElement {
    protected final String myAnnotation;
    private final String[] myAnnotationsToRemove;
    private final PsiNameValuePair[] myPairs;
    protected final String myText;
    private final ExternalAnnotationsManager.AnnotationPlace myAnnotationPlace;

    public AddAnnotationPsiFix(@NotNull String fqn, @NotNull PsiModifierListOwner modifierListOwner, PsiNameValuePair @NotNull [] values, String ... annotationsToRemove) {
        if (fqn == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(0);
        }
        if (modifierListOwner == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(1);
        }
        if (values == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(2);
        }
        if (annotationsToRemove == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(3);
        }
        super((PsiElement)modifierListOwner);
        this.myAnnotation = fqn;
        ObjectUtils.assertAllElementsNotNull((Object[])values);
        this.myPairs = values;
        ObjectUtils.assertAllElementsNotNull((Object[])annotationsToRemove);
        this.myAnnotationsToRemove = annotationsToRemove;
        this.myText = AddAnnotationPsiFix.calcText(modifierListOwner, this.myAnnotation);
        this.myAnnotationPlace = this.choosePlace(modifierListOwner);
    }

    public static String calcText(PsiModifierListOwner modifierListOwner, @Nullable String annotation) {
        String name2;
        String shortName;
        String string = shortName = annotation == null ? null : annotation.substring(annotation.lastIndexOf(46) + 1);
        if (modifierListOwner instanceof PsiNamedElement && (name2 = ((PsiNamedElement)modifierListOwner).getName()) != null) {
            String type2 = LanguageFindUsages.getType((PsiElement)modifierListOwner);
            if (shortName == null) {
                return JavaAnalysisBundle.message((String)"inspection.i18n.quickfix.annotate.element", (Object[])new Object[]{type2, name2});
            }
            return JavaAnalysisBundle.message((String)"inspection.i18n.quickfix.annotate.element.as", (Object[])new Object[]{type2, name2, shortName});
        }
        if (shortName == null) {
            return JavaAnalysisBundle.message((String)"inspection.i18n.quickfix.annotate", (Object[])new Object[0]);
        }
        return JavaAnalysisBundle.message((String)"inspection.i18n.quickfix.annotate.as", (Object[])new Object[]{shortName});
    }

    @Nullable
    public static PsiModifierListOwner getContainer(PsiFile file, int offset) {
        return AddAnnotationPsiFix.getContainer(file, offset, false);
    }

    @Nullable
    public static PsiModifierListOwner getContainer(PsiFile file, int offset, boolean availableOnReference) {
        PsiElement id;
        PsiElement target;
        PsiReference reference;
        PsiReference psiReference = reference = availableOnReference ? file.findReferenceAt(offset) : null;
        if (reference != null && (target = reference.resolve()) instanceof PsiMember) {
            return (PsiMember)target;
        }
        PsiElement element = file.findElementAt(offset);
        PsiModifierListOwner listOwner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)element, PsiModifierListOwner.class, (boolean)false);
        if (listOwner instanceof PsiParameter) {
            return listOwner;
        }
        if (listOwner instanceof PsiNameIdentifierOwner && (id = ((PsiNameIdentifierOwner)listOwner).getNameIdentifier()) != null && id.getTextRange().containsOffset(offset)) {
            return listOwner;
        }
        return null;
    }

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = JavaAnalysisBundle.message((String)"intention.add.annotation.family", (Object[])new Object[0]);
        if (string == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(5);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(6);
        }
        if (file == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(7);
        }
        if (startElement == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(8);
        }
        if (endElement == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(9);
        }
        return AddAnnotationPsiFix.isAvailable((PsiModifierListOwner)startElement, this.myAnnotation);
    }

    public static boolean isAvailable(@NotNull PsiModifierListOwner modifierListOwner, @NotNull String annotationFQN) {
        if (modifierListOwner == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(10);
        }
        if (annotationFQN == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(11);
        }
        if (!modifierListOwner.isValid()) {
            return false;
        }
        if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)modifierListOwner)) {
            return false;
        }
        if (modifierListOwner instanceof PsiParameter && ((PsiParameter)modifierListOwner).getTypeElement() == null) {
            if (modifierListOwner.getParent() instanceof PsiParameterList && modifierListOwner.getParent().getParent() instanceof PsiLambdaExpression) {
                if (PsiUtil.isLanguageLevel11OrHigher((PsiElement)modifierListOwner)) {
                    return true;
                }
                PsiLambdaExpression lambda2 = (PsiLambdaExpression)modifierListOwner.getParent().getParent();
                return LambdaUtil.createLambdaParameterListWithFormalTypes((PsiType)lambda2.getFunctionalInterfaceType(), (PsiLambdaExpression)lambda2, (boolean)false) != null;
            }
            return false;
        }
        PsiModifierList modifierList = modifierListOwner.getModifierList();
        return modifierList != null && !(modifierList instanceof LightElement) && !(modifierListOwner instanceof LightElement) && !AnnotationUtil.isAnnotated((PsiModifierListOwner)modifierListOwner, (String)annotationFQN, (int)10);
    }

    public boolean startInWriteAction() {
        return this.myAnnotationPlace == ExternalAnnotationsManager.AnnotationPlace.IN_CODE;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiModifierListOwner myModifierListOwner;
        PsiAnnotationOwner target;
        if (project == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(12);
        }
        if (file == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(13);
        }
        if (startElement == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(14);
        }
        if (endElement == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(15);
        }
        if ((target = AnnotationTargetUtil.getTarget((PsiModifierListOwner)(myModifierListOwner = (PsiModifierListOwner)startElement), (String)this.myAnnotation)) == null || target.hasAnnotation(this.myAnnotation)) {
            return;
        }
        ExternalAnnotationsManager annotationsManager = ExternalAnnotationsManager.getInstance((Project)project);
        ExternalAnnotationsManager.AnnotationPlace place = this.myAnnotationPlace == ExternalAnnotationsManager.AnnotationPlace.NEED_ASK_USER ? annotationsManager.chooseAnnotationsPlace((PsiElement)myModifierListOwner) : this.myAnnotationPlace;
        switch (place) {
            case NOWHERE: {
                return;
            }
            case EXTERNAL: {
                for (String fqn : this.myAnnotationsToRemove) {
                    annotationsManager.deannotate(myModifierListOwner, fqn);
                }
                try {
                    annotationsManager.annotateExternally(myModifierListOwner, this.myAnnotation, file, this.myPairs);
                }
                catch (ExternalAnnotationsManager.CanceledConfigurationException canceledConfigurationException) {}
                break;
            }
            case IN_CODE: {
                PsiFile containingFile = myModifierListOwner.getContainingFile();
                WriteCommandAction.runWriteCommandAction((Project)project, null, null, () -> {
                    AddAnnotationPsiFix.removePhysicalAnnotations(myModifierListOwner, this.myAnnotationsToRemove);
                    PsiAnnotation inserted = AddAnnotationPsiFix.addPhysicalAnnotationTo(this.myAnnotation, this.myPairs, target);
                    JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)inserted);
                }, (PsiFile[])new PsiFile[]{containingFile});
                if (containingFile == file) break;
                UndoUtil.markPsiFileForUndo((PsiFile)file);
            }
        }
    }

    @NotNull
    private ExternalAnnotationsManager.AnnotationPlace choosePlace(@NotNull PsiModifierListOwner modifierListOwner) {
        if (modifierListOwner == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(16);
        }
        Project project = modifierListOwner.getProject();
        ExternalAnnotationsManager annotationsManager = ExternalAnnotationsManager.getInstance((Project)project);
        PsiClass aClass = JavaPsiFacade.getInstance((Project)project).findClass(this.myAnnotation, modifierListOwner.getResolveScope());
        if (aClass != null && BaseIntentionAction.canModify((PsiElement)modifierListOwner)) {
            PsiClass resolvedBySimpleName;
            if (AnnotationsHighlightUtil.getRetentionPolicy(aClass) == RetentionPolicy.RUNTIME) {
                ExternalAnnotationsManager.AnnotationPlace annotationPlace = ExternalAnnotationsManager.AnnotationPlace.IN_CODE;
                if (annotationPlace == null) {
                    AddAnnotationPsiFix.$$$reportNull$$$0(17);
                }
                return annotationPlace;
            }
            if (!"java.lang".equals(StringUtil.getPackageName((String)this.myAnnotation)) && (resolvedBySimpleName = JavaPsiFacade.getInstance((Project)project).getResolveHelper().resolveReferencedClass(StringUtil.getShortName((String)this.myAnnotation), (PsiElement)modifierListOwner)) != null && resolvedBySimpleName.getManager().areElementsEquivalent((PsiElement)resolvedBySimpleName, (PsiElement)aClass)) {
                ExternalAnnotationsManager.AnnotationPlace annotationPlace = ExternalAnnotationsManager.AnnotationPlace.IN_CODE;
                if (annotationPlace == null) {
                    AddAnnotationPsiFix.$$$reportNull$$$0(18);
                }
                return annotationPlace;
            }
        }
        ExternalAnnotationsManager.AnnotationPlace annotationPlace = annotationsManager.chooseAnnotationsPlaceNoUi((PsiElement)modifierListOwner);
        if (annotationPlace == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(19);
        }
        return annotationPlace;
    }

    public static PsiAnnotation addPhysicalAnnotation(String fqn, PsiNameValuePair[] pairs, PsiModifierList modifierList) {
        return AddAnnotationPsiFix.addPhysicalAnnotationTo(fqn, pairs, (PsiAnnotationOwner)modifierList);
    }

    public static PsiAnnotation addPhysicalAnnotationTo(String fqn, PsiNameValuePair[] pairs, PsiAnnotationOwner owner2) {
        owner2 = AddAnnotationPsiFix.expandParameterIfNecessary(owner2);
        PsiAnnotation inserted = owner2.addAnnotation(fqn);
        for (PsiNameValuePair pair2 : pairs) {
            inserted.setDeclaredAttributeValue(pair2.getName(), pair2.getValue());
        }
        return inserted;
    }

    private static PsiAnnotationOwner expandParameterIfNecessary(PsiAnnotationOwner owner2) {
        PsiParameterList list;
        PsiParameter parameter2;
        if (owner2 instanceof PsiModifierList && (parameter2 = (PsiParameter)ObjectUtils.tryCast((Object)((PsiModifierList)owner2).getParent(), PsiParameter.class)) != null && parameter2.getTypeElement() == null && (list = (PsiParameterList)ObjectUtils.tryCast((Object)parameter2.getParent(), PsiParameterList.class)) != null && list.getParent() instanceof PsiLambdaExpression) {
            PsiParameterList newList;
            Object[] parameters2 = list.getParameters();
            int index = ArrayUtil.indexOf((Object[])parameters2, (Object)parameter2);
            if (PsiUtil.isLanguageLevel11OrHigher((PsiElement)list)) {
                String newListText = StreamEx.of((Object[])parameters2).map(p -> "var " + p.getName()).joining((CharSequence)",", (CharSequence)"(", (CharSequence)")");
                newList = ((PsiLambdaExpression)JavaPsiFacade.getElementFactory((Project)list.getProject()).createExpressionFromText(newListText + " -> {}", null)).getParameterList();
                newList = (PsiParameterList)new CommentTracker().replaceAndRestoreComments((PsiElement)list, (PsiElement)newList);
            } else {
                newList = LambdaUtil.specifyLambdaParameterTypes((PsiLambdaExpression)((PsiLambdaExpression)list.getParent()));
            }
            if (newList != null) {
                list = newList;
                parameter2 = list.getParameter(index);
                LOG.assertTrue(parameter2 != null);
                owner2 = parameter2.getModifierList();
                LOG.assertTrue(owner2 != null);
            }
        }
        return owner2;
    }

    public static void removePhysicalAnnotations(@NotNull PsiModifierListOwner owner2, String ... fqns) {
        if (owner2 == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(20);
        }
        if (fqns == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(21);
        }
        for (String fqn : fqns) {
            PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)owner2, (boolean)true, (String[])new String[]{fqn});
            if (annotation == null || AnnotationUtil.isInferredAnnotation((PsiAnnotation)annotation)) continue;
            annotation.delete();
        }
    }

    protected String @NotNull [] getAnnotationsToRemove() {
        if (this.myAnnotationsToRemove == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(22);
        }
        return this.myAnnotationsToRemove;
    }

    public static boolean isNullabilityAnnotationApplicable(@NotNull PsiModifierListOwner owner2) {
        if (owner2 == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(23);
        }
        if (owner2 instanceof PsiMethod) {
            PsiType returnType = ((PsiMethod)owner2).getReturnType();
            return returnType != null && !(returnType instanceof PsiPrimitiveType);
        }
        return !(owner2 instanceof PsiClass);
    }

    @Nullable
    public static AddAnnotationPsiFix createAddNullableFix(PsiModifierListOwner owner2) {
        NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)owner2.getProject());
        return AddAnnotationPsiFix.createAddNullableNotNullFix(owner2, manager.getDefaultNullable(), manager.getNotNulls());
    }

    @Nullable
    public static AddAnnotationPsiFix createAddNotNullFix(PsiModifierListOwner owner2) {
        NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)owner2.getProject());
        return AddAnnotationPsiFix.createAddNullableNotNullFix(owner2, manager.getDefaultNotNull(), manager.getNullables());
    }

    @Nullable
    private static AddAnnotationPsiFix createAddNullableNotNullFix(PsiModifierListOwner owner2, String annotationToAdd, List<String> annotationsToRemove) {
        if (!AddAnnotationPsiFix.isNullabilityAnnotationApplicable(owner2)) {
            return null;
        }
        return new AddAnnotationPsiFix(annotationToAdd, owner2, PsiNameValuePair.EMPTY_ARRAY, ArrayUtilRt.toStringArray(annotationsToRemove));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 17: 
            case 18: 
            case 19: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 17: 
            case 18: 
            case 19: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 1: 
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierListOwner";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationsToRemove";
                break;
            }
            case 4: 
            case 5: 
            case 17: 
            case 18: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/AddAnnotationPsiFix";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationFQN";
                break;
            }
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/AddAnnotationPsiFix";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "choosePlace";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationsToRemove";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 17: 
            case 18: 
            case 19: 
            case 22: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "choosePlace";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "removePhysicalAnnotations";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isNullabilityAnnotationApplicable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 17: 
            case 18: 
            case 19: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

