/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.openapi.editor.actions.FlipCommaIntention;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ipp.psiutils.ErrorUtil;
import org.jetbrains.annotations.NotNull;

public class JavaFlipper
implements FlipCommaIntention.Flipper {
    public boolean flip(@NotNull PsiElement left, @NotNull PsiElement right) {
        if (left == null) {
            JavaFlipper.$$$reportNull$$$0(0);
        }
        if (right == null) {
            JavaFlipper.$$$reportNull$$$0(1);
        }
        if (left instanceof PsiVariable && right instanceof PsiVariable) {
            if (left instanceof PsiParameter || right instanceof PsiParameter) {
                return false;
            }
            if (left instanceof PsiEnumConstant && ErrorUtil.containsDeepError(left) || right instanceof PsiEnumConstant && ErrorUtil.containsDeepError(right)) {
                return false;
            }
            PsiVariable leftVariable = (PsiVariable)left;
            PsiVariable rightVariable = (PsiVariable)right;
            PsiIdentifier leftIdentifier = leftVariable.getNameIdentifier();
            assert (leftIdentifier != null);
            PsiIdentifier rightIdentifier = rightVariable.getNameIdentifier();
            assert (rightIdentifier != null);
            PsiElement leftLast = leftVariable.getLastChild();
            leftLast = PsiUtil.isJavaToken((PsiElement)leftLast, (IElementType)JavaTokenType.SEMICOLON) ? leftLast.getPrevSibling() : leftLast;
            PsiElement rightLast = rightVariable.getLastChild();
            rightLast = PsiUtil.isJavaToken((PsiElement)rightLast, (IElementType)JavaTokenType.SEMICOLON) ? rightLast.getPrevSibling() : rightLast;
            left.addRangeBefore((PsiElement)rightIdentifier, rightLast, (PsiElement)leftIdentifier);
            right.addRangeBefore((PsiElement)leftIdentifier, leftLast, (PsiElement)rightIdentifier);
            left.deleteChildRange((PsiElement)leftIdentifier, leftLast);
            right.deleteChildRange((PsiElement)rightIdentifier, rightLast);
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "left";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "right";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/intention/impl/JavaFlipper";
        objectArray[2] = "flip";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

