/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.JavaClassSupers;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SameErasureButDifferentMethodsFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private final SmartPsiElementPointer<PsiMethod> methodPtr;

    public SameErasureButDifferentMethodsFix(@NotNull PsiMethod method, @NotNull PsiMethod superMethod) {
        if (method == null) {
            SameErasureButDifferentMethodsFix.$$$reportNull$$$0(0);
        }
        if (superMethod == null) {
            SameErasureButDifferentMethodsFix.$$$reportNull$$$0(1);
        }
        super((PsiElement)superMethod);
        this.methodPtr = SmartPointerManager.getInstance((Project)method.getProject()).createSmartPsiElementPointer((PsiElement)method);
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiParameter[] superParameters;
        if (project == null) {
            SameErasureButDifferentMethodsFix.$$$reportNull$$$0(2);
        }
        if (file == null) {
            SameErasureButDifferentMethodsFix.$$$reportNull$$$0(3);
        }
        if (startElement == null) {
            SameErasureButDifferentMethodsFix.$$$reportNull$$$0(4);
        }
        if (endElement == null) {
            SameErasureButDifferentMethodsFix.$$$reportNull$$$0(5);
        }
        if (!this.isAvailable(project, file, startElement, endElement)) {
            return;
        }
        PsiMethod superMethod = (PsiMethod)startElement;
        PsiMethod method = (PsiMethod)this.methodPtr.getElement();
        if (method == null || !method.isValid()) {
            return;
        }
        PsiClass containingClass = method.getContainingClass();
        PsiClass superContainingClass = superMethod.getContainingClass();
        if (containingClass == null || superContainingClass == null) {
            return;
        }
        PsiSubstitutor superSubstitutor = JavaClassSupers.getInstance().getSuperClassSubstitutor(superContainingClass, containingClass, containingClass.getResolveScope(), PsiSubstitutor.EMPTY);
        if (superSubstitutor == null) {
            return;
        }
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        if (parameters2.length != (superParameters = superMethod.getParameterList().getParameters()).length) {
            return;
        }
        ParameterInfoImpl[] infos = new ParameterInfoImpl[parameters2.length];
        for (int i = 0; i < parameters2.length; ++i) {
            PsiParameter parameter2 = parameters2[i];
            PsiParameter superParameter = superParameters[i];
            PsiType superParameterType = superSubstitutor.substitute(superParameter.getType());
            infos[i] = ParameterInfoImpl.create(i).withName(parameter2.getName()).withType(superParameterType);
        }
        ChangeSignatureProcessor processor = new ChangeSignatureProcessor(project, method, false, null, method.getName(), method.getReturnType(), infos);
        processor.run();
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            SameErasureButDifferentMethodsFix.$$$reportNull$$$0(6);
        }
        if (file == null) {
            SameErasureButDifferentMethodsFix.$$$reportNull$$$0(7);
        }
        if (startElement == null) {
            SameErasureButDifferentMethodsFix.$$$reportNull$$$0(8);
        }
        if (endElement == null) {
            SameErasureButDifferentMethodsFix.$$$reportNull$$$0(9);
        }
        PsiMethod superMethod = (PsiMethod)startElement;
        PsiMethod method = (PsiMethod)this.methodPtr.getElement();
        if (method == null || !method.isValid()) {
            return false;
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        PsiClass containingClass = method.getContainingClass();
        PsiClass superContainingClass = superMethod.getContainingClass();
        if (containingClass == null || superContainingClass == null) {
            return false;
        }
        if (!facade.getResolveHelper().isAccessible((PsiMember)superMethod, (PsiElement)containingClass, null)) {
            return false;
        }
        MethodSignature signature = method.getSignature(PsiSubstitutor.EMPTY);
        PsiSubstitutor superSubstitutor = JavaClassSupers.getInstance().getSuperClassSubstitutor(superContainingClass, containingClass, containingClass.getResolveScope(), PsiSubstitutor.EMPTY);
        if (superSubstitutor == null) {
            return false;
        }
        MethodSignature superSignature = superMethod.getSignature(superSubstitutor);
        if (method.getParameterList().getParametersCount() != superMethod.getParameterList().getParametersCount()) {
            return false;
        }
        return !signature.equals(superSignature) && MethodSignatureUtil.areSignaturesErasureEqual((MethodSignature)signature, (MethodSignature)superSignature);
    }

    @NotNull
    public String getText() {
        PsiMethod method = (PsiMethod)this.methodPtr.getElement();
        if (method == null || !method.isValid()) {
            String string = this.getFamilyName();
            if (string == null) {
                SameErasureButDifferentMethodsFix.$$$reportNull$$$0(10);
            }
            return string;
        }
        String string = JavaBundle.message((String)"intention.text.fix.method.0.parameters.with.bounded.wildcards", (Object[])new Object[]{method.getName()});
        if (string == null) {
            SameErasureButDifferentMethodsFix.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JavaBundle.message((String)"intention.family.fix.bounded.wildcards", (Object[])new Object[0]);
        if (string == null) {
            SameErasureButDifferentMethodsFix.$$$reportNull$$$0(12);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superMethod";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/SameErasureButDifferentMethodsFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/SameErasureButDifferentMethodsFix";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

