/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl.config;

import com.intellij.codeInsight.CodeInsightWorkspaceSettings;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.DaemonListeners;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.LocalInspectionsPass;
import com.intellij.codeInsight.daemon.impl.analysis.IncreaseLanguageLevelFix;
import com.intellij.codeInsight.daemon.impl.quickfix.AccessStaticViaInstanceFix;
import com.intellij.codeInsight.daemon.impl.quickfix.AddAnnotationAttributeNameFix;
import com.intellij.codeInsight.daemon.impl.quickfix.AddDefaultConstructorFix;
import com.intellij.codeInsight.daemon.impl.quickfix.AddEmptyRecordHeaderFix;
import com.intellij.codeInsight.daemon.impl.quickfix.AddExceptionFromFieldInitializerToConstructorThrowsFix;
import com.intellij.codeInsight.daemon.impl.quickfix.AddExceptionToCatchFix;
import com.intellij.codeInsight.daemon.impl.quickfix.AddExceptionToExistingCatchFix;
import com.intellij.codeInsight.daemon.impl.quickfix.AddExceptionToThrowsFix;
import com.intellij.codeInsight.daemon.impl.quickfix.AddMethodBodyFix;
import com.intellij.codeInsight.daemon.impl.quickfix.AddMethodFix;
import com.intellij.codeInsight.daemon.impl.quickfix.AddMethodQualifierFix;
import com.intellij.codeInsight.daemon.impl.quickfix.AddMissingRequiredAnnotationParametersFix;
import com.intellij.codeInsight.daemon.impl.quickfix.AddNewArrayExpressionFix;
import com.intellij.codeInsight.daemon.impl.quickfix.AddParameterListFix;
import com.intellij.codeInsight.daemon.impl.quickfix.AddReturnFix;
import com.intellij.codeInsight.daemon.impl.quickfix.AddTypeCastFix;
import com.intellij.codeInsight.daemon.impl.quickfix.AddVariableInitializerFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ChangeClassSignatureFromUsageFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ChangeExtendsToImplementsFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ChangeMethodSignatureFromUsageFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ChangeMethodSignatureFromUsageReverseOrderFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ChangeParameterClassFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ChangeToAppendFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ConvertCollectionToArrayFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ConvertSwitchToIfIntention;
import com.intellij.codeInsight.daemon.impl.quickfix.ConvertToStringLiteralAction;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateAnnotationMethodFromUsageFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateConstructorMatchingSuperFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateConstructorParameterFromFieldFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFieldFromUsageFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateGetterOrSetterFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateMethodFromMethodReferenceFix;
import com.intellij.codeInsight.daemon.impl.quickfix.DeferFinalAssignmentFix;
import com.intellij.codeInsight.daemon.impl.quickfix.DeleteCatchFix;
import com.intellij.codeInsight.daemon.impl.quickfix.DeleteElementFix;
import com.intellij.codeInsight.daemon.impl.quickfix.DeleteMethodBodyFix;
import com.intellij.codeInsight.daemon.impl.quickfix.DeleteMultiCatchFix;
import com.intellij.codeInsight.daemon.impl.quickfix.DeleteReturnFix;
import com.intellij.codeInsight.daemon.impl.quickfix.DeleteSideEffectsAwareFix;
import com.intellij.codeInsight.daemon.impl.quickfix.EnableOptimizeImportsOnTheFlyFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ExtendsListFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ImplementAbstractClassMethodsFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ImplementMethodsFix;
import com.intellij.codeInsight.daemon.impl.quickfix.InitializeFinalFieldInConstructorFix;
import com.intellij.codeInsight.daemon.impl.quickfix.InsertMethodCallFix;
import com.intellij.codeInsight.daemon.impl.quickfix.InsertNewFix;
import com.intellij.codeInsight.daemon.impl.quickfix.InsertSuperFix;
import com.intellij.codeInsight.daemon.impl.quickfix.InsertThisFix;
import com.intellij.codeInsight.daemon.impl.quickfix.MakeClassInterfaceFix;
import com.intellij.codeInsight.daemon.impl.quickfix.MakeVarargParameterLastFix;
import com.intellij.codeInsight.daemon.impl.quickfix.MethodParameterFix;
import com.intellij.codeInsight.daemon.impl.quickfix.MethodReturnTypeFix;
import com.intellij.codeInsight.daemon.impl.quickfix.MethodThrowsFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ModifierFix;
import com.intellij.codeInsight.daemon.impl.quickfix.MoveBoundClassToFrontFix;
import com.intellij.codeInsight.daemon.impl.quickfix.MoveCatchUpFix;
import com.intellij.codeInsight.daemon.impl.quickfix.MoveClassToSeparateFileFix;
import com.intellij.codeInsight.daemon.impl.quickfix.NavigateToAlreadyDeclaredVariableFix;
import com.intellij.codeInsight.daemon.impl.quickfix.NegationBroadScopeFix;
import com.intellij.codeInsight.daemon.impl.quickfix.OrderEntryFix;
import com.intellij.codeInsight.daemon.impl.quickfix.PullAsAbstractUpFix;
import com.intellij.codeInsight.daemon.impl.quickfix.QualifyStaticMethodCallFix;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.daemon.impl.quickfix.RemoveNewQualifierFix;
import com.intellij.codeInsight.daemon.impl.quickfix.RemoveParameterListFix;
import com.intellij.codeInsight.daemon.impl.quickfix.RemoveQualifierFix;
import com.intellij.codeInsight.daemon.impl.quickfix.RemoveTypeArgumentsFix;
import com.intellij.codeInsight.daemon.impl.quickfix.RemoveUnusedParameterFix;
import com.intellij.codeInsight.daemon.impl.quickfix.RemoveUnusedVariableFix;
import com.intellij.codeInsight.daemon.impl.quickfix.RenameElementFix;
import com.intellij.codeInsight.daemon.impl.quickfix.RenameFileFix;
import com.intellij.codeInsight.daemon.impl.quickfix.RenameToIgnoredFix;
import com.intellij.codeInsight.daemon.impl.quickfix.RenameWrongRefFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ReplaceAddAllArrayToCollectionFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ReplaceInaccessibleFieldWithGetterSetterFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ReplaceIteratorForEachLoopWithIteratorForLoopFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ReplacePrimitiveWithBoxedTypeAction;
import com.intellij.codeInsight.daemon.impl.quickfix.ReplaceWithListAccessFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ReuseVariableDeclarationFix;
import com.intellij.codeInsight.daemon.impl.quickfix.SafeDeleteFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ShowModulePropertiesFix;
import com.intellij.codeInsight.daemon.impl.quickfix.StaticImportMethodFix;
import com.intellij.codeInsight.daemon.impl.quickfix.SuperMethodReturnFix;
import com.intellij.codeInsight.daemon.impl.quickfix.SurroundWithArrayFix;
import com.intellij.codeInsight.daemon.impl.quickfix.SurroundWithQuotesAnnotationParameterValueFix;
import com.intellij.codeInsight.daemon.impl.quickfix.SurroundWithTryCatchFix;
import com.intellij.codeInsight.daemon.impl.quickfix.VariableAccessFromInnerClassFix;
import com.intellij.codeInsight.daemon.impl.quickfix.VariableTypeFromCallFix;
import com.intellij.codeInsight.daemon.impl.quickfix.WrapExpressionFix;
import com.intellij.codeInsight.daemon.impl.quickfix.WrapObjectWithOptionalOfNullableFix;
import com.intellij.codeInsight.daemon.impl.quickfix.WrapSwitchRuleStatementsIntoBlockFix;
import com.intellij.codeInsight.daemon.impl.quickfix.WrapWithAdapterMethodCallFix;
import com.intellij.codeInsight.daemon.quickFix.CreateClassOrPackageFix;
import com.intellij.codeInsight.daemon.quickFix.CreateFieldOrPropertyFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionManager;
import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInsight.intention.impl.CollapseAnnotationsFix;
import com.intellij.codeInsight.intention.impl.CreateClassInPackageInModuleFix;
import com.intellij.codeInsight.intention.impl.ReplaceAssignmentWithComparisonFix;
import com.intellij.codeInsight.intention.impl.RunRefactoringAction;
import com.intellij.codeInsight.intention.impl.SameErasureButDifferentMethodsFix;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.SuppressIntentionActionFromFix;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.deadCode.UnusedDeclarationInspectionBase;
import com.intellij.codeInspection.ex.EntryPointsManagerBase;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.util.SpecialAnnotationsUtil;
import com.intellij.diagnostic.AttachmentFactory;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.java.request.CreateConstructorFromUsage;
import com.intellij.lang.java.request.CreateMethodFromUsage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConstructorCall;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterListOwner;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ServerPageFile;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.ClassKind;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PropertyMemberType;
import com.intellij.refactoring.memberPushDown.JavaPushDownHandler;
import com.intellij.util.DocumentUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.fixes.CreateDefaultBranchFix;
import com.siyeh.ig.fixes.CreateMissingSwitchBranchesFix;
import com.siyeh.ipp.modifiers.ChangeModifierIntention;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuickFixFactoryImpl
extends QuickFixFactory {
    private static final Logger LOG = Logger.getInstance(QuickFixFactoryImpl.class);

    @NotNull
    public LocalQuickFixAndIntentionActionOnPsiElement createModifierListFix(@NotNull PsiModifierList modifierList, @NotNull String modifier, boolean shouldHave, boolean showContainingClass) {
        if (modifierList == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(0);
        }
        if (modifier == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(1);
        }
        return new ModifierFix(modifierList, modifier, shouldHave, showContainingClass);
    }

    @NotNull
    public LocalQuickFixAndIntentionActionOnPsiElement createModifierListFix(@NotNull PsiModifierListOwner owner2, @NotNull String modifier, boolean shouldHave, boolean showContainingClass) {
        if (owner2 == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(2);
        }
        if (modifier == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(3);
        }
        return new ModifierFix(owner2, modifier, shouldHave, showContainingClass);
    }

    @NotNull
    public LocalQuickFixAndIntentionActionOnPsiElement createMethodReturnFix(@NotNull PsiMethod method, @NotNull PsiType toReturn, boolean fixWholeHierarchy) {
        if (method == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(4);
        }
        if (toReturn == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(5);
        }
        return new MethodReturnTypeFix(method, toReturn, fixWholeHierarchy);
    }

    @NotNull
    public LocalQuickFixAndIntentionActionOnPsiElement createMethodReturnFix(@NotNull PsiMethod method, @NotNull PsiType toReturn, boolean fixWholeHierarchy, boolean suggestSuperTypes) {
        if (method == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(6);
        }
        if (toReturn == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(7);
        }
        return new MethodReturnTypeFix(method, toReturn, fixWholeHierarchy, suggestSuperTypes);
    }

    @NotNull
    public LocalQuickFixAndIntentionActionOnPsiElement createAddMethodFix(@NotNull PsiMethod method, @NotNull PsiClass toClass) {
        if (method == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(8);
        }
        if (toClass == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(9);
        }
        return new AddMethodFix(method, toClass);
    }

    @NotNull
    public LocalQuickFixAndIntentionActionOnPsiElement createAddMethodFix(@NotNull String methodText, @NotNull PsiClass toClass, String ... exceptions) {
        if (methodText == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(10);
        }
        if (toClass == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(11);
        }
        if (exceptions == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(12);
        }
        return new AddMethodFix(methodText, toClass, exceptions);
    }

    @NotNull
    public LocalQuickFixAndIntentionActionOnPsiElement createImplementMethodsFix(@NotNull PsiClass aClass) {
        if (aClass == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(13);
        }
        return new ImplementMethodsFix((PsiElement)aClass);
    }

    @NotNull
    public LocalQuickFixAndIntentionActionOnPsiElement createImplementMethodsFix(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(14);
        }
        return new ImplementMethodsFix(psiElement);
    }

    @NotNull
    public LocalQuickFixAndIntentionActionOnPsiElement createAssignmentToComparisonFix(@NotNull PsiAssignmentExpression expr2) {
        if (expr2 == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(15);
        }
        return new ReplaceAssignmentWithComparisonFix(expr2);
    }

    @NotNull
    public LocalQuickFixOnPsiElement createMethodThrowsFix(@NotNull PsiMethod method, @NotNull PsiClassType exceptionClass, boolean shouldThrow, boolean showContainingClass) {
        if (method == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(16);
        }
        if (exceptionClass == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(17);
        }
        return shouldThrow ? new MethodThrowsFix.Add(method, exceptionClass, showContainingClass) : new MethodThrowsFix.Remove(method, exceptionClass, showContainingClass);
    }

    @NotNull
    public LocalQuickFixAndIntentionActionOnPsiElement createAddDefaultConstructorFix(@NotNull PsiClass aClass) {
        if (aClass == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(18);
        }
        return new AddDefaultConstructorFix(aClass);
    }

    public LocalQuickFixAndIntentionActionOnPsiElement createAddConstructorFix(@NotNull PsiClass aClass, @NotNull String modifier) {
        if (aClass == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(19);
        }
        if (modifier == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(20);
        }
        return aClass.getName() != null ? new AddDefaultConstructorFix(aClass, modifier) : null;
    }

    @NotNull
    public LocalQuickFixAndIntentionActionOnPsiElement createMethodParameterTypeFix(@NotNull PsiMethod method, int index, @NotNull PsiType newType, boolean fixWholeHierarchy) {
        if (method == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(21);
        }
        if (newType == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(22);
        }
        return new MethodParameterFix(method, newType, index, fixWholeHierarchy);
    }

    @NotNull
    public LocalQuickFixAndIntentionActionOnPsiElement createMakeClassInterfaceFix(@NotNull PsiClass aClass) {
        if (aClass == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(23);
        }
        return new MakeClassInterfaceFix(aClass, true);
    }

    @NotNull
    public LocalQuickFixAndIntentionActionOnPsiElement createMakeClassInterfaceFix(@NotNull PsiClass aClass, boolean makeInterface) {
        if (aClass == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(24);
        }
        return new MakeClassInterfaceFix(aClass, makeInterface);
    }

    @NotNull
    public LocalQuickFixAndIntentionActionOnPsiElement createExtendsListFix(@NotNull PsiClass aClass, @NotNull PsiClassType typeToExtendFrom, boolean toAdd) {
        if (aClass == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(25);
        }
        if (typeToExtendFrom == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(26);
        }
        return new ExtendsListFix(aClass, typeToExtendFrom, toAdd);
    }

    @NotNull
    public LocalQuickFixAndIntentionActionOnPsiElement createRemoveUnusedParameterFix(@NotNull PsiParameter parameter2) {
        if (parameter2 == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(27);
        }
        return new RemoveUnusedParameterFix(parameter2);
    }

    @NotNull
    public IntentionAction createRemoveUnusedVariableFix(@NotNull PsiVariable variable) {
        if (variable == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(28);
        }
        return new RemoveUnusedVariableFix(variable);
    }

    @Nullable
    public IntentionAction createCreateClassOrPackageFix(@NotNull PsiElement context, @NotNull String qualifiedName, boolean createClass, String superClass) {
        if (context == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(29);
        }
        if (qualifiedName == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(30);
        }
        return CreateClassOrPackageFix.createFix(qualifiedName, context, (ClassKind)(createClass ? ClassKind.CLASS : null), superClass);
    }

    @Nullable
    public IntentionAction createCreateClassOrInterfaceFix(@NotNull PsiElement context, @NotNull String qualifiedName, boolean createClass, String superClass) {
        if (context == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(31);
        }
        if (qualifiedName == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(32);
        }
        return CreateClassOrPackageFix.createFix(qualifiedName, context, createClass ? ClassKind.CLASS : ClassKind.INTERFACE, superClass);
    }

    @NotNull
    public IntentionAction createCreateFieldOrPropertyFix(@NotNull PsiClass aClass, @NotNull String name2, @NotNull PsiType type2, @NotNull PropertyMemberType targetMember, PsiAnnotation ... annotations) {
        if (aClass == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(33);
        }
        if (name2 == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(34);
        }
        if (type2 == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(35);
        }
        if (targetMember == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(36);
        }
        if (annotations == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(37);
        }
        return new CreateFieldOrPropertyFix(aClass, name2, type2, targetMember, annotations);
    }

    @NotNull
    public IntentionAction createAddExceptionToCatchFix() {
        return new AddExceptionToCatchFix(true);
    }

    @NotNull
    public IntentionAction createAddExceptionToThrowsFix(@NotNull PsiElement element) {
        if (element == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(38);
        }
        return new AddExceptionToThrowsFix(element);
    }

    @NotNull
    public IntentionAction createAddExceptionFromFieldInitializerToConstructorThrowsFix(@NotNull PsiElement element) {
        if (element == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(39);
        }
        return new AddExceptionFromFieldInitializerToConstructorThrowsFix(element);
    }

    @NotNull
    public IntentionAction createSurroundWithTryCatchFix(@NotNull PsiElement element) {
        if (element == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(40);
        }
        return new SurroundWithTryCatchFix(element);
    }

    @NotNull
    public IntentionAction createAddExceptionToExistingCatch(@NotNull PsiElement element) {
        if (element == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(41);
        }
        return new AddExceptionToExistingCatchFix(element);
    }

    @NotNull
    public IntentionAction createChangeToAppendFix(@NotNull IElementType sign, @NotNull PsiType type2, @NotNull PsiAssignmentExpression assignment) {
        if (sign == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(42);
        }
        if (type2 == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(43);
        }
        if (assignment == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(44);
        }
        return new ChangeToAppendFix(sign, type2, assignment);
    }

    @NotNull
    public IntentionAction createAddTypeCastFix(@NotNull PsiType type2, @NotNull PsiExpression expression2) {
        if (type2 == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(45);
        }
        if (expression2 == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(46);
        }
        return new AddTypeCastFix(type2, expression2);
    }

    @NotNull
    public IntentionAction createWrapExpressionFix(@NotNull PsiType type2, @NotNull PsiExpression expression2) {
        if (type2 == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(47);
        }
        if (expression2 == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(48);
        }
        return new WrapExpressionFix(type2, expression2);
    }

    @NotNull
    public IntentionAction createReuseVariableDeclarationFix(@NotNull PsiLocalVariable variable) {
        if (variable == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(49);
        }
        return new ReuseVariableDeclarationFix(variable);
    }

    @NotNull
    public IntentionAction createNavigateToAlreadyDeclaredVariableFix(@NotNull PsiVariable variable) {
        if (variable == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(50);
        }
        return new NavigateToAlreadyDeclaredVariableFix(variable);
    }

    @NotNull
    public IntentionAction createConvertToStringLiteralAction() {
        return new ConvertToStringLiteralAction();
    }

    @NotNull
    public IntentionAction createDeleteReturnFix(@NotNull PsiMethod method, @NotNull PsiReturnStatement returnStatement, @NotNull PsiExpression returnValue) {
        if (method == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(51);
        }
        if (returnStatement == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(52);
        }
        if (returnValue == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(53);
        }
        return new DeleteReturnFix(method, returnStatement, returnValue);
    }

    @NotNull
    public IntentionAction createDeleteCatchFix(@NotNull PsiParameter parameter2) {
        if (parameter2 == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(54);
        }
        return new DeleteCatchFix(parameter2);
    }

    @NotNull
    public IntentionAction createDeleteMultiCatchFix(@NotNull PsiTypeElement element) {
        if (element == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(55);
        }
        return new DeleteMultiCatchFix(element);
    }

    @NotNull
    public IntentionAction createConvertSwitchToIfIntention(@NotNull PsiSwitchStatement statement) {
        if (statement == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(56);
        }
        return new ConvertSwitchToIfIntention(statement);
    }

    @NotNull
    public IntentionAction createNegationBroadScopeFix(@NotNull PsiPrefixExpression expr2) {
        if (expr2 == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(57);
        }
        return new NegationBroadScopeFix(expr2);
    }

    @NotNull
    public IntentionAction createCreateFieldFromUsageFix(@NotNull PsiReferenceExpression place) {
        if (place == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(58);
        }
        return new CreateFieldFromUsageFix(place);
    }

    @NotNull
    public IntentionAction createReplaceWithListAccessFix(@NotNull PsiArrayAccessExpression expression2) {
        if (expression2 == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(59);
        }
        return new ReplaceWithListAccessFix(expression2);
    }

    @NotNull
    public IntentionAction createAddNewArrayExpressionFix(@NotNull PsiArrayInitializerExpression expression2) {
        if (expression2 == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(60);
        }
        return new AddNewArrayExpressionFix(expression2);
    }

    @NotNull
    public IntentionAction createMoveCatchUpFix(@NotNull PsiCatchSection section, @NotNull PsiCatchSection section1) {
        if (section == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(61);
        }
        if (section1 == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(62);
        }
        return new MoveCatchUpFix(section, section1);
    }

    @NotNull
    public IntentionAction createRenameWrongRefFix(@NotNull PsiReferenceExpression ref) {
        if (ref == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(63);
        }
        return new RenameWrongRefFix(ref);
    }

    @NotNull
    public IntentionAction createRemoveQualifierFix(@NotNull PsiExpression qualifier, @NotNull PsiReferenceExpression expression2, @NotNull PsiClass resolved) {
        if (qualifier == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(64);
        }
        if (expression2 == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(65);
        }
        if (resolved == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(66);
        }
        return new RemoveQualifierFix(qualifier, expression2, resolved);
    }

    @NotNull
    public IntentionAction createRemoveParameterListFix(@NotNull PsiMethod parent) {
        if (parent == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(67);
        }
        return new RemoveParameterListFix(parent);
    }

    @NotNull
    public IntentionAction createShowModulePropertiesFix(@NotNull PsiElement element) {
        if (element == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(68);
        }
        return new ShowModulePropertiesFix(element);
    }

    @NotNull
    public IntentionAction createShowModulePropertiesFix(@NotNull Module module) {
        if (module == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(69);
        }
        return new ShowModulePropertiesFix(module);
    }

    @NotNull
    public IntentionAction createIncreaseLanguageLevelFix(@NotNull LanguageLevel level) {
        if (level == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(70);
        }
        return new IncreaseLanguageLevelFix(level);
    }

    @NotNull
    public IntentionAction createChangeParameterClassFix(@NotNull PsiClass aClass, @NotNull PsiClassType type2) {
        if (aClass == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(71);
        }
        if (type2 == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(72);
        }
        return new ChangeParameterClassFix(aClass, type2);
    }

    @NotNull
    public IntentionAction createReplaceInaccessibleFieldWithGetterSetterFix(@NotNull PsiElement element, @NotNull PsiMethod getter, boolean isSetter) {
        if (element == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(73);
        }
        if (getter == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(74);
        }
        return new ReplaceInaccessibleFieldWithGetterSetterFix(element, getter, isSetter);
    }

    @NotNull
    public IntentionAction createSurroundWithArrayFix(@Nullable PsiCall methodCall, @Nullable PsiExpression expression2) {
        return new SurroundWithArrayFix(methodCall, expression2);
    }

    @NotNull
    public IntentionAction createImplementAbstractClassMethodsFix(@NotNull PsiElement elementToHighlight) {
        if (elementToHighlight == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(75);
        }
        return new ImplementAbstractClassMethodsFix(elementToHighlight);
    }

    @NotNull
    public IntentionAction createMoveClassToSeparateFileFix(@NotNull PsiClass aClass) {
        if (aClass == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(76);
        }
        return new MoveClassToSeparateFileFix(aClass);
    }

    @NotNull
    public IntentionAction createRenameFileFix(@NotNull String newName) {
        if (newName == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(77);
        }
        return new RenameFileFix(newName);
    }

    @NotNull
    public LocalQuickFixAndIntentionActionOnPsiElement createRenameElementFix(@NotNull PsiNamedElement element) {
        if (element == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(78);
        }
        return new RenameElementFix(element);
    }

    @NotNull
    public LocalQuickFixAndIntentionActionOnPsiElement createRenameElementFix(@NotNull PsiNamedElement element, @NotNull String newName) {
        if (element == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(79);
        }
        if (newName == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(80);
        }
        return new RenameElementFix(element, newName);
    }

    @NotNull
    public IntentionAction createChangeExtendsToImplementsFix(@NotNull PsiClass aClass, @NotNull PsiClassType classToExtendFrom) {
        if (aClass == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(81);
        }
        if (classToExtendFrom == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(82);
        }
        return new ChangeExtendsToImplementsFix(aClass, classToExtendFrom);
    }

    @NotNull
    public IntentionAction createCreateConstructorMatchingSuperFix(@NotNull PsiClass aClass) {
        if (aClass == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(83);
        }
        return new CreateConstructorMatchingSuperFix(aClass);
    }

    @NotNull
    public IntentionAction createRemoveNewQualifierFix(@NotNull PsiNewExpression expression2, PsiClass aClass) {
        if (expression2 == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(84);
        }
        return new RemoveNewQualifierFix(expression2, aClass);
    }

    @NotNull
    public IntentionAction createSuperMethodReturnFix(@NotNull PsiMethod superMethod, @NotNull PsiType superMethodType) {
        if (superMethod == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(85);
        }
        if (superMethodType == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(86);
        }
        return new SuperMethodReturnFix(superMethod, superMethodType);
    }

    @NotNull
    public IntentionAction createInsertNewFix(@NotNull PsiMethodCallExpression call, @NotNull PsiClass aClass) {
        if (call == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(87);
        }
        if (aClass == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(88);
        }
        return new InsertNewFix(call, aClass);
    }

    @NotNull
    public IntentionAction createAddMethodBodyFix(@NotNull PsiMethod method) {
        if (method == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(89);
        }
        return new AddMethodBodyFix(method);
    }

    @NotNull
    public IntentionAction createDeleteMethodBodyFix(@NotNull PsiMethod method) {
        if (method == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(90);
        }
        return new DeleteMethodBodyFix(method);
    }

    @NotNull
    public IntentionAction createInsertSuperFix(@NotNull PsiMethod constructor) {
        if (constructor == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(91);
        }
        return new InsertSuperFix(constructor);
    }

    @NotNull
    public IntentionAction createInsertThisFix(@NotNull PsiMethod constructor) {
        if (constructor == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(92);
        }
        return new InsertThisFix(constructor);
    }

    @NotNull
    public IntentionAction createChangeMethodSignatureFromUsageFix(@NotNull PsiMethod targetMethod, PsiExpression @NotNull [] expressions2, @NotNull PsiSubstitutor substitutor, @NotNull PsiElement context, boolean changeAllUsages, int minUsagesNumberToShowDialog) {
        if (targetMethod == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(93);
        }
        if (substitutor == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(94);
        }
        if (context == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(95);
        }
        if (expressions2 == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(96);
        }
        return new ChangeMethodSignatureFromUsageFix(targetMethod, expressions2, substitutor, context, changeAllUsages, minUsagesNumberToShowDialog);
    }

    @NotNull
    public IntentionAction createChangeMethodSignatureFromUsageReverseOrderFix(@NotNull PsiMethod targetMethod, PsiExpression @NotNull [] expressions2, @NotNull PsiSubstitutor substitutor, @NotNull PsiElement context, boolean changeAllUsages, int minUsagesNumberToShowDialog) {
        if (targetMethod == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(97);
        }
        if (substitutor == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(98);
        }
        if (context == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(99);
        }
        if (expressions2 == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(100);
        }
        return new ChangeMethodSignatureFromUsageReverseOrderFix(targetMethod, expressions2, substitutor, context, changeAllUsages, minUsagesNumberToShowDialog);
    }

    @NotNull
    public List<IntentionAction> createCreateMethodFromUsageFixes(@NotNull PsiMethodCallExpression call) {
        if (call == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(101);
        }
        List<IntentionAction> list = CreateMethodFromUsage.generateActions(call);
        if (list == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(102);
        }
        return list;
    }

    @NotNull
    public IntentionAction createCreateMethodFromUsageFix(@NotNull PsiMethodReferenceExpression methodReferenceExpression) {
        if (methodReferenceExpression == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(103);
        }
        return new CreateMethodFromMethodReferenceFix(methodReferenceExpression);
    }

    @NotNull
    public List<IntentionAction> createCreateConstructorFromCallExpressionFixes(@NotNull PsiMethodCallExpression call) {
        if (call == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(104);
        }
        List<IntentionAction> list = CreateConstructorFromUsage.generateConstructorActions(call);
        if (list == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(105);
        }
        return list;
    }

    @NotNull
    public IntentionAction createStaticImportMethodFix(@NotNull PsiMethodCallExpression call) {
        if (call == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(106);
        }
        return new StaticImportMethodFix(call.getContainingFile(), call);
    }

    @NotNull
    public IntentionAction createQualifyStaticMethodCallFix(@NotNull PsiMethodCallExpression call) {
        if (call == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(107);
        }
        return new QualifyStaticMethodCallFix(call.getContainingFile(), call);
    }

    @NotNull
    public IntentionAction createReplaceAddAllArrayToCollectionFix(@NotNull PsiMethodCallExpression call) {
        if (call == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(108);
        }
        return new ReplaceAddAllArrayToCollectionFix(call);
    }

    @NotNull
    public List<IntentionAction> createCreateConstructorFromUsageFixes(@NotNull PsiConstructorCall call) {
        if (call == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(109);
        }
        List<IntentionAction> list = CreateConstructorFromUsage.generateConstructorActions(call);
        if (list == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(110);
        }
        return list;
    }

    @NotNull
    public List<IntentionAction> getVariableTypeFromCallFixes(@NotNull PsiMethodCallExpression call, @NotNull PsiExpressionList list) {
        if (call == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(111);
        }
        if (list == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(112);
        }
        List<IntentionAction> list2 = VariableTypeFromCallFix.getQuickFixActions(call, list);
        if (list2 == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(113);
        }
        return list2;
    }

    @NotNull
    public IntentionAction createAddReturnFix(@NotNull PsiParameterListOwner methodOrLambda) {
        if (methodOrLambda == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(114);
        }
        return new AddReturnFix(methodOrLambda);
    }

    @NotNull
    public IntentionAction createAddVariableInitializerFix(@NotNull PsiVariable variable) {
        if (variable == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(115);
        }
        return new AddVariableInitializerFix(variable);
    }

    @NotNull
    public IntentionAction createDeferFinalAssignmentFix(@NotNull PsiVariable variable, @NotNull PsiReferenceExpression expression2) {
        if (variable == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(116);
        }
        if (expression2 == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(117);
        }
        return new DeferFinalAssignmentFix(variable, expression2);
    }

    @NotNull
    public IntentionAction createVariableAccessFromInnerClassFix(@NotNull PsiVariable variable, @NotNull PsiElement scope) {
        if (variable == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(118);
        }
        if (scope == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(119);
        }
        return new VariableAccessFromInnerClassFix(variable, scope);
    }

    @NotNull
    public IntentionAction createCreateConstructorParameterFromFieldFix(@NotNull PsiField field) {
        if (field == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(120);
        }
        return new CreateConstructorParameterFromFieldFix(field);
    }

    @NotNull
    public IntentionAction createInitializeFinalFieldInConstructorFix(@NotNull PsiField field) {
        if (field == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(121);
        }
        return new InitializeFinalFieldInConstructorFix(field);
    }

    @NotNull
    public IntentionAction createRemoveTypeArgumentsFix(@NotNull PsiElement variable) {
        if (variable == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(122);
        }
        return new RemoveTypeArgumentsFix(variable);
    }

    @NotNull
    public IntentionAction createChangeClassSignatureFromUsageFix(@NotNull PsiClass owner2, @NotNull PsiReferenceParameterList parameterList) {
        if (owner2 == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(123);
        }
        if (parameterList == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(124);
        }
        return new ChangeClassSignatureFromUsageFix(owner2, parameterList);
    }

    @NotNull
    public IntentionAction createReplacePrimitiveWithBoxedTypeAction(@NotNull PsiTypeElement element, @NotNull String typeName, @NotNull String boxedTypeName) {
        if (element == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(125);
        }
        if (typeName == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(126);
        }
        if (boxedTypeName == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(127);
        }
        return new ReplacePrimitiveWithBoxedTypeAction(element, typeName, boxedTypeName);
    }

    @NotNull
    public IntentionAction createMakeVarargParameterLastFix(@NotNull PsiParameter parameter2) {
        if (parameter2 == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(128);
        }
        return new MakeVarargParameterLastFix(parameter2);
    }

    @NotNull
    public IntentionAction createMoveBoundClassToFrontFix(@NotNull PsiClass aClass, @NotNull PsiClassType type2) {
        if (aClass == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(129);
        }
        if (type2 == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(130);
        }
        return new MoveBoundClassToFrontFix(aClass, type2);
    }

    public void registerPullAsAbstractUpFixes(@NotNull PsiMethod method, @NotNull QuickFixActionRegistrar registrar) {
        if (method == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(131);
        }
        if (registrar == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(132);
        }
        PullAsAbstractUpFix.registerQuickFix(method, registrar);
    }

    @NotNull
    public IntentionAction createCreateAnnotationMethodFromUsageFix(@NotNull PsiNameValuePair pair2) {
        if (pair2 == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(133);
        }
        return new CreateAnnotationMethodFromUsageFix(pair2);
    }

    @NotNull
    public IntentionAction createOptimizeImportsFix(final boolean onTheFly) {
        return new IntentionAction(){

            @NotNull
            public String getText() {
                String string = QuickFixBundle.message("optimize.imports.fix", new Object[0]);
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @NotNull
            public String getFamilyName() {
                String string = QuickFixBundle.message("optimize.imports.fix", new Object[0]);
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
                if (project == null) {
                    1.$$$reportNull$$$0(2);
                }
                return (!onTheFly || QuickFixFactoryImpl.timeToOptimizeImports(file)) && file instanceof PsiJavaFile && BaseIntentionAction.canModify((PsiElement)file);
            }

            public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
                if (project == null) {
                    1.$$$reportNull$$$0(3);
                }
                QuickFixFactoryImpl.invokeOnTheFlyImportOptimizer(file);
            }

            public boolean startInWriteAction() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 2: 
                    case 3: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 2: 
                    case 3: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInsight/intention/impl/config/QuickFixFactoryImpl$1";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getText";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInsight/intention/impl/config/QuickFixFactoryImpl$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "isAvailable";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "invoke";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    public void registerFixesForUnusedParameter(@NotNull PsiParameter parameter2, @NotNull Object highlightInfo) {
        if (parameter2 == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(134);
        }
        if (highlightInfo == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(135);
        }
        Project myProject = parameter2.getProject();
        InspectionProfileImpl profile = InspectionProjectProfileManager.getInstance((Project)myProject).getCurrentProfile();
        UnusedDeclarationInspectionBase unusedParametersInspection = (UnusedDeclarationInspectionBase)profile.getUnwrappedTool("unused", (PsiElement)parameter2);
        LOG.assertTrue(ApplicationManager.getApplication().isUnitTestMode() || unusedParametersInspection != null);
        HighlightDisplayKey myUnusedSymbolKey = HighlightDisplayKey.find((String)"unused");
        ArrayList options = new ArrayList(IntentionManager.getInstance().getStandardIntentionOptions(myUnusedSymbolKey, (PsiElement)parameter2));
        if (unusedParametersInspection != null) {
            SuppressQuickFix[] batchSuppressActions = unusedParametersInspection.getBatchSuppressActions((PsiElement)parameter2);
            Collections.addAll(options, SuppressIntentionActionFromFix.convertBatchToSuppressIntentionActions((SuppressQuickFix[])batchSuppressActions));
        }
        QuickFixAction.registerQuickFixAction((HighlightInfo)((HighlightInfo)highlightInfo), (IntentionAction)new SafeDeleteFix((PsiElement)parameter2), options, (String)HighlightDisplayKey.getDisplayNameByKey((HighlightDisplayKey)myUnusedSymbolKey));
    }

    @NotNull
    public IntentionAction createAddToDependencyInjectionAnnotationsFix(@NotNull Project project, @NotNull String qualifiedName) {
        if (project == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(136);
        }
        if (qualifiedName == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(137);
        }
        EntryPointsManagerBase entryPointsManager = EntryPointsManagerBase.getInstance(project);
        IntentionAction intentionAction = SpecialAnnotationsUtil.createAddToSpecialAnnotationsListIntentionAction(QuickFixBundle.message("fix.unused.symbol.injection.text", qualifiedName), QuickFixBundle.message("fix.unused.symbol.injection.family", new Object[0]), (List<String>)entryPointsManager.ADDITIONAL_ANNOTATIONS, qualifiedName);
        if (intentionAction == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(138);
        }
        return intentionAction;
    }

    @NotNull
    public IntentionAction createAddToImplicitlyWrittenFieldsFix(@NotNull Project project, @NotNull String qualifiedName) {
        EntryPointsManagerBase entryPointsManagerBase;
        if (project == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(139);
        }
        if (qualifiedName == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(140);
        }
        EntryPointsManagerBase entryPointsManagerBase2 = entryPointsManagerBase = EntryPointsManagerBase.getInstance(project);
        ((Object)((Object)entryPointsManagerBase2)).getClass();
        return entryPointsManagerBase2.new EntryPointsManagerBase.AddImplicitlyWriteAnnotation(qualifiedName);
    }

    @NotNull
    public IntentionAction createCreateGetterOrSetterFix(boolean createGetter, boolean createSetter, @NotNull PsiField field) {
        if (field == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(141);
        }
        return new CreateGetterOrSetterFix(createGetter, createSetter, field);
    }

    @NotNull
    public IntentionAction createRenameToIgnoredFix(@NotNull PsiNamedElement namedElement) {
        if (namedElement == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(142);
        }
        return new RenameToIgnoredFix(namedElement);
    }

    @NotNull
    public IntentionAction createEnableOptimizeImportsOnTheFlyFix() {
        return new EnableOptimizeImportsOnTheFlyFix();
    }

    @NotNull
    public LocalQuickFixAndIntentionActionOnPsiElement createDeleteFix(@NotNull PsiElement element) {
        if (element == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(143);
        }
        return new DeleteElementFix(element);
    }

    @NotNull
    public LocalQuickFixAndIntentionActionOnPsiElement createDeleteFix(@NotNull PsiElement element, @Nls @NotNull String text2) {
        if (element == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(144);
        }
        if (text2 == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(145);
        }
        return new DeleteElementFix(element, text2);
    }

    @NotNull
    public IntentionAction createSafeDeleteFix(@NotNull PsiElement element) {
        if (element == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(146);
        }
        return new SafeDeleteFix(element);
    }

    @Nullable
    public List<LocalQuickFix> registerOrderEntryFixes(@NotNull QuickFixActionRegistrar registrar, @NotNull PsiReference reference) {
        if (registrar == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(147);
        }
        if (reference == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(148);
        }
        return OrderEntryFix.registerFixes(registrar, reference);
    }

    private static void invokeOnTheFlyImportOptimizer(@NotNull PsiFile file) {
        String afterText;
        Project project;
        Document document;
        if (file == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(149);
        }
        if ((document = PsiDocumentManager.getInstance((Project)(project = file.getProject())).getDocument(file)) == null) {
            return;
        }
        String beforeText = file.getText();
        long oldStamp = document.getModificationStamp();
        DocumentUtil.writeInRunUndoTransparentAction(() -> JavaCodeStyleManager.getInstance((Project)project).optimizeImports(file));
        if (oldStamp != document.getModificationStamp() && Comparing.strEqual((String)beforeText, (String)(afterText = file.getText()))) {
            LOG.error("Import optimizer hasn't optimized any imports", new Throwable(file.getViewProvider().getVirtualFile().getPath()), new Attachment[]{AttachmentFactory.createAttachment((VirtualFile)file.getViewProvider().getVirtualFile())});
        }
    }

    @NotNull
    public IntentionAction createAddMissingRequiredAnnotationParametersFix(@NotNull PsiAnnotation annotation, PsiMethod @NotNull [] annotationMethods, @NotNull Collection<String> missedElements) {
        if (annotation == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(150);
        }
        if (missedElements == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(151);
        }
        if (annotationMethods == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(152);
        }
        return new AddMissingRequiredAnnotationParametersFix(annotation, annotationMethods, missedElements);
    }

    @NotNull
    public IntentionAction createSurroundWithQuotesAnnotationParameterValueFix(@NotNull PsiAnnotationMemberValue value2, @NotNull PsiType expectedType) {
        if (value2 == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(153);
        }
        if (expectedType == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(154);
        }
        return new SurroundWithQuotesAnnotationParameterValueFix(value2, expectedType);
    }

    @NotNull
    public IntentionAction addMethodQualifierFix(@NotNull PsiMethodCallExpression methodCall) {
        if (methodCall == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(155);
        }
        return new AddMethodQualifierFix(methodCall);
    }

    @NotNull
    public IntentionAction createWrapWithOptionalFix(@Nullable PsiType type2, @NotNull PsiExpression expression2) {
        if (expression2 == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(156);
        }
        IntentionAction intentionAction = WrapObjectWithOptionalOfNullableFix.createFix(type2, expression2);
        if (intentionAction == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(157);
        }
        return intentionAction;
    }

    @Nullable
    public IntentionAction createNotIterableForEachLoopFix(@NotNull PsiExpression expression2) {
        PsiType type2;
        PsiElement parent;
        if (expression2 == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(158);
        }
        if ((parent = expression2.getParent()) instanceof PsiForeachStatement && InheritanceUtil.isInheritor((PsiType)(type2 = expression2.getType()), (String)"java.util.Iterator")) {
            return new ReplaceIteratorForEachLoopWithIteratorForLoopFix((PsiForeachStatement)parent);
        }
        return null;
    }

    @NotNull
    public List<IntentionAction> createAddAnnotationAttributeNameFixes(@NotNull PsiNameValuePair pair2) {
        if (pair2 == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(159);
        }
        List<IntentionAction> list = AddAnnotationAttributeNameFix.createFixes(pair2);
        if (list == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(160);
        }
        return list;
    }

    private static boolean timeToOptimizeImports(@NotNull PsiFile file) {
        if (file == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(161);
        }
        if (!CodeInsightWorkspaceSettings.getInstance((Project)file.getProject()).optimizeImportsOnTheFly) {
            return false;
        }
        DaemonCodeAnalyzerEx codeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx((Project)file.getProject());
        if (!codeAnalyzer.isHighlightingAvailable(file) || !(file instanceof PsiJavaFile) || file instanceof ServerPageFile) {
            return false;
        }
        if (!codeAnalyzer.isErrorAnalyzingFinished(file)) {
            return false;
        }
        boolean errors = QuickFixFactoryImpl.containsErrorsPreventingOptimize(file);
        return !errors && DaemonListeners.canChangeFileSilently((PsiFileSystemItem)file);
    }

    private static boolean containsErrorsPreventingOptimize(@NotNull PsiFile file) {
        Document document;
        if (file == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(162);
        }
        if ((document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file)) == null) {
            return true;
        }
        PsiImportList importList = ((PsiJavaFile)file).getImportList();
        TextRange importsRange = importList == null ? TextRange.EMPTY_RANGE : importList.getTextRange();
        boolean hasErrorsExceptUnresolvedImports = !DaemonCodeAnalyzerEx.processHighlights((Document)document, (Project)file.getProject(), (HighlightSeverity)HighlightSeverity.ERROR, (int)0, (int)document.getTextLength(), error -> {
            int infoEnd;
            if (error.type instanceof LocalInspectionsPass.InspectionHighlightInfoType) {
                return true;
            }
            int infoStart = error.getActualStartOffset();
            return importsRange.containsRange(infoStart, infoEnd = error.getActualEndOffset()) && error.type.equals(HighlightInfoType.WRONG_REF);
        });
        return hasErrorsExceptUnresolvedImports;
    }

    @NotNull
    public IntentionAction createCollectionToArrayFix(@NotNull PsiExpression collectionExpression, @NotNull PsiExpression expressionToReplace, @NotNull PsiArrayType arrayType) {
        if (collectionExpression == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(163);
        }
        if (expressionToReplace == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(164);
        }
        if (arrayType == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(165);
        }
        return new ConvertCollectionToArrayFix(collectionExpression, expressionToReplace, arrayType);
    }

    @NotNull
    public IntentionAction createInsertMethodCallFix(@NotNull PsiMethodCallExpression call, @NotNull PsiMethod method) {
        if (call == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(166);
        }
        if (method == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(167);
        }
        return new InsertMethodCallFix(call, method);
    }

    @NotNull
    public LocalQuickFixAndIntentionActionOnPsiElement createAccessStaticViaInstanceFix(@NotNull PsiReferenceExpression methodRef, @NotNull JavaResolveResult result) {
        if (methodRef == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(168);
        }
        if (result == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(169);
        }
        return new AccessStaticViaInstanceFix(methodRef, result, true);
    }

    @NotNull
    public IntentionAction createWrapWithAdapterFix(@Nullable PsiType type2, @NotNull PsiExpression expression2) {
        if (expression2 == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(170);
        }
        return new WrapWithAdapterMethodCallFix(type2, expression2);
    }

    @NotNull
    public IntentionAction createDeleteSideEffectAwareFix(@NotNull PsiExpressionStatement statement) {
        if (statement == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(171);
        }
        return new DeleteSideEffectsAwareFix((PsiStatement)statement, statement.getExpression());
    }

    @Nullable
    public IntentionAction createCreateClassInPackageInModuleFix(@NotNull Module module, @Nullable String packageName) {
        if (module == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(172);
        }
        return CreateClassInPackageInModuleFix.createFix(module, packageName);
    }

    @NotNull
    public IntentionAction createPushDownMethodFix() {
        return new RunRefactoringAction(new JavaPushDownHandler(), "Push method down..."){

            @NotNull
            public PriorityAction.Priority getPriority() {
                PriorityAction.Priority priority = PriorityAction.Priority.NORMAL;
                if (priority == null) {
                    2.$$$reportNull$$$0(0);
                }
                return priority;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/config/QuickFixFactoryImpl$2", "getPriority"));
            }
        };
    }

    @NotNull
    public IntentionAction createSameErasureButDifferentMethodsFix(@NotNull PsiMethod method, @NotNull PsiMethod superMethod) {
        if (method == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(173);
        }
        if (superMethod == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(174);
        }
        return new SameErasureButDifferentMethodsFix(method, superMethod);
    }

    @NotNull
    public IntentionAction createAddMissingEnumBranchesFix(@NotNull PsiSwitchBlock switchBlock, @NotNull Set<String> missingCases) {
        if (switchBlock == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(175);
        }
        if (missingCases == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(176);
        }
        return new CreateMissingSwitchBranchesFix(switchBlock, missingCases);
    }

    @NotNull
    public IntentionAction createAddSwitchDefaultFix(@NotNull PsiSwitchBlock switchBlock, String message2) {
        if (switchBlock == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(177);
        }
        return new CreateDefaultBranchFix(switchBlock, message2);
    }

    @Nullable
    public IntentionAction createCollapseAnnotationsFix(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            QuickFixFactoryImpl.$$$reportNull$$$0(178);
        }
        return CollapseAnnotationsFix.from(annotation);
    }

    @NotNull
    public IntentionAction createChangeModifierFix() {
        return new ChangeModifierIntention(true);
    }

    @NotNull
    public IntentionAction createWrapSwitchRuleStatementsIntoBlockFix(PsiSwitchLabeledRuleStatement rule) {
        return new WrapSwitchRuleStatementsIntoBlockFix(rule);
    }

    @NotNull
    public IntentionAction createAddParameterListFix(PsiMethod method) {
        return new AddParameterListFix(method);
    }

    @NotNull
    public IntentionAction createAddEmptyRecordHeaderFix(PsiClass psiClass) {
        return new AddEmptyRecordHeaderFix(psiClass);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 102: 
            case 105: 
            case 110: 
            case 113: 
            case 138: 
            case 157: 
            case 160: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 102: 
            case 105: 
            case 110: 
            case 113: 
            case 138: 
            case 157: 
            case 160: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierList";
                break;
            }
            case 1: 
            case 3: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
            case 2: 
            case 123: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 16: 
            case 21: 
            case 51: 
            case 89: 
            case 90: 
            case 131: 
            case 167: 
            case 173: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toReturn";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toClass";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodText";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptions";
                break;
            }
            case 13: 
            case 18: 
            case 19: 
            case 23: 
            case 24: 
            case 25: 
            case 33: 
            case 71: 
            case 76: 
            case 81: 
            case 83: 
            case 88: 
            case 129: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 15: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionClass";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newType";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeToExtendFrom";
                break;
            }
            case 27: 
            case 54: 
            case 128: 
            case 134: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 28: 
            case 49: 
            case 50: 
            case 115: 
            case 116: 
            case 118: 
            case 122: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 29: 
            case 31: 
            case 95: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 30: 
            case 32: 
            case 137: 
            case 140: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 35: 
            case 43: 
            case 45: 
            case 47: 
            case 72: 
            case 130: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetMember";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 55: 
            case 68: 
            case 73: 
            case 78: 
            case 79: 
            case 125: 
            case 143: 
            case 144: 
            case 146: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sign";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignment";
                break;
            }
            case 46: 
            case 48: 
            case 59: 
            case 60: 
            case 65: 
            case 84: 
            case 117: 
            case 156: 
            case 158: 
            case 170: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnStatement";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnValue";
                break;
            }
            case 56: 
            case 171: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "section";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "section1";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolved";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 69: 
            case 172: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getter";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToHighlight";
                break;
            }
            case 77: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classToExtendFrom";
                break;
            }
            case 85: 
            case 174: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superMethod";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superMethodType";
                break;
            }
            case 87: 
            case 101: 
            case 104: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 111: 
            case 166: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 91: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructor";
                break;
            }
            case 93: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetMethod";
                break;
            }
            case 94: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 96: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
            case 102: 
            case 105: 
            case 110: 
            case 113: 
            case 138: 
            case 157: 
            case 160: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/config/QuickFixFactoryImpl";
                break;
            }
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodReferenceExpression";
                break;
            }
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodOrLambda";
                break;
            }
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 120: 
            case 121: 
            case 141: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 124: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterList";
                break;
            }
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "boxedTypeName";
                break;
            }
            case 132: 
            case 147: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 133: 
            case 159: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pair";
                break;
            }
            case 135: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightInfo";
                break;
            }
            case 136: 
            case 139: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 142: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedElement";
                break;
            }
            case 145: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 148: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 149: 
            case 161: 
            case 162: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 150: 
            case 178: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 151: {
                objectArray2 = objectArray3;
                objectArray3[0] = "missedElements";
                break;
            }
            case 152: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationMethods";
                break;
            }
            case 153: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 154: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedType";
                break;
            }
            case 155: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCall";
                break;
            }
            case 163: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collectionExpression";
                break;
            }
            case 164: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionToReplace";
                break;
            }
            case 165: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayType";
                break;
            }
            case 168: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodRef";
                break;
            }
            case 169: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 175: 
            case 177: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switchBlock";
                break;
            }
            case 176: {
                objectArray2 = objectArray3;
                objectArray3[0] = "missingCases";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/config/QuickFixFactoryImpl";
                break;
            }
            case 102: {
                objectArray = objectArray2;
                objectArray2[1] = "createCreateMethodFromUsageFixes";
                break;
            }
            case 105: {
                objectArray = objectArray2;
                objectArray2[1] = "createCreateConstructorFromCallExpressionFixes";
                break;
            }
            case 110: {
                objectArray = objectArray2;
                objectArray2[1] = "createCreateConstructorFromUsageFixes";
                break;
            }
            case 113: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableTypeFromCallFixes";
                break;
            }
            case 138: {
                objectArray = objectArray2;
                objectArray2[1] = "createAddToDependencyInjectionAnnotationsFix";
                break;
            }
            case 157: {
                objectArray = objectArray2;
                objectArray2[1] = "createWrapWithOptionalFix";
                break;
            }
            case 160: {
                objectArray = objectArray2;
                objectArray2[1] = "createAddAnnotationAttributeNameFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createModifierListFix";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createMethodReturnFix";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createAddMethodFix";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createImplementMethodsFix";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createAssignmentToComparisonFix";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createMethodThrowsFix";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createAddDefaultConstructorFix";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createAddConstructorFix";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createMethodParameterTypeFix";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createMakeClassInterfaceFix";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createExtendsListFix";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createRemoveUnusedParameterFix";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createRemoveUnusedVariableFix";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createCreateClassOrPackageFix";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "createCreateClassOrInterfaceFix";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "createCreateFieldOrPropertyFix";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "createAddExceptionToThrowsFix";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "createAddExceptionFromFieldInitializerToConstructorThrowsFix";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "createSurroundWithTryCatchFix";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "createAddExceptionToExistingCatch";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "createChangeToAppendFix";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "createAddTypeCastFix";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "createWrapExpressionFix";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "createReuseVariableDeclarationFix";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "createNavigateToAlreadyDeclaredVariableFix";
                break;
            }
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "createDeleteReturnFix";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "createDeleteCatchFix";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "createDeleteMultiCatchFix";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "createConvertSwitchToIfIntention";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "createNegationBroadScopeFix";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "createCreateFieldFromUsageFix";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "createReplaceWithListAccessFix";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "createAddNewArrayExpressionFix";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "createMoveCatchUpFix";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "createRenameWrongRefFix";
                break;
            }
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "createRemoveQualifierFix";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "createRemoveParameterListFix";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "createShowModulePropertiesFix";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "createIncreaseLanguageLevelFix";
                break;
            }
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "createChangeParameterClassFix";
                break;
            }
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "createReplaceInaccessibleFieldWithGetterSetterFix";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "createImplementAbstractClassMethodsFix";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "createMoveClassToSeparateFileFix";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "createRenameFileFix";
                break;
            }
            case 78: 
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "createRenameElementFix";
                break;
            }
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "createChangeExtendsToImplementsFix";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "createCreateConstructorMatchingSuperFix";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "createRemoveNewQualifierFix";
                break;
            }
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "createSuperMethodReturnFix";
                break;
            }
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "createInsertNewFix";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "createAddMethodBodyFix";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "createDeleteMethodBodyFix";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "createInsertSuperFix";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "createInsertThisFix";
                break;
            }
            case 93: 
            case 94: 
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "createChangeMethodSignatureFromUsageFix";
                break;
            }
            case 97: 
            case 98: 
            case 99: 
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "createChangeMethodSignatureFromUsageReverseOrderFix";
                break;
            }
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "createCreateMethodFromUsageFixes";
                break;
            }
            case 102: 
            case 105: 
            case 110: 
            case 113: 
            case 138: 
            case 157: 
            case 160: {
                break;
            }
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "createCreateMethodFromUsageFix";
                break;
            }
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "createCreateConstructorFromCallExpressionFixes";
                break;
            }
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "createStaticImportMethodFix";
                break;
            }
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "createQualifyStaticMethodCallFix";
                break;
            }
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "createReplaceAddAllArrayToCollectionFix";
                break;
            }
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "createCreateConstructorFromUsageFixes";
                break;
            }
            case 111: 
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "getVariableTypeFromCallFixes";
                break;
            }
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "createAddReturnFix";
                break;
            }
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "createAddVariableInitializerFix";
                break;
            }
            case 116: 
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "createDeferFinalAssignmentFix";
                break;
            }
            case 118: 
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "createVariableAccessFromInnerClassFix";
                break;
            }
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "createCreateConstructorParameterFromFieldFix";
                break;
            }
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "createInitializeFinalFieldInConstructorFix";
                break;
            }
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "createRemoveTypeArgumentsFix";
                break;
            }
            case 123: 
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "createChangeClassSignatureFromUsageFix";
                break;
            }
            case 125: 
            case 126: 
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "createReplacePrimitiveWithBoxedTypeAction";
                break;
            }
            case 128: {
                objectArray = objectArray;
                objectArray[2] = "createMakeVarargParameterLastFix";
                break;
            }
            case 129: 
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "createMoveBoundClassToFrontFix";
                break;
            }
            case 131: 
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "registerPullAsAbstractUpFixes";
                break;
            }
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "createCreateAnnotationMethodFromUsageFix";
                break;
            }
            case 134: 
            case 135: {
                objectArray = objectArray;
                objectArray[2] = "registerFixesForUnusedParameter";
                break;
            }
            case 136: 
            case 137: {
                objectArray = objectArray;
                objectArray[2] = "createAddToDependencyInjectionAnnotationsFix";
                break;
            }
            case 139: 
            case 140: {
                objectArray = objectArray;
                objectArray[2] = "createAddToImplicitlyWrittenFieldsFix";
                break;
            }
            case 141: {
                objectArray = objectArray;
                objectArray[2] = "createCreateGetterOrSetterFix";
                break;
            }
            case 142: {
                objectArray = objectArray;
                objectArray[2] = "createRenameToIgnoredFix";
                break;
            }
            case 143: 
            case 144: 
            case 145: {
                objectArray = objectArray;
                objectArray[2] = "createDeleteFix";
                break;
            }
            case 146: {
                objectArray = objectArray;
                objectArray[2] = "createSafeDeleteFix";
                break;
            }
            case 147: 
            case 148: {
                objectArray = objectArray;
                objectArray[2] = "registerOrderEntryFixes";
                break;
            }
            case 149: {
                objectArray = objectArray;
                objectArray[2] = "invokeOnTheFlyImportOptimizer";
                break;
            }
            case 150: 
            case 151: 
            case 152: {
                objectArray = objectArray;
                objectArray[2] = "createAddMissingRequiredAnnotationParametersFix";
                break;
            }
            case 153: 
            case 154: {
                objectArray = objectArray;
                objectArray[2] = "createSurroundWithQuotesAnnotationParameterValueFix";
                break;
            }
            case 155: {
                objectArray = objectArray;
                objectArray[2] = "addMethodQualifierFix";
                break;
            }
            case 156: {
                objectArray = objectArray;
                objectArray[2] = "createWrapWithOptionalFix";
                break;
            }
            case 158: {
                objectArray = objectArray;
                objectArray[2] = "createNotIterableForEachLoopFix";
                break;
            }
            case 159: {
                objectArray = objectArray;
                objectArray[2] = "createAddAnnotationAttributeNameFixes";
                break;
            }
            case 161: {
                objectArray = objectArray;
                objectArray[2] = "timeToOptimizeImports";
                break;
            }
            case 162: {
                objectArray = objectArray;
                objectArray[2] = "containsErrorsPreventingOptimize";
                break;
            }
            case 163: 
            case 164: 
            case 165: {
                objectArray = objectArray;
                objectArray[2] = "createCollectionToArrayFix";
                break;
            }
            case 166: 
            case 167: {
                objectArray = objectArray;
                objectArray[2] = "createInsertMethodCallFix";
                break;
            }
            case 168: 
            case 169: {
                objectArray = objectArray;
                objectArray[2] = "createAccessStaticViaInstanceFix";
                break;
            }
            case 170: {
                objectArray = objectArray;
                objectArray[2] = "createWrapWithAdapterFix";
                break;
            }
            case 171: {
                objectArray = objectArray;
                objectArray[2] = "createDeleteSideEffectAwareFix";
                break;
            }
            case 172: {
                objectArray = objectArray;
                objectArray[2] = "createCreateClassInPackageInModuleFix";
                break;
            }
            case 173: 
            case 174: {
                objectArray = objectArray;
                objectArray[2] = "createSameErasureButDifferentMethodsFix";
                break;
            }
            case 175: 
            case 176: {
                objectArray = objectArray;
                objectArray[2] = "createAddMissingEnumBranchesFix";
                break;
            }
            case 177: {
                objectArray = objectArray;
                objectArray[2] = "createAddSwitchDefaultFix";
                break;
            }
            case 178: {
                objectArray = objectArray;
                objectArray[2] = "createCollapseAnnotationsFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 102: 
            case 105: 
            case 110: 
            case 113: 
            case 138: 
            case 157: 
            case 160: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

