/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl.lists;

import com.google.common.collect.Lists;
import com.intellij.codeInsight.intention.impl.lists.AbstractListIntentionAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractJoinListAction<L extends PsiElement, E extends PsiElement>
extends AbstractListIntentionAction<L, E> {
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            AbstractJoinListAction.$$$reportNull$$$0(0);
        }
        if (element == null) {
            AbstractJoinListAction.$$$reportNull$$$0(1);
        }
        return this.from(element) != null;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        Context<L> context;
        if (project == null) {
            AbstractJoinListAction.$$$reportNull$$$0(2);
        }
        if (element == null) {
            AbstractJoinListAction.$$$reportNull$$$0(3);
        }
        if ((context = this.from(element)) == null) {
            return;
        }
        WhitespacesInfo info = context.myWhitespacesInfo;
        List reversedBreaks = Lists.reverse(info.myBreaks);
        Document document = editor.getDocument();
        AbstractJoinListAction.deleteBreakIfPresent(document, info.myAfterLastBreak);
        for (PsiElement aBreak : reversedBreaks) {
            TextRange range = aBreak.getTextRange();
            document.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)" ");
        }
        AbstractJoinListAction.deleteBreakIfPresent(document, info.myBeforeFirstBreak);
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        documentManager.commitDocument(document);
        CodeStyleManager.getInstance((Project)project).adjustLineIndent(context.myList.getContainingFile(), context.myList.getParent().getTextRange());
    }

    private static void deleteBreakIfPresent(Document document, PsiElement aBreak) {
        if (aBreak != null) {
            TextRange range = aBreak.getTextRange();
            document.deleteString(range.getStartOffset(), range.getEndOffset());
        }
    }

    private Context<L> from(@NotNull PsiElement element) {
        Object list;
        if (element == null) {
            AbstractJoinListAction.$$$reportNull$$$0(4);
        }
        if ((list = this.extractList(element)) == null) {
            return null;
        }
        List elements = this.getElements(list);
        if (elements == null) {
            return null;
        }
        if (elements.size() < this.minElementCount()) {
            return null;
        }
        if (!this.canJoin(elements)) {
            return null;
        }
        WhitespacesInfo whitespacesInfo = this.collectBreakWhitespaces(elements);
        if (whitespacesInfo == null) {
            return null;
        }
        return new Context(whitespacesInfo, (PsiElement)list, null);
    }

    protected boolean canJoin(@NotNull List<E> elements) {
        if (elements == null) {
            AbstractJoinListAction.$$$reportNull$$$0(5);
        }
        return true;
    }

    private WhitespacesInfo collectBreakWhitespaces(List<E> elements) {
        ArrayList<PsiElement> breaks = new ArrayList<PsiElement>();
        PsiElement beforeFirst = null;
        PsiElement afterLastToDelete = null;
        int size = elements.size();
        for (int i = 0; i < size; ++i) {
            PsiElement nextBreak;
            PsiElement current = (PsiElement)elements.get(i);
            if (i == 0 && !this.needHeadBreak(current)) {
                beforeFirst = this.prevBreak(current);
            }
            if ((nextBreak = this.nextBreak(current)) == null) continue;
            if (i == size - 1) {
                if (this.needTailBreak(current)) continue;
                afterLastToDelete = nextBreak;
                continue;
            }
            breaks.add(nextBreak);
        }
        if (breaks.isEmpty() && beforeFirst == null && afterLastToDelete == null) {
            return null;
        }
        return new WhitespacesInfo(breaks, beforeFirst, afterLastToDelete);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/intention/impl/lists/AbstractJoinListAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "from";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "canJoin";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class WhitespacesInfo {
        @NotNull
        final List<PsiElement> myBreaks;
        @Nullable
        final PsiElement myBeforeFirstBreak;
        @Nullable
        final PsiElement myAfterLastBreak;

        private WhitespacesInfo(@NotNull List<PsiElement> breaks, @Nullable PsiElement beforeFirstBreak, @Nullable PsiElement afterLastBreak) {
            if (breaks == null) {
                WhitespacesInfo.$$$reportNull$$$0(0);
            }
            this.myBreaks = breaks;
            this.myBeforeFirstBreak = beforeFirstBreak;
            this.myAfterLastBreak = afterLastBreak;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breaks", "com/intellij/codeInsight/intention/impl/lists/AbstractJoinListAction$WhitespacesInfo", "<init>"));
        }
    }

    private static class Context<L extends PsiElement> {
        @NotNull
        final WhitespacesInfo myWhitespacesInfo;
        @NotNull
        final L myList;

        private Context(@NotNull WhitespacesInfo info, @NotNull L list) {
            if (info == null) {
                Context.$$$reportNull$$$0(0);
            }
            if (list == null) {
                Context.$$$reportNull$$$0(1);
            }
            this.myWhitespacesInfo = info;
            this.myList = list;
        }

        /* synthetic */ Context(WhitespacesInfo x0, PsiElement x1, 1 x2) {
            this(x0, x1);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "info";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "list";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/intention/impl/lists/AbstractJoinListAction$Context";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

