/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.daemon.impl.PsiElementListNavigator;
import com.intellij.codeInsight.generation.actions.PresentableCodeInsightActionHandler;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.util.MethodCellRenderer;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.idea.ActionsBundle;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.impl.FindSuperElementsHelper;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaGotoSuperHandler
implements PresentableCodeInsightActionHandler {
    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            JavaGotoSuperHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            JavaGotoSuperHandler.$$$reportNull$$$0(1);
        }
        if (file == null) {
            JavaGotoSuperHandler.$$$reportNull$$$0(2);
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("navigation.goto.super");
        int offset = editor.getCaretModel().getOffset();
        PsiElement[] superElements = this.findSuperElements(file, offset);
        if (superElements.length == 0) {
            return;
        }
        if (superElements.length == 1) {
            PsiElement superElement = superElements[0].getNavigationElement();
            PsiFile containingFile = superElement.getContainingFile();
            if (containingFile == null) {
                return;
            }
            VirtualFile virtualFile = containingFile.getVirtualFile();
            if (virtualFile == null) {
                return;
            }
            Navigatable descriptor = PsiNavigationSupport.getInstance().createNavigatable(project, virtualFile, superElement.getTextOffset());
            descriptor.navigate(true);
        } else if (superElements[0] instanceof PsiMethod) {
            boolean showMethodNames = !PsiUtil.allMethodsHaveSameSignature((PsiMethod[])((PsiMethod[])superElements));
            PsiElementListNavigator.openTargets((Editor)editor, (NavigatablePsiElement[])((PsiMethod[])superElements), (String)CodeInsightBundle.message((String)"goto.super.method.chooser.title", (Object[])new Object[0]), (String)CodeInsightBundle.message((String)"goto.super.method.findUsages.title", (Object[])new Object[]{((PsiMethod)superElements[0]).getName()}), (ListCellRenderer)((Object)new MethodCellRenderer(showMethodNames)));
        } else {
            NavigationUtil.getPsiElementPopup((PsiElement[])superElements, (String)JavaBundle.message((String)"goto.super.class.chooser.title", (Object[])new Object[0])).showInBestPositionFor(editor);
        }
    }

    private PsiElement @NotNull [] findSuperElements(@NotNull PsiFile file, int offset) {
        PsiMethod interfaceMethod;
        PsiElement element;
        if (file == null) {
            JavaGotoSuperHandler.$$$reportNull$$$0(3);
        }
        if ((element = this.getElement(file, offset)) == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                JavaGotoSuperHandler.$$$reportNull$$$0(4);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement psiElement = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiFunctionalExpression.class, PsiMember.class});
        if (psiElement instanceof PsiFunctionalExpression && (interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiElement)psiElement)) != null) {
            PsiElement[] psiElementArray = (PsiElement[])ArrayUtil.prepend((Object)interfaceMethod, (Object[])interfaceMethod.findSuperMethods(false));
            if (psiElementArray == null) {
                JavaGotoSuperHandler.$$$reportNull$$$0(5);
            }
            return psiElementArray;
        }
        PsiNameIdentifierOwner parent = (PsiNameIdentifierOwner)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{PsiMethod.class, PsiClass.class});
        if (parent == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                JavaGotoSuperHandler.$$$reportNull$$$0(6);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement[] psiElementArray = FindSuperElementsHelper.findSuperElements((PsiElement)parent);
        if (psiElementArray == null) {
            JavaGotoSuperHandler.$$$reportNull$$$0(7);
        }
        return psiElementArray;
    }

    protected PsiElement getElement(@NotNull PsiFile file, int offset) {
        if (file == null) {
            JavaGotoSuperHandler.$$$reportNull$$$0(8);
        }
        return file.findElementAt(offset);
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void update(@NotNull Editor editor, @NotNull PsiFile file, Presentation presentation) {
        if (editor == null) {
            JavaGotoSuperHandler.$$$reportNull$$$0(9);
        }
        if (file == null) {
            JavaGotoSuperHandler.$$$reportNull$$$0(10);
        }
        this.update(editor, file, presentation, null);
    }

    public void update(@NotNull Editor editor, @NotNull PsiFile file, Presentation presentation, @Nullable String actionPlace) {
        boolean useShortName;
        if (editor == null) {
            JavaGotoSuperHandler.$$$reportNull$$$0(11);
        }
        if (file == null) {
            JavaGotoSuperHandler.$$$reportNull$$$0(12);
        }
        PsiElement element = this.getElement(file, editor.getCaretModel().getOffset());
        PsiElement containingElement = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiFunctionalExpression.class, PsiMember.class});
        boolean bl = useShortName = actionPlace != null && ("MainMenu".equals(actionPlace) || ActionPlaces.isPopupPlace((String)actionPlace));
        if (containingElement instanceof PsiClass) {
            presentation.setText(ActionsBundle.actionText((String)(useShortName ? "GotoSuperClass.MainMenu" : "GotoSuperClass")));
            presentation.setDescription(ActionsBundle.actionDescription((String)"GotoSuperClass"));
        } else {
            presentation.setText(ActionsBundle.actionText((String)(useShortName ? "GotoSuperMethod.MainMenu" : "GotoSuperMethod")));
            presentation.setDescription(ActionsBundle.actionDescription((String)"GotoSuperMethod"));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/navigation/JavaGotoSuperHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/navigation/JavaGotoSuperHandler";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findSuperElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findSuperElements";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getElement";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

