/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.templates;

import com.intellij.codeInsight.guess.GuessManager;
import com.intellij.codeInsight.lookup.PsiTypeLookupItem;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.PsiTypeResult;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.macro.SuggestVariableNameMacro;
import com.intellij.codeInsight.template.postfix.templates.StringBasedPostfixTemplate;
import com.intellij.codeInsight.template.postfix.util.JavaPostfixTemplatesUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CastVarPostfixTemplate
extends StringBasedPostfixTemplate {
    private static final String TYPE_VAR = "typeVar";
    private static final String VAR_NAME = "varName";

    public CastVarPostfixTemplate() {
        super("castvar", "T name = (T)expr", JavaPostfixTemplatesUtils.selectorTopmost(JavaPostfixTemplatesUtils.IS_NON_VOID));
    }

    @Nullable
    public String getTemplateString(@NotNull PsiElement element) {
        if (element == null) {
            CastVarPostfixTemplate.$$$reportNull$$$0(0);
        }
        PsiFile file = element.getContainingFile();
        boolean isFinal = JavaCodeStyleSettings.getInstance((PsiFile)file).GENERATE_FINAL_LOCALS;
        return (isFinal ? "final " : "") + "$" + TYPE_VAR + "$ $" + VAR_NAME + "$ = ($" + TYPE_VAR + "$)$expr$;$END$";
    }

    public void setVariables(@NotNull Template template, @NotNull PsiElement element) {
        if (template == null) {
            CastVarPostfixTemplate.$$$reportNull$$$0(1);
        }
        if (element == null) {
            CastVarPostfixTemplate.$$$reportNull$$$0(2);
        }
        super.setVariables(template, element);
        if (element instanceof PsiExpression) {
            PsiType[] types = GuessManager.getInstance(element.getProject()).guessTypeToCast((PsiExpression)element);
            CastVarPostfixTemplate.fill(template, types, element);
        } else {
            template.addVariable(TYPE_VAR, null, null, true, false);
        }
        MacroCallNode nameMacro = new MacroCallNode((Macro)new SuggestVariableNameMacro());
        template.addVariable(VAR_NAME, (Expression)nameMacro, (Expression)nameMacro, true);
    }

    private static void fill(@NotNull Template template, PsiType @NotNull [] suggestedTypes, @NotNull PsiElement context) {
        if (template == null) {
            CastVarPostfixTemplate.$$$reportNull$$$0(3);
        }
        if (context == null) {
            CastVarPostfixTemplate.$$$reportNull$$$0(4);
        }
        if (suggestedTypes == null) {
            CastVarPostfixTemplate.$$$reportNull$$$0(5);
        }
        LinkedHashSet<PsiTypeLookupItem> itemSet = new LinkedHashSet<PsiTypeLookupItem>();
        for (PsiType type2 : suggestedTypes) {
            itemSet.add(PsiTypeLookupItem.createLookupItem(type2, null));
        }
        PsiTypeResult result = suggestedTypes.length > 0 ? new PsiTypeResult(suggestedTypes[0], context.getProject()) : null;
        ConstantNode expr2 = new ConstantNode((Result)result).withLookupItems(itemSet.size() > 1 ? itemSet : Collections.emptyList());
        template.addVariable(TYPE_VAR, (Expression)expr2, (Expression)expr2, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suggestedTypes";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/template/postfix/templates/CastVarPostfixTemplate";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getTemplateString";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setVariables";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "fill";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

