/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.openapi.diagnostic.Logger;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.Handle;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.TypePath;
import org.jetbrains.org.objectweb.asm.signature.SignatureReader;
import org.jetbrains.org.objectweb.asm.signature.SignatureVisitor;

public abstract class AbstractDependencyVisitor
extends ClassVisitor {
    private static final Logger LOG = Logger.getInstance(AbstractDependencyVisitor.class);
    private static final Label LABEL = new Label();
    private final AnnotationDependencyVisitor myAnnotationVisitor = new AnnotationDependencyVisitor();
    private final DependencySignatureVisitor mySignatureVisitor = new DependencySignatureVisitor();
    private final DependencyFieldVisitor myFieldVisitor = new DependencyFieldVisitor();
    private String myCurrentClassName;
    private final Map<String, String> mySlotNames = new HashMap<String, String>();

    protected AbstractDependencyVisitor() {
        super(458752);
    }

    protected abstract void addClassName(String var1);

    public void processFile(File file) {
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));){
            this.processStream(is);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    public void processStream(InputStream is) throws IOException {
        ClassReader cr = new ClassReader(is){

            protected Label readLabel(int offset, Label[] labels2) {
                if (offset >= labels2.length) {
                    return LABEL;
                }
                return super.readLabel(offset, labels2);
            }
        };
        cr.accept((ClassVisitor)this, 4);
    }

    public void visit(int version, int access, String name2, String signature, String superName, String[] interfaces) {
        this.myCurrentClassName = this.getSlotName(name2);
        if (signature == null) {
            this.addName(superName);
            this.addNames(interfaces);
        } else {
            this.addSignature(signature);
        }
    }

    private String getSlotName(String name2) {
        String result = this.mySlotNames.get(name2);
        if (result == null) {
            result = name2.replace("/", ".");
            int idx = result.indexOf("$");
            if (idx >= 0) {
                result = result.substring(0, idx);
            }
            this.mySlotNames.put(name2, result);
        }
        return result;
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        this.addDesc(desc);
        return this.myAnnotationVisitor;
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        this.addDesc(desc);
        return this.myAnnotationVisitor;
    }

    public FieldVisitor visitField(int access, String name2, String desc, String signature, Object value2) {
        if (signature == null) {
            this.addDesc(desc);
        } else {
            this.addTypeSignature(signature);
        }
        if (value2 instanceof Type) {
            this.addType((Type)value2);
        }
        return this.myFieldVisitor;
    }

    public MethodVisitor visitMethod(int access, String name2, String desc, String signature, String[] exceptions) {
        if ((access & 0x1000) == 0) {
            if (signature == null) {
                this.addMethodDesc(desc);
            } else {
                this.addSignature(signature);
            }
            this.addNames(exceptions);
        }
        if ((access & 0x400) != 0) {
            return null;
        }
        return new DependencyMethodVisitor();
    }

    private void addName(String name2) {
        if (name2 == null) {
            return;
        }
        if ((name2 = this.getSlotName(name2)).equals(this.myCurrentClassName)) {
            return;
        }
        this.addClassName(name2);
    }

    private void addNames(String[] names2) {
        for (int i = 0; names2 != null && i < names2.length; ++i) {
            this.addName(names2[i]);
        }
    }

    private void addDesc(String desc) {
        this.addType(Type.getType((String)desc));
    }

    private void addHandle(Handle h) {
        this.addName(h.getOwner());
        this.addMethodDesc(h.getDesc());
    }

    private void addMethodDesc(String desc) {
        Type[] types;
        this.addType(Type.getReturnType((String)desc));
        for (Type type2 : types = Type.getArgumentTypes((String)desc)) {
            this.addType(type2);
        }
    }

    private void addType(Type t) {
        switch (t.getSort()) {
            case 9: {
                this.addType(t.getElementType());
                break;
            }
            case 10: {
                this.addName(t.getClassName().replace('.', '/'));
                break;
            }
            case 11: {
                this.addMethodDesc(t.getDescriptor());
            }
        }
    }

    private void addSignature(String signature) {
        if (signature != null) {
            new SignatureReader(signature).accept((SignatureVisitor)this.mySignatureVisitor);
        }
    }

    private void addTypeSignature(String signature) {
        if (signature != null) {
            new SignatureReader(signature).acceptType((SignatureVisitor)this.mySignatureVisitor);
        }
    }

    public String getCurrentClassName() {
        return this.myCurrentClassName;
    }

    private class DependencySignatureVisitor
    extends SignatureVisitor {
        DependencySignatureVisitor() {
            super(458752);
        }

        public void visitClassType(String name2) {
            AbstractDependencyVisitor.this.addName(name2);
        }

        public void visitInnerClassType(String name2) {
            AbstractDependencyVisitor.this.addName(name2);
        }
    }

    private class AnnotationDependencyVisitor
    extends AnnotationVisitor {
        AnnotationDependencyVisitor() {
            super(458752);
        }

        public void visit(String name2, Object value2) {
            if (value2 instanceof Type) {
                AbstractDependencyVisitor.this.addType((Type)value2);
            }
        }

        public void visitEnum(String name2, String desc, String value2) {
            AbstractDependencyVisitor.this.addDesc(desc);
        }

        public AnnotationVisitor visitAnnotation(String name2, String desc) {
            AbstractDependencyVisitor.this.addDesc(desc);
            return this;
        }

        public AnnotationVisitor visitArray(String name2) {
            return this;
        }
    }

    private class DependencyFieldVisitor
    extends FieldVisitor {
        DependencyFieldVisitor() {
            super(458752);
        }

        public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            AbstractDependencyVisitor.this.addDesc(desc);
            return AbstractDependencyVisitor.this.myAnnotationVisitor;
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            AbstractDependencyVisitor.this.addDesc(desc);
            return AbstractDependencyVisitor.this.myAnnotationVisitor;
        }
    }

    private class DependencyMethodVisitor
    extends MethodVisitor {
        private Label myFirstLabel;

        DependencyMethodVisitor() {
            super(458752);
            this.myFirstLabel = null;
        }

        public void visitLabel(Label label) {
            if (this.myFirstLabel == null) {
                this.myFirstLabel = label;
            }
        }

        public AnnotationVisitor visitAnnotationDefault() {
            return AbstractDependencyVisitor.this.myAnnotationVisitor;
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            AbstractDependencyVisitor.this.addDesc(desc);
            return AbstractDependencyVisitor.this.myAnnotationVisitor;
        }

        public AnnotationVisitor visitParameterAnnotation(int parameter2, String desc, boolean visible) {
            AbstractDependencyVisitor.this.addDesc(desc);
            return AbstractDependencyVisitor.this.myAnnotationVisitor;
        }

        public void visitTypeInsn(int opcode, String desc) {
            if (187 == opcode) {
                return;
            }
            if (desc.charAt(0) == '[') {
                AbstractDependencyVisitor.this.addDesc(desc);
            } else {
                AbstractDependencyVisitor.this.addName(desc);
            }
        }

        public void visitFieldInsn(int opcode, String owner2, String name2, String desc) {
            AbstractDependencyVisitor.this.addName(owner2);
            AbstractDependencyVisitor.this.addDesc(desc);
        }

        public void visitMethodInsn(int opcode, String owner2, String name2, String desc, boolean itf) {
            AbstractDependencyVisitor.this.addName(owner2);
            AbstractDependencyVisitor.this.addMethodDesc(desc);
        }

        public void visitLdcInsn(Object cst) {
            if (cst instanceof Type) {
                AbstractDependencyVisitor.this.addType((Type)cst);
            }
        }

        public void visitMultiANewArrayInsn(String desc, int dims) {
            AbstractDependencyVisitor.this.addDesc(desc);
        }

        public void visitTryCatchBlock(Label start, Label end, Label handler, String type2) {
            AbstractDependencyVisitor.this.addName(type2);
        }

        public void visitLocalVariable(String name2, String desc, String signature, Label start, Label end, int index) {
            if (this.myFirstLabel == start) {
                return;
            }
            AbstractDependencyVisitor.this.addTypeSignature(signature == null ? desc : signature);
        }

        public void visitInvokeDynamicInsn(String name2, String desc, Handle bsm, Object ... bsmArgs) {
            AbstractDependencyVisitor.this.addDesc(desc);
            for (Object arg : bsmArgs) {
                if (!(arg instanceof Handle)) continue;
                AbstractDependencyVisitor.this.addHandle((Handle)arg);
            }
        }

        public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            AbstractDependencyVisitor.this.addDesc(desc);
            return AbstractDependencyVisitor.this.myAnnotationVisitor;
        }

        public AnnotationVisitor visitInsnAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            AbstractDependencyVisitor.this.addDesc(desc);
            return AbstractDependencyVisitor.this.myAnnotationVisitor;
        }

        public AnnotationVisitor visitTryCatchAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            AbstractDependencyVisitor.this.addDesc(desc);
            return AbstractDependencyVisitor.this.myAnnotationVisitor;
        }

        public AnnotationVisitor visitLocalVariableAnnotation(int typeRef, TypePath typePath, Label[] start, Label[] end, int[] index, String desc, boolean visible) {
            AbstractDependencyVisitor.this.addDesc(desc);
            return AbstractDependencyVisitor.this.myAnnotationVisitor;
        }
    }
}

