/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.JavaSuppressionUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import org.jetbrains.annotations.NotNull;

public class AddAssertStatementFix
implements LocalQuickFix {
    private static final Logger LOG = Logger.getInstance(AddAssertStatementFix.class);
    private final String myText;

    public AddAssertStatementFix(@NotNull String text2) {
        if (text2 == null) {
            AddAssertStatementFix.$$$reportNull$$$0(0);
        }
        this.myText = text2;
    }

    @NotNull
    public String getName() {
        String string = JavaBundle.message((String)"inspection.assert.quickfix", (Object[])new Object[]{this.myText});
        if (string == null) {
            AddAssertStatementFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiExpression element;
        if (project == null) {
            AddAssertStatementFix.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            AddAssertStatementFix.$$$reportNull$$$0(3);
        }
        if ((element = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiExpression.class)) == null) {
            return;
        }
        if ((element = RefactoringUtil.ensureCodeBlock(element)) == null) {
            return;
        }
        PsiElement anchorElement = RefactoringUtil.getParentStatement((PsiElement)element, false);
        LOG.assertTrue(anchorElement != null);
        PsiElement prev = PsiTreeUtil.skipWhitespacesBackward((PsiElement)anchorElement);
        if (prev instanceof PsiComment && JavaSuppressionUtil.getSuppressedInspectionIdsIn(prev) != null) {
            anchorElement = prev;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)element.getProject());
        String text2 = "assert " + this.myText + ";";
        PsiAssertStatement assertStatement = (PsiAssertStatement)factory.createStatementFromText(text2, (PsiElement)element);
        anchorElement.getParent().addBefore((PsiElement)assertStatement, anchorElement);
    }

    @NotNull
    public String getFamilyName() {
        String string = JavaBundle.message((String)"inspection.quickfix.assert.family", (Object[])new Object[0]);
        if (string == null) {
            AddAssertStatementFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/AddAssertStatementFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/AddAssertStatementFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

