/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.CommentTracker;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ClassGetClassInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final CallMatcher OBJECT_GET_CLASS = CallMatcher.instanceCall("java.lang.Object", "getClass").parameterCount(0);

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            ClassGetClassInspection.$$$reportNull$$$0(0);
        }
        return new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression call) {
                if (!OBJECT_GET_CLASS.test(call)) {
                    return;
                }
                if (call.getParent() instanceof PsiExpressionStatement && !(call.getParent().getParent() instanceof PsiSwitchLabeledRuleStatement)) {
                    return;
                }
                PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
                if (qualifier == null) {
                    return;
                }
                PsiType type2 = qualifier.getType();
                if (!(type2 instanceof PsiClassType)) {
                    return;
                }
                if (!((PsiClassType)type2).rawType().equalsToText("java.lang.Class")) {
                    return;
                }
                holder.registerProblem(Objects.requireNonNull(call.getMethodExpression().getReferenceNameElement()), JavaAnalysisBundle.message((String)"inspection.class.getclass.message", (Object[])new Object[0]), new LocalQuickFix[]{new RemoveGetClassCallFix(), new ReplaceWithClassClassFix()});
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/ClassGetClassInspection", "buildVisitor"));
    }

    private static class ReplaceWithClassClassFix
    implements LocalQuickFix {
        private ReplaceWithClassClassFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = JavaAnalysisBundle.message((String)"inspection.class.getclass.fix.replace.name", (Object[])new Object[0]);
            if (string == null) {
                ReplaceWithClassClassFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiMethodCallExpression call;
            if (project == null) {
                ReplaceWithClassClassFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                ReplaceWithClassClassFix.$$$reportNull$$$0(2);
            }
            if ((call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getStartElement(), PsiMethodCallExpression.class)) == null) {
                return;
            }
            CommentTracker ct = new CommentTracker();
            ct.replaceAndRestoreComments((PsiElement)call, "java.lang.Class.class");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/ClassGetClassInspection$ReplaceWithClassClassFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/ClassGetClassInspection$ReplaceWithClassClassFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class RemoveGetClassCallFix
    implements LocalQuickFix {
        private RemoveGetClassCallFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = JavaAnalysisBundle.message((String)"inspection.class.getclass.fix.remove.name", (Object[])new Object[0]);
            if (string == null) {
                RemoveGetClassCallFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiMethodCallExpression call;
            if (project == null) {
                RemoveGetClassCallFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                RemoveGetClassCallFix.$$$reportNull$$$0(2);
            }
            if ((call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getStartElement(), PsiMethodCallExpression.class)) == null) {
                return;
            }
            PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            new CommentTracker().replaceAndRestoreComments((PsiElement)call, (PsiElement)qualifier);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/ClassGetClassInspection$RemoveGetClassCallFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/ClassGetClassInspection$RemoveGetClassCallFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

