/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.DefUseUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ComparatorResultComparisonInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final CallMatcher COMPARE_METHOD = CallMatcher.anyOf(CallMatcher.instanceCall("java.util.Comparator", "compare").parameterCount(2), CallMatcher.instanceCall("java.lang.Comparable", "compareTo").parameterCount(1));
    public static final LongRangeSet NEGATIVE_INTEGERS = LongRangeSet.range(Integer.MIN_VALUE, -1L);
    public static final LongRangeSet POSITIVE_INTEGERS = LongRangeSet.range(1L, Integer.MAX_VALUE);

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            ComparatorResultComparisonInspection.$$$reportNull$$$0(0);
        }
        return new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression call) {
                if (!COMPARE_METHOD.test(call)) {
                    return;
                }
                this.checkComparison((PsiElement)call);
                PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)call.getParent());
                if (parent instanceof PsiLocalVariable) {
                    PsiLocalVariable var = (PsiLocalVariable)parent;
                    PsiCodeBlock block = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)var, PsiCodeBlock.class);
                    PsiExpression initializer = var.getInitializer();
                    if (block != null && initializer != null) {
                        for (PsiElement element : DefUseUtil.getRefs(block, (PsiVariable)var, (PsiElement)initializer)) {
                            this.checkComparison(element);
                        }
                    }
                }
            }

            private void checkComparison(PsiElement compareExpression) {
                LongRangeSet rangeSet;
                boolean yodaCondition;
                PsiExpression constOperand;
                PsiBinaryExpression binOp = (PsiBinaryExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprUp((PsiElement)compareExpression.getParent()), PsiBinaryExpression.class);
                if (binOp == null) {
                    return;
                }
                PsiJavaToken sign = binOp.getOperationSign();
                IElementType tokenType = sign.getTokenType();
                RelationType relation = RelationType.fromElementType(tokenType);
                if (relation == null) {
                    return;
                }
                PsiExpression psiExpression = constOperand = PsiTreeUtil.isAncestor((PsiElement)binOp.getLOperand(), (PsiElement)compareExpression, (boolean)false) ? binOp.getROperand() : binOp.getLOperand();
                if (constOperand == null) {
                    return;
                }
                Object constantExpression = ExpressionUtils.computeConstantExpression(constOperand);
                if (!(constantExpression instanceof Integer)) {
                    return;
                }
                int value2 = (Integer)constantExpression;
                if (value2 == 0) {
                    return;
                }
                boolean bl = yodaCondition = constOperand == binOp.getLOperand();
                if (yodaCondition) {
                    relation = relation.getFlipped();
                }
                if (this.coversPartially(rangeSet = LongRangeSet.point(value2).fromRelation(relation), NEGATIVE_INTEGERS)) {
                    this.register(sign, yodaCondition, rangeSet.intersects(POSITIVE_INTEGERS) ? null : RelationType.LT);
                } else if (this.coversPartially(rangeSet, POSITIVE_INTEGERS)) {
                    this.register(sign, yodaCondition, rangeSet.intersects(NEGATIVE_INTEGERS) ? null : RelationType.GT);
                }
            }

            private boolean coversPartially(LongRangeSet testedRange, LongRangeSet coveredRange) {
                LongRangeSet intersection = testedRange.intersect(coveredRange);
                return !intersection.isEmpty() && !coveredRange.subtract(intersection).isEmpty();
            }

            private void register(PsiJavaToken sign, boolean yodaCondition, RelationType relationType) {
                LocalQuickFix[] localQuickFixArray;
                if (relationType == null) {
                    localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
                } else {
                    LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                    localQuickFixArray = localQuickFixArray2;
                    localQuickFixArray2[0] = new ComparatorComparisonFix(yodaCondition, relationType);
                }
                LocalQuickFix[] fixes = localQuickFixArray;
                holder.registerProblem((PsiElement)sign, JavaBundle.message((String)"inspection.comparator.result.comparison.problem.display.name", (Object[])new Object[0]), fixes);
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/ComparatorResultComparisonInspection", "buildVisitor"));
    }

    private static class ComparatorComparisonFix
    implements LocalQuickFix {
        private final boolean myYodaCondition;
        private final RelationType myRelation;

        ComparatorComparisonFix(boolean yodaCondition, RelationType relation) {
            this.myYodaCondition = yodaCondition;
            this.myRelation = relation;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{this.getReplacement()});
            if (string == null) {
                ComparatorComparisonFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        private String getReplacement() {
            String string = this.myYodaCondition ? "0 " + (Object)((Object)this.myRelation.getFlipped()) : (Object)((Object)this.myRelation) + " 0";
            if (string == null) {
                ComparatorComparisonFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = JavaBundle.message((String)"inspection.comparator.result.comparison.fix.family.name", (Object[])new Object[0]);
            if (string == null) {
                ComparatorComparisonFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            String replacement;
            PsiBinaryExpression binOp;
            if (project == null) {
                ComparatorComparisonFix.$$$reportNull$$$0(3);
            }
            if (descriptor == null) {
                ComparatorComparisonFix.$$$reportNull$$$0(4);
            }
            if ((binOp = (PsiBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getStartElement(), PsiBinaryExpression.class)) == null) {
                return;
            }
            CommentTracker ct = new CommentTracker();
            if (this.myYodaCondition) {
                PsiExpression operand2 = binOp.getROperand();
                if (operand2 == null) {
                    return;
                }
                replacement = this.getReplacement() + ct.text((PsiElement)operand2);
            } else {
                replacement = ct.text((PsiElement)binOp.getLOperand()) + this.getReplacement();
            }
            ct.replaceAndRestoreComments((PsiElement)binOp, replacement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/ComparatorResultComparisonInspection$ComparatorComparisonFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReplacement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/ComparatorResultComparisonInspection$ComparatorComparisonFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

