/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.daemon.JavaErrorBundle;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.ConstantEvaluationOverflowException;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NumericOverflowInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final Key<String> HAS_OVERFLOW_IN_CHILD = Key.create((String)"HAS_OVERFLOW_IN_CHILD");
    public boolean ignoreLeftShiftWithNegativeResult = true;

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(JavaAnalysisBundle.message((String)"ignore.operation.which.results.in.negative.value", (Object[])new Object[0]), (InspectionProfileEntry)this, "ignoreLeftShiftWithNegativeResult");
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = InspectionsBundle.message((String)"group.names.numeric.issues", (Object[])new Object[0]);
        if (string == null) {
            NumericOverflowInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        return "NumericOverflow";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            NumericOverflowInspection.$$$reportNull$$$0(1);
        }
        return new JavaElementVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                this.visitExpression((PsiExpression)expression2);
            }

            public void visitExpression(PsiExpression expression2) {
                boolean hasOverflow = NumericOverflowInspection.hasOverflow(expression2, holder.getProject());
                if (!(!hasOverflow || NumericOverflowInspection.this.ignoreLeftShiftWithNegativeResult && NumericOverflowInspection.isLeftShiftWithNegativeResult(expression2, holder.getProject()))) {
                    holder.registerProblem((PsiElement)expression2, JavaErrorBundle.message("numeric.overflow.in.expression", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                }
            }
        };
    }

    private static boolean isLeftShiftWithNegativeResult(PsiExpression expression2, Project project) {
        PsiBinaryExpression binOp = (PsiBinaryExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2), PsiBinaryExpression.class);
        if (binOp == null || !binOp.getOperationTokenType().equals(JavaTokenType.LTLT)) {
            return false;
        }
        PsiConstantEvaluationHelper helper = JavaPsiFacade.getInstance((Project)project).getConstantEvaluationHelper();
        Object lOperandValue = helper.computeConstantExpression((PsiElement)binOp.getLOperand());
        Object rOperandValue = helper.computeConstantExpression((PsiElement)binOp.getROperand());
        if (lOperandValue instanceof Character) {
            lOperandValue = (int)((Character)lOperandValue).charValue();
        }
        if (rOperandValue instanceof Character) {
            rOperandValue = (int)((Character)rOperandValue).charValue();
        }
        if (!(lOperandValue instanceof Number) || !(rOperandValue instanceof Number)) {
            return false;
        }
        if (lOperandValue instanceof Long) {
            long l = ((Number)lOperandValue).longValue();
            long r = ((Number)rOperandValue).longValue();
            return (long)Long.numberOfLeadingZeros(l) - (r & 0x3FL) == 0L;
        }
        int l = ((Number)lOperandValue).intValue();
        int r = ((Number)rOperandValue).intValue();
        return Integer.numberOfLeadingZeros(l) - (r & 0x1F) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean hasOverflow(PsiExpression expr2, @NotNull Project project) {
        if (project == null) {
            NumericOverflowInspection.$$$reportNull$$$0(2);
        }
        if (!TypeConversionUtil.isNumericType((PsiType)expr2.getType())) {
            return false;
        }
        boolean result = false;
        boolean toStoreInParent = false;
        try {
            if (expr2.getUserData(HAS_OVERFLOW_IN_CHILD) == null) {
                JavaPsiFacade.getInstance((Project)project).getConstantEvaluationHelper().computeConstantExpression((PsiElement)expr2, true);
            } else {
                toStoreInParent = true;
                expr2.putUserData(HAS_OVERFLOW_IN_CHILD, null);
            }
        }
        catch (ConstantEvaluationOverflowException e) {
            toStoreInParent = true;
            result = true;
        }
        finally {
            PsiElement parent = expr2.getParent();
            if (toStoreInParent && parent instanceof PsiExpression) {
                parent.putUserData(HAS_OVERFLOW_IN_CHILD, (Object)"");
            }
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/NumericOverflowInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/NumericOverflowInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hasOverflow";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

