/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.Result;
import com.intellij.codeInspection.bytecodeAnalysis.asm.ASMUtils;
import com.intellij.codeInspection.dataFlow.ContractReturnValue;
import com.intellij.codeInspection.dataFlow.StandardMethodContract;
import java.util.stream.Stream;
import org.jetbrains.org.objectweb.asm.Type;

enum Value implements Result
{
    Bot,
    NotNull,
    Null,
    True,
    False,
    Fail,
    Pure,
    Top;


    static Stream<Value> typeValues(Type type2) {
        if (ASMUtils.isReferenceType(type2)) {
            return Stream.of(Null, NotNull);
        }
        if (ASMUtils.isBooleanType(type2)) {
            return Stream.of(True, False);
        }
        return Stream.empty();
    }

    ContractReturnValue toReturnValue() {
        switch (this) {
            case False: {
                return ContractReturnValue.returnFalse();
            }
            case True: {
                return ContractReturnValue.returnTrue();
            }
            case NotNull: {
                return ContractReturnValue.returnNotNull();
            }
            case Null: {
                return ContractReturnValue.returnNull();
            }
            case Fail: {
                return ContractReturnValue.fail();
            }
        }
        return ContractReturnValue.returnAny();
    }

    StandardMethodContract.ValueConstraint toValueConstraint() {
        switch (this) {
            case False: {
                return StandardMethodContract.ValueConstraint.FALSE_VALUE;
            }
            case True: {
                return StandardMethodContract.ValueConstraint.TRUE_VALUE;
            }
            case NotNull: {
                return StandardMethodContract.ValueConstraint.NOT_NULL_VALUE;
            }
            case Null: {
                return StandardMethodContract.ValueConstraint.NULL_VALUE;
            }
        }
        return StandardMethodContract.ValueConstraint.ANY_VALUE;
    }
}

