/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis.asm;

import com.intellij.codeInspection.bytecodeAnalysis.asm.ASMUtils;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.org.objectweb.asm.Opcodes;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.TableSwitchInsnNode;
import org.jetbrains.org.objectweb.asm.tree.TryCatchBlockNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;
import org.jetbrains.org.objectweb.asm.tree.analysis.Interpreter;
import org.jetbrains.org.objectweb.asm.tree.analysis.Value;

public class LiteAnalyzer<V extends Value>
implements Opcodes {
    private final Interpreter<V> interpreter;
    private Frame<V>[] frames;
    private boolean[] queued;
    private int[] queue;
    private int top;

    public LiteAnalyzer(Interpreter<V> interpreter) {
        this.interpreter = interpreter;
    }

    public Frame<V>[] analyze(String owner2, MethodNode m) throws AnalyzerException {
        boolean isInstanceMethod;
        if ((m.access & 0x500) != 0 || m.instructions.size() == 0) {
            this.frames = ASMUtils.newFrameArray(0);
            return this.frames;
        }
        int n = m.instructions.size();
        InsnList insns = m.instructions;
        List<V>[] handlers = ASMUtils.newListArray(n);
        this.frames = ASMUtils.newFrameArray(n);
        this.queued = new boolean[n];
        this.queue = new int[n];
        this.top = 0;
        for (int i = 0; i < m.tryCatchBlocks.size(); ++i) {
            TryCatchBlockNode tcb = (TryCatchBlockNode)m.tryCatchBlocks.get(i);
            int begin = insns.indexOf((AbstractInsnNode)tcb.start);
            int end = insns.indexOf((AbstractInsnNode)tcb.end);
            for (int j = begin; j < end; ++j) {
                List insnHandlers = handlers[j];
                if (insnHandlers == null) {
                    insnHandlers = new ArrayList();
                    handlers[j] = insnHandlers;
                }
                insnHandlers.add(tcb);
            }
        }
        Frame current = new Frame(m.maxLocals, m.maxStack);
        Frame handler = new Frame(m.maxLocals, m.maxStack);
        current.setReturn(this.interpreter.newReturnTypeValue(Type.getReturnType((String)m.desc)));
        Type args = Type.getArgumentTypes((String)m.desc);
        int local = 0;
        boolean bl = isInstanceMethod = (m.access & 8) == 0;
        if (isInstanceMethod) {
            Type ctype = Type.getObjectType((String)owner2);
            current.setLocal(local, this.interpreter.newParameterValue(true, local, ctype));
            ++local;
        }
        for (Type arg : args) {
            current.setLocal(local, this.interpreter.newParameterValue(isInstanceMethod, local, arg));
            ++local;
            if (arg.getSize() != 2) continue;
            current.setLocal(local, this.interpreter.newEmptyValue(local));
            ++local;
        }
        while (local < m.maxLocals) {
            current.setLocal(local, this.interpreter.newEmptyValue(local));
            ++local;
        }
        this.merge(0, current);
        while (this.top > 0) {
            int insn = this.queue[--this.top];
            Frame<V> f = this.frames[insn];
            this.queued[insn] = false;
            AbstractInsnNode insnNode = null;
            try {
                List insnHandlers;
                insnNode = m.instructions.get(insn);
                int insnOpcode = insnNode.getOpcode();
                int insnType = insnNode.getType();
                if (insnType == 8 || insnType == 15 || insnType == 14) {
                    this.merge(insn + 1, f);
                } else {
                    int j;
                    current.init(f).execute(insnNode, this.interpreter);
                    if (insnNode instanceof JumpInsnNode) {
                        JumpInsnNode j2 = (JumpInsnNode)insnNode;
                        if (insnOpcode != 167 && insnOpcode != 168) {
                            this.merge(insn + 1, current);
                        }
                        int jump = insns.indexOf((AbstractInsnNode)j2.label);
                        this.merge(jump, current);
                    } else if (insnNode instanceof LookupSwitchInsnNode) {
                        LookupSwitchInsnNode lsi = (LookupSwitchInsnNode)insnNode;
                        int jump = insns.indexOf((AbstractInsnNode)lsi.dflt);
                        this.merge(jump, current);
                        for (j = 0; j < lsi.labels.size(); ++j) {
                            LabelNode label = (LabelNode)lsi.labels.get(j);
                            jump = insns.indexOf((AbstractInsnNode)label);
                            this.merge(jump, current);
                        }
                    } else if (insnNode instanceof TableSwitchInsnNode) {
                        TableSwitchInsnNode tsi = (TableSwitchInsnNode)insnNode;
                        int jump = insns.indexOf((AbstractInsnNode)tsi.dflt);
                        this.merge(jump, current);
                        for (j = 0; j < tsi.labels.size(); ++j) {
                            LabelNode label = (LabelNode)tsi.labels.get(j);
                            jump = insns.indexOf((AbstractInsnNode)label);
                            this.merge(jump, current);
                        }
                    } else if (insnOpcode != 191 && (insnOpcode < 172 || insnOpcode > 177)) {
                        this.merge(insn + 1, current);
                    }
                }
                if ((insnHandlers = handlers[insn]) == null) continue;
                for (TryCatchBlockNode tcb : insnHandlers) {
                    int jump = insns.indexOf((AbstractInsnNode)tcb.handler);
                    handler.init(f);
                    handler.clearStack();
                    handler.push(this.interpreter.newExceptionValue(tcb, handler, ASMUtils.THROWABLE_TYPE));
                    this.merge(jump, handler);
                }
            }
            catch (AnalyzerException e) {
                throw new AnalyzerException(e.node, "Error at instruction " + insn + ": " + e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                throw new AnalyzerException(insnNode, "Error at instruction " + insn + ": " + e.getMessage(), (Throwable)e);
            }
        }
        return this.frames;
    }

    public Frame<V>[] getFrames() {
        return this.frames;
    }

    private void merge(int insn, Frame<V> frame) throws AnalyzerException {
        boolean changes;
        Frame<V> oldFrame = this.frames[insn];
        if (oldFrame == null) {
            this.frames[insn] = new Frame(frame);
            changes = true;
        } else {
            changes = oldFrame.merge(frame, this.interpreter);
        }
        if (changes && !this.queued[insn]) {
            this.queued[insn] = true;
            this.queue[this.top++] = insn;
        }
    }
}

