/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.ExpressionUtil;
import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.NullabilityAnnotationInfo;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.AnnotateMethodFix;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SetInspectionOptionFix;
import com.intellij.codeInspection.dataFlow.ContractReturnValue;
import com.intellij.codeInspection.dataFlow.ContractValue;
import com.intellij.codeInspection.dataFlow.DataFlowInstructionVisitor;
import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaOptionalSupport;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.NullParameterConstraintChecker;
import com.intellij.codeInspection.dataFlow.NullabilityProblemKind;
import com.intellij.codeInspection.dataFlow.RunnerResult;
import com.intellij.codeInspection.dataFlow.TrackingRunner;
import com.intellij.codeInspection.dataFlow.fix.DeleteSwitchLabelFix;
import com.intellij.codeInspection.dataFlow.fix.RedundantInstanceofFix;
import com.intellij.codeInspection.dataFlow.fix.ReplaceWithConstantValueFix;
import com.intellij.codeInspection.dataFlow.fix.ReplaceWithObjectsEqualsFix;
import com.intellij.codeInspection.dataFlow.fix.SimplifyToAssignmentFix;
import com.intellij.codeInspection.dataFlow.instructions.InstanceofInstruction;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.nullable.NullableStuffInspectionBase;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.JavaPsiPatternUtil;
import com.intellij.psi.util.PsiExpressionTrimRenderer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.JavaPsiConstructorUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.bugs.EqualsWithItselfInspection;
import com.siyeh.ig.fixes.EqualsToEqualityFix;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.BreakConverter;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.TestUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import javax.swing.JComponent;
import one.util.streamex.StreamEx;
import org.jdom.Element;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public abstract class DataFlowInspectionBase
extends AbstractBaseJavaLocalInspectionTool {
    static final Logger LOG = Logger.getInstance(DataFlowInspectionBase.class);
    @NonNls
    private static final String SHORT_NAME = "ConstantConditions";
    public boolean SUGGEST_NULLABLE_ANNOTATIONS;
    public boolean DONT_REPORT_TRUE_ASSERT_STATEMENTS;
    public boolean TREAT_UNKNOWN_MEMBERS_AS_NULLABLE;
    public boolean IGNORE_ASSERT_STATEMENTS;
    public boolean REPORT_CONSTANT_REFERENCE_VALUES = true;
    public boolean REPORT_NULLS_PASSED_TO_NOT_NULL_PARAMETER = true;
    public boolean REPORT_NULLABLE_METHODS_RETURNING_NOT_NULL = true;
    public boolean REPORT_UNSOUND_WARNINGS = true;

    public JComponent createOptionsPanel() {
        throw new RuntimeException("no UI in headless mode");
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            DataFlowInspectionBase.$$$reportNull$$$0(0);
        }
        node.addContent(new Element("option").setAttribute("name", "SUGGEST_NULLABLE_ANNOTATIONS").setAttribute("value", String.valueOf(this.SUGGEST_NULLABLE_ANNOTATIONS)));
        node.addContent(new Element("option").setAttribute("name", "DONT_REPORT_TRUE_ASSERT_STATEMENTS").setAttribute("value", String.valueOf(this.DONT_REPORT_TRUE_ASSERT_STATEMENTS)));
        if (this.IGNORE_ASSERT_STATEMENTS) {
            node.addContent(new Element("option").setAttribute("name", "IGNORE_ASSERT_STATEMENTS").setAttribute("value", "true"));
        }
        if (!this.REPORT_CONSTANT_REFERENCE_VALUES) {
            node.addContent(new Element("option").setAttribute("name", "REPORT_CONSTANT_REFERENCE_VALUES").setAttribute("value", "false"));
        }
        if (this.TREAT_UNKNOWN_MEMBERS_AS_NULLABLE) {
            node.addContent(new Element("option").setAttribute("name", "TREAT_UNKNOWN_MEMBERS_AS_NULLABLE").setAttribute("value", "true"));
        }
        if (!this.REPORT_NULLS_PASSED_TO_NOT_NULL_PARAMETER) {
            node.addContent(new Element("option").setAttribute("name", "REPORT_NULLS_PASSED_TO_NOT_NULL_PARAMETER").setAttribute("value", "false"));
        }
        if (!this.REPORT_NULLABLE_METHODS_RETURNING_NOT_NULL) {
            node.addContent(new Element("option").setAttribute("name", "REPORT_NULLABLE_METHODS_RETURNING_NOT_NULL").setAttribute("value", "false"));
        }
        if (!this.REPORT_UNSOUND_WARNINGS) {
            node.addContent(new Element("option").setAttribute("name", "REPORT_UNSOUND_WARNINGS").setAttribute("value", "false"));
        }
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            DataFlowInspectionBase.$$$reportNull$$$0(1);
        }
        return new JavaElementVisitor(){

            public void visitClass(PsiClass aClass) {
                if (aClass instanceof PsiTypeParameter) {
                    return;
                }
                if (PsiUtil.isLocalOrAnonymousClass((PsiClass)aClass) && !(aClass instanceof PsiEnumConstantInitializer)) {
                    return;
                }
                DataFlowRunner runner = new DataFlowRunner(holder.getProject(), (PsiElement)aClass, DataFlowInspectionBase.this.TREAT_UNKNOWN_MEMBERS_AS_NULLABLE, DataFlowInspectionBase.this.IGNORE_ASSERT_STATEMENTS);
                DataFlowInstructionVisitor visitor2 = DataFlowInspectionBase.this.analyzeDfaWithNestedClosures((PsiElement)aClass, holder, runner, Collections.singletonList(runner.createMemoryState()));
                List<DfaMemoryState> states = visitor2.getEndOfInitializerStates();
                boolean physical = aClass.isPhysical();
                for (PsiMethod method : aClass.getConstructors()) {
                    if (physical && !method.isPhysical()) continue;
                    PsiMethodCallExpression call = JavaPsiConstructorUtil.findThisOrSuperCallInConstructor((PsiMethod)method);
                    List initialStates = JavaPsiConstructorUtil.isChainedConstructorCall((PsiElement)call) || call == null && DfaUtil.hasImplicitImpureSuperCall(aClass, method) ? Collections.singletonList(runner.createMemoryState()) : StreamEx.of(states).map(DfaMemoryState::createCopy).toList();
                    this.analyzeMethod(method, runner, initialStates);
                }
            }

            public void visitMethod(PsiMethod method) {
                if (method.isConstructor()) {
                    return;
                }
                DataFlowRunner runner = new DataFlowRunner(holder.getProject(), (PsiElement)method.getBody(), DataFlowInspectionBase.this.TREAT_UNKNOWN_MEMBERS_AS_NULLABLE, DataFlowInspectionBase.this.IGNORE_ASSERT_STATEMENTS);
                this.analyzeMethod(method, runner, Collections.singletonList(runner.createMemoryState()));
            }

            private void analyzeMethod(PsiMethod method, DataFlowRunner runner, List<DfaMemoryState> initialStates) {
                PsiCodeBlock scope = method.getBody();
                if (scope == null) {
                    return;
                }
                PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)method, PsiClass.class);
                if (containingClass != null && PsiUtil.isLocalOrAnonymousClass((PsiClass)containingClass) && !(containingClass instanceof PsiEnumConstantInitializer)) {
                    return;
                }
                DataFlowInspectionBase.this.analyzeDfaWithNestedClosures((PsiElement)scope, holder, runner, initialStates);
                DataFlowInspectionBase.this.analyzeNullLiteralMethodArguments(method, holder);
            }

            public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression2) {
                PsiType returnType;
                PsiType methodReturnType;
                super.visitMethodReferenceExpression(expression2);
                if (!DataFlowInspectionBase.this.REPORT_UNSOUND_WARNINGS) {
                    return;
                }
                PsiElement resolve2 = expression2.resolve();
                if (resolve2 instanceof PsiMethod && TypeConversionUtil.isPrimitiveWrapper((PsiType)(methodReturnType = ((PsiMethod)resolve2).getReturnType())) && NullableNotNullManager.isNullable((PsiModifierListOwner)((PsiMethod)resolve2)) && TypeConversionUtil.isPrimitiveAndNotNull((PsiType)(returnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)expression2)))) {
                    holder.registerProblem((PsiElement)expression2, JavaAnalysisBundle.message((String)"dataflow.message.unboxing.method.reference", (Object[])new Object[0]), new LocalQuickFix[0]);
                }
            }

            public void visitIfStatement(PsiIfStatement statement) {
                PsiExpression condition2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)statement.getCondition());
                if (BoolUtils.isBooleanLiteral(condition2)) {
                    LocalQuickFix fix2 = DataFlowInspectionBase.this.createSimplifyBooleanExpressionFix((PsiElement)condition2, condition2.textMatches((CharSequence)"true"));
                    holder.registerProblem((PsiElement)condition2, JavaAnalysisBundle.message((String)"dataflow.message.constant.no.ref", (Object[])new Object[]{condition2.textMatches((CharSequence)"true") ? 1 : 0}), new LocalQuickFix[]{fix2});
                }
            }

            public void visitWhileStatement(PsiWhileStatement statement) {
                this.checkLoopCondition(statement.getCondition());
            }

            public void visitDoWhileStatement(PsiDoWhileStatement statement) {
                this.checkLoopCondition(statement.getCondition());
            }

            public void visitForStatement(PsiForStatement statement) {
                this.checkLoopCondition(statement.getCondition());
            }

            private void checkLoopCondition(PsiExpression condition2) {
                if ((condition2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)condition2)) != null && condition2.textMatches((CharSequence)"false")) {
                    holder.registerProblem((PsiElement)condition2, JavaAnalysisBundle.message((String)"dataflow.message.constant.no.ref", (Object[])new Object[]{0}), new LocalQuickFix[]{DataFlowInspectionBase.this.createSimplifyBooleanExpressionFix((PsiElement)condition2, false)});
                }
            }
        };
    }

    protected LocalQuickFix createNavigateToNullParameterUsagesFix(PsiParameter parameter2) {
        return null;
    }

    private void analyzeNullLiteralMethodArguments(PsiMethod method, ProblemsHolder holder) {
        if (this.REPORT_NULLS_PASSED_TO_NOT_NULL_PARAMETER && holder.isOnTheFly()) {
            for (PsiParameter parameter2 : NullParameterConstraintChecker.checkMethodParameters(method)) {
                PsiIdentifier name2 = parameter2.getNameIdentifier();
                if (name2 == null) continue;
                holder.registerProblem((PsiElement)name2, JavaAnalysisBundle.message((String)"dataflow.method.fails.with.null.argument", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{this.createNavigateToNullParameterUsagesFix(parameter2)});
            }
        }
    }

    private DataFlowInstructionVisitor analyzeDfaWithNestedClosures(PsiElement scope, ProblemsHolder holder, DataFlowRunner dfaRunner, Collection<? extends DfaMemoryState> initialStates) {
        DataFlowInstructionVisitor visitor2 = new DataFlowInstructionVisitor();
        RunnerResult rc = dfaRunner.analyzeMethod(scope, visitor2, initialStates);
        if (rc == RunnerResult.OK) {
            if (dfaRunner.wasForciblyMerged() && (ApplicationManager.getApplication().isUnitTestMode() || Registry.is((String)"ide.dfa.report.imprecise"))) {
                DataFlowInspectionBase.reportAnalysisQualityProblem(holder, scope, "dataflow.not.precise");
            }
            this.createDescription(dfaRunner, holder, visitor2, scope);
            dfaRunner.forNestedClosures((closure, states) -> this.analyzeDfaWithNestedClosures((PsiElement)closure, holder, dfaRunner, (Collection<? extends DfaMemoryState>)states));
        } else if (rc == RunnerResult.TOO_COMPLEX) {
            DataFlowInspectionBase.reportAnalysisQualityProblem(holder, scope, "dataflow.too.complex");
        }
        return visitor2;
    }

    private static void reportAnalysisQualityProblem(ProblemsHolder holder, PsiElement scope, @PropertyKey(resourceBundle="messages.JavaAnalysisBundle") String problemKey) {
        PsiIdentifier name2 = null;
        String message2 = null;
        if (scope.getParent() instanceof PsiMethod) {
            name2 = ((PsiMethod)scope.getParent()).getNameIdentifier();
            message2 = JavaAnalysisBundle.message((String)problemKey, (Object[])new Object[]{"Method <code>#ref</code>"});
        } else if (scope instanceof PsiClass) {
            name2 = ((PsiClass)scope).getNameIdentifier();
            message2 = JavaAnalysisBundle.message((String)problemKey, (Object[])new Object[]{"Class initializer"});
        }
        if (name2 != null) {
            holder.registerProblem((PsiElement)name2, message2, ProblemHighlightType.WEAK_WARNING, new LocalQuickFix[0]);
        }
    }

    @NotNull
    protected List<LocalQuickFix> createCastFixes(PsiTypeCastExpression castExpression, PsiType realType, boolean onTheFly, boolean alwaysFails) {
        List<LocalQuickFix> list = Collections.emptyList();
        if (list == null) {
            DataFlowInspectionBase.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    protected List<LocalQuickFix> createNPEFixes(PsiExpression qualifier, PsiExpression expression2, boolean onTheFly) {
        List<LocalQuickFix> list = Collections.emptyList();
        if (list == null) {
            DataFlowInspectionBase.$$$reportNull$$$0(3);
        }
        return list;
    }

    protected List<LocalQuickFix> createMethodReferenceNPEFixes(PsiMethodReferenceExpression methodRef, boolean onTheFly) {
        return Collections.emptyList();
    }

    @Nullable
    protected LocalQuickFix createUnwrapSwitchLabelFix() {
        return null;
    }

    @Nullable
    protected LocalQuickFix createIntroduceVariableFix() {
        return null;
    }

    protected LocalQuickFix createRemoveAssignmentFix(PsiAssignmentExpression assignment) {
        return null;
    }

    protected LocalQuickFix createReplaceWithTrivialLambdaFix(Object value2) {
        return null;
    }

    private void createDescription(DataFlowRunner runner, ProblemsHolder holder, DataFlowInstructionVisitor visitor2, PsiElement scope) {
        ProblemReporter reporter = new ProblemReporter(holder, scope);
        this.reportFailingCasts(reporter, visitor2);
        this.reportUnreachableSwitchBranches(visitor2.getSwitchLabelsReachability(), holder);
        this.reportAlwaysFailingCalls(reporter, visitor2);
        List<NullabilityProblemKind.NullabilityProblem<?>> problems2 = NullabilityProblemKind.postprocessNullabilityProblems(visitor2.problems().toList());
        Map<PsiExpression, ConstantResult> constantExpressions = visitor2.getConstantExpressions();
        this.reportNullabilityProblems(reporter, problems2, constantExpressions);
        this.reportNullableReturns(reporter, problems2, constantExpressions, scope);
        DataFlowInspectionBase.reportOptionalOfNullableImprovements(reporter, visitor2.getOfNullableCalls());
        DataFlowInspectionBase.reportRedundantInstanceOf(runner, visitor2, reporter);
        this.reportConstants(reporter, visitor2);
        this.reportMethodReferenceProblems(holder, visitor2);
        DataFlowInspectionBase.reportArrayAccessProblems(holder, visitor2);
        DataFlowInspectionBase.reportArrayStoreProblems(holder, visitor2);
        if (this.REPORT_NULLABLE_METHODS_RETURNING_NOT_NULL && visitor2.isAlwaysReturnsNotNull(runner.getInstructions())) {
            this.reportAlwaysReturnsNotNull(holder, scope);
        }
        this.reportMutabilityViolations(holder, visitor2.getMutabilityViolations(true), JavaAnalysisBundle.message((String)"dataflow.message.immutable.modified", (Object[])new Object[0]));
        this.reportMutabilityViolations(holder, visitor2.getMutabilityViolations(false), JavaAnalysisBundle.message((String)"dataflow.message.immutable.passed", (Object[])new Object[0]));
        this.reportDuplicateAssignments(reporter, visitor2);
        DataFlowInspectionBase.reportPointlessSameArguments(reporter, visitor2);
    }

    private static void reportRedundantInstanceOf(DataFlowRunner runner, DataFlowInstructionVisitor visitor2, ProblemReporter reporter) {
        for (Instruction instruction : runner.getInstructions()) {
            Object expression2;
            InstanceofInstruction instanceOf;
            if (!(instruction instanceof InstanceofInstruction) || !visitor2.isInstanceofRedundant(instanceOf = (InstanceofInstruction)instruction) || (expression2 = instanceOf.getExpression()) != null && !JavaPsiPatternUtil.getExposedPatternVariables(expression2).isEmpty()) continue;
            reporter.registerProblem((PsiElement)expression2, JavaAnalysisBundle.message((String)"dataflow.message.redundant.instanceof", (Object[])new Object[0]), new RedundantInstanceofFix());
        }
    }

    private void reportUnreachableSwitchBranches(Map<PsiExpression, ThreeState> labelReachability, ProblemsHolder holder) {
        PsiExpression label;
        PsiSwitchLabelStatementBase labelStatement;
        HashSet<PsiSwitchBlock> coveredSwitches = new HashSet<PsiSwitchBlock>();
        for (Map.Entry<PsiExpression, ThreeState> entry : labelReachability.entrySet()) {
            PsiSwitchBlock statement;
            if (entry.getValue() != ThreeState.YES || (statement = (labelStatement = Objects.requireNonNull(PsiImplUtil.getSwitchLabel(label = entry.getKey()))).getEnclosingSwitchBlock()) == null || !DataFlowInspectionBase.canRemoveUnreachableBranches(labelStatement, statement) || !((StreamEx)StreamEx.iterate((Object)labelStatement, Objects::nonNull, l -> (PsiSwitchLabelStatementBase)PsiTreeUtil.getPrevSiblingOfType((PsiElement)l, PsiSwitchLabelStatementBase.class)).skip(1L)).map(PsiSwitchLabelStatementBase::getCaseValues).nonNull().flatArray(PsiExpressionList::getExpressions).allMatch(l -> labelReachability.get(l) == ThreeState.NO)) continue;
            coveredSwitches.add(statement);
            holder.registerProblem((PsiElement)label, JavaAnalysisBundle.message((String)"dataflow.message.only.switch.label", (Object[])new Object[0]), new LocalQuickFix[]{this.createUnwrapSwitchLabelFix()});
        }
        for (Map.Entry<PsiExpression, ThreeState> entry : labelReachability.entrySet()) {
            if (entry.getValue() != ThreeState.NO || coveredSwitches.contains((labelStatement = Objects.requireNonNull(PsiImplUtil.getSwitchLabel(label = entry.getKey()))).getEnclosingSwitchBlock())) continue;
            holder.registerProblem((PsiElement)label, JavaAnalysisBundle.message((String)"dataflow.message.unreachable.switch.label", (Object[])new Object[0]), new LocalQuickFix[]{new DeleteSwitchLabelFix(label)});
        }
    }

    private static boolean canRemoveUnreachableBranches(PsiSwitchLabelStatementBase labelStatement, PsiSwitchBlock statement) {
        if (Objects.requireNonNull(labelStatement.getCaseValues()).getExpressionCount() != 1) {
            return true;
        }
        List allBranches = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)statement.getBody(), PsiSwitchLabelStatementBase.class);
        if (statement instanceof PsiSwitchStatement) {
            return allBranches.size() != 1 || BreakConverter.from(statement) != null;
        }
        return allBranches.size() <= 2 && !allBranches.stream().allMatch(branch -> branch == labelStatement || branch.isDefaultCase()) || labelStatement instanceof PsiSwitchLabeledRuleStatement && ((PsiSwitchLabeledRuleStatement)labelStatement).getBody() instanceof PsiExpressionStatement;
    }

    private void reportConstants(ProblemReporter reporter, DataFlowInstructionVisitor visitor2) {
        visitor2.getConstantExpressionChunks().forEach((chunk, result) -> {
            if (result == ConstantResult.UNKNOWN) {
                return;
            }
            PsiExpression expression2 = chunk.myExpression;
            if (chunk.myRange != null) {
                if (result.value() instanceof Boolean) {
                    String message2 = JavaAnalysisBundle.message((String)"dataflow.message.constant.condition", (Object[])new Object[]{(Boolean)result.value() != false ? 1 : 0});
                    reporter.registerProblem((PsiElement)expression2, chunk.myRange, message2, new LocalQuickFix[0]);
                }
                return;
            }
            if (DataFlowInspectionBase.isCondition(expression2)) {
                if (result.value() instanceof Boolean) {
                    this.reportConstantBoolean(reporter, (PsiElement)expression2, (Boolean)result.value());
                }
            } else {
                this.reportConstantReferenceValue(reporter, expression2, (ConstantResult)((Object)result));
            }
        });
    }

    private static boolean isCondition(@NotNull PsiExpression expression2) {
        PsiType type2;
        if (expression2 == null) {
            DataFlowInspectionBase.$$$reportNull$$$0(4);
        }
        if ((type2 = expression2.getType()) == null || !PsiType.BOOLEAN.isAssignableFrom(type2)) {
            return false;
        }
        if (!(expression2 instanceof PsiMethodCallExpression) && !(expression2 instanceof PsiReferenceExpression)) {
            return true;
        }
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression2.getParent());
        if (parent instanceof PsiStatement) {
            return !(parent instanceof PsiReturnStatement);
        }
        if (parent instanceof PsiPolyadicExpression) {
            IElementType tokenType = ((PsiPolyadicExpression)parent).getOperationTokenType();
            return tokenType.equals(JavaTokenType.ANDAND) || tokenType.equals(JavaTokenType.OROR) || tokenType.equals(JavaTokenType.AND) || tokenType.equals(JavaTokenType.OR);
        }
        if (parent instanceof PsiConditionalExpression) {
            return PsiTreeUtil.isAncestor((PsiElement)((PsiConditionalExpression)parent).getCondition(), (PsiElement)expression2, (boolean)false);
        }
        return PsiUtil.isAccessedForWriting((PsiExpression)expression2);
    }

    private void reportConstantReferenceValue(ProblemReporter reporter, PsiExpression ref, ConstantResult constant) {
        String valueText;
        ProblemHighlightType type2;
        if (!this.REPORT_CONSTANT_REFERENCE_VALUES && ref instanceof PsiReferenceExpression) {
            return;
        }
        if (DataFlowInspectionBase.shouldBeSuppressed((PsiElement)ref) || constant == ConstantResult.UNKNOWN) {
            return;
        }
        SmartList fixes = new SmartList();
        String presentableName = constant.toString();
        if (constant.value() instanceof Boolean) {
            fixes.add(this.createSimplifyBooleanExpressionFix((PsiElement)ref, (Boolean)constant.value()));
        } else {
            fixes.add(new ReplaceWithConstantValueFix(presentableName, presentableName));
        }
        Object value2 = constant.value();
        boolean isAssertion = DataFlowInspectionBase.isAssertionEffectively((PsiElement)ref, constant);
        if (isAssertion && this.DONT_REPORT_TRUE_ASSERT_STATEMENTS) {
            return;
        }
        if (value2 instanceof Boolean) {
            ContainerUtil.addIfNotNull((Collection)fixes, (Object)DataFlowInspectionBase.createReplaceWithNullCheckFix((PsiElement)ref, (Boolean)value2));
        }
        if (reporter.isOnTheFly()) {
            if (ref instanceof PsiReferenceExpression) {
                fixes.add(new SetInspectionOptionFix((LocalInspectionTool)this, "REPORT_CONSTANT_REFERENCE_VALUES", JavaAnalysisBundle.message((String)"inspection.data.flow.turn.off.constant.references.quickfix", (Object[])new Object[0]), false));
            }
            if (isAssertion) {
                fixes.add(new SetInspectionOptionFix((LocalInspectionTool)this, "DONT_REPORT_TRUE_ASSERT_STATEMENTS", JavaAnalysisBundle.message((String)"inspection.data.flow.turn.off.true.asserts.quickfix", (Object[])new Object[0]), true));
            }
        }
        if (reporter.isOnTheFly()) {
            ContainerUtil.addIfNotNull((Collection)fixes, (Object)this.createExplainFix(ref, new TrackingRunner.ValueDfaProblemType(value2)));
        }
        if (ref instanceof PsiMethodCallExpression) {
            type2 = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
            valueText = "Result of";
        } else {
            type2 = ProblemHighlightType.WEAK_WARNING;
            valueText = "Value";
        }
        reporter.registerProblem((PsiElement)ref, MessageFormat.format("{0} <code>#ref</code> #loc is always ''{1}''", valueText, presentableName), type2, fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
    }

    private static void reportPointlessSameArguments(ProblemReporter reporter, DataFlowInstructionVisitor visitor2) {
        visitor2.pointlessSameArguments().forEach(expr2 -> {
            PsiElement name2 = expr2.getReferenceNameElement();
            if (name2 != null) {
                reporter.registerProblem(name2, JavaAnalysisBundle.message((String)"dataflow.message.pointless.same.arguments", (Object[])new Object[0]), new LocalQuickFix[0]);
            }
        });
    }

    private void reportDuplicateAssignments(ProblemReporter reporter, DataFlowInstructionVisitor visitor2) {
        visitor2.sameValueAssignments().forEach(expr2 -> {
            PsiReferenceExpression ref;
            PsiElement target;
            Object constValue;
            if ((expr2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expr2)) == null) {
                return;
            }
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)PsiTreeUtil.getParentOfType((PsiElement)expr2, PsiAssignmentExpression.class);
            PsiElement context = PsiTreeUtil.getParentOfType((PsiElement)expr2, (Class[])new Class[]{PsiForStatement.class, PsiClassInitializer.class});
            if (context instanceof PsiForStatement && PsiTreeUtil.isAncestor((PsiElement)((PsiForStatement)context).getInitialization(), (PsiElement)expr2, (boolean)true)) {
                return;
            }
            if (context instanceof PsiClassInitializer && expr2 instanceof PsiReferenceExpression && assignment != null && (constValue = ExpressionUtils.computeConstantExpression(assignment.getRExpression())) == PsiTypesUtil.getDefaultValue((PsiType)expr2.getType()) && (target = (ref = (PsiReferenceExpression)expr2).resolve()) instanceof PsiField && (((PsiField)target).hasModifierProperty("static") || ExpressionUtil.isEffectivelyUnqualified(ref)) && ((PsiField)target).getContainingClass() == ((PsiClassInitializer)context).getContainingClass()) {
                return;
            }
            String message2 = assignment != null && !assignment.getOperationTokenType().equals(JavaTokenType.EQ) ? JavaAnalysisBundle.message((String)"dataflow.message.redundant.update", (Object[])new Object[0]) : JavaAnalysisBundle.message((String)"dataflow.message.redundant.assignment", (Object[])new Object[0]);
            reporter.registerProblem((PsiElement)expr2, message2, this.createRemoveAssignmentFix(assignment));
        });
    }

    private void reportMutabilityViolations(ProblemsHolder holder, Set<PsiElement> violations, String message2) {
        for (PsiElement violation : violations) {
            holder.registerProblem(violation, message2, new LocalQuickFix[]{this.createMutabilityViolationFix(violation, holder.isOnTheFly())});
        }
    }

    protected LocalQuickFix createMutabilityViolationFix(PsiElement violation, boolean onTheFly) {
        return null;
    }

    protected void reportNullabilityProblems(ProblemReporter reporter, List<NullabilityProblemKind.NullabilityProblem<?>> problems2, Map<PsiExpression, ConstantResult> expressions2) {
        for (NullabilityProblemKind.NullabilityProblem<?> problem : problems2) {
            PsiExpression unwrapped;
            PsiExpression expression2 = problem.getDereferencedExpression();
            if (!this.REPORT_UNSOUND_WARNINGS && (expression2 == null || !ExpressionUtils.isNullLiteral(unwrapped = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2)) && expressions2.get(expression2) != ConstantResult.NULL)) continue;
            NullabilityProblemKind.innerClassNPE.ifMyProblem(problem, newExpression -> {
                List<LocalQuickFix> fixes = this.createNPEFixes(newExpression.getQualifier(), (PsiExpression)newExpression, reporter.isOnTheFly());
                reporter.registerProblem(DataFlowInspectionBase.getElementToHighlight((PsiCall)newExpression), problem.getMessage(expressions2), fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
            });
            NullabilityProblemKind.callMethodRefNPE.ifMyProblem(problem, methodRef -> reporter.registerProblem((PsiElement)methodRef, JavaAnalysisBundle.message((String)"dataflow.message.npe.methodref.invocation", (Object[])new Object[0]), this.createMethodReferenceNPEFixes((PsiMethodReferenceExpression)methodRef, reporter.isOnTheFly()).toArray(LocalQuickFix.EMPTY_ARRAY)));
            NullabilityProblemKind.callNPE.ifMyProblem(problem, call -> this.reportCallMayProduceNpe(reporter, problem.getMessage(expressions2), (PsiMethodCallExpression)call));
            NullabilityProblemKind.passingToNotNullParameter.ifMyProblem(problem, expr2 -> {
                List<LocalQuickFix> fixes = this.createNPEFixes(expression2, expression2, reporter.isOnTheFly());
                reporter.registerProblem((PsiElement)expression2, problem.getMessage(expressions2), fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
            });
            NullabilityProblemKind.passingToNotNullMethodRefParameter.ifMyProblem(problem, methodRef -> {
                LocalQuickFix[] fixes = this.createMethodReferenceNPEFixes((PsiMethodReferenceExpression)methodRef, reporter.isOnTheFly()).toArray(LocalQuickFix.EMPTY_ARRAY);
                reporter.registerProblem((PsiElement)methodRef, JavaAnalysisBundle.message((String)"dataflow.message.passing.nullable.argument.methodref", (Object[])new Object[0]), fixes);
            });
            NullabilityProblemKind.arrayAccessNPE.ifMyProblem(problem, arrayAccess -> {
                LocalQuickFix[] fixes = this.createNPEFixes(arrayAccess.getArrayExpression(), (PsiExpression)arrayAccess, reporter.isOnTheFly()).toArray(LocalQuickFix.EMPTY_ARRAY);
                reporter.registerProblem((PsiElement)arrayAccess, problem.getMessage(expressions2), fixes);
            });
            NullabilityProblemKind.fieldAccessNPE.ifMyProblem(problem, element -> {
                PsiElement parent = element.getParent();
                PsiExpression fieldAccess = parent instanceof PsiReferenceExpression ? (PsiExpression)parent : element;
                LocalQuickFix[] fix2 = this.createNPEFixes((PsiExpression)element, fieldAccess, reporter.isOnTheFly()).toArray(LocalQuickFix.EMPTY_ARRAY);
                reporter.registerProblem((PsiElement)element, problem.getMessage(expressions2), fix2);
            });
            NullabilityProblemKind.unboxingNullable.ifMyProblem(problem, element -> {
                PsiExpression anchor = expression2;
                if (anchor instanceof PsiTypeCastExpression && anchor.getType() instanceof PsiPrimitiveType) {
                    anchor = Objects.requireNonNull(((PsiTypeCastExpression)anchor).getOperand());
                }
                reporter.registerProblem((PsiElement)anchor, problem.getMessage(expressions2), new LocalQuickFix[0]);
            });
            NullabilityProblemKind.nullableFunctionReturn.ifMyProblem(problem, expr2 -> reporter.registerProblem((PsiElement)(expression2 == null ? expr2 : expression2), problem.getMessage(expressions2), new LocalQuickFix[0]));
            Consumer<PsiExpression> reportNullability = expr2 -> this.reportNullabilityProblem(reporter, problem, expression2, expressions2);
            NullabilityProblemKind.assigningToNotNull.ifMyProblem(problem, reportNullability);
            NullabilityProblemKind.storingToNotNullArray.ifMyProblem(problem, reportNullability);
            if (!this.SUGGEST_NULLABLE_ANNOTATIONS) continue;
            NullabilityProblemKind.passingToNonAnnotatedMethodRefParameter.ifMyProblem(problem, methodRef -> reporter.registerProblem((PsiElement)methodRef, problem.getMessage(expressions2), new LocalQuickFix[0]));
            NullabilityProblemKind.passingToNonAnnotatedParameter.ifMyProblem(problem, top -> this.reportNullableArgumentsPassedToNonAnnotated(reporter, problem.getMessage(expressions2), expression2, (PsiExpression)top));
            NullabilityProblemKind.assigningToNonAnnotatedField.ifMyProblem(problem, top -> this.reportNullableAssignedToNonAnnotatedField(reporter, (PsiExpression)top, expression2, problem.getMessage(expressions2)));
        }
    }

    private void reportNullabilityProblem(ProblemReporter reporter, NullabilityProblemKind.NullabilityProblem<?> problem, PsiExpression expr2, Map<PsiExpression, ConstantResult> expressions2) {
        LocalQuickFix[] fixes = this.createNPEFixes(expr2, expr2, reporter.isOnTheFly()).toArray(LocalQuickFix.EMPTY_ARRAY);
        reporter.registerProblem((PsiElement)expr2, problem.getMessage(expressions2), fixes);
    }

    private static void reportArrayAccessProblems(ProblemsHolder holder, DataFlowInstructionVisitor visitor2) {
        visitor2.outOfBoundsArrayAccesses().forEach(access -> {
            PsiExpression indexExpression = access.getIndexExpression();
            if (indexExpression != null) {
                holder.registerProblem((PsiElement)indexExpression, JavaAnalysisBundle.message((String)"dataflow.message.array.index.out.of.bounds", (Object[])new Object[0]), new LocalQuickFix[0]);
            }
        });
    }

    private static void reportArrayStoreProblems(ProblemsHolder holder, DataFlowInstructionVisitor visitor2) {
        visitor2.getArrayStoreProblems().forEach((assignment, types) -> holder.registerProblem((PsiElement)assignment.getOperationSign(), JavaAnalysisBundle.message((String)"dataflow.message.arraystore", (Object[])new Object[]{((PsiType)types.getFirst()).getCanonicalText(), ((PsiType)types.getSecond()).getCanonicalText()}), new LocalQuickFix[0]));
    }

    private void reportMethodReferenceProblems(ProblemsHolder holder, DataFlowInstructionVisitor visitor2) {
        visitor2.getMethodReferenceResults().forEach((methodRef, result) -> {
            if (result != ConstantResult.UNKNOWN) {
                Object value2 = result.value();
                holder.registerProblem((PsiElement)methodRef, JavaAnalysisBundle.message((String)"dataflow.message.constant.method.reference", (Object[])new Object[]{value2}), new LocalQuickFix[]{this.createReplaceWithTrivialLambdaFix(value2)});
            }
        });
    }

    private void reportAlwaysReturnsNotNull(ProblemsHolder holder, PsiElement scope) {
        if (!(scope.getParent() instanceof PsiMethod)) {
            return;
        }
        PsiMethod method = (PsiMethod)scope.getParent();
        if (PsiUtil.canBeOverridden((PsiMethod)method)) {
            return;
        }
        NullabilityAnnotationInfo info = NullableNotNullManager.getInstance((Project)scope.getProject()).findOwnNullabilityInfo((PsiModifierListOwner)method);
        if (info == null || info.getNullability() != Nullability.NULLABLE) {
            return;
        }
        PsiAnnotation annotation = info.getAnnotation();
        if (!annotation.isPhysical() || DataFlowInspectionBase.alsoAppliesToInternalSubType(annotation, method)) {
            return;
        }
        PsiJavaCodeReferenceElement annoName = annotation.getNameReferenceElement();
        assert (annoName != null);
        String msg = "@" + NullableStuffInspectionBase.getPresentableAnnoName(annotation) + " method '" + method.getName() + "' always returns a non-null value";
        Object[] fixes = new LocalQuickFix[]{AddAnnotationPsiFix.createAddNotNullFix((PsiModifierListOwner)method)};
        if (holder.isOnTheFly()) {
            fixes = (LocalQuickFix[])ArrayUtil.append((Object[])fixes, (Object)new SetInspectionOptionFix((LocalInspectionTool)this, "REPORT_NULLABLE_METHODS_RETURNING_NOT_NULL", JavaAnalysisBundle.message((String)"inspection.data.flow.turn.off.nullable.returning.notnull.quickfix", (Object[])new Object[0]), false));
        }
        holder.registerProblem((PsiElement)annoName, msg, (LocalQuickFix[])fixes);
    }

    private static boolean alsoAppliesToInternalSubType(PsiAnnotation annotation, PsiMethod method) {
        return AnnotationTargetUtil.isTypeAnnotation((PsiAnnotation)annotation) && method.getReturnType() instanceof PsiArrayType;
    }

    private void reportAlwaysFailingCalls(ProblemReporter reporter, DataFlowInstructionVisitor visitor2) {
        ((StreamEx)visitor2.alwaysFailingCalls().remove(TestUtils::isExceptionExpected)).forEach(call -> {
            String message2 = DataFlowInspectionBase.getContractMessage(JavaMethodContractUtil.getMethodCallContracts(call));
            LocalQuickFix causeFix = reporter.isOnTheFly() ? this.createExplainFix((PsiExpression)call, new TrackingRunner.FailingCallDfaProblemType()) : null;
            reporter.registerProblem(DataFlowInspectionBase.getElementToHighlight((PsiCall)call), message2, causeFix);
        });
    }

    @NotNull
    private static String getContractMessage(List<? extends MethodContract> contracts2) {
        if (contracts2.stream().allMatch(mc -> mc.getConditions().stream().allMatch(ContractValue::isBoundCheckingCondition))) {
            String string = JavaAnalysisBundle.message((String)"dataflow.message.contract.fail.index", (Object[])new Object[0]);
            if (string == null) {
                DataFlowInspectionBase.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = JavaAnalysisBundle.message((String)"dataflow.message.contract.fail", (Object[])new Object[0]);
        if (string == null) {
            DataFlowInspectionBase.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    private static PsiElement getElementToHighlight(@NotNull PsiCall call) {
        PsiJavaCodeReferenceElement ref;
        if (call == null) {
            DataFlowInspectionBase.$$$reportNull$$$0(7);
        }
        if (call instanceof PsiNewExpression) {
            ref = ((PsiNewExpression)call).getClassReference();
        } else if (call instanceof PsiMethodCallExpression) {
            ref = ((PsiMethodCallExpression)call).getMethodExpression();
        } else {
            PsiCall psiCall = call;
            if (psiCall == null) {
                DataFlowInspectionBase.$$$reportNull$$$0(8);
            }
            return psiCall;
        }
        if (ref != null) {
            PsiElement name2 = ref.getReferenceNameElement();
            Object object = name2 != null ? name2 : ref;
            if (object == null) {
                DataFlowInspectionBase.$$$reportNull$$$0(9);
            }
            return object;
        }
        PsiCall psiCall = call;
        if (psiCall == null) {
            DataFlowInspectionBase.$$$reportNull$$$0(10);
        }
        return psiCall;
    }

    private static void reportOptionalOfNullableImprovements(ProblemReporter reporter, Map<PsiElement, ThreeState> nullArgs) {
        nullArgs.forEach((anchor, alwaysPresent) -> {
            if (alwaysPresent == ThreeState.UNSURE) {
                return;
            }
            if (alwaysPresent.toBoolean()) {
                reporter.registerProblem((PsiElement)anchor, "Passing a non-null argument to <code>Optional</code>", DfaOptionalSupport.createReplaceOptionalOfNullableWithOfFix(anchor));
            } else {
                reporter.registerProblem((PsiElement)anchor, "Passing <code>null</code> argument to <code>Optional</code>", DfaOptionalSupport.createReplaceOptionalOfNullableWithEmptyFix(anchor));
            }
        });
    }

    private void reportNullableArgumentsPassedToNonAnnotated(ProblemReporter reporter, String message2, PsiExpression expression2, PsiExpression top) {
        PsiParameter parameter2 = MethodCallUtils.getParameterForArgument(top);
        if (parameter2 != null && BaseIntentionAction.canModify((PsiElement)parameter2) && AnnotationUtil.isAnnotatingApplicable((PsiElement)parameter2)) {
            List<LocalQuickFix> fixes = this.createNPEFixes(expression2, top, reporter.isOnTheFly());
            fixes.add((LocalQuickFix)AddAnnotationPsiFix.createAddNullableFix((PsiModifierListOwner)parameter2));
            reporter.registerProblem((PsiElement)expression2, message2, fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
        }
    }

    private void reportNullableAssignedToNonAnnotatedField(ProblemReporter reporter, PsiExpression top, PsiExpression expression2, String message2) {
        PsiField field = DataFlowInspectionBase.getAssignedField((PsiElement)top);
        if (field != null) {
            List<LocalQuickFix> fixes = this.createNPEFixes(expression2, top, reporter.isOnTheFly());
            fixes.add((LocalQuickFix)AddAnnotationPsiFix.createAddNullableFix((PsiModifierListOwner)field));
            reporter.registerProblem((PsiElement)expression2, message2, fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
        }
    }

    @Nullable
    private static PsiField getAssignedField(PsiElement assignedValue) {
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)assignedValue.getParent());
        if (parent instanceof PsiAssignmentExpression) {
            PsiExpression lExpression = ((PsiAssignmentExpression)parent).getLExpression();
            PsiElement target = lExpression instanceof PsiReferenceExpression ? ((PsiReferenceExpression)lExpression).resolve() : null;
            return (PsiField)ObjectUtils.tryCast((Object)target, PsiField.class);
        }
        return null;
    }

    private void reportCallMayProduceNpe(ProblemReporter reporter, String message2, PsiMethodCallExpression callExpression) {
        PsiReferenceExpression methodExpression = callExpression.getMethodExpression();
        List<LocalQuickFix> fixes = this.createNPEFixes(methodExpression.getQualifierExpression(), (PsiExpression)callExpression, reporter.isOnTheFly());
        ContainerUtil.addIfNotNull(fixes, (Object)ReplaceWithObjectsEqualsFix.createFix(callExpression, methodExpression));
        PsiElement toHighlight = DataFlowInspectionBase.getElementToHighlight((PsiCall)callExpression);
        reporter.registerProblem(toHighlight, message2, fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
    }

    private void reportFailingCasts(ProblemReporter reporter, DataFlowInstructionVisitor visitor2) {
        visitor2.getFailingCastExpressions().forKeyValue((typeCast, info) -> {
            boolean alwaysFails = (Boolean)info.getFirst();
            PsiType realType = (PsiType)info.getSecond();
            if (!this.REPORT_UNSOUND_WARNINGS && !alwaysFails) {
                return;
            }
            PsiExpression operand2 = typeCast.getOperand();
            PsiTypeElement castType = typeCast.getCastType();
            assert (castType != null);
            assert (operand2 != null);
            ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>(this.createCastFixes((PsiTypeCastExpression)typeCast, realType, reporter.isOnTheFly(), alwaysFails));
            if (reporter.isOnTheFly()) {
                fixes.add(this.createExplainFix((PsiExpression)typeCast, new TrackingRunner.CastDfaProblemType()));
            }
            String text2 = PsiExpressionTrimRenderer.render((PsiExpression)operand2);
            String message2 = alwaysFails ? JavaAnalysisBundle.message((String)"dataflow.message.cce.always", (Object[])new Object[]{text2}) : JavaAnalysisBundle.message((String)"dataflow.message.cce", (Object[])new Object[]{text2});
            reporter.registerProblem((PsiElement)castType, message2, fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
        });
    }

    private void reportConstantBoolean(ProblemReporter reporter, PsiElement psiAnchor, boolean evaluatesToTrue) {
        while (psiAnchor instanceof PsiParenthesizedExpression) {
            psiAnchor = ((PsiParenthesizedExpression)psiAnchor).getExpression();
        }
        if (psiAnchor == null || DataFlowInspectionBase.shouldBeSuppressed(psiAnchor)) {
            return;
        }
        boolean isAssertion = DataFlowInspectionBase.isAssertionEffectively(psiAnchor, evaluatesToTrue);
        if (this.DONT_REPORT_TRUE_ASSERT_STATEMENTS && isAssertion) {
            return;
        }
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)psiAnchor.getParent());
        if (parent instanceof PsiAssignmentExpression && PsiTreeUtil.isAncestor((PsiElement)((PsiAssignmentExpression)parent).getLExpression(), (PsiElement)psiAnchor, (boolean)false)) {
            reporter.registerProblem(psiAnchor, JavaAnalysisBundle.message((String)"dataflow.message.pointless.assignment.expression", (Object[])new Object[]{Boolean.toString(evaluatesToTrue)}), this.createConditionalAssignmentFixes(evaluatesToTrue, (PsiAssignmentExpression)parent, reporter.isOnTheFly()));
            return;
        }
        ArrayList<SetInspectionOptionFix> fixes = new ArrayList<SetInspectionOptionFix>();
        if (!DataFlowInspectionBase.isCoveredBySurroundingFix(psiAnchor, evaluatesToTrue)) {
            ContainerUtil.addIfNotNull(fixes, (Object)this.createSimplifyBooleanExpressionFix(psiAnchor, evaluatesToTrue));
            if (isAssertion && reporter.isOnTheFly()) {
                fixes.add(new SetInspectionOptionFix((LocalInspectionTool)this, "DONT_REPORT_TRUE_ASSERT_STATEMENTS", JavaAnalysisBundle.message((String)"inspection.data.flow.turn.off.true.asserts.quickfix", (Object[])new Object[0]), true));
            }
            ContainerUtil.addIfNotNull(fixes, (Object)DataFlowInspectionBase.createReplaceWithNullCheckFix(psiAnchor, evaluatesToTrue));
        }
        if (reporter.isOnTheFly() && psiAnchor instanceof PsiExpression) {
            ContainerUtil.addIfNotNull(fixes, (Object)this.createExplainFix((PsiExpression)psiAnchor, new TrackingRunner.ValueDfaProblemType(evaluatesToTrue)));
        }
        String message2 = JavaAnalysisBundle.message((String)(DataFlowInspectionBase.isAtRHSOfBooleanAnd(psiAnchor) ? "dataflow.message.constant.condition.when.reached" : "dataflow.message.constant.condition"), (Object[])new Object[]{evaluatesToTrue ? 1 : 0});
        reporter.registerProblem(psiAnchor, message2, fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
    }

    @Nullable
    protected LocalQuickFix createExplainFix(PsiExpression anchor, TrackingRunner.DfaProblemType problemType) {
        return null;
    }

    private static boolean isCoveredBySurroundingFix(PsiElement anchor, boolean evaluatesToTrue) {
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)anchor.getParent());
        if (parent instanceof PsiPolyadicExpression) {
            IElementType tokenType = ((PsiPolyadicExpression)parent).getOperationTokenType();
            return tokenType.equals(JavaTokenType.ANDAND) && !evaluatesToTrue || tokenType.equals(JavaTokenType.OROR) && evaluatesToTrue;
        }
        return parent instanceof PsiExpression && BoolUtils.isNegation((PsiExpression)parent);
    }

    @Contract(value="null -> false")
    private static boolean shouldBeSuppressed(PsiElement anchor) {
        PsiClass containingClass;
        PsiElement target;
        PsiReferenceExpression ref;
        if (!(anchor instanceof PsiExpression)) {
            return false;
        }
        if (anchor instanceof PsiAssignmentExpression || anchor instanceof PsiTypeCastExpression) {
            return true;
        }
        if (anchor instanceof PsiConditionalExpression) {
            return true;
        }
        PsiExpression expression2 = (PsiExpression)anchor;
        if (expression2 instanceof PsiReferenceExpression && ("TRUE".equals((ref = (PsiReferenceExpression)expression2).getReferenceName()) || "FALSE".equals(ref.getReferenceName())) && (target = ref.resolve()) instanceof PsiField && (containingClass = ((PsiField)target).getContainingClass()) != null && "java.lang.Boolean".equals(containingClass.getQualifiedName())) {
            return true;
        }
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression2.getParent());
        if (parent instanceof PsiBinaryExpression && ExpressionUtils.getValueComparedWithNull((PsiBinaryExpression)parent) != null) {
            return true;
        }
        if (ExpressionUtils.isVoidContext(expression2) || DataFlowInspectionBase.isDereferenceContext(expression2)) {
            return true;
        }
        if (TypeUtils.typeEquals("java.lang.Void", expression2.getType())) {
            return true;
        }
        if (DataFlowInspectionBase.isFlagCheck(anchor)) {
            return true;
        }
        boolean condition2 = DataFlowInspectionBase.isCondition(expression2);
        if (!condition2 && expression2 instanceof PsiReferenceExpression) {
            PsiVariable variable = (PsiVariable)ObjectUtils.tryCast((Object)((PsiReferenceExpression)expression2).resolve(), PsiVariable.class);
            if (variable instanceof PsiField && variable.hasModifierProperty("static") && ExpressionUtils.isNullLiteral(variable.getInitializer())) {
                return true;
            }
            return variable instanceof PsiLocalVariable && variable.hasModifierProperty("final") && PsiUtil.isCompileTimeConstant((PsiVariable)variable);
        }
        if (!condition2 && expression2 instanceof PsiMethodCallExpression) {
            PsiMethod method;
            List<? extends MethodContract> contracts2 = JavaMethodContractUtil.getMethodCallContracts((PsiCallExpression)expression2);
            ContractReturnValue value2 = JavaMethodContractUtil.getNonFailingReturnValue(contracts2);
            if (value2 != null) {
                return true;
            }
            if (!(parent instanceof PsiAssignmentExpression || parent instanceof PsiVariable || parent instanceof PsiReturnStatement || (method = ((PsiMethodCallExpression)expression2).resolveMethod()) != null && JavaMethodContractUtil.isPure(method))) {
                return true;
            }
        }
        while (expression2 != null && BoolUtils.isNegation(expression2)) {
            expression2 = BoolUtils.getNegated(expression2);
        }
        PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)expression2, PsiMethodCallExpression.class);
        return call != null && EqualsWithItselfInspection.isEqualsWithItself(call);
    }

    private static boolean isDereferenceContext(PsiExpression ref) {
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)ref.getParent());
        return parent instanceof PsiReferenceExpression || parent instanceof PsiArrayAccessExpression || parent instanceof PsiSwitchStatement || parent instanceof PsiSynchronizedStatement;
    }

    private static LocalQuickFix createReplaceWithNullCheckFix(PsiElement psiAnchor, boolean evaluatesToTrue) {
        if (evaluatesToTrue) {
            return null;
        }
        if (!(psiAnchor instanceof PsiMethodCallExpression)) {
            return null;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)psiAnchor;
        if (!MethodCallUtils.isEqualsCall(methodCallExpression)) {
            return null;
        }
        PsiExpression arg = (PsiExpression)ArrayUtil.getFirstElement((Object[])methodCallExpression.getArgumentList().getExpressions());
        if (!ExpressionUtils.isNullLiteral(arg)) {
            return null;
        }
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)psiAnchor.getParent());
        return EqualsToEqualityFix.buildFix(methodCallExpression, parent instanceof PsiExpression && BoolUtils.isNegation((PsiExpression)parent));
    }

    protected LocalQuickFix[] createConditionalAssignmentFixes(boolean evaluatesToTrue, PsiAssignmentExpression parent, boolean onTheFly) {
        return LocalQuickFix.EMPTY_ARRAY;
    }

    @Nullable
    private static PsiMethod getScopeMethod(PsiElement block) {
        PsiElement parent = block.getParent();
        if (parent instanceof PsiMethod) {
            return (PsiMethod)parent;
        }
        if (parent instanceof PsiLambdaExpression) {
            return LambdaUtil.getFunctionalInterfaceMethod((PsiType)((PsiLambdaExpression)parent).getFunctionalInterfaceType());
        }
        return null;
    }

    private void reportNullableReturns(ProblemReporter reporter, List<NullabilityProblemKind.NullabilityProblem<?>> problems2, Map<PsiExpression, ConstantResult> expressions2, @NotNull PsiElement block) {
        Nullability nullability;
        PsiMethod method;
        if (block == null) {
            DataFlowInspectionBase.$$$reportNull$$$0(11);
        }
        if ((method = DataFlowInspectionBase.getScopeMethod(block)) == null) {
            return;
        }
        NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)method.getProject());
        NullabilityAnnotationInfo info = manager.findEffectiveNullabilityInfo((PsiModifierListOwner)method);
        if (info == null) {
            info = DfaPsiUtil.getTypeNullabilityInfo(PsiTypesUtil.getMethodReturnType((PsiElement)block));
        }
        PsiAnnotation anno = info == null ? null : info.getAnnotation();
        Nullability nullability2 = nullability = info == null ? Nullability.UNKNOWN : info.getNullability();
        if (nullability == Nullability.NULLABLE) {
            if (!AnnotationUtil.isInferredAnnotation((PsiAnnotation)anno)) {
                return;
            }
            if (DfaPsiUtil.getTypeNullability(method.getReturnType()) == Nullability.NULLABLE) {
                return;
            }
        }
        if (nullability != Nullability.NOT_NULL && (!this.SUGGEST_NULLABLE_ANNOTATIONS || block.getParent() instanceof PsiLambdaExpression)) {
            return;
        }
        PsiType returnType = method.getReturnType();
        if (block instanceof PsiExpression && block.getParent() instanceof PsiLambdaExpression && PsiType.VOID.equals((Object)returnType)) {
            return;
        }
        if (returnType == null || returnType.equalsToText("java.lang.Void")) {
            return;
        }
        for (NullabilityProblemKind.NullabilityProblem problem : StreamEx.of(problems2).map(NullabilityProblemKind.nullableReturn::asMyProblem).nonNull()) {
            LocalQuickFix[] localQuickFixArray;
            String text2;
            boolean exactlyNull;
            PsiExpression anchor = (PsiExpression)problem.getAnchor();
            PsiExpression expr2 = problem.getDereferencedExpression();
            boolean bl = exactlyNull = DataFlowInspectionBase.isNullLiteralExpression((PsiElement)expr2) || expressions2.get(expr2) == ConstantResult.NULL;
            if (!this.REPORT_UNSOUND_WARNINGS && !exactlyNull) continue;
            if (nullability == Nullability.NOT_NULL) {
                String presentable = NullableStuffInspectionBase.getPresentableAnnoName(anno);
                String text3 = exactlyNull ? JavaAnalysisBundle.message((String)"dataflow.message.return.null.from.notnull", (Object[])new Object[]{presentable}) : JavaAnalysisBundle.message((String)"dataflow.message.return.nullable.from.notnull", (Object[])new Object[]{presentable});
                reporter.registerProblem((PsiElement)expr2, text3, this.createNPEFixes(expr2, expr2, reporter.isOnTheFly()).toArray(LocalQuickFix.EMPTY_ARRAY));
                continue;
            }
            if (!AnnotationUtil.isAnnotatingApplicable((PsiElement)anchor)) continue;
            String defaultNullable = manager.getDefaultNullable();
            String presentableNullable = StringUtil.getShortName((String)defaultNullable);
            String string = text2 = exactlyNull ? JavaAnalysisBundle.message((String)"dataflow.message.return.null.from.notnullable", (Object[])new Object[]{presentableNullable}) : JavaAnalysisBundle.message((String)"dataflow.message.return.nullable.from.notnullable", (Object[])new Object[]{presentableNullable});
            if (PsiTreeUtil.getParentOfType((PsiElement)anchor, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class}) instanceof PsiLambdaExpression) {
                localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
            } else {
                LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                localQuickFixArray = localQuickFixArray2;
                localQuickFixArray2[0] = new AnnotateMethodFix(defaultNullable, ArrayUtilRt.toStringArray((Collection)manager.getNotNulls()));
            }
            LocalQuickFix[] fixes = localQuickFixArray;
            reporter.registerProblem((PsiElement)expr2, text2, fixes);
        }
    }

    private static boolean isAssertionEffectively(@NotNull PsiElement anchor, ConstantResult result) {
        Object value2;
        if (anchor == null) {
            DataFlowInspectionBase.$$$reportNull$$$0(12);
        }
        if ((value2 = result.value()) instanceof Boolean) {
            return DataFlowInspectionBase.isAssertionEffectively(anchor, (Boolean)value2);
        }
        if (value2 != null) {
            return false;
        }
        return DataFlowInspectionBase.isAssertCallArgument(anchor, ContractValue.nullValue());
    }

    private static boolean isAssertionEffectively(@NotNull PsiElement anchor, boolean evaluatesToTrue) {
        PsiStatement thenBranch;
        PsiElement parent;
        if (anchor == null) {
            DataFlowInspectionBase.$$$reportNull$$$0(13);
        }
        while (true) {
            boolean causesShortCircuit;
            IElementType tokenType;
            if ((parent = anchor.getParent()) instanceof PsiExpression && BoolUtils.isNegation((PsiExpression)parent)) {
                evaluatesToTrue = !evaluatesToTrue;
                anchor = parent;
                continue;
            }
            if (parent instanceof PsiParenthesizedExpression) {
                anchor = parent;
                continue;
            }
            if (!(parent instanceof PsiPolyadicExpression) || !(tokenType = ((PsiPolyadicExpression)parent).getOperationTokenType()).equals(JavaTokenType.ANDAND) && !tokenType.equals(JavaTokenType.OROR)) break;
            boolean bl = causesShortCircuit = tokenType.equals(JavaTokenType.OROR) == evaluatesToTrue && ArrayUtil.getLastElement((Object[])((PsiPolyadicExpression)parent).getOperands()) != anchor;
            if (causesShortCircuit) break;
            anchor = parent;
        }
        if (parent instanceof PsiAssertStatement) {
            return evaluatesToTrue;
        }
        if (parent instanceof PsiIfStatement && anchor == ((PsiIfStatement)parent).getCondition() && (thenBranch = ControlFlowUtils.stripBraces(((PsiIfStatement)parent).getThenBranch())) instanceof PsiThrowStatement) {
            return !evaluatesToTrue;
        }
        return DataFlowInspectionBase.isAssertCallArgument(anchor, ContractValue.booleanValue(evaluatesToTrue));
    }

    private static boolean isAssertCallArgument(@NotNull PsiElement anchor, @NotNull ContractValue wantedConstraint) {
        ContractValue condition2;
        MethodContract contract;
        PsiMethodCallExpression call;
        int index;
        PsiElement parent;
        if (anchor == null) {
            DataFlowInspectionBase.$$$reportNull$$$0(14);
        }
        if (wantedConstraint == null) {
            DataFlowInspectionBase.$$$reportNull$$$0(15);
        }
        if ((parent = PsiUtil.skipParenthesizedExprUp((PsiElement)anchor.getParent())) instanceof PsiExpressionList && (index = ArrayUtil.indexOf((Object[])((PsiExpressionList)parent).getExpressions(), (Object)anchor)) >= 0 && (call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)parent.getParent(), PsiMethodCallExpression.class)) != null && (contract = (MethodContract)ContainerUtil.getOnlyItem(JavaMethodContractUtil.getMethodCallContracts((PsiCallExpression)call))) != null && contract.getReturnValue().isFail() && (condition2 = (ContractValue)ContainerUtil.getOnlyItem(contract.getConditions())) != null) {
            return condition2.getArgumentComparedTo(wantedConstraint, false).orElse(-1) == index;
        }
        return false;
    }

    private static boolean isAtRHSOfBooleanAnd(PsiElement expr2) {
        PsiElement cur = expr2;
        while (cur != null && !(cur instanceof PsiMember)) {
            PsiElement parent = cur.getParent();
            if (parent instanceof PsiBinaryExpression && cur == ((PsiBinaryExpression)parent).getROperand()) {
                return true;
            }
            cur = parent;
        }
        return false;
    }

    private static boolean isFlagCheck(PsiElement element) {
        PsiExpression topExpression;
        PsiElement scope = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiStatement.class, PsiVariable.class});
        Object object = scope instanceof PsiIfStatement ? ((PsiIfStatement)scope).getCondition() : (topExpression = scope instanceof PsiVariable ? ((PsiVariable)scope).getInitializer() : null);
        if (!PsiTreeUtil.isAncestor((PsiElement)topExpression, (PsiElement)element, (boolean)false)) {
            return false;
        }
        return StreamEx.ofTree((Object)topExpression, e -> StreamEx.of((Object[])e.getChildren())).anyMatch(DataFlowInspectionBase::isCompileTimeFlagCheck);
    }

    private static boolean isCompileTimeFlagCheck(PsiElement element) {
        PsiBinaryExpression binOp;
        if (element instanceof PsiBinaryExpression && ComparisonUtils.isComparisonOperation((binOp = (PsiBinaryExpression)element).getOperationTokenType())) {
            PsiBinaryExpression subOp;
            PsiExpression comparedWith = null;
            if (ExpressionUtils.isLiteral(binOp.getROperand())) {
                comparedWith = binOp.getLOperand();
            } else if (ExpressionUtils.isLiteral(binOp.getLOperand())) {
                comparedWith = binOp.getROperand();
            }
            comparedWith = PsiUtil.skipParenthesizedExprDown((PsiExpression)comparedWith);
            if (DataFlowInspectionBase.isConstantOfType((PsiElement)comparedWith, PsiType.INT, PsiType.LONG)) {
                return true;
            }
            if (comparedWith instanceof PsiBinaryExpression && (subOp = (PsiBinaryExpression)comparedWith).getOperationTokenType().equals(JavaTokenType.AND)) {
                PsiExpression left = PsiUtil.skipParenthesizedExprDown((PsiExpression)subOp.getLOperand());
                PsiExpression right = PsiUtil.skipParenthesizedExprDown((PsiExpression)subOp.getROperand());
                if (DataFlowInspectionBase.isConstantOfType((PsiElement)left, PsiType.INT, PsiType.LONG) || DataFlowInspectionBase.isConstantOfType((PsiElement)right, PsiType.INT, PsiType.LONG)) {
                    return true;
                }
            }
        }
        return DataFlowInspectionBase.isConstantOfType(element, PsiType.BOOLEAN);
    }

    private static boolean isConstantOfType(PsiElement element, PsiPrimitiveType ... types) {
        PsiElement resolved;
        PsiElement psiElement = resolved = element instanceof PsiReferenceExpression ? ((PsiReferenceExpression)element).resolve() : null;
        if (!(resolved instanceof PsiField)) {
            return false;
        }
        PsiVariable field = (PsiVariable)resolved;
        return field.hasModifierProperty("static") && PsiUtil.isCompileTimeConstant((PsiVariable)field) && ArrayUtil.contains((Object)field.getType(), (Object[])types);
    }

    private static boolean isNullLiteralExpression(PsiElement expr2) {
        return expr2 instanceof PsiExpression && ExpressionUtils.isNullLiteral((PsiExpression)expr2);
    }

    @Nullable
    private LocalQuickFix createSimplifyBooleanExpressionFix(PsiElement element, final boolean value2) {
        LocalQuickFixOnPsiElement fix2 = this.createSimplifyBooleanFix(element, value2);
        if (fix2 == null) {
            return null;
        }
        final String text2 = fix2.getText();
        return new LocalQuickFix(){

            @NotNull
            public String getName() {
                String string = text2;
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                PsiElement psiElement;
                if (project == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (descriptor == null) {
                    2.$$$reportNull$$$0(2);
                }
                if ((psiElement = descriptor.getPsiElement()) == null) {
                    return;
                }
                LocalQuickFixOnPsiElement fix2 = DataFlowInspectionBase.this.createSimplifyBooleanFix(psiElement, value2);
                if (fix2 == null) {
                    return;
                }
                try {
                    LOG.assertTrue(psiElement.isValid());
                    fix2.applyFix();
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }

            @NotNull
            public String getFamilyName() {
                String string = JavaAnalysisBundle.message((String)"inspection.data.flow.simplify.boolean.expression.quickfix", (Object[])new Object[0]);
                if (string == null) {
                    2.$$$reportNull$$$0(3);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInspection/dataFlow/DataFlowInspectionBase$2";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "descriptor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInspection/dataFlow/DataFlowInspectionBase$2";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "applyFix";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @NotNull
    protected static LocalQuickFix createSimplifyToAssignmentFix() {
        return new SimplifyToAssignmentFix();
    }

    protected LocalQuickFixOnPsiElement createSimplifyBooleanFix(PsiElement element, boolean value2) {
        return null;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = InspectionsBundle.message((String)"group.names.probable.bugs", (Object[])new Object[0]);
        if (string == null) {
            DataFlowInspectionBase.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        return SHORT_NAME;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/DataFlowInspectionBase";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wantedConstraint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/DataFlowInspectionBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createCastFixes";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createNPEFixes";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getContractMessage";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementToHighlight";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 16: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isCondition";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getElementToHighlight";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "reportNullableReturns";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isAssertionEffectively";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isAssertCallArgument";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class ProblemReporter {
        private final Set<PsiElement> myReportedAnchors = new HashSet<PsiElement>();
        private final ProblemsHolder myHolder;
        private final PsiElement myScope;

        ProblemReporter(ProblemsHolder holder, PsiElement scope) {
            this.myHolder = holder;
            this.myScope = scope;
        }

        public void registerProblem(PsiElement element, String message2, LocalQuickFix ... fixes) {
            if (this.register(element)) {
                this.myHolder.registerProblem(element, message2, fixes);
            }
        }

        void registerProblem(PsiElement element, String message2, ProblemHighlightType type2, LocalQuickFix ... fixes) {
            if (this.register(element)) {
                this.myHolder.registerProblem(element, message2, type2, fixes);
            }
        }

        void registerProblem(PsiElement element, TextRange range, String message2, LocalQuickFix ... fixes) {
            if (range == null) {
                this.registerProblem(element, message2, fixes);
            } else {
                this.myHolder.registerProblem(element, range, message2, fixes);
            }
        }

        private boolean register(PsiElement element) {
            PsiExpression deparenthesized;
            PsiMember member;
            if (!PsiTreeUtil.isAncestor((PsiElement)this.myScope, (PsiElement)element, (boolean)false)) {
                return false;
            }
            if (this.myScope instanceof PsiClass && (member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMember.class)) instanceof PsiMethod && !((PsiMethod)member).isConstructor()) {
                return false;
            }
            if (!this.myReportedAnchors.add(element)) {
                return false;
            }
            if (element instanceof PsiParenthesizedExpression && (deparenthesized = PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiExpression)element))) != null) {
                this.myReportedAnchors.add((PsiElement)deparenthesized);
            }
            return true;
        }

        boolean isOnTheFly() {
            return this.myHolder.isOnTheFly();
        }
    }

    protected static enum ConstantResult {
        TRUE,
        FALSE,
        NULL,
        UNKNOWN;


        @NotNull
        public String toString() {
            String string = StringUtil.toLowerCase((String)this.name());
            if (string == null) {
                ConstantResult.$$$reportNull$$$0(0);
            }
            return string;
        }

        public Object value() {
            switch (this) {
                case TRUE: {
                    return Boolean.TRUE;
                }
                case FALSE: {
                    return Boolean.FALSE;
                }
                case NULL: {
                    return null;
                }
            }
            throw new UnsupportedOperationException();
        }

        @NotNull
        static ConstantResult fromDfType(@NotNull DfType dfType) {
            if (dfType == null) {
                ConstantResult.$$$reportNull$$$0(1);
            }
            if (dfType == DfTypes.NULL) {
                ConstantResult constantResult = NULL;
                if (constantResult == null) {
                    ConstantResult.$$$reportNull$$$0(2);
                }
                return constantResult;
            }
            if (dfType == DfTypes.TRUE) {
                ConstantResult constantResult = TRUE;
                if (constantResult == null) {
                    ConstantResult.$$$reportNull$$$0(3);
                }
                return constantResult;
            }
            if (dfType == DfTypes.FALSE) {
                ConstantResult constantResult = FALSE;
                if (constantResult == null) {
                    ConstantResult.$$$reportNull$$$0(4);
                }
                return constantResult;
            }
            ConstantResult constantResult = UNKNOWN;
            if (constantResult == null) {
                ConstantResult.$$$reportNull$$$0(5);
            }
            return constantResult;
        }

        @NotNull
        static ConstantResult mergeValue(@Nullable ConstantResult state, @NotNull DfaMemoryState memState, @Nullable DfaValue value2) {
            if (memState == null) {
                ConstantResult.$$$reportNull$$$0(6);
            }
            if (state == UNKNOWN || value2 == null) {
                ConstantResult constantResult = UNKNOWN;
                if (constantResult == null) {
                    ConstantResult.$$$reportNull$$$0(7);
                }
                return constantResult;
            }
            ConstantResult nextState = ConstantResult.fromDfType(memState.getUnboxedDfType(value2));
            ConstantResult constantResult = state == null || state == nextState ? nextState : UNKNOWN;
            if (constantResult == null) {
                ConstantResult.$$$reportNull$$$0(8);
            }
            return constantResult;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 6: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 6: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/DataFlowInspectionBase$ConstantResult";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dfType";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "memState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
                case 1: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/DataFlowInspectionBase$ConstantResult";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fromDfType";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "mergeValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "fromDfType";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "mergeValue";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 6: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

