/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.ControlFlow;
import com.intellij.codeInspection.dataFlow.ControlFlowAnalyzer;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaMemoryStateImpl;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.codeInspection.dataFlow.LiveVariablesAnalyzer;
import com.intellij.codeInspection.dataFlow.Mutability;
import com.intellij.codeInspection.dataFlow.MutationSignature;
import com.intellij.codeInspection.dataFlow.RunnerResult;
import com.intellij.codeInspection.dataFlow.StandardInstructionVisitor;
import com.intellij.codeInspection.dataFlow.StateQueue;
import com.intellij.codeInspection.dataFlow.instructions.BranchingInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ClosureInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ConditionalGotoInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ControlTransferInstruction;
import com.intellij.codeInspection.dataFlow.instructions.FinishElementInstruction;
import com.intellij.codeInspection.dataFlow.instructions.GotoInstruction;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.instructions.MethodCallInstruction;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DfaExpressionFactory;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import gnu.trove.THashSet;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataFlowRunner {
    private static final Logger LOG = Logger.getInstance(DataFlowRunner.class);
    private static final int MERGING_BACK_BRANCHES_THRESHOLD = 50;
    static final int MAX_STATES_PER_BRANCH = 300;
    private Instruction[] myInstructions;
    @NotNull
    private final MultiMap<PsiElement, DfaMemoryState> myNestedClosures;
    @NotNull
    private final DfaValueFactory myValueFactory;
    private final boolean myIgnoreAssertions;
    private boolean myInlining;
    private boolean myCancelled;
    private boolean myWasForciblyMerged;
    private final TimeStats myStats;

    public DataFlowRunner(@NotNull Project project) {
        if (project == null) {
            DataFlowRunner.$$$reportNull$$$0(0);
        }
        this(project, null);
    }

    public DataFlowRunner(@NotNull Project project, @Nullable PsiElement context) {
        if (project == null) {
            DataFlowRunner.$$$reportNull$$$0(1);
        }
        this(project, context, false, false);
    }

    public DataFlowRunner(@NotNull Project project, @Nullable PsiElement context, boolean unknownMembersAreNullable, boolean ignoreAssertions) {
        if (project == null) {
            DataFlowRunner.$$$reportNull$$$0(2);
        }
        this.myNestedClosures = new MultiMap();
        this.myInlining = true;
        this.myCancelled = false;
        this.myWasForciblyMerged = false;
        this.myStats = this.createStatistics();
        this.myValueFactory = new DfaValueFactory(project, context, unknownMembersAreNullable);
        this.myIgnoreAssertions = ignoreAssertions;
    }

    @NotNull
    public DfaValueFactory getFactory() {
        DfaValueFactory dfaValueFactory = this.myValueFactory;
        if (dfaValueFactory == null) {
            DataFlowRunner.$$$reportNull$$$0(3);
        }
        return dfaValueFactory;
    }

    public final void cancel() {
        this.myCancelled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Collection<DfaMemoryState> createInitialStates(@NotNull PsiElement psiBlock, @NotNull InstructionVisitor visitor2, boolean allowInlining) {
        PsiElement block;
        PsiElement container;
        if (psiBlock == null) {
            DataFlowRunner.$$$reportNull$$$0(4);
        }
        if (visitor2 == null) {
            DataFlowRunner.$$$reportNull$$$0(5);
        }
        if ((container = PsiTreeUtil.getParentOfType((PsiElement)psiBlock, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class})) != null && (!(container instanceof PsiClass) || PsiUtil.isLocalOrAnonymousClass((PsiClass)((PsiClass)container))) && (block = DfaPsiUtil.getTopmostBlockInSameClass(container.getParent())) != null) {
            RunnerResult result;
            try {
                this.myInlining = allowInlining;
                result = this.analyzeMethod(block, visitor2);
            }
            finally {
                this.myInlining = true;
            }
            if (result == RunnerResult.OK) {
                Collection closureStates = this.myNestedClosures.get((Object)DfaPsiUtil.getTopmostBlockInSameClass(psiBlock));
                if (allowInlining || !closureStates.isEmpty()) {
                    return closureStates;
                }
            }
            return null;
        }
        return Collections.singletonList(this.createMemoryState());
    }

    @NotNull
    public final RunnerResult analyzeMethod(@NotNull PsiElement psiBlock, @NotNull InstructionVisitor visitor2) {
        Collection<DfaMemoryState> initialStates;
        if (psiBlock == null) {
            DataFlowRunner.$$$reportNull$$$0(6);
        }
        if (visitor2 == null) {
            DataFlowRunner.$$$reportNull$$$0(7);
        }
        return (initialStates = this.createInitialStates(psiBlock, visitor2, false)) == null ? RunnerResult.NOT_APPLICABLE : this.analyzeMethod(psiBlock, visitor2, initialStates);
    }

    @NotNull
    public final RunnerResult analyzeMethodWithInlining(@NotNull PsiElement psiBlock, @NotNull InstructionVisitor visitor2) {
        Collection<DfaMemoryState> initialStates;
        if (psiBlock == null) {
            DataFlowRunner.$$$reportNull$$$0(8);
        }
        if (visitor2 == null) {
            DataFlowRunner.$$$reportNull$$$0(9);
        }
        if ((initialStates = this.createInitialStates(psiBlock, visitor2, true)) == null) {
            RunnerResult runnerResult = RunnerResult.NOT_APPLICABLE;
            if (runnerResult == null) {
                DataFlowRunner.$$$reportNull$$$0(10);
            }
            return runnerResult;
        }
        if (initialStates.isEmpty()) {
            RunnerResult runnerResult = RunnerResult.OK;
            if (runnerResult == null) {
                DataFlowRunner.$$$reportNull$$$0(11);
            }
            return runnerResult;
        }
        return this.analyzeMethod(psiBlock, visitor2, initialStates);
    }

    public final RunnerResult analyzeCodeBlock(@NotNull PsiCodeBlock block, @NotNull InstructionVisitor visitor2) {
        if (block == null) {
            DataFlowRunner.$$$reportNull$$$0(12);
        }
        if (visitor2 == null) {
            DataFlowRunner.$$$reportNull$$$0(13);
        }
        return this.analyzeMethod((PsiElement)block, visitor2, Collections.singleton(this.createMemoryState()));
    }

    @NotNull
    final RunnerResult analyzeMethod(@NotNull PsiElement psiBlock, @NotNull InstructionVisitor visitor2, @NotNull Collection<? extends DfaMemoryState> initialStates) {
        ControlFlow flow;
        if (psiBlock == null) {
            DataFlowRunner.$$$reportNull$$$0(14);
        }
        if (visitor2 == null) {
            DataFlowRunner.$$$reportNull$$$0(15);
        }
        if (initialStates == null) {
            DataFlowRunner.$$$reportNull$$$0(16);
        }
        if ((flow = this.buildFlow(psiBlock)) == null) {
            RunnerResult runnerResult = RunnerResult.NOT_APPLICABLE;
            if (runnerResult == null) {
                DataFlowRunner.$$$reportNull$$$0(17);
            }
            return runnerResult;
        }
        List<DfaInstructionState> startingStates = this.createInitialInstructionStates(psiBlock, initialStates, flow);
        if (startingStates.isEmpty()) {
            RunnerResult runnerResult = RunnerResult.ABORTED;
            if (runnerResult == null) {
                DataFlowRunner.$$$reportNull$$$0(18);
            }
            return runnerResult;
        }
        return this.interpret(psiBlock, visitor2, flow, startingStates);
    }

    @Nullable
    protected final ControlFlow buildFlow(@NotNull PsiElement psiBlock) {
        if (psiBlock == null) {
            DataFlowRunner.$$$reportNull$$$0(19);
        }
        ControlFlow flow = null;
        try {
            this.myStats.reset();
            flow = new ControlFlowAnalyzer(this.myValueFactory, psiBlock, this.myInlining).buildControlFlow();
            this.myStats.endFlow();
            if (flow != null) {
                new LiveVariablesAnalyzer(flow, this.myValueFactory).flushDeadVariablesOnStatementFinish();
            }
            this.myStats.endLVA();
        }
        catch (ProcessCanceledException ex) {
            throw ex;
        }
        catch (AssertionError | RuntimeException e) {
            DataFlowRunner.reportDfaProblem(psiBlock, flow, null, (Throwable)e);
        }
        return flow;
    }

    /*
     * Exception decompiling
     */
    @NotNull
    protected final RunnerResult interpret(@NotNull PsiElement psiBlock, @NotNull InstructionVisitor visitor, @NotNull ControlFlow flow, @NotNull List<DfaInstructionState> startingStates) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 8[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @NotNull
    protected List<DfaInstructionState> createInitialInstructionStates(@NotNull PsiElement psiBlock, @NotNull Collection<? extends DfaMemoryState> memStates, @NotNull ControlFlow flow) {
        if (psiBlock == null) {
            DataFlowRunner.$$$reportNull$$$0(30);
        }
        if (memStates == null) {
            DataFlowRunner.$$$reportNull$$$0(31);
        }
        if (flow == null) {
            DataFlowRunner.$$$reportNull$$$0(32);
        }
        this.initializeVariables(psiBlock, memStates, flow);
        List list = ContainerUtil.map(memStates, s -> new DfaInstructionState(flow.getInstruction(0), (DfaMemoryState)s));
        if (list == null) {
            DataFlowRunner.$$$reportNull$$$0(33);
        }
        return list;
    }

    protected void beforeInstruction(Instruction instruction) {
    }

    protected void afterInstruction(Instruction instruction) {
    }

    @NotNull
    private DfaInstructionState mergeBackBranches(DfaInstructionState instructionState, Collection<DfaMemoryState> processed) {
        DfaMemoryStateImpl curState = (DfaMemoryStateImpl)instructionState.getMemoryState();
        Object key2 = curState.getMergeabilityKey();
        DfaMemoryStateImpl mergedState = (DfaMemoryStateImpl)StreamEx.of(processed).select(DfaMemoryStateImpl.class).filterBy(DfaMemoryStateImpl::getMergeabilityKey, key2).foldLeft((Object)curState, (s1, s2) -> {
            s1.merge((DfaMemoryStateImpl)s2);
            return s1;
        });
        instructionState = new DfaInstructionState(instructionState.getInstruction(), mergedState);
        this.myWasForciblyMerged = true;
        DfaInstructionState dfaInstructionState = instructionState;
        if (dfaInstructionState == null) {
            DataFlowRunner.$$$reportNull$$$0(34);
        }
        return dfaInstructionState;
    }

    boolean wasForciblyMerged() {
        return this.myWasForciblyMerged;
    }

    @NotNull
    private Set<Instruction> getJoinInstructions() {
        HashSet<Instruction> joinInstructions = new HashSet<Instruction>();
        for (int index = 0; index < this.myInstructions.length; ++index) {
            Instruction instruction = this.myInstructions[index];
            if (instruction instanceof GotoInstruction) {
                joinInstructions.add(this.myInstructions[((GotoInstruction)instruction).getOffset()]);
                continue;
            }
            if (instruction instanceof ConditionalGotoInstruction) {
                joinInstructions.add(this.myInstructions[((ConditionalGotoInstruction)instruction).getOffset()]);
                continue;
            }
            if (instruction instanceof ControlTransferInstruction) {
                IntStreamEx.of(((ControlTransferInstruction)instruction).getPossibleTargetIndices()).elements((Object[])this.myInstructions).into(joinInstructions);
                continue;
            }
            if (instruction instanceof MethodCallInstruction && !((MethodCallInstruction)instruction).getContracts().isEmpty()) {
                joinInstructions.add(this.myInstructions[index + 1]);
                continue;
            }
            if (!(instruction instanceof FinishElementInstruction) || ((FinishElementInstruction)instruction).getVarsToFlush().isEmpty()) continue;
            joinInstructions.add(this.myInstructions[index + 1]);
        }
        HashSet<Instruction> hashSet = joinInstructions;
        if (hashSet == null) {
            DataFlowRunner.$$$reportNull$$$0(35);
        }
        return hashSet;
    }

    private static void reportDfaProblem(@NotNull PsiElement psiBlock, ControlFlow flow, DfaInstructionState lastInstructionState, Throwable e) {
        if (psiBlock == null) {
            DataFlowRunner.$$$reportNull$$$0(36);
        }
        Object[] attachments = new Attachment[]{new Attachment("method_body.txt", psiBlock.getText())};
        if (flow != null) {
            String flowText = flow.toString();
            if (lastInstructionState != null) {
                int index = lastInstructionState.getInstruction().getIndex();
                flowText = flowText.replaceAll("(?m)^", "  ");
                flowText = flowText.replaceFirst("(?m)^ {2}" + index + ": ", "* " + index + ": ");
            }
            attachments = (Attachment[])ArrayUtil.append((Object[])attachments, (Object)new Attachment("flow.txt", flowText));
            if (lastInstructionState != null) {
                DfaMemoryState memoryState = lastInstructionState.getMemoryState();
                String memStateText = null;
                try {
                    memStateText = memoryState.toString();
                }
                catch (RuntimeException second) {
                    e.addSuppressed(second);
                }
                if (memStateText != null) {
                    attachments = (Attachment[])ArrayUtil.append((Object[])attachments, (Object)new Attachment("memory_state.txt", memStateText));
                }
            }
        }
        LOG.error((Throwable)new RuntimeExceptionWithAttachments(e, (Attachment[])attachments));
    }

    @NotNull
    public RunnerResult analyzeMethodRecursively(@NotNull PsiElement block, @NotNull StandardInstructionVisitor visitor2) {
        Collection<DfaMemoryState> states;
        if (block == null) {
            DataFlowRunner.$$$reportNull$$$0(37);
        }
        if (visitor2 == null) {
            DataFlowRunner.$$$reportNull$$$0(38);
        }
        if ((states = this.createInitialStates(block, visitor2, false)) == null) {
            RunnerResult runnerResult = RunnerResult.NOT_APPLICABLE;
            if (runnerResult == null) {
                DataFlowRunner.$$$reportNull$$$0(39);
            }
            return runnerResult;
        }
        RunnerResult runnerResult = this.analyzeBlockRecursively(block, states, visitor2);
        if (runnerResult == null) {
            DataFlowRunner.$$$reportNull$$$0(40);
        }
        return runnerResult;
    }

    @NotNull
    public RunnerResult analyzeBlockRecursively(@NotNull PsiElement block, @NotNull Collection<? extends DfaMemoryState> states, @NotNull StandardInstructionVisitor visitor2) {
        RunnerResult result;
        if (block == null) {
            DataFlowRunner.$$$reportNull$$$0(41);
        }
        if (states == null) {
            DataFlowRunner.$$$reportNull$$$0(42);
        }
        if (visitor2 == null) {
            DataFlowRunner.$$$reportNull$$$0(43);
        }
        if ((result = this.analyzeMethod(block, visitor2, states)) != RunnerResult.OK) {
            RunnerResult runnerResult = result;
            if (runnerResult == null) {
                DataFlowRunner.$$$reportNull$$$0(44);
            }
            return runnerResult;
        }
        Ref ref = Ref.create((Object)((Object)RunnerResult.OK));
        this.forNestedClosures((closure, nestedStates) -> {
            RunnerResult res = this.analyzeBlockRecursively((PsiElement)closure, (Collection<? extends DfaMemoryState>)nestedStates, visitor2);
            if (res != RunnerResult.OK) {
                ref.set((Object)res);
            }
        });
        RunnerResult runnerResult = (RunnerResult)((Object)ref.get());
        if (runnerResult == null) {
            DataFlowRunner.$$$reportNull$$$0(45);
        }
        return runnerResult;
    }

    private void initializeVariables(@NotNull PsiElement psiBlock, @NotNull Collection<? extends DfaMemoryState> initialStates, @NotNull ControlFlow flow) {
        List vars;
        DfaVariableValue assertionStatus;
        if (psiBlock == null) {
            DataFlowRunner.$$$reportNull$$$0(46);
        }
        if (initialStates == null) {
            DataFlowRunner.$$$reportNull$$$0(47);
        }
        if (flow == null) {
            DataFlowRunner.$$$reportNull$$$0(48);
        }
        if ((assertionStatus = (DfaVariableValue)ContainerUtil.find(vars = flow.accessedVariables().collect(Collectors.toList()), v -> v.getDescriptor() instanceof DfaExpressionFactory.AssertionDisabledDescriptor)) != null) {
            for (DfaMemoryState dfaMemoryState : initialStates) {
                dfaMemoryState.applyCondition(assertionStatus.eq(this.myValueFactory.getBoolean(this.myIgnoreAssertions)));
            }
        }
        if (psiBlock instanceof PsiClass) {
            DfaVariableValue thisValue = this.getFactory().getVarFactory().createThisValue((PsiClass)psiBlock);
            for (DfaMemoryState dfaMemoryState : initialStates) {
                dfaMemoryState.meetDfType(thisValue, DfTypes.LOCAL_OBJECT);
            }
            return;
        }
        PsiElement parent = psiBlock.getParent();
        if (parent instanceof PsiMethod && !((PsiMethod)parent).isConstructor()) {
            Map map2 = StreamEx.of(vars).mapToEntry(var -> DataFlowRunner.makeInitialValue(var, (PsiMethod)parent)).nonNullValues().toMap();
            for (DfaMemoryState dfaMemoryState : initialStates) {
                map2.forEach(dfaMemoryState::setVarValue);
            }
        }
    }

    @Nullable
    private static DfaValue makeInitialValue(DfaVariableValue var, @NotNull PsiMethod method) {
        if (method == null) {
            DataFlowRunner.$$$reportNull$$$0(49);
        }
        DfaValueFactory factory = var.getFactory();
        if (var.getDescriptor() instanceof DfaExpressionFactory.ThisDescriptor && var.getType() != null) {
            PsiClass aClass = ((DfaExpressionFactory.ThisDescriptor)var.getDescriptor()).getPsiElement();
            if (method.getContainingClass() == aClass && MutationSignature.fromMethod(method).preservesThis()) {
                DfType dfType = DfTypes.typedObject(var.getType(), Nullability.NOT_NULL).meet(Mutability.UNMODIFIABLE_VIEW.asDfType());
                return factory.fromDfType(dfType);
            }
            return null;
        }
        if (!DfaUtil.isEffectivelyUnqualified(var)) {
            return null;
        }
        PsiField field = (PsiField)ObjectUtils.tryCast((Object)var.getPsiVariable(), PsiField.class);
        if (field == null || DfaUtil.ignoreInitializer((PsiVariable)field) || DfaUtil.hasInitializationHacks(field)) {
            return null;
        }
        return DfaUtil.getPossiblyNonInitializedValue(factory, field, (PsiElement)method);
    }

    private static boolean containsState(Collection<DfaMemoryState> processed, DfaInstructionState instructionState) {
        if (processed.contains(instructionState.getMemoryState())) {
            return true;
        }
        for (DfaMemoryState state : processed) {
            if (!((DfaMemoryStateImpl)state).isSuperStateOf((DfaMemoryStateImpl)instructionState.getMemoryState())) continue;
            return true;
        }
        return false;
    }

    private void handleStepOutOfLoop(@NotNull Instruction prevInstruction, @NotNull Instruction nextInstruction, int @NotNull [] loopNumber, @NotNull MultiMap<BranchingInstruction, DfaMemoryState> processedStates, @NotNull MultiMap<BranchingInstruction, DfaMemoryState> incomingStates, @NotNull List<DfaInstructionState> inFlightStates, DfaInstructionState @NotNull [] afterStates, @NotNull StateQueue queue) {
        if (prevInstruction == null) {
            DataFlowRunner.$$$reportNull$$$0(50);
        }
        if (nextInstruction == null) {
            DataFlowRunner.$$$reportNull$$$0(51);
        }
        if (processedStates == null) {
            DataFlowRunner.$$$reportNull$$$0(52);
        }
        if (incomingStates == null) {
            DataFlowRunner.$$$reportNull$$$0(53);
        }
        if (inFlightStates == null) {
            DataFlowRunner.$$$reportNull$$$0(54);
        }
        if (queue == null) {
            DataFlowRunner.$$$reportNull$$$0(55);
        }
        if (loopNumber == null) {
            DataFlowRunner.$$$reportNull$$$0(56);
        }
        if (afterStates == null) {
            DataFlowRunner.$$$reportNull$$$0(57);
        }
        if (loopNumber[prevInstruction.getIndex()] == 0 || DataFlowRunner.inSameLoop(prevInstruction, nextInstruction, loopNumber)) {
            return;
        }
        for (DfaInstructionState state2 : inFlightStates) {
            Instruction instruction = state2.getInstruction();
            if (!DataFlowRunner.inSameLoop(prevInstruction, instruction, loopNumber)) continue;
            return;
        }
        for (DfaInstructionState state3 : afterStates) {
            Instruction instruction = state3.getInstruction();
            if (!DataFlowRunner.inSameLoop(prevInstruction, instruction, loopNumber)) continue;
            return;
        }
        if (!queue.processAll((Processor<? super DfaInstructionState>)((Processor)state -> {
            Instruction instruction = state.getInstruction();
            return !DataFlowRunner.inSameLoop(prevInstruction, instruction, loopNumber);
        }))) {
            return;
        }
        THashSet mayRemoveStatesFor = new THashSet();
        for (Instruction instruction : this.myInstructions) {
            if (!DataFlowRunner.inSameLoop(prevInstruction, instruction, loopNumber) || !(instruction instanceof BranchingInstruction)) continue;
            mayRemoveStatesFor.add((BranchingInstruction)((Object)instruction));
        }
        for (BranchingInstruction instruction : mayRemoveStatesFor) {
            processedStates.remove((Object)instruction);
            incomingStates.remove((Object)instruction);
        }
    }

    private static boolean inSameLoop(@NotNull Instruction prevInstruction, @NotNull Instruction nextInstruction, int @NotNull [] loopNumber) {
        if (prevInstruction == null) {
            DataFlowRunner.$$$reportNull$$$0(58);
        }
        if (nextInstruction == null) {
            DataFlowRunner.$$$reportNull$$$0(59);
        }
        if (loopNumber == null) {
            DataFlowRunner.$$$reportNull$$$0(60);
        }
        return loopNumber[nextInstruction.getIndex()] == loopNumber[prevInstruction.getIndex()];
    }

    protected DfaInstructionState @NotNull [] acceptInstruction(@NotNull InstructionVisitor visitor2, @NotNull DfaInstructionState instructionState) {
        if (visitor2 == null) {
            DataFlowRunner.$$$reportNull$$$0(61);
        }
        if (instructionState == null) {
            DataFlowRunner.$$$reportNull$$$0(62);
        }
        Instruction instruction = instructionState.getInstruction();
        DfaInstructionState[] states = instruction.accept(this, instructionState.getMemoryState(), visitor2);
        if (instruction instanceof ClosureInstruction) {
            PsiElement closure = ((ClosureInstruction)instruction).getClosureElement();
            if (closure instanceof PsiClass) {
                this.registerNestedClosures(instructionState, (PsiClass)closure);
            } else if (closure instanceof PsiLambdaExpression) {
                this.registerNestedClosures(instructionState, (PsiLambdaExpression)closure);
            }
        }
        if (states == null) {
            DataFlowRunner.$$$reportNull$$$0(63);
        }
        return states;
    }

    private void registerNestedClosures(@NotNull DfaInstructionState instructionState, @NotNull PsiClass nestedClass) {
        if (instructionState == null) {
            DataFlowRunner.$$$reportNull$$$0(64);
        }
        if (nestedClass == null) {
            DataFlowRunner.$$$reportNull$$$0(65);
        }
        DfaMemoryState state = instructionState.getMemoryState();
        for (PsiMethod psiMethod : nestedClass.getMethods()) {
            PsiCodeBlock body2 = psiMethod.getBody();
            if (body2 == null || !psiMethod.isPhysical() && nestedClass.isPhysical()) continue;
            this.createClosureState((PsiElement)body2, state);
        }
        for (PsiMethod psiMethod : nestedClass.getInitializers()) {
            this.createClosureState((PsiElement)psiMethod.getBody(), state);
        }
        for (PsiMethod psiMethod : nestedClass.getFields()) {
            this.createClosureState((PsiElement)psiMethod, state);
        }
    }

    private void registerNestedClosures(@NotNull DfaInstructionState instructionState, @NotNull PsiLambdaExpression expr2) {
        if (instructionState == null) {
            DataFlowRunner.$$$reportNull$$$0(66);
        }
        if (expr2 == null) {
            DataFlowRunner.$$$reportNull$$$0(67);
        }
        DfaMemoryState state = instructionState.getMemoryState();
        PsiElement body2 = expr2.getBody();
        if (body2 != null) {
            this.createClosureState(body2, state);
        }
    }

    private void createClosureState(PsiElement anchor, DfaMemoryState state) {
        this.myNestedClosures.putValue((Object)anchor, (Object)state.createClosureState());
    }

    @NotNull
    protected TimeStats createStatistics() {
        return new TimeStats();
    }

    @NotNull
    protected DfaMemoryState createMemoryState() {
        return new DfaMemoryStateImpl(this.myValueFactory);
    }

    public Instruction @NotNull [] getInstructions() {
        if (this.myInstructions == null) {
            DataFlowRunner.$$$reportNull$$$0(68);
        }
        return this.myInstructions;
    }

    @NotNull
    public Instruction getInstruction(int index) {
        Instruction instruction = this.myInstructions[index];
        if (instruction == null) {
            DataFlowRunner.$$$reportNull$$$0(69);
        }
        return instruction;
    }

    public void forNestedClosures(BiConsumer<? super PsiElement, ? super Collection<? extends DfaMemoryState>> consumer) {
        MultiMap closures = new MultiMap(this.myNestedClosures);
        for (PsiElement closure : closures.keySet()) {
            List unusedVars = ((StreamEx)((StreamEx)StreamEx.of(this.getFactory().getValues()).select(DfaVariableValue.class).filter(var -> var.getQualifier() == null)).filter(var -> var.getPsiVariable() instanceof PsiVariable && !VariableAccessUtils.variableIsUsed((PsiVariable)var.getPsiVariable(), closure))).toList();
            List<DfaMemoryStateImpl> states = closures.get((Object)closure);
            if (!unusedVars.isEmpty()) {
                List stateList = ((StreamEx)((StreamEx)StreamEx.of((Collection)states).peek(state -> unusedVars.forEach(state::flushVariable))).map(state -> (DfaMemoryStateImpl)state).distinct()).toList();
                states = StateQueue.mergeGroup(stateList);
            }
            consumer.accept((PsiElement)closure, states);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 10: 
            case 11: 
            case 17: 
            case 18: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 33: 
            case 34: 
            case 35: 
            case 39: 
            case 40: 
            case 44: 
            case 45: 
            case 63: 
            case 68: 
            case 69: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 10: 
            case 11: 
            case 17: 
            case 18: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 33: 
            case 34: 
            case 35: 
            case 39: 
            case 40: 
            case 44: 
            case 45: 
            case 63: 
            case 68: 
            case 69: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 10: 
            case 11: 
            case 17: 
            case 18: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 33: 
            case 34: 
            case 35: 
            case 39: 
            case 40: 
            case 44: 
            case 45: 
            case 63: 
            case 68: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/DataFlowRunner";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 14: 
            case 19: 
            case 20: 
            case 30: 
            case 36: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiBlock";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 13: 
            case 15: 
            case 21: 
            case 38: 
            case 43: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 12: 
            case 37: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 16: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialStates";
                break;
            }
            case 22: 
            case 32: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flow";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startingStates";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memStates";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "states";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 50: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prevInstruction";
                break;
            }
            case 51: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nextInstruction";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processedStates";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "incomingStates";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inFlightStates";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queue";
                break;
            }
            case 56: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loopNumber";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterStates";
                break;
            }
            case 62: 
            case 64: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instructionState";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nestedClass";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/DataFlowRunner";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFactory";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "analyzeMethodWithInlining";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "analyzeMethod";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "interpret";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "createInitialInstructionStates";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeBackBranches";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getJoinInstructions";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "analyzeMethodRecursively";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "analyzeBlockRecursively";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "acceptInstruction";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstructions";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstruction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 10: 
            case 11: 
            case 17: 
            case 18: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 33: 
            case 34: 
            case 35: 
            case 39: 
            case 40: 
            case 44: 
            case 45: 
            case 63: 
            case 68: 
            case 69: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createInitialStates";
                break;
            }
            case 6: 
            case 7: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "analyzeMethod";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "analyzeMethodWithInlining";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "analyzeCodeBlock";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "buildFlow";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "interpret";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "createInitialInstructionStates";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "reportDfaProblem";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "analyzeMethodRecursively";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "analyzeBlockRecursively";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "initializeVariables";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "makeInitialValue";
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "handleStepOutOfLoop";
                break;
            }
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "inSameLoop";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "acceptInstruction";
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "registerNestedClosures";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 10: 
            case 11: 
            case 17: 
            case 18: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 33: 
            case 34: 
            case 35: 
            case 39: 
            case 40: 
            case 44: 
            case 45: 
            case 63: 
            case 68: 
            case 69: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class TimeStats {
        private static final long DFA_EXECUTION_TIME_TO_REPORT_NANOS = TimeUnit.SECONDS.toNanos(30L);
        @Nullable
        private final ThreadMXBean myMxBean;
        private long myStart;
        private long myMergeStart;
        private long myFlowTime;
        private long myLVATime;
        private long myMergeTime;
        private long myProcessTime;

        TimeStats() {
            this(ApplicationManager.getApplication().isInternal() || ApplicationManager.getApplication().isEAP());
        }

        public TimeStats(boolean record) {
            this.myMxBean = record ? ManagementFactory.getThreadMXBean() : null;
            this.reset();
        }

        void reset() {
            this.myStart = this.myMxBean == null ? 0L : this.myMxBean.getCurrentThreadCpuTime();
            this.myProcessTime = 0L;
            this.myMergeTime = 0L;
            this.myLVATime = 0L;
            this.myFlowTime = 0L;
            this.myMergeStart = 0L;
        }

        void endFlow() {
            if (this.myMxBean != null) {
                this.myFlowTime = this.myMxBean.getCurrentThreadCpuTime() - this.myStart;
            }
        }

        void endLVA() {
            if (this.myMxBean != null) {
                this.myLVATime = this.myMxBean.getCurrentThreadCpuTime() - this.myStart - this.myFlowTime;
            }
        }

        void startMerge() {
            if (this.myMxBean != null) {
                this.myMergeStart = System.nanoTime();
            }
        }

        void endMerge() {
            if (this.myMxBean != null) {
                this.myMergeTime += System.nanoTime() - this.myMergeStart;
            }
        }

        void endProcess() {
            if (this.myMxBean != null) {
                this.myProcessTime = this.myMxBean.getCurrentThreadCpuTime() - this.myStart;
            }
        }

        boolean isTooSlow() {
            return this.myProcessTime > DFA_EXECUTION_TIME_TO_REPORT_NANOS;
        }

        public String toString() {
            double flowTime = (double)this.myFlowTime / 1.0E9;
            double lvaTime = (double)this.myLVATime / 1.0E9;
            double mergeTime = (double)this.myMergeTime / 1.0E9;
            double interpretTime = (double)(this.myProcessTime - this.myFlowTime - this.myLVATime - this.myMergeTime) / 1.0E9;
            double totalTime = (double)this.myProcessTime / 1.0E9;
            String format = "Building ControlFlow: %.2fs\nLiveVariableAnalyzer: %.2fs\nMerging states: %.2fs\nInterpreting: %.2fs\nTotal: %.2fs";
            return String.format(Locale.ENGLISH, format, flowTime, lvaTime, mergeTime, interpretTime, totalTime);
        }
    }
}

