/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.SortedIntSet;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class EqClass
extends SortedIntSet
implements Iterable<DfaVariableValue> {
    private final DfaValueFactory myFactory;
    static final Comparator<DfaVariableValue> CANONICAL_VARIABLE_COMPARATOR = Comparator.nullsFirst((v1, v2) -> {
        int result = CANONICAL_VARIABLE_COMPARATOR.compare(v1.getQualifier(), v2.getQualifier());
        if (result != 0) {
            return result;
        }
        return Integer.compare(v1.getID(), v2.getID());
    });

    EqClass(DfaValueFactory factory) {
        this.myFactory = factory;
    }

    EqClass(@NotNull EqClass toCopy) {
        if (toCopy == null) {
            EqClass.$$$reportNull$$$0(0);
        }
        super(toCopy.toNativeArray());
        this.myFactory = toCopy.myFactory;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("(");
        for (int i = 0; i < this.size(); ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            int value2 = this.get(i);
            DfaValue dfaValue = this.myFactory.getValue(value2);
            buf.append(dfaValue);
        }
        buf.append(")");
        return buf.toString();
    }

    DfaVariableValue getVariable(int index) {
        return (DfaVariableValue)this.myFactory.getValue(this.get(index));
    }

    List<DfaVariableValue> asList() {
        ArrayList<DfaVariableValue> vars = new ArrayList<DfaVariableValue>(this.size());
        this.forEach(id -> {
            vars.add((DfaVariableValue)this.myFactory.getValue(id));
            return true;
        });
        return vars;
    }

    @Nullable
    DfaVariableValue getCanonicalVariable() {
        if (this.size() == 1) {
            return this.getVariable(0);
        }
        return StreamEx.of(this.iterator()).min(CANONICAL_VARIABLE_COMPARATOR).orElse(null);
    }

    @Override
    @NotNull
    public Iterator<DfaVariableValue> iterator() {
        return new Iterator<DfaVariableValue>(){
            int pos;

            @Override
            public boolean hasNext() {
                return this.pos < EqClass.this.size();
            }

            @Override
            public DfaVariableValue next() {
                if (this.pos >= EqClass.this.size()) {
                    throw new NoSuchElementException();
                }
                return (DfaVariableValue)EqClass.this.myFactory.getValue(EqClass.this.get(this.pos++));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toCopy", "com/intellij/codeInspection/dataFlow/EqClass", "<init>"));
    }
}

