/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import gnu.trove.TIntArrayList;

public class SortedIntSet
extends TIntArrayList
implements Comparable<SortedIntSet> {
    public SortedIntSet() {
    }

    public SortedIntSet(int[] values) {
        super(values);
    }

    public void add(int val) {
        for (int idx = 0; idx < this.size(); ++idx) {
            int data = this.get(idx);
            if (data == val) {
                return;
            }
            if (data <= val) continue;
            this.insert(idx, val);
            return;
        }
        super.add(val);
    }

    public void add(int[] vals) {
        for (int val : vals) {
            this.add(val);
        }
    }

    public void removeValue(int val) {
        int offset = this.indexOf(val);
        if (offset != -1) {
            this.remove(offset);
        }
    }

    boolean containsAll(SortedIntSet that) {
        int thisSize;
        int thatSize = that.size();
        if (thatSize > (thisSize = this.size())) {
            return false;
        }
        int thisIndex = 0;
        for (int thatIndex = 0; thatIndex < thatSize; ++thatIndex) {
            int thatValue = that._data[thatIndex];
            while (thisIndex < thisSize && this._data[thisIndex] < thatValue) {
                ++thisIndex;
            }
            if (thisIndex == thisSize || this._data[thisIndex] > thatValue) {
                return false;
            }
            ++thisIndex;
        }
        return true;
    }

    @Override
    public int compareTo(SortedIntSet t) {
        if (t == this) {
            return 0;
        }
        if (t.size() != this.size()) {
            return Integer.compare(this.size(), t.size());
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this._data[i] == t._data[i]) continue;
            return Integer.compare(this._data[i], t._data[i]);
        }
        return 0;
    }
}

