/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.ContractReturnValue;
import com.intellij.codeInspection.dataFlow.ContractValue;
import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.Mutability;
import com.intellij.codeInspection.dataFlow.StandardMethodContract;
import com.intellij.codeInspection.dataFlow.TypeConstraints;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.types.DfConstantType;
import com.intellij.codeInspection.dataFlow.types.DfIntConstantType;
import com.intellij.codeInspection.dataFlow.types.DfReferenceType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DfaBoxedValue;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.codeInspection.dataFlow.value.VariableDescriptor;
import com.intellij.codeInspection.util.OptionalUtil;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum SpecialField implements VariableDescriptor
{
    ARRAY_LENGTH("length", true){

        @Override
        boolean isMyQualifierType(PsiType type2) {
            return type2 instanceof PsiArrayType;
        }

        @Override
        boolean isMyAccessor(PsiMember accessor) {
            return accessor instanceof PsiField && "length".equals(accessor.getName()) && PsiUtil.isArrayClass((PsiElement)accessor.getContainingClass());
        }

        @Override
        @NotNull
        DfType fromInitializer(PsiExpression initializer) {
            if (initializer instanceof PsiArrayInitializerExpression) {
                DfIntConstantType dfIntConstantType = DfTypes.intValue(((PsiArrayInitializerExpression)initializer).getInitializers().length);
                if (dfIntConstantType == null) {
                    1.$$$reportNull$$$0(0);
                }
                return dfIntConstantType;
            }
            if (initializer instanceof PsiNewExpression) {
                Object length;
                PsiArrayInitializerExpression arrayInitializer = ((PsiNewExpression)initializer).getArrayInitializer();
                if (arrayInitializer != null) {
                    DfIntConstantType dfIntConstantType = DfTypes.intValue(arrayInitializer.getInitializers().length);
                    if (dfIntConstantType == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return dfIntConstantType;
                }
                PsiExpression[] dimensions = ((PsiNewExpression)initializer).getArrayDimensions();
                if (dimensions.length > 0 && (length = ExpressionUtils.computeConstantExpression(dimensions[0])) instanceof Integer) {
                    DfIntConstantType dfIntConstantType = DfTypes.intValue((Integer)length);
                    if (dfIntConstantType == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return dfIntConstantType;
                }
            }
            DfType dfType = DfTypes.TOP;
            if (dfType == null) {
                1.$$$reportNull$$$0(3);
            }
            return dfType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/SpecialField$1", "fromInitializer"));
        }
    }
    ,
    STRING_LENGTH("length", true){

        @Override
        @NotNull
        DfType fromInitializer(PsiExpression initializer) {
            DfType dfType = this.fromConstant(ExpressionUtils.computeConstantExpression(initializer));
            if (dfType == null) {
                2.$$$reportNull$$$0(0);
            }
            return dfType;
        }

        @Override
        boolean isMyQualifierType(PsiType type2) {
            return TypeUtils.isJavaLangString(type2);
        }

        @Override
        boolean isMyAccessor(PsiMember accessor) {
            if (!(accessor instanceof PsiMethod && "length".equals(accessor.getName()) && ((PsiMethod)accessor).getParameterList().isEmpty())) {
                return false;
            }
            PsiClass containingClass = accessor.getContainingClass();
            return containingClass != null && "java.lang.String".equals(containingClass.getQualifiedName());
        }

        @Override
        @NotNull
        public DfType fromConstant(@Nullable Object obj) {
            DfType dfType = obj instanceof String ? DfTypes.intValue(((String)obj).length()) : DfTypes.TOP;
            if (dfType == null) {
                2.$$$reportNull$$$0(1);
            }
            return dfType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/codeInspection/dataFlow/SpecialField$2";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fromInitializer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fromConstant";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
    ,
    COLLECTION_SIZE("size", false){
        private final CallMatcher SIZE_METHODS = CallMatcher.anyOf(CallMatcher.instanceCall("java.util.Collection", "size").parameterCount(0), CallMatcher.instanceCall("java.util.Map", "size").parameterCount(0));
        private final CallMatcher MAP_COLLECTIONS = CallMatcher.instanceCall("java.util.Map", "keySet", "entrySet", "values").parameterCount(0);

        @Override
        boolean isMyQualifierType(PsiType type2) {
            return InheritanceUtil.isInheritor((PsiType)type2, (String)"java.util.Map") || InheritanceUtil.isInheritor((PsiType)type2, (String)"java.util.Collection");
        }

        @Override
        boolean isMyAccessor(PsiMember accessor) {
            return accessor instanceof PsiMethod && this.SIZE_METHODS.methodMatches((PsiMethod)accessor);
        }

        @Override
        @NotNull
        public DfType fromConstant(@Nullable Object obj) {
            if (obj instanceof PsiField && DfaUtil.isEmptyCollectionConstantField((PsiVariable)obj)) {
                DfIntConstantType dfIntConstantType = DfTypes.intValue(0);
                if (dfIntConstantType == null) {
                    3.$$$reportNull$$$0(0);
                }
                return dfIntConstantType;
            }
            DfType dfType = super.fromConstant(obj);
            if (dfType == null) {
                3.$$$reportNull$$$0(1);
            }
            return dfType;
        }

        @Override
        @NotNull
        public DfaValue createValue(@NotNull DfaValueFactory factory, @Nullable DfaValue qualifier, boolean forAccessor) {
            if (factory == null) {
                3.$$$reportNull$$$0(2);
            }
            if (qualifier instanceof DfaVariableValue) {
                DfaVariableValue var = (DfaVariableValue)qualifier;
                PsiModifierListOwner owner2 = var.getPsiVariable();
                if (var.getQualifier() != null && owner2 instanceof PsiMethod && this.MAP_COLLECTIONS.methodMatches((PsiMethod)owner2)) {
                    DfaValue dfaValue = super.createValue(factory, var.getQualifier(), forAccessor);
                    if (dfaValue == null) {
                        3.$$$reportNull$$$0(3);
                    }
                    return dfaValue;
                }
            }
            DfaValue dfaValue = super.createValue(factory, qualifier, forAccessor);
            if (dfaValue == null) {
                3.$$$reportNull$$$0(4);
            }
            return dfaValue;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/SpecialField$3";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fromConstant";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/SpecialField$3";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createValue";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
    ,
    UNBOX("value", true){
        private final CallMatcher UNBOXING_CALL = CallMatcher.anyOf(CallMatcher.exactInstanceCall("java.lang.Integer", "intValue").parameterCount(0), CallMatcher.exactInstanceCall("java.lang.Long", "longValue").parameterCount(0), CallMatcher.exactInstanceCall("java.lang.Short", "shortValue").parameterCount(0), CallMatcher.exactInstanceCall("java.lang.Byte", "byteValue").parameterCount(0), CallMatcher.exactInstanceCall("java.lang.Character", "charValue").parameterCount(0), CallMatcher.exactInstanceCall("java.lang.Boolean", "booleanValue").parameterCount(0), CallMatcher.exactInstanceCall("java.lang.Float", "floatValue").parameterCount(0), CallMatcher.exactInstanceCall("java.lang.Double", "doubleValue").parameterCount(0));

        public PsiPrimitiveType getType(DfaVariableValue variableValue) {
            return PsiPrimitiveType.getUnboxedType((PsiType)variableValue.getType());
        }

        @Override
        @NotNull
        public DfType getDefaultValue(boolean forAccessor) {
            DfType dfType = DfTypes.TOP;
            if (dfType == null) {
                4.$$$reportNull$$$0(0);
            }
            return dfType;
        }

        @Override
        @NotNull
        public DfaValue createValue(@NotNull DfaValueFactory factory, @Nullable DfaValue qualifier, boolean forAccessor) {
            if (factory == null) {
                4.$$$reportNull$$$0(1);
            }
            if (qualifier instanceof DfaBoxedValue) {
                DfaVariableValue dfaVariableValue = ((DfaBoxedValue)qualifier).getWrappedValue();
                if (dfaVariableValue == null) {
                    4.$$$reportNull$$$0(2);
                }
                return dfaVariableValue;
            }
            DfaValue dfaValue = super.createValue(factory, qualifier, forAccessor);
            if (dfaValue == null) {
                4.$$$reportNull$$$0(3);
            }
            return dfaValue;
        }

        @Override
        boolean isMyQualifierType(PsiType type2) {
            return TypeConversionUtil.isPrimitiveWrapper((PsiType)type2);
        }

        @Override
        boolean isMyAccessor(PsiMember accessor) {
            return accessor instanceof PsiMethod && this.UNBOXING_CALL.methodMatches((PsiMethod)accessor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/SpecialField$4";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefaultValue";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/SpecialField$4";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "createValue";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
    ,
    OPTIONAL_VALUE("value", true){

        @Override
        public PsiType getType(DfaVariableValue variableValue) {
            PsiType optionalType = variableValue.getType();
            PsiType type2 = OptionalUtil.getOptionalElementType(optionalType);
            if (type2 instanceof PsiPrimitiveType) {
                return ((PsiPrimitiveType)type2).getBoxedType((PsiElement)Objects.requireNonNull(((PsiClassType)optionalType).resolve()));
            }
            return type2;
        }

        @Override
        @NotNull
        public DfType getDefaultValue(boolean forAccessor) {
            DfReferenceType dfReferenceType = (forAccessor ? DfaNullability.NOT_NULL : DfaNullability.NULLABLE).asDfType();
            if (dfReferenceType == null) {
                5.$$$reportNull$$$0(0);
            }
            return dfReferenceType;
        }

        @Override
        boolean isMyQualifierType(PsiType type2) {
            return TypeUtils.isOptional(type2);
        }

        @Override
        public String getPresentationText(@NotNull DfType dfType, @Nullable PsiType type2) {
            if (dfType == null) {
                5.$$$reportNull$$$0(1);
            }
            if (dfType == DfTypes.NULL) {
                return "empty Optional";
            }
            if (!dfType.isSuperType(DfTypes.NULL)) {
                return "present Optional";
            }
            return "";
        }

        @Override
        boolean isMyAccessor(PsiMember accessor) {
            return accessor instanceof PsiMethod && OptionalUtil.OPTIONAL_GET.methodMatches((PsiMethod)accessor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/SpecialField$5";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dfType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefaultValue";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/SpecialField$5";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentationText";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };

    private static final SpecialField[] VALUES;
    private final String myTitle;
    private final boolean myFinal;

    private SpecialField(String title, boolean isFinal) {
        this.myTitle = title;
        this.myFinal = isFinal;
    }

    @Override
    public boolean isStable() {
        return this.myFinal;
    }

    abstract boolean isMyQualifierType(PsiType var1);

    abstract boolean isMyAccessor(PsiMember var1);

    public String getPresentationText(@NotNull DfType dfType, @Nullable PsiType type2) {
        if (dfType == null) {
            SpecialField.$$$reportNull$$$0(0);
        }
        if (this.getDefaultValue(false).equals(dfType)) {
            return "";
        }
        return dfType.toString();
    }

    @Contract(value="null -> null")
    @Nullable
    public static SpecialField findSpecialField(PsiElement accessor) {
        if (!(accessor instanceof PsiMember)) {
            return null;
        }
        PsiMember member = (PsiMember)accessor;
        for (SpecialField sf : VALUES) {
            if (!sf.isMyAccessor(member)) continue;
            return sf;
        }
        return null;
    }

    @Override
    @NotNull
    public final DfaValue createValue(@NotNull DfaValueFactory factory, @Nullable DfaValue qualifier) {
        if (factory == null) {
            SpecialField.$$$reportNull$$$0(1);
        }
        DfaValue dfaValue = this.createValue(factory, qualifier, false);
        if (dfaValue == null) {
            SpecialField.$$$reportNull$$$0(2);
        }
        return dfaValue;
    }

    @Override
    @NotNull
    public DfaValue createValue(@NotNull DfaValueFactory factory, @Nullable DfaValue qualifier, boolean forAccessor) {
        if (factory == null) {
            SpecialField.$$$reportNull$$$0(3);
        }
        if (qualifier instanceof DfaVariableValue) {
            DfType dfType;
            PsiExpression initializer;
            DfaVariableValue variableValue = (DfaVariableValue)qualifier;
            PsiModifierListOwner psiVariable = variableValue.getPsiVariable();
            if (psiVariable instanceof PsiField && factory.canTrustFieldInitializer((PsiField)psiVariable) && psiVariable.hasModifierProperty("static") && psiVariable.hasModifierProperty("final") && (initializer = ((PsiField)psiVariable).getInitializer()) != null && (dfType = this.fromInitializer(initializer)) != DfTypes.TOP) {
                DfaTypeValue dfaTypeValue = factory.fromDfType(dfType);
                if (dfaTypeValue == null) {
                    SpecialField.$$$reportNull$$$0(4);
                }
                return dfaTypeValue;
            }
            DfaValue dfaValue = VariableDescriptor.super.createValue(factory, qualifier, forAccessor);
            if (dfaValue == null) {
                SpecialField.$$$reportNull$$$0(5);
            }
            return dfaValue;
        }
        DfType dfType = qualifier == null ? DfTypes.TOP : this.getFromQualifier(qualifier.getDfType());
        DfaTypeValue dfaTypeValue = factory.fromDfType(dfType.meet(this.getDefaultValue(forAccessor)));
        if (dfaTypeValue == null) {
            SpecialField.$$$reportNull$$$0(6);
        }
        return dfaTypeValue;
    }

    @NotNull
    public DfType getDefaultValue(boolean forAccessor) {
        DfType dfType = DfTypes.intRange(LongRangeSet.indexRange());
        if (dfType == null) {
            SpecialField.$$$reportNull$$$0(7);
        }
        return dfType;
    }

    @Override
    public PsiType getType(DfaVariableValue variableValue) {
        return PsiType.INT;
    }

    @NotNull
    DfType fromInitializer(PsiExpression initializer) {
        DfType dfType = DfTypes.TOP;
        if (dfType == null) {
            SpecialField.$$$reportNull$$$0(8);
        }
        return dfType;
    }

    @NotNull
    public DfType fromConstant(@Nullable Object obj) {
        DfType dfType = DfTypes.TOP;
        if (dfType == null) {
            SpecialField.$$$reportNull$$$0(9);
        }
        return dfType;
    }

    public MethodContract[] getEmptyContracts() {
        ContractValue thisValue = ContractValue.qualifier().specialField(this);
        return new MethodContract[]{MethodContract.singleConditionContract(thisValue, RelationType.EQ, ContractValue.zero(), ContractReturnValue.returnTrue()), MethodContract.trivialContract(ContractReturnValue.returnFalse())};
    }

    public MethodContract[] getEqualsContracts() {
        return new MethodContract[]{new StandardMethodContract(new StandardMethodContract.ValueConstraint[]{StandardMethodContract.ValueConstraint.NULL_VALUE}, ContractReturnValue.returnFalse()), MethodContract.singleConditionContract(ContractValue.qualifier().specialField(this), RelationType.NE, ContractValue.argument(0).specialField(this), ContractReturnValue.returnFalse())};
    }

    @NotNull
    public DfType asDfType(@NotNull DfType fieldValue) {
        DfReferenceType defaultType;
        DfType clamped;
        if (fieldValue == null) {
            SpecialField.$$$reportNull$$$0(10);
        }
        if ((clamped = fieldValue.meet(defaultType = this == OPTIONAL_VALUE ? DfTypes.OBJECT_OR_NULL : this.getDefaultValue(false))).equals(defaultType)) {
            DfReferenceType dfReferenceType = DfTypes.NOT_NULL_OBJECT;
            if (dfReferenceType == null) {
                SpecialField.$$$reportNull$$$0(11);
            }
            return dfReferenceType;
        }
        if (clamped.equals(DfTypes.BOTTOM)) {
            DfType dfType = DfTypes.BOTTOM;
            if (dfType == null) {
                SpecialField.$$$reportNull$$$0(12);
            }
            return dfType;
        }
        DfReferenceType dfReferenceType = DfTypes.customObject(TypeConstraints.TOP, DfaNullability.NOT_NULL, Mutability.UNKNOWN, this, clamped);
        if (dfReferenceType == null) {
            SpecialField.$$$reportNull$$$0(13);
        }
        return dfReferenceType;
    }

    @NotNull
    public DfType asDfType(@NotNull DfType fieldValue, @Nullable PsiType exactResultType) {
        if (fieldValue == null) {
            SpecialField.$$$reportNull$$$0(14);
        }
        DfType dfType = this.asDfType(fieldValue);
        if (exactResultType == null) {
            DfType dfType2 = dfType;
            if (dfType2 == null) {
                SpecialField.$$$reportNull$$$0(15);
            }
            return dfType2;
        }
        if (this == STRING_LENGTH && DfConstantType.isConst(fieldValue, 0)) {
            DfConstantType<?> dfConstantType = DfTypes.constant("", exactResultType);
            if (dfConstantType == null) {
                SpecialField.$$$reportNull$$$0(16);
            }
            return dfConstantType;
        }
        DfType dfType3 = dfType.meet(TypeConstraints.exact(exactResultType).asDfType());
        if (dfType3 == null) {
            SpecialField.$$$reportNull$$$0(17);
        }
        return dfType3;
    }

    @NotNull
    public DfType getFromQualifier(@NotNull DfType dfType) {
        if (dfType == null) {
            SpecialField.$$$reportNull$$$0(18);
        }
        if (dfType == DfTypes.TOP) {
            DfType dfType2 = DfTypes.TOP;
            if (dfType2 == null) {
                SpecialField.$$$reportNull$$$0(19);
            }
            return dfType2;
        }
        if (!(dfType instanceof DfReferenceType)) {
            DfType dfType3 = DfTypes.BOTTOM;
            if (dfType3 == null) {
                SpecialField.$$$reportNull$$$0(20);
            }
            return dfType3;
        }
        SpecialField sf = ((DfReferenceType)dfType).getSpecialField();
        if (sf == null) {
            DfType dfType4 = DfTypes.TOP;
            if (dfType4 == null) {
                SpecialField.$$$reportNull$$$0(21);
            }
            return dfType4;
        }
        if (sf != this) {
            DfType dfType5 = DfTypes.BOTTOM;
            if (dfType5 == null) {
                SpecialField.$$$reportNull$$$0(22);
            }
            return dfType5;
        }
        DfType dfType6 = ((DfReferenceType)dfType).getSpecialFieldType();
        if (dfType6 == null) {
            SpecialField.$$$reportNull$$$0(23);
        }
        return dfType6;
    }

    @Contract(value="null -> null")
    @Nullable
    public static SpecialField fromQualifierType(PsiType type2) {
        if (type2 == null) {
            return null;
        }
        for (SpecialField value2 : VALUES) {
            if (!value2.isMyQualifierType(type2)) continue;
            return value2;
        }
        return null;
    }

    @Nullable
    public static SpecialField fromQualifier(@NotNull DfaValue value2) {
        DfReferenceType dfType;
        if (value2 == null) {
            SpecialField.$$$reportNull$$$0(24);
        }
        if ((dfType = (DfReferenceType)ObjectUtils.tryCast((Object)value2.getDfType(), DfReferenceType.class)) != null && dfType.getSpecialField() != null) {
            return dfType.getSpecialField();
        }
        return SpecialField.fromQualifierType(value2.getType());
    }

    public String toString() {
        return this.myTitle;
    }

    static {
        VALUES = SpecialField.values();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfType";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/SpecialField";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldValue";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/SpecialField";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createValue";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValue";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "fromInitializer";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "fromConstant";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "asDfType";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getFromQualifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPresentationText";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createValue";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                break;
            }
            case 10: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "asDfType";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getFromQualifier";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "fromQualifier";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

