/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.rangeSet;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeUtil;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ThreeState;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LongRangeSet {
    private static final String JETBRAINS_RANGE = "org.jetbrains.annotations.Range";
    private static final String CHECKER_RANGE = "org.checkerframework.common.value.qual.IntRange";
    private static final String CHECKER_GTE_NEGATIVE_ONE = "org.checkerframework.checker.index.qual.GTENegativeOne";
    private static final String CHECKER_NON_NEGATIVE = "org.checkerframework.checker.index.qual.NonNegative";
    private static final String CHECKER_POSITIVE = "org.checkerframework.checker.index.qual.Positive";
    private static final String JSR305_NONNEGATIVE = "javax.annotation.Nonnegative";
    private static final String VALIDATION_MIN = "javax.validation.constraints.Min";
    private static final String VALIDATION_MAX = "javax.validation.constraints.Max";
    private static final List<String> ANNOTATIONS = Arrays.asList("org.checkerframework.common.value.qual.IntRange", "org.checkerframework.checker.index.qual.GTENegativeOne", "org.checkerframework.checker.index.qual.NonNegative", "org.checkerframework.checker.index.qual.Positive", "javax.annotation.Nonnegative", "javax.validation.constraints.Min", "javax.validation.constraints.Max");

    LongRangeSet() {
    }

    @NotNull
    public abstract LongRangeSet subtract(@NotNull LongRangeSet var1);

    public LongRangeSet without(long value2) {
        return this.subtract(LongRangeSet.point(value2));
    }

    public boolean isEmpty() {
        return this == Empty.EMPTY;
    }

    @NotNull
    public abstract LongRangeSet intersect(@NotNull LongRangeSet var1);

    @NotNull
    public abstract LongRangeSet unite(@NotNull LongRangeSet var1);

    public abstract long min();

    public abstract long max();

    @Nullable
    public Long getConstantValue() {
        return null;
    }

    public abstract boolean intersects(LongRangeSet var1);

    public abstract boolean contains(long var1);

    public abstract boolean contains(LongRangeSet var1);

    public LongRangeSet fromRelation(@Nullable RelationType relation) {
        if (this.isEmpty() || relation == null) {
            return null;
        }
        switch (relation) {
            case EQ: {
                return this;
            }
            case NE: {
                long min = this.min();
                if (min == this.max()) {
                    return LongRangeSet.all().without(min);
                }
                return LongRangeSet.all();
            }
            case GT: {
                long min = this.min();
                return min == Long.MAX_VALUE ? LongRangeSet.empty() : LongRangeSet.range(min + 1L, Long.MAX_VALUE);
            }
            case GE: {
                return LongRangeSet.range(this.min(), Long.MAX_VALUE);
            }
            case LE: {
                return LongRangeSet.range(Long.MIN_VALUE, this.max());
            }
            case LT: {
                long max = this.max();
                return max == Long.MIN_VALUE ? LongRangeSet.empty() : LongRangeSet.range(Long.MIN_VALUE, max - 1L);
            }
        }
        return null;
    }

    public abstract String getPresentationText(PsiType var1);

    @Contract(value="null, _, _ -> null")
    @Nullable
    public final LongRangeSet binOpFromToken(IElementType token, LongRangeSet right, boolean isLong) {
        if (token == null) {
            return null;
        }
        if (token.equals(JavaTokenType.PLUS)) {
            return this.plus(right, isLong);
        }
        if (token.equals(JavaTokenType.MINUS)) {
            return this.minus(right, isLong);
        }
        if (token.equals(JavaTokenType.AND)) {
            return this.bitwiseAnd(right);
        }
        if (token.equals(JavaTokenType.OR)) {
            return this.bitwiseOr(right, isLong);
        }
        if (token.equals(JavaTokenType.XOR)) {
            return this.bitwiseXor(right, isLong);
        }
        if (token.equals(JavaTokenType.PERC)) {
            return this.mod(right);
        }
        if (token.equals(JavaTokenType.DIV)) {
            return this.div(right, isLong);
        }
        if (token.equals(JavaTokenType.LTLT)) {
            return this.shiftLeft(right, isLong);
        }
        if (token.equals(JavaTokenType.GTGT)) {
            return this.shiftRight(right, isLong);
        }
        if (token.equals(JavaTokenType.GTGTGT)) {
            return this.unsignedShiftRight(right, isLong);
        }
        if (token.equals(JavaTokenType.ASTERISK)) {
            return this.mul(right, isLong);
        }
        return null;
    }

    @Nullable
    public LongRangeSet wideBinOpFromToken(@NotNull IElementType token, @NotNull LongRangeSet other, boolean isLong) {
        if (token == null) {
            LongRangeSet.$$$reportNull$$$0(0);
        }
        if (other == null) {
            LongRangeSet.$$$reportNull$$$0(1);
        }
        if (token.equals(JavaTokenType.PLUS) || token.equals(JavaTokenType.MINUS)) {
            return this.plusWiden(token.equals(JavaTokenType.MINUS) ? other.negate(isLong) : other, isLong);
        }
        if (token.equals(JavaTokenType.ASTERISK)) {
            return this.mulWiden(other, isLong);
        }
        return null;
    }

    private LongRangeSet mulWiden(LongRangeSet other, boolean isLong) {
        if (Point.ZERO.equals(this)) {
            return this;
        }
        if (Point.ZERO.equals(other)) {
            return other;
        }
        if (Point.ONE.equals(this)) {
            return other;
        }
        if (Point.ONE.equals(other)) {
            return this;
        }
        if (Point.ZERO.equals(this.mod(LongRangeSet.point(2L))) || Point.ZERO.equals(other.mod(LongRangeSet.point(2L)))) {
            return LongRangeSet.modRange(LongRangeSet.minValue(isLong), LongRangeSet.maxValue(isLong), 2L, 1L);
        }
        return null;
    }

    private LongRangeSet plusWiden(LongRangeSet other, boolean isLong) {
        if (this instanceof Point && other instanceof Point) {
            int mod;
            LongRangeSet constVal;
            int tzb2;
            long val1 = ((Point)this).myValue;
            long val2 = ((Point)other).myValue;
            int tzb1 = val1 == 0L ? 0 : Long.numberOfTrailingZeros(val1);
            int n = tzb2 = val2 == 0L ? 0 : Long.numberOfTrailingZeros(val2);
            if (tzb1 > tzb2) {
                constVal = other;
                mod = 1 << Math.min(6, tzb1);
            } else {
                constVal = this;
                mod = 1 << Math.min(6, tzb2);
            }
            if (mod < 2) {
                return null;
            }
            return LongRangeSet.modRange(LongRangeSet.minValue(isLong), LongRangeSet.maxValue(isLong), mod, 1L).plus(constVal, isLong);
        }
        if (this instanceof Point && other instanceof ModRange) {
            int gcd;
            long value2 = ((Point)this).myValue;
            ModRange modRange = (ModRange)other;
            if (value2 % (long)modRange.myMod == 0L) {
                return LongRangeSet.modRange(LongRangeSet.minValue(isLong), LongRangeSet.maxValue(isLong), modRange.myMod, modRange.myBits);
            }
            if (modRange.myBits == 1L) {
                return this.plus(other, isLong);
            }
            if (value2 >= -64L && value2 < 64L && (gcd = LongRangeUtil.gcd(Math.abs((int)value2), modRange.myMod)) > 1) {
                long count = modRange.myMod / gcd;
                long bits = 0L;
                int i = 0;
                while ((long)i < count) {
                    bits |= modRange.myBits >>> i * gcd & (1L << gcd) - 1L;
                    ++i;
                }
                return LongRangeSet.modRange(LongRangeSet.minValue(isLong), LongRangeSet.maxValue(isLong), gcd, bits);
            }
        }
        if (other instanceof Point && this instanceof ModRange) {
            return other.plusWiden(this, isLong);
        }
        return null;
    }

    public abstract boolean isCardinalityBigger(long var1);

    public abstract LongRangeSet castTo(PsiPrimitiveType var1);

    @NotNull
    public abstract LongRangeSet abs(boolean var1);

    @NotNull
    public abstract LongRangeSet negate(boolean var1);

    @NotNull
    public abstract LongRangeSet plus(LongRangeSet var1, boolean var2);

    @NotNull
    public LongRangeSet minus(LongRangeSet other, boolean isLong) {
        LongRangeSet longRangeSet = this.plus(other.negate(isLong), isLong);
        if (longRangeSet == null) {
            LongRangeSet.$$$reportNull$$$0(2);
        }
        return longRangeSet;
    }

    @NotNull
    public LongRangeSet bitwiseOr(LongRangeSet other, boolean isLong) {
        if (this.isEmpty() || other.isEmpty()) {
            LongRangeSet longRangeSet = LongRangeSet.empty();
            if (longRangeSet == null) {
                LongRangeSet.$$$reportNull$$$0(3);
            }
            return longRangeSet;
        }
        LongRangeSet result = LongRangeSet.fromBits(this.getBitwiseMask().or(other.getBitwiseMask()));
        LongRangeSet longRangeSet = isLong ? result : result.intersect(Range.INT_RANGE);
        if (longRangeSet == null) {
            LongRangeSet.$$$reportNull$$$0(4);
        }
        return longRangeSet;
    }

    @NotNull
    public LongRangeSet bitwiseXor(LongRangeSet other, boolean isLong) {
        if (this.isEmpty() || other.isEmpty()) {
            LongRangeSet longRangeSet = LongRangeSet.empty();
            if (longRangeSet == null) {
                LongRangeSet.$$$reportNull$$$0(5);
            }
            return longRangeSet;
        }
        LongRangeSet result = LongRangeSet.fromBits(this.getBitwiseMask().xor(other.getBitwiseMask()));
        LongRangeSet longRangeSet = isLong ? result : result.intersect(Range.INT_RANGE);
        if (longRangeSet == null) {
            LongRangeSet.$$$reportNull$$$0(6);
        }
        return longRangeSet;
    }

    @NotNull
    public LongRangeSet bitwiseAnd(LongRangeSet other) {
        if (this.isEmpty() || other.isEmpty()) {
            LongRangeSet longRangeSet = LongRangeSet.empty();
            if (longRangeSet == null) {
                LongRangeSet.$$$reportNull$$$0(7);
            }
            return longRangeSet;
        }
        long[] left = LongRangeSet.splitAtZero(this.asRanges());
        long[] right = LongRangeSet.splitAtZero(other.asRanges());
        if (left.length > 6) {
            left = LongRangeSet.splitAtZero(new long[]{left[0], left[left.length - 1]});
        }
        if (right.length > 6) {
            right = LongRangeSet.splitAtZero(new long[]{right[0], right[right.length - 1]});
        }
        LongRangeUtil.BitString globalMask = this.getBitwiseMask().and(other.getBitwiseMask());
        globalMask = new LongRangeUtil.BitString(globalMask.myBits | globalMask.myMask ^ 0xFFFFFFFFFFFFFFFFL, -1L);
        LongRangeSet result = LongRangeSet.empty();
        for (int i = 0; i < left.length; i += 2) {
            for (int j = 0; j < right.length; j += 2) {
                result = result.unite(LongRangeSet.bitwiseAnd(left[i], left[i + 1], right[j], right[j + 1], globalMask));
            }
        }
        LongRangeSet longRangeSet = result;
        if (longRangeSet == null) {
            LongRangeSet.$$$reportNull$$$0(8);
        }
        return longRangeSet;
    }

    public abstract LongRangeSet mul(LongRangeSet var1, boolean var2);

    LongRangeUtil.BitString getBitwiseMask() {
        if (this.isEmpty()) {
            return LongRangeUtil.BitString.UNSURE;
        }
        return LongRangeUtil.BitString.fromRange(this.min(), this.max());
    }

    @NotNull
    public LongRangeSet div(LongRangeSet divisor, boolean isLong) {
        if (divisor.isEmpty() || divisor.equals(Point.ZERO)) {
            LongRangeSet longRangeSet = LongRangeSet.empty();
            if (longRangeSet == null) {
                LongRangeSet.$$$reportNull$$$0(9);
            }
            return longRangeSet;
        }
        LongRangeSet dividend = this;
        if (!isLong) {
            divisor = divisor.intersect(Range.INT_RANGE);
            dividend = dividend.intersect(Range.INT_RANGE);
        }
        long[] left = LongRangeSet.splitAtZero(dividend.asRanges());
        long[] right = LongRangeSet.splitAtZero(new long[]{divisor.min(), divisor.max()});
        LongRangeSet result = LongRangeSet.empty();
        for (int i = 0; i < left.length; i += 2) {
            for (int j = 0; j < right.length; j += 2) {
                result = result.unite(LongRangeSet.divide(left[i], left[i + 1], right[j], right[j + 1], isLong));
            }
        }
        LongRangeSet longRangeSet = result;
        if (longRangeSet == null) {
            LongRangeSet.$$$reportNull$$$0(10);
        }
        return longRangeSet;
    }

    public boolean subtractionMayOverflow(LongRangeSet other, boolean isLong) {
        long leftMin = this.min();
        long leftMax = this.max();
        long rightMin = other.min();
        long rightMax = other.max();
        return isLong ? LongRangeSet.overflowsLong(leftMin, rightMax) || LongRangeSet.overflowsLong(leftMax, rightMin) : LongRangeSet.overflowsInt(leftMin, rightMax) || LongRangeSet.overflowsInt(leftMax, rightMin);
    }

    private static boolean overflowsInt(long a, long b) {
        long diff = a - b;
        return diff < Integer.MIN_VALUE || diff > Integer.MAX_VALUE;
    }

    private static boolean overflowsLong(long a, long b) {
        long diff = a - b;
        return ((a ^ b) & (a ^ diff)) < 0L;
    }

    @NotNull
    private static LongRangeSet divide(long dividendMin, long dividendMax, long divisorMin, long divisorMax, boolean isLong) {
        if (divisorMin == 0L) {
            if (divisorMax == 0L) {
                LongRangeSet longRangeSet = LongRangeSet.empty();
                if (longRangeSet == null) {
                    LongRangeSet.$$$reportNull$$$0(11);
                }
                return longRangeSet;
            }
            divisorMin = 1L;
        }
        if (dividendMin >= 0L) {
            LongRangeSet longRangeSet = divisorMin > 0L ? LongRangeSet.range(dividendMin / divisorMax, dividendMax / divisorMin) : LongRangeSet.range(dividendMax / divisorMax, dividendMin / divisorMin);
            if (longRangeSet == null) {
                LongRangeSet.$$$reportNull$$$0(12);
            }
            return longRangeSet;
        }
        if (divisorMin > 0L) {
            LongRangeSet longRangeSet = LongRangeSet.range(dividendMin / divisorMin, dividendMax / divisorMax);
            if (longRangeSet == null) {
                LongRangeSet.$$$reportNull$$$0(13);
            }
            return longRangeSet;
        }
        long minValue = LongRangeSet.minValue(isLong);
        if (dividendMin == minValue && divisorMax == -1L) {
            LongRangeSet longRangeSet = LongRangeSet.point(minValue).unite(divisorMin == -1L ? LongRangeSet.empty() : LongRangeSet.range(dividendMin / divisorMin, dividendMin / (divisorMax - 1L))).unite(dividendMax == minValue ? LongRangeSet.empty() : LongRangeSet.range(dividendMax / divisorMin, (dividendMin + 1L) / divisorMax));
            if (longRangeSet == null) {
                LongRangeSet.$$$reportNull$$$0(14);
            }
            return longRangeSet;
        }
        LongRangeSet longRangeSet = LongRangeSet.range(dividendMax / divisorMin, dividendMin / divisorMax);
        if (longRangeSet == null) {
            LongRangeSet.$$$reportNull$$$0(15);
        }
        return longRangeSet;
    }

    @NotNull
    public LongRangeSet shiftLeft(LongRangeSet shiftSize, boolean isLong) {
        if (this.isEmpty() || shiftSize.isEmpty()) {
            LongRangeSet longRangeSet = LongRangeSet.empty();
            if (longRangeSet == null) {
                LongRangeSet.$$$reportNull$$$0(16);
            }
            return longRangeSet;
        }
        if (shiftSize instanceof Point) {
            long shift = ((Point)shiftSize).myValue & (long)((isLong ? 64 : 32) - 1);
            LongRangeSet longRangeSet = LongRangeSet.point(1L << (int)shift).mul(this, isLong);
            if (longRangeSet == null) {
                LongRangeSet.$$$reportNull$$$0(17);
            }
            return longRangeSet;
        }
        Range range = isLong ? Range.LONG_RANGE : Range.INT_RANGE;
        if (range == null) {
            LongRangeSet.$$$reportNull$$$0(18);
        }
        return range;
    }

    @NotNull
    public LongRangeSet shiftRight(LongRangeSet shiftSize, boolean isLong) {
        LongRangeSet longRangeSet = this.doShiftRight(shiftSize, isLong, false);
        if (longRangeSet == null) {
            LongRangeSet.$$$reportNull$$$0(19);
        }
        return longRangeSet;
    }

    @NotNull
    public LongRangeSet unsignedShiftRight(LongRangeSet shiftSize, boolean isLong) {
        LongRangeSet longRangeSet = this.doShiftRight(shiftSize, isLong, true);
        if (longRangeSet == null) {
            LongRangeSet.$$$reportNull$$$0(20);
        }
        return longRangeSet;
    }

    private LongRangeSet doShiftRight(LongRangeSet shiftSize, boolean isLong, boolean unsigned) {
        LongRangeSet negativeResult;
        if (this.isEmpty() || shiftSize.isEmpty()) {
            return LongRangeSet.empty();
        }
        int maxShift = (isLong ? 64 : 32) - 1;
        if (shiftSize.min() < 0L || shiftSize.max() > (long)maxShift) {
            shiftSize = shiftSize.bitwiseAnd(LongRangeSet.point(maxShift));
        }
        long min = shiftSize.min();
        long max = shiftSize.max();
        LongRangeSet negative = this.intersect(LongRangeSet.range(LongRangeSet.minValue(isLong), -1L));
        LongRangeSet positive = this.intersect(LongRangeSet.range(0L, LongRangeSet.maxValue(isLong)));
        LongRangeSet positiveResult = positive.shrPositive(min, max, isLong);
        LongRangeSet negativeComplement = LongRangeSet.point(-1L).minus(negative, isLong);
        if (unsigned) {
            if (min == 0L) {
                positiveResult = positiveResult.unite(negative);
                if (max == 0L) {
                    return positiveResult;
                }
                ++min;
            }
            negativeResult = LongRangeSet.point(LongRangeSet.maxValue(isLong)).minus(negativeComplement.shrPositive(1L, 1L, isLong), isLong).shrPositive(min - 1L, max - 1L, isLong);
        } else {
            negativeResult = LongRangeSet.point(-1L).minus(negativeComplement.shrPositive(min, max, isLong), isLong);
        }
        return positiveResult.unite(negativeResult);
    }

    private LongRangeSet shrPositive(long min, long max, boolean isLong) {
        if (this.isEmpty()) {
            return LongRangeSet.empty();
        }
        int maxShift = (isLong ? 64 : 32) - 1;
        if (max == (long)maxShift) {
            return min == max ? Point.ZERO : Point.ZERO.unite(this.div(LongRangeSet.range(1L << (int)min, 1L << (int)(max - 1L)), isLong));
        }
        return this.div(LongRangeSet.range(1L << (int)min, 1L << (int)max), isLong);
    }

    @NotNull
    public abstract LongRangeSet mod(LongRangeSet var1);

    private static long[] splitAtZero(long[] ranges2) {
        for (int i = 0; i < ranges2.length; i += 2) {
            if (ranges2[i] >= 0L || ranges2[i + 1] < 0L) continue;
            long[] result = new long[ranges2.length + 2];
            System.arraycopy(ranges2, 0, result, 0, i + 1);
            result[i + 1] = -1L;
            System.arraycopy(ranges2, i + 1, result, i + 3, ranges2.length - i - 1);
            return result;
        }
        return ranges2;
    }

    private static LongRangeSet bitwiseAnd(long leftFrom, long leftTo, long rightFrom, long rightTo, LongRangeUtil.BitString globalMask) {
        if (leftFrom == leftTo && rightFrom == rightTo) {
            return LongRangeSet.point(leftFrom & rightFrom & (globalMask.myBits | globalMask.myMask ^ 0xFFFFFFFFFFFFFFFFL));
        }
        if (leftFrom == leftTo && Long.bitCount(leftFrom + 1L) == 1) {
            return LongRangeSet.bitwiseMask(rightFrom, rightTo, leftFrom);
        }
        if (rightFrom == rightTo && Long.bitCount(rightFrom + 1L) == 1) {
            return LongRangeSet.bitwiseMask(leftFrom, leftTo, rightFrom);
        }
        LongRangeUtil.BitString leftBits = LongRangeUtil.BitString.fromRange(leftFrom, leftTo);
        LongRangeUtil.BitString rightBits = LongRangeUtil.BitString.fromRange(rightFrom, rightTo);
        return LongRangeSet.fromBits(leftBits.and(rightBits).and(globalMask));
    }

    private static LongRangeSet bitwiseMask(long from, long to, long mask) {
        if (to - from > mask) {
            return LongRangeSet.range(0L, mask);
        }
        long min = from & mask;
        long max = to & mask;
        assert (min != max);
        if (min < max) {
            return LongRangeSet.range(min, max);
        }
        return new RangeSet(new long[]{0L, max, min, mask});
    }

    private static LongRangeSet fromBits(LongRangeUtil.BitString bits) {
        int j;
        int i;
        if (bits.myMask == -1L) {
            return LongRangeSet.point(bits.myBits);
        }
        long from = 0L;
        for (i = 63; i >= 0 && bits.get(i) != ThreeState.UNSURE; --i) {
            if (bits.get(i) != ThreeState.YES) continue;
            from = LongRangeUtil.setBit(from, i);
        }
        long to = (i == 63 ? 0L : 1L << i + 1) - 1L | from;
        for (j = 0; j < i && bits.get(j) != ThreeState.UNSURE; ++j) {
            if (bits.get(j) != ThreeState.NO) continue;
            to = LongRangeUtil.clearBit(to, j);
        }
        if (i == j) {
            return LongRangeSet.point(from).unite(LongRangeSet.point(to));
        }
        long modBits = -1L;
        block2: for (int rem = 0; rem < 64; ++rem) {
            for (int pos = 0; pos < 6; ++pos) {
                ThreeState bit = bits.get(pos);
                if (bit != ThreeState.fromBoolean((!LongRangeUtil.isSet(rem, pos) ? 1 : 0) != 0)) continue;
                modBits = LongRangeUtil.clearBit(modBits, rem);
                continue block2;
            }
        }
        if (from >= 0L && to < 0L) {
            from = Long.MIN_VALUE;
            to = Long.MAX_VALUE;
        }
        return from < to ? LongRangeSet.modRange(from, to, 64L, modBits) : LongRangeSet.modRange(to, from, 64L, modBits);
    }

    private static String formatNumber(long value2) {
        if (value2 == Long.MAX_VALUE) {
            return "Long.MAX_VALUE";
        }
        if (value2 == 0x7FFFFFFFFFFFFFFEL) {
            return "Long.MAX_VALUE-1";
        }
        if (value2 == Long.MIN_VALUE) {
            return "Long.MIN_VALUE";
        }
        if (value2 == -9223372036854775807L) {
            return "Long.MIN_VALUE+1";
        }
        if (value2 == Integer.MAX_VALUE) {
            return "Integer.MAX_VALUE";
        }
        if (value2 == 0x7FFFFFFEL) {
            return "Integer.MAX_VALUE-1";
        }
        if (value2 == Integer.MIN_VALUE) {
            return "Integer.MIN_VALUE";
        }
        if (value2 == -2147483647L) {
            return "Integer.MIN_VALUE+1";
        }
        return String.valueOf(value2);
    }

    public abstract LongStream stream();

    public static LongRangeSet empty() {
        return Empty.EMPTY;
    }

    @NotNull
    public static LongRangeSet all() {
        Range range = Range.LONG_RANGE;
        if (range == null) {
            LongRangeSet.$$$reportNull$$$0(21);
        }
        return range;
    }

    public static LongRangeSet point(long value2) {
        return value2 == 0L ? Point.ZERO : (value2 == 1L ? Point.ONE : new Point(value2));
    }

    @Nullable
    public static LongRangeSet fromConstant(Object val) {
        if (val instanceof Byte || val instanceof Short || val instanceof Integer || val instanceof Long) {
            return LongRangeSet.point(((Number)val).longValue());
        }
        if (val instanceof Character) {
            return LongRangeSet.point(((Character)val).charValue());
        }
        return null;
    }

    public static LongRangeSet range(long from, long to) {
        return from == to ? LongRangeSet.point(from) : new Range(from, to);
    }

    public static LongRangeSet modRange(long from, long to, long mod, long bits) {
        long leftHalf;
        int halfMod;
        long rightHalf;
        int toBit;
        long rotatedTo;
        long rotatedFrom;
        if (mod <= 0L) {
            throw new IllegalArgumentException();
        }
        if (bits == 0L) {
            return LongRangeSet.empty();
        }
        if (mod == 1L || mod > 64L) {
            return LongRangeSet.range(from, to);
        }
        int intMod = (int)mod;
        if ((from += (long)Long.numberOfTrailingZeros(rotatedFrom = LongRangeUtil.rotateRemainders(bits, intMod, LongRangeUtil.remainder(from, intMod)))) > (to -= (long)(intMod - (64 - Long.numberOfLeadingZeros(rotatedTo = LongRangeUtil.rotateRemainders(bits, intMod, toBit = (LongRangeUtil.remainder(to, intMod) + 1) % intMod)))))) {
            return LongRangeSet.empty();
        }
        if (from == to) {
            return new Point(from);
        }
        long length = to - from;
        if (length > 0L && length <= (long)(intMod / 2)) {
            for (int newMod = (int)length; newMod <= intMod / 2; ++newMod) {
                if (intMod % newMod != 0) continue;
                long newBits = 0L;
                for (long i = from; i >= from && i <= to; ++i) {
                    if (!LongRangeUtil.isSet(bits, LongRangeUtil.remainder(i, intMod))) continue;
                    newBits = LongRangeUtil.setBit(newBits, LongRangeUtil.remainder(i, newMod));
                }
                intMod = newMod;
                bits = newBits;
                if (bits != 0L) break;
                return LongRangeSet.empty();
            }
        }
        if (intMod % 2 == 0 && (rightHalf = LongRangeUtil.extractBits(bits, 0, halfMod = intMod / 2)) == (leftHalf = LongRangeUtil.extractBits(bits, halfMod, halfMod))) {
            return LongRangeSet.modRange(from, to, halfMod, leftHalf);
        }
        if (Long.bitCount(bits) == intMod) {
            return LongRangeSet.range(from, to);
        }
        ModRange range = new ModRange(from, to, intMod, bits);
        LongRangeSet fullRange = LongRangeSet.range(from, to);
        return range.contains(fullRange) ? fullRange : range;
    }

    abstract long[] asRanges();

    static String toString(long from, long to) {
        return LongRangeSet.formatNumber(from) + (from == to ? "" : (to - from == 1L ? ", " : "..") + LongRangeSet.formatNumber(to));
    }

    static long minValue(boolean isLong) {
        return isLong ? Long.MIN_VALUE : Integer.MIN_VALUE;
    }

    static long maxValue(boolean isLong) {
        return isLong ? Long.MAX_VALUE : Integer.MAX_VALUE;
    }

    public static LongRangeSet indexRange() {
        return Range.INDEX_RANGE;
    }

    @Nullable
    public static LongRangeSet fromType(PsiType type2) {
        if (!(type2 instanceof PsiPrimitiveType) && !TypeConversionUtil.isPrimitiveWrapper((PsiType)type2)) {
            return null;
        }
        if ((type2 = PsiPrimitiveType.getOptionallyUnboxedType((PsiType)type2)) != null) {
            if (type2.equals(PsiType.BYTE)) {
                return Range.BYTE_RANGE;
            }
            if (type2.equals(PsiType.CHAR)) {
                return Range.CHAR_RANGE;
            }
            if (type2.equals(PsiType.SHORT)) {
                return Range.SHORT_RANGE;
            }
            if (type2.equals(PsiType.INT)) {
                return Range.INT_RANGE;
            }
            if (type2.equals(PsiType.LONG)) {
                return LongRangeSet.all();
            }
        }
        return null;
    }

    @NotNull
    public static LongRangeSet fromPsiElement(PsiModifierListOwner owner2) {
        if (owner2 == null) {
            return LongRangeSet.all();
        }
        LongRangeSet longRangeSet = (LongRangeSet)StreamEx.of((Object[])new PsiAnnotation[]{AnnotationUtil.findAnnotation((PsiModifierListOwner)owner2, (String[])new String[]{JETBRAINS_RANGE}), owner2.getAnnotation(JETBRAINS_RANGE)}).nonNull().append((Object[])AnnotationUtil.findAnnotations((PsiModifierListOwner)owner2, ANNOTATIONS)).map(LongRangeSet::fromAnnotation).foldLeft((Object)LongRangeSet.all(), LongRangeSet::intersect);
        if (longRangeSet == null) {
            LongRangeSet.$$$reportNull$$$0(22);
        }
        return longRangeSet;
    }

    private static LongRangeSet fromAnnotation(PsiAnnotation annotation) {
        switch (Objects.requireNonNull(annotation.getQualifiedName())) {
            case "org.jetbrains.annotations.Range": 
            case "org.checkerframework.common.value.qual.IntRange": {
                Long from = AnnotationUtil.getLongAttributeValue((PsiAnnotation)annotation, (String)"from");
                Long to = AnnotationUtil.getLongAttributeValue((PsiAnnotation)annotation, (String)"to");
                if (from == null || to == null || to < from) break;
                return LongRangeSet.range(from, to);
            }
            case "javax.validation.constraints.Min": {
                Long minValue = AnnotationUtil.getLongAttributeValue((PsiAnnotation)annotation, (String)"value");
                if (minValue == null || annotation.findDeclaredAttributeValue("groups") != null) break;
                return LongRangeSet.range(minValue, Long.MAX_VALUE);
            }
            case "javax.validation.constraints.Max": {
                Long maxValue = AnnotationUtil.getLongAttributeValue((PsiAnnotation)annotation, (String)"value");
                if (maxValue == null || annotation.findDeclaredAttributeValue("groups") != null) break;
                return LongRangeSet.range(Long.MIN_VALUE, maxValue);
            }
            case "org.checkerframework.checker.index.qual.GTENegativeOne": {
                return LongRangeSet.range(-1L, Long.MAX_VALUE);
            }
            case "javax.annotation.Nonnegative": 
            case "org.checkerframework.checker.index.qual.NonNegative": {
                return LongRangeSet.range(0L, Long.MAX_VALUE);
            }
            case "org.checkerframework.checker.index.qual.Positive": {
                return LongRangeSet.range(1L, Long.MAX_VALUE);
            }
        }
        return LongRangeSet.all();
    }

    static LongRangeSet fromRanges(long[] ranges2, int bound) {
        if (bound == 0) {
            return Empty.EMPTY;
        }
        if (bound == 2) {
            return LongRangeSet.range(ranges2[0], ranges2[1]);
        }
        return new RangeSet(Arrays.copyOfRange(ranges2, 0, bound));
    }

    public static LongRangeSet fromRemainder(long mod, LongRangeSet remainders) {
        long max;
        if (remainders.isEmpty()) {
            return LongRangeSet.empty();
        }
        long min = remainders.min() > 0L ? 1L : Long.MIN_VALUE;
        long l = max = remainders.max() < 0L ? -1L : Long.MAX_VALUE;
        if (mod > 1L && mod <= 64L) {
            long bits = remainders.contains(0L) ? 1L : 0L;
            int rem = 1;
            while ((long)rem < mod) {
                if (remainders.contains(rem) || remainders.contains((long)rem - mod)) {
                    bits = LongRangeUtil.setBit(bits, rem);
                }
                ++rem;
            }
            return LongRangeSet.modRange(min, max, mod, bits);
        }
        return LongRangeSet.range(min, max);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "token";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/rangeSet/LongRangeSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/rangeSet/LongRangeSet";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "minus";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "bitwiseOr";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "bitwiseXor";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "bitwiseAnd";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "div";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "divide";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "shiftLeft";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "shiftRight";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "unsignedShiftRight";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "all";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "fromPsiElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "wideBinOpFromToken";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class RangeSet
    extends LongRangeSet {
        final long[] myRanges;

        RangeSet(long[] ranges2) {
            if (ranges2.length < 4 || ranges2.length % 2 != 0) {
                throw new IllegalArgumentException("Bad length: " + ranges2.length + " " + Arrays.toString(ranges2));
            }
            for (int i = 0; i < ranges2.length; i += 2) {
                if (ranges2[i + 1] < ranges2[i]) {
                    throw new IllegalArgumentException("Bad sub-range #" + i / 2 + " " + Arrays.toString(ranges2));
                }
                if (i <= 0 || ranges2[i - 1] != Long.MAX_VALUE && 1L + ranges2[i - 1] <= ranges2[i]) continue;
                throw new IllegalArgumentException("Bad sub-ranges #" + (i / 2 - 1) + " and #" + i / 2 + " " + Arrays.toString(ranges2));
            }
            this.myRanges = ranges2;
        }

        @Override
        LongRangeUtil.BitString getBitwiseMask() {
            LongRangeUtil.BitString result = null;
            for (int i = 0; i < this.myRanges.length; i += 2) {
                LongRangeUtil.BitString newBits = LongRangeUtil.BitString.fromRange(this.myRanges[i], this.myRanges[i + 1]);
                result = result == null ? newBits : result.unite(newBits);
            }
            return result;
        }

        @Override
        @NotNull
        public LongRangeSet subtract(@NotNull LongRangeSet other) {
            if (other == null) {
                RangeSet.$$$reportNull$$$0(0);
            }
            if (other.isEmpty()) {
                RangeSet rangeSet = this;
                if (rangeSet == null) {
                    RangeSet.$$$reportNull$$$0(1);
                }
                return rangeSet;
            }
            if (other == this) {
                LongRangeSet longRangeSet = Empty.EMPTY;
                if (longRangeSet == null) {
                    RangeSet.$$$reportNull$$$0(2);
                }
                return longRangeSet;
            }
            long[] result = new long[this.myRanges.length + other.asRanges().length];
            int index = 0;
            for (int i = 0; i < this.myRanges.length; i += 2) {
                LongRangeSet res = RangeSet.range(this.myRanges[i], this.myRanges[i + 1]).subtract(other);
                long[] ranges2 = res.asRanges();
                System.arraycopy(ranges2, 0, result, index, ranges2.length);
                index += ranges2.length;
            }
            LongRangeSet longRangeSet = RangeSet.fromRanges(result, index);
            if (longRangeSet == null) {
                RangeSet.$$$reportNull$$$0(3);
            }
            return longRangeSet;
        }

        @Override
        @NotNull
        public LongRangeSet intersect(@NotNull LongRangeSet other) {
            if (other == null) {
                RangeSet.$$$reportNull$$$0(4);
            }
            if (other == this) {
                RangeSet rangeSet = this;
                if (rangeSet == null) {
                    RangeSet.$$$reportNull$$$0(5);
                }
                return rangeSet;
            }
            if (other.isEmpty()) {
                LongRangeSet longRangeSet = other;
                if (longRangeSet == null) {
                    RangeSet.$$$reportNull$$$0(6);
                }
                return longRangeSet;
            }
            if (other instanceof Point || other instanceof Range) {
                LongRangeSet longRangeSet = other.intersect(this);
                if (longRangeSet == null) {
                    RangeSet.$$$reportNull$$$0(7);
                }
                return longRangeSet;
            }
            LongRangeSet longRangeSet = this.subtract(RangeSet.all().subtract(other));
            if (longRangeSet == null) {
                RangeSet.$$$reportNull$$$0(8);
            }
            return longRangeSet;
        }

        @Override
        @NotNull
        public LongRangeSet unite(@NotNull LongRangeSet other) {
            if (other == null) {
                RangeSet.$$$reportNull$$$0(9);
            }
            if (!(other instanceof RangeSet)) {
                LongRangeSet longRangeSet = other.unite(this);
                if (longRangeSet == null) {
                    RangeSet.$$$reportNull$$$0(10);
                }
                return longRangeSet;
            }
            if (other == this) {
                RangeSet rangeSet = this;
                if (rangeSet == null) {
                    RangeSet.$$$reportNull$$$0(11);
                }
                return rangeSet;
            }
            if (other.contains(this)) {
                LongRangeSet longRangeSet = other;
                if (longRangeSet == null) {
                    RangeSet.$$$reportNull$$$0(12);
                }
                return longRangeSet;
            }
            if (this.contains(other)) {
                RangeSet rangeSet = this;
                if (rangeSet == null) {
                    RangeSet.$$$reportNull$$$0(13);
                }
                return rangeSet;
            }
            LongRangeSet result = other;
            for (int i = 0; i < this.myRanges.length; i += 2) {
                result = RangeSet.range(this.myRanges[i], this.myRanges[i + 1]).unite(result);
            }
            LongRangeSet longRangeSet = result;
            if (longRangeSet == null) {
                RangeSet.$$$reportNull$$$0(14);
            }
            return longRangeSet;
        }

        @Override
        public long min() {
            return this.myRanges[0];
        }

        @Override
        public long max() {
            return this.myRanges[this.myRanges.length - 1];
        }

        @Override
        public boolean intersects(LongRangeSet other) {
            long bTo;
            long aFrom;
            if (other.isEmpty()) {
                return false;
            }
            if (other instanceof Point) {
                return this.contains(((Point)other).myValue);
            }
            long[] otherRanges = other.asRanges();
            int a = 0;
            int b = 0;
            do {
                aFrom = this.myRanges[a];
                long aTo = this.myRanges[a + 1];
                long bFrom = otherRanges[b];
                bTo = otherRanges[b + 1];
                if (aFrom > bTo || bFrom > aTo) continue;
                return true;
            } while (!(aFrom > bTo ? (b += 2) >= otherRanges.length : (a += 2) >= this.myRanges.length));
            return false;
        }

        @Override
        public boolean contains(long value2) {
            for (int i = 0; i < this.myRanges.length; i += 2) {
                if (value2 < this.myRanges[i] || value2 > this.myRanges[i + 1]) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean contains(LongRangeSet other) {
            if (other.isEmpty() || other == this) {
                return true;
            }
            if (other instanceof Point) {
                return this.contains(((Point)other).myValue);
            }
            LongRangeSet result = other;
            for (int i = 0; i < this.myRanges.length; i += 2) {
                if (!(result = result.subtract(RangeSet.range(this.myRanges[i], this.myRanges[i + 1]))).isEmpty()) continue;
                return true;
            }
            return false;
        }

        @Override
        public String getPresentationText(PsiType type2) {
            LongRangeSet diff;
            LongRangeSet set = RangeSet.fromType(type2);
            if (set != null && (diff = set.subtract(this)) instanceof Point) {
                return "!= " + diff.min();
            }
            if (this.myRanges.length == 4 && this.myRanges[0] == this.myRanges[1] && this.myRanges[2] == this.myRanges[3]) {
                return this.myRanges[0] + " or " + this.myRanges[2];
            }
            return "in " + this.toString();
        }

        @Override
        public boolean isCardinalityBigger(long cutoff) {
            long totalDiff = 0L;
            for (int i = 0; i < this.myRanges.length; i += 2) {
                long diff = this.myRanges[i + 1] - this.myRanges[i];
                if (diff < 0L) {
                    return true;
                }
                if ((totalDiff += diff + 1L) >= 0L && totalDiff <= cutoff) continue;
                return true;
            }
            return false;
        }

        @Override
        public LongRangeSet castTo(PsiPrimitiveType type2) {
            LongRangeSet result = RangeSet.empty();
            for (int i = 0; i < this.myRanges.length; i += 2) {
                result = result.unite(RangeSet.range(this.myRanges[i], this.myRanges[i + 1]).castTo(type2));
            }
            return result;
        }

        @Override
        @NotNull
        public LongRangeSet abs(boolean isLong) {
            LongRangeSet result = RangeSet.empty();
            for (int i = 0; i < this.myRanges.length; i += 2) {
                result = result.unite(RangeSet.range(this.myRanges[i], this.myRanges[i + 1]).abs(isLong));
            }
            LongRangeSet longRangeSet = result;
            if (longRangeSet == null) {
                RangeSet.$$$reportNull$$$0(15);
            }
            return longRangeSet;
        }

        @Override
        @NotNull
        public LongRangeSet negate(boolean isLong) {
            LongRangeSet result = RangeSet.empty();
            for (int i = 0; i < this.myRanges.length; i += 2) {
                result = result.unite(RangeSet.range(this.myRanges[i], this.myRanges[i + 1]).negate(isLong));
            }
            LongRangeSet longRangeSet = result;
            if (longRangeSet == null) {
                RangeSet.$$$reportNull$$$0(16);
            }
            return longRangeSet;
        }

        @Override
        @NotNull
        public LongRangeSet plus(LongRangeSet other, boolean isLong) {
            if (this.myRanges.length > 6) {
                LongRangeSet longRangeSet = RangeSet.range(this.min(), this.max()).plus(other, isLong);
                if (longRangeSet == null) {
                    RangeSet.$$$reportNull$$$0(17);
                }
                return longRangeSet;
            }
            LongRangeSet result = RangeSet.empty();
            for (int i = 0; i < this.myRanges.length; i += 2) {
                result = result.unite(RangeSet.range(this.myRanges[i], this.myRanges[i + 1]).plus(other, isLong));
            }
            LongRangeSet longRangeSet = result;
            if (longRangeSet == null) {
                RangeSet.$$$reportNull$$$0(18);
            }
            return longRangeSet;
        }

        @Override
        public LongRangeSet mul(LongRangeSet multiplier, boolean isLong) {
            if (multiplier.isEmpty()) {
                return multiplier;
            }
            if (multiplier instanceof Point) {
                return multiplier.mul(this, isLong);
            }
            return isLong ? Range.LONG_RANGE : Range.INT_RANGE;
        }

        @Override
        @NotNull
        public LongRangeSet mod(LongRangeSet divisor) {
            if (divisor.isEmpty()) {
                LongRangeSet longRangeSet = RangeSet.empty();
                if (longRangeSet == null) {
                    RangeSet.$$$reportNull$$$0(19);
                }
                return longRangeSet;
            }
            LongRangeSet result = RangeSet.empty();
            for (int i = 0; i < this.myRanges.length; i += 2) {
                result = result.unite(RangeSet.range(this.myRanges[i], this.myRanges[i + 1]).mod(divisor));
            }
            LongRangeSet longRangeSet = result;
            if (longRangeSet == null) {
                RangeSet.$$$reportNull$$$0(20);
            }
            return longRangeSet;
        }

        @Override
        public LongStream stream() {
            return IntStream.range(0, this.myRanges.length / 2).mapToObj(idx -> LongStream.rangeClosed(this.myRanges[idx * 2], this.myRanges[idx * 2 + 1])).reduce(LongStream::concat).orElseGet(LongStream::empty);
        }

        @Override
        long[] asRanges() {
            return this.myRanges;
        }

        public int hashCode() {
            return Arrays.hashCode(this.myRanges);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            return o instanceof RangeSet && Arrays.equals(this.myRanges, ((RangeSet)o).myRanges);
        }

        public String toString() {
            StringJoiner sb = new StringJoiner(", ", "{", "}");
            for (int i = 0; i < this.myRanges.length; i += 2) {
                sb.add(LongRangeSet.toString(this.myRanges[i], this.myRanges[i + 1]));
            }
            return sb.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "other";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/rangeSet/LongRangeSet$RangeSet";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/rangeSet/LongRangeSet$RangeSet";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "subtract";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "intersect";
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "unite";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "abs";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "negate";
                    break;
                }
                case 17: 
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[1] = "plus";
                    break;
                }
                case 19: 
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[1] = "mod";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "subtract";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "intersect";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "unite";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static final class ModRange
    extends Range {
        private final int myMod;
        private final long myBits;

        ModRange(long from, long to, int mod, long bits) {
            super(from, to);
            assert (mod > 1 && mod <= 64);
            this.myMod = mod;
            this.myBits = bits;
            assert ((bits & (this.getMask() ^ 0xFFFFFFFFFFFFFFFFL)) == 0L) : "bits outside of mask should be zero";
            assert (bits != this.getMask()) : "at least one bit in mask should be zero, otherwise simple Range could be used";
        }

        @Override
        public String getPresentationText(PsiType type2) {
            LongRangeSet set = ModRange.fromType(type2);
            if (set != null) {
                set = ModRange.modRange(set.min(), set.max(), this.myMod, this.myBits);
                String prefix = null;
                if (set.min() == this.myFrom) {
                    prefix = set.max() == this.myTo ? "" : "<= " + LongRangeSet.formatNumber(this.myTo) + "; ";
                } else if (set.max() == this.myTo) {
                    prefix = ">= " + LongRangeSet.formatNumber(this.myFrom) + "; ";
                }
                if (prefix != null) {
                    return prefix + this.getSuffix();
                }
            }
            return "in " + super.toString() + "; " + this.getSuffix();
        }

        @Override
        public boolean isCardinalityBigger(long cutoff) {
            long bottom = this.myFrom - 1L - (long)LongRangeUtil.remainder(this.myFrom - 1L, this.myMod) + (long)this.myMod;
            long top = this.myTo - (long)LongRangeUtil.remainder(this.myTo, this.myMod);
            if (bottom >= this.myFrom && top > bottom && this.myTo >= top) {
                long i;
                int count = Long.bitCount(this.myBits);
                long wholeCount = (top / (long)this.myMod - bottom / (long)this.myMod) * (long)count;
                if (wholeCount < 0L || wholeCount > cutoff) {
                    return true;
                }
                for (i = this.myFrom; i < bottom; ++i) {
                    if (!LongRangeUtil.isSet(this.myBits, LongRangeUtil.remainder(i, this.myMod))) continue;
                    ++wholeCount;
                }
                for (i = top; i <= this.myTo; ++i) {
                    if (!LongRangeUtil.isSet(this.myBits, LongRangeUtil.remainder(i, this.myMod))) continue;
                    ++wholeCount;
                }
                return wholeCount < 0L || wholeCount > cutoff;
            }
            return this.stream().limit(Math.max(0L, cutoff + 1L)).count() > cutoff;
        }

        @Override
        public boolean contains(long value2) {
            return super.contains(value2) && LongRangeUtil.isSet(this.myBits, LongRangeUtil.remainder(value2, this.myMod));
        }

        @Override
        @NotNull
        public LongRangeSet intersect(@NotNull LongRangeSet other) {
            LongRangeSet intersection;
            if (other == null) {
                ModRange.$$$reportNull$$$0(0);
            }
            if ((intersection = super.intersect(other)) instanceof Range || intersection instanceof Point) {
                long bits = this.myBits;
                int mod = this.myMod;
                if (other instanceof ModRange) {
                    ModRange modRange = (ModRange)other;
                    int lcm = this.lcm(modRange.myMod);
                    if (lcm <= 64) {
                        bits = this.widenBits(lcm) & modRange.widenBits(lcm);
                        mod = (byte)lcm;
                    } else if (modRange.myMod > this.myMod) {
                        bits = modRange.myBits;
                        mod = modRange.myMod;
                    }
                }
                LongRangeSet longRangeSet = ModRange.modRange(intersection.min(), intersection.max(), mod, bits);
                if (longRangeSet == null) {
                    ModRange.$$$reportNull$$$0(1);
                }
                return longRangeSet;
            }
            if (intersection instanceof RangeSet) {
                long min = intersection.min();
                long max = intersection.max();
                long diff = max - min;
                if (diff > 0L && diff < 64L) {
                    for (byte newMod = (byte)(diff + 1L); newMod <= 64; newMod = (byte)(newMod + 1)) {
                        if (newMod % this.myMod != 0) continue;
                        long bits = this.widenBits(newMod);
                        for (long pos = min; pos <= max; ++pos) {
                            int bit = LongRangeUtil.remainder(pos, newMod);
                            if (!LongRangeUtil.isSet(bits, bit) || intersection.contains(pos)) continue;
                            bits = LongRangeUtil.clearBit(bits, bit);
                        }
                        LongRangeSet longRangeSet = ModRange.modRange(min, max, newMod, bits);
                        if (longRangeSet == null) {
                            ModRange.$$$reportNull$$$0(2);
                        }
                        return longRangeSet;
                    }
                }
            }
            LongRangeSet longRangeSet = intersection;
            if (longRangeSet == null) {
                ModRange.$$$reportNull$$$0(3);
            }
            return longRangeSet;
        }

        @Override
        public boolean intersects(LongRangeSet other) {
            if (other instanceof Point) {
                return this.contains(((Point)other).myValue);
            }
            if (other instanceof ModRange) {
                ModRange modRange = (ModRange)other;
                int lcm = this.lcm(modRange.myMod);
                if (lcm <= 64 && (modRange.widenBits(lcm) & this.widenBits(lcm)) == 0L) {
                    return false;
                }
            }
            long[] otherRanges = other.asRanges();
            for (int i = 0; i < otherRanges.length && otherRanges[i] <= this.myTo; i += 2) {
                if (this.myTo < otherRanges[i] || this.myFrom > otherRanges[i + 1] || ModRange.modRange(otherRanges[i], otherRanges[i + 1], this.myMod, this.myBits).isEmpty()) continue;
                return true;
            }
            return false;
        }

        @Override
        @NotNull
        public LongRangeSet unite(@NotNull LongRangeSet other) {
            if (other == null) {
                ModRange.$$$reportNull$$$0(4);
            }
            if (other instanceof ModRange) {
                ModRange modRange = (ModRange)other;
                int lcm = this.lcm(modRange.myMod);
                if (lcm <= 64) {
                    long bits = this.widenBits(lcm) | modRange.widenBits(lcm);
                    if (this.myTo >= modRange.myFrom && this.myFrom <= modRange.myTo || this.myTo < modRange.myFrom && ModRange.modRange(this.myTo + 1L, modRange.myFrom - 1L, lcm, bits).isEmpty() || modRange.myTo < this.myFrom && ModRange.modRange(modRange.myTo + 1L, this.myFrom - 1L, lcm, bits).isEmpty()) {
                        LongRangeSet longRangeSet = ModRange.modRange(Math.min(this.myFrom, modRange.myFrom), Math.max(this.myTo, modRange.myTo), lcm, bits);
                        if (longRangeSet == null) {
                            ModRange.$$$reportNull$$$0(5);
                        }
                        return longRangeSet;
                    }
                }
            }
            if (other instanceof Point) {
                long val = ((Point)other).myValue;
                if (LongRangeUtil.isSet(this.myBits, LongRangeUtil.remainder(val, this.myMod))) {
                    if (val >= this.myFrom && val <= this.myTo) {
                        ModRange modRange = this;
                        if (modRange == null) {
                            ModRange.$$$reportNull$$$0(6);
                        }
                        return modRange;
                    }
                    if (val < this.myFrom && ModRange.modRange(val + 1L, this.myFrom - 1L, this.myMod, this.myBits).isEmpty() || val > this.myTo && ModRange.modRange(this.myTo + 1L, val - 1L, this.myMod, this.myBits).isEmpty()) {
                        LongRangeSet longRangeSet = ModRange.modRange(Math.min(this.myFrom, val), Math.max(this.myTo, val), this.myMod, this.myBits);
                        if (longRangeSet == null) {
                            ModRange.$$$reportNull$$$0(7);
                        }
                        return longRangeSet;
                    }
                }
                LongRangeSet longRangeSet = other.unite(ModRange.range(this.myFrom, this.myTo));
                if (longRangeSet == null) {
                    ModRange.$$$reportNull$$$0(8);
                }
                return longRangeSet;
            }
            LongRangeSet longRangeSet = super.unite(other);
            if (longRangeSet == null) {
                ModRange.$$$reportNull$$$0(9);
            }
            return longRangeSet;
        }

        @Override
        public boolean contains(LongRangeSet other) {
            if (other instanceof ModRange) {
                ModRange modRange = (ModRange)other;
                if (modRange.myFrom < this.myFrom || modRange.myTo > this.myTo) {
                    return false;
                }
                int lcm = this.lcm(modRange.myMod);
                if (lcm <= 64) {
                    return ((this.widenBits(lcm) ^ 0xFFFFFFFFFFFFFFFFL) & modRange.widenBits(lcm)) == 0L;
                }
            }
            long[] ranges2 = other.asRanges();
            for (int i = 0; i < ranges2.length; i += 2) {
                if (this.contains(ranges2[i], ranges2[i + 1])) continue;
                return false;
            }
            return true;
        }

        @Override
        @NotNull
        public LongRangeSet negate(boolean isLong) {
            LongRangeSet negated = super.negate(isLong);
            if (negated instanceof Range) {
                long negatedBits = Long.reverse(this.myBits & 0xFFFFFFFFFFFFFFFEL) >>> 64 - this.myMod - 1 | this.myBits & 1L;
                LongRangeSet longRangeSet = ModRange.modRange(negated.min(), negated.max(), this.myMod, negatedBits);
                if (longRangeSet == null) {
                    ModRange.$$$reportNull$$$0(10);
                }
                return longRangeSet;
            }
            LongRangeSet longRangeSet = negated;
            if (longRangeSet == null) {
                ModRange.$$$reportNull$$$0(11);
            }
            return longRangeSet;
        }

        @Override
        @NotNull
        public LongRangeSet plus(LongRangeSet other, boolean isLong) {
            LongRangeSet set = super.plus(other, isLong);
            if (other instanceof Point || other instanceof ModRange && ((ModRange)other).myMod == this.myMod && Long.bitCount(((ModRange)other).myBits) == 1) {
                long[] ranges2 = set.asRanges();
                LongRangeSet result = ModRange.empty();
                for (int i = 0; i < ranges2.length; i += 2) {
                    result = result.unite(this.plus(ranges2[i], ranges2[i + 1], other, isLong));
                }
                LongRangeSet longRangeSet = result;
                if (longRangeSet == null) {
                    ModRange.$$$reportNull$$$0(12);
                }
                return longRangeSet;
            }
            LongRangeSet longRangeSet = set;
            if (longRangeSet == null) {
                ModRange.$$$reportNull$$$0(13);
            }
            return longRangeSet;
        }

        private LongRangeSet plus(long min, long max, LongRangeSet other, boolean isLong) {
            if (Integer.bitCount(this.myMod) == 1 || !this.subtractionMayOverflow(other.negate(isLong), isLong)) {
                int bit = other instanceof Point ? LongRangeUtil.remainder(((Point)other).myValue, this.myMod) : Long.numberOfTrailingZeros(((ModRange)other).myBits);
                long bits = LongRangeUtil.rotateRemainders(this.myBits, this.myMod, this.myMod - bit);
                return ModRange.modRange(min, max, this.myMod, bits);
            }
            return ModRange.range(min, max);
        }

        @Override
        @NotNull
        public LongRangeSet mod(LongRangeSet divisor) {
            int divisorValue;
            int lcm;
            if (divisor instanceof Point && ((Point)divisor).myValue > 1L && ((Point)divisor).myValue <= 64L && (lcm = this.lcm(divisorValue = (int)((Point)divisor).myValue)) <= 64) {
                long from = Math.min(0L, Math.max(this.myFrom, (long)(-divisorValue + 1)));
                long to = Math.max(0L, Math.min(this.myTo, (long)(divisorValue - 1)));
                long possibleMods = this.widenBits(lcm);
                while (64 - Long.numberOfLeadingZeros(possibleMods) > divisorValue) {
                    possibleMods = LongRangeUtil.extractBits(possibleMods, divisorValue, 64) | LongRangeUtil.extractBits(possibleMods, 0, divisorValue);
                }
                LongRangeSet longRangeSet = ModRange.modRange(from, to, divisorValue, possibleMods);
                if (longRangeSet == null) {
                    ModRange.$$$reportNull$$$0(14);
                }
                return longRangeSet;
            }
            LongRangeSet longRangeSet = ModRange.range(this.myFrom, this.myTo).mod(divisor);
            if (longRangeSet == null) {
                ModRange.$$$reportNull$$$0(15);
            }
            return longRangeSet;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass() || !super.equals(o)) {
                return false;
            }
            return this.myMod == ((ModRange)o).myMod && this.myBits == ((ModRange)o).myBits;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.myMod, this.myBits);
        }

        @Override
        public String toString() {
            return super.toString() + ": " + this.getSuffix();
        }

        private String getSuffix() {
            String suffix = this.myMod == 2 ? (this.myBits == 1L ? "even" : "odd") : (this.myBits == 1L ? "divisible by " + this.myMod : IntStreamEx.of((BitSet)BitSet.valueOf(new long[]{this.myBits})).joining((CharSequence)", ", (CharSequence)"<", (CharSequence)("> mod " + this.myMod)));
            return suffix;
        }

        @Override
        public LongStream stream() {
            return super.stream().filter(this::contains);
        }

        private boolean contains(long from, long to) {
            int toBit;
            if (from < this.myFrom || to > this.myTo) {
                return false;
            }
            if (to == from) {
                return this.contains(from);
            }
            if (to - from < 0L || to - from >= (long)this.myMod) {
                return false;
            }
            int fromBit = LongRangeUtil.remainder(from, this.myMod);
            if (fromBit < (toBit = LongRangeUtil.remainder(to, this.myMod))) {
                return Long.numberOfTrailingZeros(this.myBits >>> fromBit ^ 0xFFFFFFFFFFFFFFFFL) > toBit - fromBit;
            }
            return Long.numberOfTrailingZeros(this.myBits ^ 0xFFFFFFFFFFFFFFFFL) > toBit && 64 - Long.numberOfLeadingZeros((this.myBits ^ 0xFFFFFFFFFFFFFFFFL) & this.getMask()) <= fromBit;
        }

        private long widenBits(int targetMod) {
            assert (targetMod <= 64 && targetMod % this.myMod == 0);
            long result = this.myBits;
            for (int shift = targetMod - this.myMod; shift > 0; shift -= this.myMod) {
                result |= this.myBits << shift;
            }
            return result;
        }

        @Override
        LongRangeUtil.BitString getBitwiseMask() {
            int knownBits = Long.numberOfTrailingZeros(this.myMod);
            int powerOfTwo = 1 << knownBits;
            long result = -1L;
            long mask = powerOfTwo - 1;
            for (int rem = 0; rem < this.myMod; ++rem) {
                if (!LongRangeUtil.isSet(this.myBits, rem)) continue;
                int setBits = rem % powerOfTwo;
                if (result != -1L) {
                    long diffBits = result ^ (long)setBits;
                    mask &= diffBits ^ 0xFFFFFFFFFFFFFFFFL;
                }
                result = setBits;
            }
            LongRangeUtil.BitString intersection = new LongRangeUtil.BitString(result, mask).intersect(super.getBitwiseMask());
            assert (intersection != null);
            return intersection;
        }

        private long getMask() {
            return -1L >>> 64 - this.myMod;
        }

        private int lcm(int otherMod) {
            return this.myMod * otherMod / LongRangeUtil.gcd(this.myMod, otherMod);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "other";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/rangeSet/LongRangeSet$ModRange";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/rangeSet/LongRangeSet$ModRange";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "intersect";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "unite";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "negate";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "plus";
                    break;
                }
                case 14: 
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "mod";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "intersect";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "unite";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class Range
    extends LongRangeSet {
        static final Range BYTE_RANGE = new Range(-128L, 127L);
        static final Range CHAR_RANGE = new Range(0L, 65535L);
        static final Range SHORT_RANGE = new Range(-32768L, 32767L);
        static final Range INT_RANGE = new Range(Integer.MIN_VALUE, Integer.MAX_VALUE);
        static final Range LONG_RANGE = new Range(Long.MIN_VALUE, Long.MAX_VALUE);
        static final Range INDEX_RANGE = new Range(0L, Integer.MAX_VALUE);
        final long myFrom;
        final long myTo;

        Range(long from, long to) {
            if (to <= from) {
                throw new IllegalArgumentException(to + "<=" + from);
            }
            this.myFrom = from;
            this.myTo = to;
        }

        @Override
        public String getPresentationText(PsiType type2) {
            LongRangeSet set = Range.fromType(type2);
            if (set != null) {
                if (set.min() == this.myFrom) {
                    if (set.max() == this.myTo) {
                        return "any value";
                    }
                    return "<= " + LongRangeSet.formatNumber(this.myTo);
                }
                if (set.max() == this.myTo) {
                    return ">= " + LongRangeSet.formatNumber(this.myFrom);
                }
            }
            if (this.myTo - this.myFrom == 1L) {
                return this.myFrom + " or " + this.myTo;
            }
            return "in " + this.toString();
        }

        @Override
        public boolean isCardinalityBigger(long cutoff) {
            long diff = this.myTo - this.myFrom;
            return diff < 0L || diff >= cutoff;
        }

        @Override
        @NotNull
        public LongRangeSet subtract(@NotNull LongRangeSet other) {
            if (other == null) {
                Range.$$$reportNull$$$0(0);
            }
            if (other.isEmpty()) {
                Range range = this;
                if (range == null) {
                    Range.$$$reportNull$$$0(1);
                }
                return range;
            }
            if (other == this) {
                LongRangeSet longRangeSet = Empty.EMPTY;
                if (longRangeSet == null) {
                    Range.$$$reportNull$$$0(2);
                }
                return longRangeSet;
            }
            if (other instanceof Point) {
                long value2 = ((Point)other).myValue;
                if (value2 < this.myFrom || value2 > this.myTo) {
                    Range range = this;
                    if (range == null) {
                        Range.$$$reportNull$$$0(3);
                    }
                    return range;
                }
                if (value2 == this.myFrom) {
                    LongRangeSet longRangeSet = Range.range(this.myFrom + 1L, this.myTo);
                    if (longRangeSet == null) {
                        Range.$$$reportNull$$$0(4);
                    }
                    return longRangeSet;
                }
                if (value2 == this.myTo) {
                    LongRangeSet longRangeSet = Range.range(this.myFrom, this.myTo - 1L);
                    if (longRangeSet == null) {
                        Range.$$$reportNull$$$0(5);
                    }
                    return longRangeSet;
                }
                return new RangeSet(new long[]{this.myFrom, value2 - 1L, value2 + 1L, this.myTo});
            }
            if (other instanceof Range) {
                long from = ((Range)other).myFrom;
                long to = ((Range)other).myTo;
                if (to < this.myFrom || from > this.myTo) {
                    Range range = this;
                    if (range == null) {
                        Range.$$$reportNull$$$0(6);
                    }
                    return range;
                }
                if (from <= this.myFrom && to >= this.myTo) {
                    LongRangeSet longRangeSet = Empty.EMPTY;
                    if (longRangeSet == null) {
                        Range.$$$reportNull$$$0(7);
                    }
                    return longRangeSet;
                }
                if (from > this.myFrom && to < this.myTo) {
                    return new RangeSet(new long[]{this.myFrom, from - 1L, to + 1L, this.myTo});
                }
                if (from <= this.myFrom) {
                    LongRangeSet longRangeSet = Range.range(to + 1L, this.myTo);
                    if (longRangeSet == null) {
                        Range.$$$reportNull$$$0(8);
                    }
                    return longRangeSet;
                }
                assert (to >= this.myTo);
                LongRangeSet longRangeSet = Range.range(this.myFrom, from - 1L);
                if (longRangeSet == null) {
                    Range.$$$reportNull$$$0(9);
                }
                return longRangeSet;
            }
            long[] ranges2 = ((RangeSet)other).myRanges;
            LongRangeSet result = this;
            for (int i = 0; i < ranges2.length; i += 2) {
                if (!(result = result.subtract(Range.range(ranges2[i], ranges2[i + 1]))).isEmpty()) continue;
                LongRangeSet longRangeSet = result;
                if (longRangeSet == null) {
                    Range.$$$reportNull$$$0(10);
                }
                return longRangeSet;
            }
            Range range = result;
            if (range == null) {
                Range.$$$reportNull$$$0(11);
            }
            return range;
        }

        @Override
        @NotNull
        public LongRangeSet intersect(@NotNull LongRangeSet other) {
            if (other == null) {
                Range.$$$reportNull$$$0(12);
            }
            if (other == this) {
                Range range = this;
                if (range == null) {
                    Range.$$$reportNull$$$0(13);
                }
                return range;
            }
            if (other.isEmpty()) {
                LongRangeSet longRangeSet = other;
                if (longRangeSet == null) {
                    Range.$$$reportNull$$$0(14);
                }
                return longRangeSet;
            }
            if (other instanceof ModRange && !(this instanceof ModRange) || other instanceof Point) {
                LongRangeSet longRangeSet = other.intersect(this);
                if (longRangeSet == null) {
                    Range.$$$reportNull$$$0(15);
                }
                return longRangeSet;
            }
            if (other instanceof Range) {
                long from = ((Range)other).myFrom;
                long to = ((Range)other).myTo;
                if (from <= this.myFrom && to >= this.myTo) {
                    Range range = this;
                    if (range == null) {
                        Range.$$$reportNull$$$0(16);
                    }
                    return range;
                }
                if (from >= this.myFrom && to <= this.myTo) {
                    LongRangeSet longRangeSet = other;
                    if (longRangeSet == null) {
                        Range.$$$reportNull$$$0(17);
                    }
                    return longRangeSet;
                }
                if (from < this.myFrom) {
                    from = this.myFrom;
                }
                if (to > this.myTo) {
                    to = this.myTo;
                }
                LongRangeSet longRangeSet = from <= to ? Range.range(from, to) : Empty.EMPTY;
                if (longRangeSet == null) {
                    Range.$$$reportNull$$$0(18);
                }
                return longRangeSet;
            }
            long[] ranges2 = ((RangeSet)other).myRanges;
            long[] result = new long[ranges2.length];
            int index = 0;
            for (int i = 0; i < ranges2.length; i += 2) {
                long[] res = this.intersect(Range.range(ranges2[i], ranges2[i + 1])).asRanges();
                System.arraycopy(res, 0, result, index, res.length);
                index += res.length;
            }
            LongRangeSet longRangeSet = Range.fromRanges(result, index);
            if (longRangeSet == null) {
                Range.$$$reportNull$$$0(19);
            }
            return longRangeSet;
        }

        @Override
        @NotNull
        public LongRangeSet unite(@NotNull LongRangeSet other) {
            int maxIndex;
            if (other == null) {
                Range.$$$reportNull$$$0(20);
            }
            if (other.isEmpty() || other == this) {
                Range range = this;
                if (range == null) {
                    Range.$$$reportNull$$$0(21);
                }
                return range;
            }
            if (other instanceof Point) {
                LongRangeSet longRangeSet = other.unite(this);
                if (longRangeSet == null) {
                    Range.$$$reportNull$$$0(22);
                }
                return longRangeSet;
            }
            if (other instanceof Range) {
                if (other.min() <= this.max() && this.min() <= other.max() || other.max() < this.min() && other.max() + 1L == this.min() || other.min() > this.max() && this.max() + 1L == other.min()) {
                    LongRangeSet longRangeSet = Range.range(Math.min(this.min(), other.min()), Math.max(this.max(), other.max()));
                    if (longRangeSet == null) {
                        Range.$$$reportNull$$$0(23);
                    }
                    return longRangeSet;
                }
                if (other.max() < this.min()) {
                    return new RangeSet(new long[]{other.min(), other.max(), this.min(), this.max()});
                }
                return new RangeSet(new long[]{this.min(), this.max(), other.min(), other.max()});
            }
            long[] longs = other.asRanges();
            int minIndex = Arrays.binarySearch(longs, this.min());
            if (minIndex < 0) {
                if ((minIndex = -minIndex - 1) % 2 == 0 && minIndex > 0 && longs[minIndex - 1] + 1L == this.min()) {
                    --minIndex;
                }
            } else if (minIndex % 2 == 0) {
                ++minIndex;
            }
            if ((maxIndex = Arrays.binarySearch(longs, this.max())) < 0) {
                if ((maxIndex = -maxIndex - 1) % 2 == 0 && maxIndex < longs.length && this.max() + 1L == longs[maxIndex]) {
                    ++maxIndex;
                }
            } else if (maxIndex % 2 == 0) {
                ++maxIndex;
            }
            long[] result = new long[longs.length + 2];
            System.arraycopy(longs, 0, result, 0, minIndex);
            int pos = minIndex;
            if (minIndex % 2 == 0) {
                result[pos++] = this.min();
            }
            if (maxIndex % 2 == 0) {
                result[pos++] = this.max();
            }
            System.arraycopy(longs, maxIndex, result, pos, longs.length - maxIndex);
            LongRangeSet longRangeSet = Range.fromRanges(result, longs.length + pos - maxIndex);
            if (longRangeSet == null) {
                Range.$$$reportNull$$$0(24);
            }
            return longRangeSet;
        }

        @Override
        public long min() {
            return this.myFrom;
        }

        @Override
        public long max() {
            return this.myTo;
        }

        @Override
        public boolean intersects(LongRangeSet other) {
            if (other.isEmpty()) {
                return false;
            }
            if (other instanceof RangeSet) {
                long[] otherRanges = ((RangeSet)other).myRanges;
                for (int i = 0; i < otherRanges.length && otherRanges[i] <= this.myTo; i += 2) {
                    if (this.myTo < otherRanges[i] || this.myFrom > otherRanges[i + 1]) continue;
                    return true;
                }
                return false;
            }
            return this.myTo >= other.min() && this.myFrom <= other.max();
        }

        @Override
        public boolean contains(long value2) {
            return this.myFrom <= value2 && this.myTo >= value2;
        }

        @Override
        public boolean contains(LongRangeSet other) {
            return other.isEmpty() || other.min() >= this.myFrom && other.max() <= this.myTo;
        }

        @Override
        public LongRangeSet castTo(PsiPrimitiveType type2) {
            if (PsiType.LONG.equals((Object)type2)) {
                return this;
            }
            if (PsiType.BYTE.equals((Object)type2)) {
                LongRangeSet result = this.mask(8, type2);
                assert (BYTE_RANGE.contains(result)) : this;
                return result;
            }
            if (PsiType.SHORT.equals((Object)type2)) {
                LongRangeSet result = this.mask(16, type2);
                assert (SHORT_RANGE.contains(result)) : this;
                return result;
            }
            if (PsiType.INT.equals((Object)type2)) {
                LongRangeSet result = this.mask(32, type2);
                assert (INT_RANGE.contains(result)) : this;
                return result;
            }
            if (PsiType.CHAR.equals((Object)type2)) {
                if (this.myFrom <= 0L && this.myTo >= 65535L) {
                    return CHAR_RANGE;
                }
                if (this.myFrom >= 0L && this.myTo <= 65535L) {
                    return this;
                }
                return this.bitwiseAnd(Range.point(65535L));
            }
            throw new IllegalArgumentException(type2.toString());
        }

        @NotNull
        private LongRangeSet mask(int size, PsiPrimitiveType type2) {
            long addend = 1L << size - 1;
            if (this.myFrom <= -addend && this.myTo >= addend - 1L) {
                LongRangeSet longRangeSet = Objects.requireNonNull(Range.fromType((PsiType)type2));
                if (longRangeSet == null) {
                    Range.$$$reportNull$$$0(25);
                }
                return longRangeSet;
            }
            if (this.myFrom >= -addend && this.myTo <= addend - 1L) {
                Range range = this;
                if (range == null) {
                    Range.$$$reportNull$$$0(26);
                }
                return range;
            }
            long mask = (1L << size) - 1L;
            LongRangeSet longRangeSet = Range.plus(this.myFrom, this.myTo, addend, addend, true).bitwiseAnd(Range.point(mask)).plus(Range.point(-addend), true);
            if (longRangeSet == null) {
                Range.$$$reportNull$$$0(27);
            }
            return longRangeSet;
        }

        @Override
        @NotNull
        public LongRangeSet abs(boolean isLong) {
            if (this.myFrom >= 0L) {
                Range range = this;
                if (range == null) {
                    Range.$$$reportNull$$$0(28);
                }
                return range;
            }
            long minValue = Range.minValue(isLong);
            long low = this.myFrom;
            long hi = this.myTo;
            if (low <= minValue) {
                low = minValue + 1L;
            }
            if (this.myTo <= 0L) {
                hi = -low;
                low = -this.myTo;
            } else {
                hi = Math.max(-low, hi);
                low = 0L;
            }
            if (low > hi) {
                Range range = isLong ? LONG_RANGE : INT_RANGE;
                if (range == null) {
                    Range.$$$reportNull$$$0(29);
                }
                return range;
            }
            if (this.myFrom <= minValue) {
                return new RangeSet(new long[]{minValue, minValue, low, hi});
            }
            return new Range(low, hi);
        }

        @Override
        @NotNull
        public LongRangeSet negate(boolean isLong) {
            long minValue = Range.minValue(isLong);
            if (this.myFrom <= minValue) {
                if (this.myTo >= Range.maxValue(isLong)) {
                    Range range = isLong ? LONG_RANGE : INT_RANGE;
                    if (range == null) {
                        Range.$$$reportNull$$$0(30);
                    }
                    return range;
                }
                return new RangeSet(new long[]{minValue, minValue, -this.myTo, -(minValue + 1L)});
            }
            return new Range(-this.myTo, -this.myFrom);
        }

        @Override
        @NotNull
        public LongRangeSet plus(LongRangeSet other, boolean isLong) {
            if (other.isEmpty()) {
                LongRangeSet longRangeSet = other;
                if (longRangeSet == null) {
                    Range.$$$reportNull$$$0(31);
                }
                return longRangeSet;
            }
            if (isLong && this.equals(LONG_RANGE) || !isLong && this.equals(INT_RANGE)) {
                Range range = this;
                if (range == null) {
                    Range.$$$reportNull$$$0(32);
                }
                return range;
            }
            if (other instanceof Point || other instanceof Range || other instanceof RangeSet && ((RangeSet)other).myRanges.length > 6) {
                return Range.plus(this.myFrom, this.myTo, other.min(), other.max(), isLong);
            }
            long[] ranges2 = other.asRanges();
            LongRangeSet result = Range.empty();
            for (int i = 0; i < ranges2.length; i += 2) {
                result = result.unite(Range.plus(this.myFrom, this.myTo, ranges2[i], ranges2[i + 1], isLong));
            }
            LongRangeSet longRangeSet = result;
            if (longRangeSet == null) {
                Range.$$$reportNull$$$0(33);
            }
            return longRangeSet;
        }

        @Override
        public LongRangeSet mul(LongRangeSet multiplier, boolean isLong) {
            if (multiplier.isEmpty()) {
                return multiplier;
            }
            if (multiplier instanceof Point) {
                return multiplier.mul(this, isLong);
            }
            return isLong ? LONG_RANGE : INT_RANGE;
        }

        @NotNull
        private static LongRangeSet plus(long from1, long to1, long from2, long to2, boolean isLong) {
            long len1 = to1 - from1;
            long len2 = to2 - from2;
            if (len1 < 0L && len2 < 0L || (len1 < 0L || len2 < 0L) && len1 + len2 + 1L >= 0L) {
                Range range = isLong ? LONG_RANGE : INT_RANGE;
                if (range == null) {
                    Range.$$$reportNull$$$0(34);
                }
                return range;
            }
            long from = from1 + from2;
            long to = to1 + to2;
            if (!isLong) {
                if (to - from + 1L >= 0x100000000L) {
                    Range range = INT_RANGE;
                    if (range == null) {
                        Range.$$$reportNull$$$0(35);
                    }
                    return range;
                }
                from = (int)from;
                to = (int)to;
            }
            if (to < from) {
                return new RangeSet(new long[]{Range.minValue(isLong), to, from, Range.maxValue(isLong)});
            }
            LongRangeSet longRangeSet = Range.range(from, to);
            if (longRangeSet == null) {
                Range.$$$reportNull$$$0(36);
            }
            return longRangeSet;
        }

        @Override
        @NotNull
        public LongRangeSet mod(LongRangeSet divisor) {
            long minDivisor;
            if (divisor.isEmpty() || divisor.equals(Point.ZERO)) {
                LongRangeSet longRangeSet = Range.empty();
                if (longRangeSet == null) {
                    Range.$$$reportNull$$$0(37);
                }
                return longRangeSet;
            }
            if (divisor instanceof Point && ((Point)divisor).myValue == Long.MIN_VALUE) {
                LongRangeSet longRangeSet = this.contains(Long.MIN_VALUE) ? this.subtract(divisor).unite(Point.ZERO) : this;
                if (longRangeSet == null) {
                    Range.$$$reportNull$$$0(38);
                }
                return longRangeSet;
            }
            if (divisor.contains(Long.MIN_VALUE)) {
                LongRangeSet longRangeSet = this.possibleMod();
                if (longRangeSet == null) {
                    Range.$$$reportNull$$$0(39);
                }
                return longRangeSet;
            }
            long min = divisor.min();
            long max = divisor.max();
            long maxDivisor = Math.max(Math.abs(min), Math.abs(max));
            long l = min > 0L ? min : (minDivisor = max < 0L ? Math.abs(max) : 0L);
            if (!this.intersects(LongRangeSet.range(Long.MIN_VALUE, -minDivisor)) && !this.intersects(LongRangeSet.range(minDivisor, Long.MAX_VALUE))) {
                Range range = this;
                if (range == null) {
                    Range.$$$reportNull$$$0(40);
                }
                return range;
            }
            LongRangeSet longRangeSet = this.possibleMod().intersect(Range.range(-maxDivisor + 1L, maxDivisor - 1L));
            if (longRangeSet == null) {
                Range.$$$reportNull$$$0(41);
            }
            return longRangeSet;
        }

        private LongRangeSet possibleMod() {
            if (this.contains(0L)) {
                return this;
            }
            if (this.min() > 0L) {
                return Range.range(0L, this.max());
            }
            return Range.range(this.min(), 0L);
        }

        @Override
        public LongStream stream() {
            return LongStream.rangeClosed(this.myFrom, this.myTo);
        }

        @Override
        long[] asRanges() {
            return new long[]{this.myFrom, this.myTo};
        }

        public int hashCode() {
            return Long.hashCode(this.myFrom) * 1337 + Long.hashCode(this.myTo);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            return o != null && o.getClass() == this.getClass() && this.myFrom == ((Range)o).myFrom && this.myTo == ((Range)o).myTo;
        }

        public String toString() {
            return "{" + Range.toString(this.myFrom, this.myTo) + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "other";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/rangeSet/LongRangeSet$Range";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/rangeSet/LongRangeSet$Range";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "subtract";
                    break;
                }
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    objectArray = objectArray2;
                    objectArray2[1] = "intersect";
                    break;
                }
                case 21: 
                case 22: 
                case 23: 
                case 24: {
                    objectArray = objectArray2;
                    objectArray2[1] = "unite";
                    break;
                }
                case 25: 
                case 26: 
                case 27: {
                    objectArray = objectArray2;
                    objectArray2[1] = "mask";
                    break;
                }
                case 28: 
                case 29: {
                    objectArray = objectArray2;
                    objectArray2[1] = "abs";
                    break;
                }
                case 30: {
                    objectArray = objectArray2;
                    objectArray2[1] = "negate";
                    break;
                }
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: {
                    objectArray = objectArray2;
                    objectArray2[1] = "plus";
                    break;
                }
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: {
                    objectArray = objectArray2;
                    objectArray2[1] = "mod";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "subtract";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: {
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "intersect";
                    break;
                }
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "unite";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static final class Point
    extends LongRangeSet {
        static final Point ZERO = new Point(0L);
        static final Point ONE = new Point(1L);
        final long myValue;

        Point(long value2) {
            this.myValue = value2;
        }

        @Override
        public String getPresentationText(PsiType type2) {
            return LongRangeSet.formatNumber(this.myValue);
        }

        @Override
        public boolean isCardinalityBigger(long cutoff) {
            return cutoff < 1L;
        }

        @Override
        @NotNull
        public LongRangeSet subtract(@NotNull LongRangeSet other) {
            if (other == null) {
                Point.$$$reportNull$$$0(0);
            }
            LongRangeSet longRangeSet = other.contains(this.myValue) ? Empty.EMPTY : this;
            if (longRangeSet == null) {
                Point.$$$reportNull$$$0(1);
            }
            return longRangeSet;
        }

        @Override
        @NotNull
        public LongRangeSet intersect(@NotNull LongRangeSet other) {
            if (other == null) {
                Point.$$$reportNull$$$0(2);
            }
            LongRangeSet longRangeSet = other.contains(this.myValue) ? this : Empty.EMPTY;
            if (longRangeSet == null) {
                Point.$$$reportNull$$$0(3);
            }
            return longRangeSet;
        }

        @Override
        public long min() {
            return this.myValue;
        }

        @Override
        public long max() {
            return this.myValue;
        }

        @Override
        public Long getConstantValue() {
            return this.myValue;
        }

        @Override
        @NotNull
        public LongRangeSet unite(@NotNull LongRangeSet other) {
            long[] result;
            boolean touchRight;
            if (other == null) {
                Point.$$$reportNull$$$0(4);
            }
            if (other.isEmpty() || other == this) {
                Point point = this;
                if (point == null) {
                    Point.$$$reportNull$$$0(5);
                }
                return point;
            }
            if (other.contains(this.myValue)) {
                LongRangeSet longRangeSet = other;
                if (longRangeSet == null) {
                    Point.$$$reportNull$$$0(6);
                }
                return longRangeSet;
            }
            if (other instanceof Point) {
                long value2;
                long value1 = Math.min(this.myValue, ((Point)other).myValue);
                return value1 + 1L == (value2 = Math.max(this.myValue, ((Point)other).myValue)) ? Point.range(value1, value2) : new RangeSet(new long[]{value1, value1, value2, value2});
            }
            if (other instanceof ModRange) {
                LongRangeSet longRangeSet = other.unite(this);
                if (longRangeSet == null) {
                    Point.$$$reportNull$$$0(7);
                }
                return longRangeSet;
            }
            if (other instanceof Range) {
                if (this.myValue < other.min()) {
                    return this.myValue + 1L == other.min() ? Point.range(this.myValue, other.max()) : new RangeSet(new long[]{this.myValue, this.myValue, other.min(), other.max()});
                }
                assert (this.myValue > other.max());
                return this.myValue - 1L == other.max() ? Point.range(other.min(), this.myValue) : new RangeSet(new long[]{other.min(), other.max(), this.myValue, this.myValue});
            }
            long[] longs = other.asRanges();
            int pos = -Arrays.binarySearch(longs, this.myValue) - 1;
            assert (pos >= 0 && pos % 2 == 0);
            boolean touchLeft = pos > 0 && longs[pos - 1] + 1L == this.myValue;
            boolean bl = touchRight = pos < longs.length - 1 && this.myValue + 1L == longs[pos];
            if (touchLeft) {
                if (touchRight) {
                    result = new long[longs.length - 2];
                    System.arraycopy(longs, 0, result, 0, pos - 1);
                    System.arraycopy(longs, pos + 1, result, pos - 1, longs.length - pos - 1);
                } else {
                    result = (long[])longs.clone();
                    result[pos - 1] = this.myValue;
                }
            } else if (touchRight) {
                result = (long[])longs.clone();
                result[pos] = this.myValue;
            } else {
                result = new long[longs.length + 2];
                System.arraycopy(longs, 0, result, 0, pos);
                long l = this.myValue;
                result[pos + 1] = l;
                result[pos] = l;
                System.arraycopy(longs, pos, result, pos + 2, longs.length - pos);
            }
            LongRangeSet longRangeSet = Point.fromRanges(result, result.length);
            if (longRangeSet == null) {
                Point.$$$reportNull$$$0(8);
            }
            return longRangeSet;
        }

        @Override
        public boolean intersects(LongRangeSet other) {
            return other.contains(this.myValue);
        }

        @Override
        public boolean contains(long value2) {
            return this.myValue == value2;
        }

        @Override
        public boolean contains(LongRangeSet other) {
            return other.isEmpty() || this.equals(other);
        }

        @Override
        public LongRangeSet castTo(PsiPrimitiveType type2) {
            long newValue;
            if (PsiType.LONG.equals((Object)type2)) {
                return this;
            }
            if (PsiType.CHAR.equals((Object)type2)) {
                newValue = (char)this.myValue;
            } else if (PsiType.INT.equals((Object)type2)) {
                newValue = (int)this.myValue;
            } else if (PsiType.SHORT.equals((Object)type2)) {
                newValue = (short)this.myValue;
            } else if (PsiType.BYTE.equals((Object)type2)) {
                newValue = (byte)this.myValue;
            } else {
                throw new IllegalArgumentException(type2.toString());
            }
            return newValue == this.myValue ? this : Point.point(newValue);
        }

        @Override
        @NotNull
        public LongRangeSet abs(boolean isLong) {
            LongRangeSet longRangeSet = this.myValue >= 0L || this.myValue == Point.minValue(isLong) ? this : Point.point(-this.myValue);
            if (longRangeSet == null) {
                Point.$$$reportNull$$$0(9);
            }
            return longRangeSet;
        }

        @Override
        @NotNull
        public LongRangeSet negate(boolean isLong) {
            LongRangeSet longRangeSet = this.myValue == Point.minValue(isLong) ? this : Point.point(-this.myValue);
            if (longRangeSet == null) {
                Point.$$$reportNull$$$0(10);
            }
            return longRangeSet;
        }

        @Override
        @NotNull
        public LongRangeSet plus(LongRangeSet other, boolean isLong) {
            if (other.isEmpty()) {
                LongRangeSet longRangeSet = other;
                if (longRangeSet == null) {
                    Point.$$$reportNull$$$0(11);
                }
                return longRangeSet;
            }
            if (other instanceof Point) {
                long res = this.myValue + ((Point)other).myValue;
                LongRangeSet longRangeSet = Point.point(isLong ? res : (long)((int)res));
                if (longRangeSet == null) {
                    Point.$$$reportNull$$$0(12);
                }
                return longRangeSet;
            }
            LongRangeSet longRangeSet = other.plus(this, isLong);
            if (longRangeSet == null) {
                Point.$$$reportNull$$$0(13);
            }
            return longRangeSet;
        }

        @Override
        public LongRangeSet mul(LongRangeSet multiplier, boolean isLong) {
            if (multiplier.isEmpty()) {
                return multiplier;
            }
            if (this.myValue == 0L) {
                return this;
            }
            if (this.myValue == 1L) {
                return multiplier;
            }
            if (this.myValue == -1L) {
                return multiplier.negate(isLong);
            }
            if (multiplier instanceof Point) {
                long val = ((Point)multiplier).myValue;
                long res = this.myValue * val;
                return Point.point(isLong ? res : (long)((int)res));
            }
            boolean overflow = false;
            long min = multiplier.min();
            long max = multiplier.max();
            if (isLong) {
                try {
                    min = Math.multiplyExact(min, this.myValue);
                    max = Math.multiplyExact(max, this.myValue);
                }
                catch (ArithmeticException e) {
                    overflow = true;
                }
            } else if ((min *= this.myValue) != (long)((int)min) || (max *= this.myValue) != (long)((int)max)) {
                overflow = true;
            }
            LongRangeSet result = overflow ? (isLong ? Range.LONG_RANGE : Range.INT_RANGE) : (min > max ? Point.range(max, min) : Point.range(min, max));
            long abs = Math.abs(this.myValue);
            if (overflow) {
                abs = Long.lowestOneBit(abs);
            }
            if (abs < 0L || abs > 64L && Long.bitCount(abs) == 1) {
                abs = 64L;
            }
            return Point.modRange(result.min(), result.max(), abs, 1L);
        }

        @Override
        @NotNull
        public LongRangeSet mod(LongRangeSet divisor) {
            long abs;
            if (divisor.isEmpty() || divisor.equals(ZERO)) {
                LongRangeSet longRangeSet = Point.empty();
                if (longRangeSet == null) {
                    Point.$$$reportNull$$$0(14);
                }
                return longRangeSet;
            }
            if (this.myValue == 0L) {
                Point point = this;
                if (point == null) {
                    Point.$$$reportNull$$$0(15);
                }
                return point;
            }
            if (divisor instanceof Point) {
                LongRangeSet longRangeSet = LongRangeSet.point(this.myValue % ((Point)divisor).myValue);
                if (longRangeSet == null) {
                    Point.$$$reportNull$$$0(16);
                }
                return longRangeSet;
            }
            if (this.myValue != Long.MIN_VALUE && !divisor.intersects(LongRangeSet.range(-(abs = Math.abs(this.myValue)), abs))) {
                Point point = this;
                if (point == null) {
                    Point.$$$reportNull$$$0(17);
                }
                return point;
            }
            LongRangeSet addend = Point.empty();
            if (divisor.contains(Long.MIN_VALUE)) {
                divisor = divisor.subtract(Point.point(Long.MIN_VALUE));
                addend = Point.point(this.myValue);
            }
            long max = Math.max(0L, Math.max(Math.abs(divisor.min()), Math.abs(divisor.max())) - 1L);
            if (this.myValue < 0L) {
                LongRangeSet longRangeSet = LongRangeSet.range(Math.max(this.myValue, -max), 0L).unite(addend);
                if (longRangeSet == null) {
                    Point.$$$reportNull$$$0(18);
                }
                return longRangeSet;
            }
            LongRangeSet longRangeSet = LongRangeSet.range(0L, Math.min(this.myValue, max)).unite(addend);
            if (longRangeSet == null) {
                Point.$$$reportNull$$$0(19);
            }
            return longRangeSet;
        }

        @Override
        public LongStream stream() {
            return LongStream.of(this.myValue);
        }

        @Override
        long[] asRanges() {
            return new long[]{this.myValue, this.myValue};
        }

        public int hashCode() {
            return Long.hashCode(this.myValue);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            return o instanceof Point && this.myValue == ((Point)o).myValue;
        }

        public String toString() {
            return "{" + LongRangeSet.formatNumber(this.myValue) + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "other";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/rangeSet/LongRangeSet$Point";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/rangeSet/LongRangeSet$Point";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "subtract";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "intersect";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "unite";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "abs";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "negate";
                    break;
                }
                case 11: 
                case 12: 
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "plus";
                    break;
                }
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    objectArray = objectArray2;
                    objectArray2[1] = "mod";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "subtract";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "intersect";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "unite";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static final class Empty
    extends LongRangeSet {
        static final LongRangeSet EMPTY = new Empty();

        Empty() {
        }

        @Override
        @NotNull
        public LongRangeSet subtract(@NotNull LongRangeSet other) {
            if (other == null) {
                Empty.$$$reportNull$$$0(0);
            }
            Empty empty = this;
            if (empty == null) {
                Empty.$$$reportNull$$$0(1);
            }
            return empty;
        }

        @Override
        @NotNull
        public LongRangeSet intersect(@NotNull LongRangeSet other) {
            if (other == null) {
                Empty.$$$reportNull$$$0(2);
            }
            Empty empty = this;
            if (empty == null) {
                Empty.$$$reportNull$$$0(3);
            }
            return empty;
        }

        @Override
        @NotNull
        public LongRangeSet unite(@NotNull LongRangeSet other) {
            if (other == null) {
                Empty.$$$reportNull$$$0(4);
            }
            LongRangeSet longRangeSet = other;
            if (longRangeSet == null) {
                Empty.$$$reportNull$$$0(5);
            }
            return longRangeSet;
        }

        @Override
        public long min() {
            throw new NoSuchElementException();
        }

        @Override
        public long max() {
            throw new NoSuchElementException();
        }

        @Override
        public boolean intersects(LongRangeSet other) {
            return false;
        }

        @Override
        public boolean contains(long value2) {
            return false;
        }

        @Override
        public boolean contains(LongRangeSet other) {
            return other.isEmpty();
        }

        @Override
        public String getPresentationText(PsiType type2) {
            return "unknown";
        }

        @Override
        public boolean isCardinalityBigger(long cutoff) {
            return cutoff < 0L;
        }

        @Override
        public LongRangeSet castTo(PsiPrimitiveType type2) {
            if (TypeConversionUtil.isIntegralNumberType((PsiType)type2)) {
                return this;
            }
            throw new IllegalArgumentException(type2.toString());
        }

        @Override
        @NotNull
        public LongRangeSet abs(boolean isLong) {
            Empty empty = this;
            if (empty == null) {
                Empty.$$$reportNull$$$0(6);
            }
            return empty;
        }

        @Override
        @NotNull
        public LongRangeSet negate(boolean isLong) {
            Empty empty = this;
            if (empty == null) {
                Empty.$$$reportNull$$$0(7);
            }
            return empty;
        }

        @Override
        @NotNull
        public LongRangeSet plus(LongRangeSet other, boolean isLong) {
            Empty empty = this;
            if (empty == null) {
                Empty.$$$reportNull$$$0(8);
            }
            return empty;
        }

        @Override
        public LongRangeSet mul(LongRangeSet multiplier, boolean isLong) {
            return this;
        }

        @Override
        @NotNull
        public LongRangeSet mod(LongRangeSet divisor) {
            LongRangeSet longRangeSet = Empty.empty();
            if (longRangeSet == null) {
                Empty.$$$reportNull$$$0(9);
            }
            return longRangeSet;
        }

        @Override
        public LongStream stream() {
            return LongStream.empty();
        }

        @Override
        long[] asRanges() {
            return new long[0];
        }

        public int hashCode() {
            return 2154231;
        }

        public boolean equals(Object obj) {
            return obj == this;
        }

        public String toString() {
            return "{}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "other";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/rangeSet/LongRangeSet$Empty";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/rangeSet/LongRangeSet$Empty";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "subtract";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "intersect";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "unite";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "abs";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "negate";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "plus";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "mod";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "subtract";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "intersect";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "unite";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

