/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.types;

import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiType;
import com.intellij.util.ObjectUtils;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DfConstantType<T>
implements DfType {
    private final T myValue;

    DfConstantType(T value2) {
        this.myValue = value2;
    }

    @Override
    public boolean isSuperType(@NotNull DfType other) {
        if (other == null) {
            DfConstantType.$$$reportNull$$$0(0);
        }
        return other.equals(this) || other == DfTypes.BOTTOM;
    }

    @NotNull
    public abstract PsiType getPsiType();

    @Override
    @NotNull
    public DfType meet(@NotNull DfType other) {
        if (other == null) {
            DfConstantType.$$$reportNull$$$0(1);
        }
        DfType dfType = other.isSuperType(this) ? this : DfTypes.BOTTOM;
        if (dfType == null) {
            DfConstantType.$$$reportNull$$$0(2);
        }
        return dfType;
    }

    public T getValue() {
        return this.myValue;
    }

    public int hashCode() {
        return Objects.hashCode(this.myValue);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof DfConstantType && Objects.equals(((DfConstantType)obj).myValue, this.myValue);
    }

    public String toString() {
        return DfConstantType.renderValue(this.myValue);
    }

    public static boolean isConst(@NotNull DfType dfType, @Nullable Object value2) {
        if (dfType == null) {
            DfConstantType.$$$reportNull$$$0(3);
        }
        return dfType instanceof DfConstantType && Objects.equals(((DfConstantType)dfType).getValue(), value2);
    }

    @Nullable
    public static <T> T getConstantOfType(@NotNull DfType dfType, @NotNull Class<T> clazz) {
        if (dfType == null) {
            DfConstantType.$$$reportNull$$$0(4);
        }
        if (clazz == null) {
            DfConstantType.$$$reportNull$$$0(5);
        }
        return (T)(dfType instanceof DfConstantType ? ObjectUtils.tryCast(((DfConstantType)dfType).getValue(), clazz) : null);
    }

    public static String renderValue(Object value2) {
        if (value2 == null) {
            return "null";
        }
        if (value2 instanceof String) {
            return '\"' + StringUtil.escapeStringCharacters((String)((String)value2)) + '\"';
        }
        if (value2 instanceof Float) {
            return value2 + "f";
        }
        if (value2 instanceof Long) {
            return value2 + "L";
        }
        if (value2 instanceof PsiField) {
            PsiField field = (PsiField)value2;
            PsiClass containingClass = field.getContainingClass();
            return containingClass == null ? field.getName() : containingClass.getName() + "." + field.getName();
        }
        return value2.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/types/DfConstantType";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/types/DfConstantType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "meet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSuperType";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "meet";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isConst";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getConstantOfType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

