/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.value;

import com.intellij.codeInspection.dataFlow.types.DfPrimitiveType;
import com.intellij.codeInspection.dataFlow.types.DfReferenceType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiType;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DfaTypeValue
extends DfaValue {
    @NotNull
    private final DfType myType;

    DfaTypeValue(@NotNull DfaValueFactory factory, @NotNull DfType type2) {
        if (factory == null) {
            DfaTypeValue.$$$reportNull$$$0(0);
        }
        if (type2 == null) {
            DfaTypeValue.$$$reportNull$$$0(1);
        }
        super(factory);
        this.myType = type2;
    }

    @Override
    @NotNull
    public DfType getDfType() {
        DfType dfType = this.myType;
        if (dfType == null) {
            DfaTypeValue.$$$reportNull$$$0(2);
        }
        return dfType;
    }

    @Override
    @Nullable
    public PsiType getType() {
        return DfaTypeValue.toPsiType(this.myFactory.getProject(), this.myType);
    }

    public static boolean isUnknown(DfaValue value2) {
        return value2 instanceof DfaTypeValue && value2.getDfType() == DfTypes.TOP;
    }

    public String toString() {
        return this.myType.toString();
    }

    @Contract(value="null -> false")
    public static boolean isContractFail(DfaValue value2) {
        return value2 instanceof DfaTypeValue && value2.getDfType() == DfTypes.FAIL;
    }

    @Nullable
    public static PsiType toPsiType(Project project, DfType dfType) {
        if (dfType instanceof DfPrimitiveType) {
            return ((DfPrimitiveType)dfType).getPsiType();
        }
        if (dfType instanceof DfReferenceType) {
            return ((DfReferenceType)dfType).getConstraint().getPsiType(project);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/value/DfaTypeValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/value/DfaTypeValue";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDfType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class Factory {
        private final DfaValueFactory myFactory;
        private final Map<DfType, DfaTypeValue> myValues = new HashMap<DfType, DfaTypeValue>();

        Factory(DfaValueFactory factory) {
            this.myFactory = factory;
        }

        @NotNull
        DfaTypeValue create(@NotNull DfType type2) {
            if (type2 == null) {
                Factory.$$$reportNull$$$0(0);
            }
            DfaTypeValue dfaTypeValue = this.myValues.computeIfAbsent(type2, t -> new DfaTypeValue(this.myFactory, (DfType)t));
            if (dfaTypeValue == null) {
                Factory.$$$reportNull$$$0(1);
            }
            return dfaTypeValue;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/value/DfaTypeValue$Factory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/value/DfaTypeValue$Factory";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

