/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.deprecation;

import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.deprecation.DeprecationInspectionQuickFixesKt;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\fH\u0016J\b\u0010\u000e\u001a\u00020\fH\u0016J)\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0096\u0002R!\u0010\u0007\u001a\u0015\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00050\u00050\b\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \t*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/codeInspection/deprecation/ReplaceFieldReferenceFix;", "Lcom/intellij/codeInspection/LocalQuickFixOnPsiElement;", "expr", "Lcom/intellij/psi/PsiReferenceExpression;", "replacementField", "Lcom/intellij/psi/PsiField;", "(Lcom/intellij/psi/PsiReferenceExpression;Lcom/intellij/psi/PsiField;)V", "myReplacementMethodPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "myReplacementText", "", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "intellij.java.analysis.impl"})
public final class ReplaceFieldReferenceFix
extends LocalQuickFixOnPsiElement {
    private final SmartPsiElementPointer<PsiField> myReplacementMethodPointer;
    private final String myReplacementText;

    @NotNull
    public String getFamilyName() {
        String string = InspectionGadgetsBundle.message("replace.field.reference.fix.family.name", new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"InspectionGadgetsBundle.\u2026ference.fix.family.name\")");
        return string;
    }

    @NotNull
    public String getText() {
        String string = InspectionGadgetsBundle.message("replace.field.reference.fix.text", this.myReplacementText);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"InspectionGadgetsBundle.\u2026text\", myReplacementText)");
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)startElement, (String)"startElement");
        Intrinsics.checkParameterIsNotNull((Object)endElement, (String)"endElement");
        PsiReferenceExpression psiReferenceExpression = (PsiReferenceExpression)ObjectUtils.tryCast((Object)startElement, PsiReferenceExpression.class);
        if (psiReferenceExpression == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiReferenceExpression, (String)"ObjectUtils.tryCast(star\u2026on::class.java) ?: return");
        PsiReferenceExpression expr2 = psiReferenceExpression;
        PsiField psiField = (PsiField)this.myReplacementMethodPointer.getElement();
        if (psiField == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiField, (String)"myReplacementMethodPointer.element ?: return");
        PsiField replacementField = psiField;
        String qualifierText = DeprecationInspectionQuickFixesKt.access$generateQualifierText(expr2, (PsiMember)replacementField);
        PsiElement replaced = expr2.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText(qualifierText + replacementField.getName(), (PsiElement)expr2));
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(replaced);
    }

    public ReplaceFieldReferenceFix(@NotNull PsiReferenceExpression expr2, @NotNull PsiField replacementField) {
        Intrinsics.checkParameterIsNotNull((Object)expr2, (String)"expr");
        Intrinsics.checkParameterIsNotNull((Object)replacementField, (String)"replacementField");
        super((PsiElement)expr2);
        SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.getInstance((Project)replacementField.getProject()).createSmartPsiElementPointer((PsiElement)replacementField);
        Intrinsics.checkExpressionValueIsNotNull((Object)smartPsiElementPointer, (String)"SmartPointerManager.getI\u2026Pointer(replacementField)");
        this.myReplacementMethodPointer = smartPsiElementPointer;
        this.myReplacementText = PsiFormatUtil.formatVariable((PsiVariable)((PsiVariable)replacementField), (int)4097, (PsiSubstitutor)PsiSubstitutor.EMPTY);
    }
}

