/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.equalsAndHashcode;

import com.intellij.codeInsight.generation.GenerateEqualsHandler;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.equalsAndHashcode.EqualsAndHashcodeBase;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EqualsAndHashcode
extends EqualsAndHashcodeBase {
    @Override
    protected LocalQuickFix[] buildFixes(boolean isOnTheFly, boolean hasEquals) {
        if (!isOnTheFly) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        return new LocalQuickFix[]{new GenerateEqualsHashcodeFix(hasEquals)};
    }

    private static class GenerateEqualsHashcodeFix
    implements LocalQuickFix {
        private final boolean myHasEquals;

        GenerateEqualsHashcodeFix(boolean hasEquals) {
            this.myHasEquals = hasEquals;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.myHasEquals ? JavaBundle.message((String)"inspection.equals.hashcode.generate.hashcode.quickfix", (Object[])new Object[0]) : JavaBundle.message((String)"inspection.equals.hashcode.generate.equals.quickfix", (Object[])new Object[0]);
            if (string == null) {
                GenerateEqualsHashcodeFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            Editor editor;
            if (project == null) {
                GenerateEqualsHashcodeFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                GenerateEqualsHashcodeFix.$$$reportNull$$$0(2);
            }
            if ((editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor()) == null) {
                return;
            }
            PsiElement element = descriptor.getPsiElement();
            new GenerateEqualsHandler().invoke(project, editor, element.getContainingFile());
        }

        @Nullable
        public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
            if (currentFile == null) {
                GenerateEqualsHashcodeFix.$$$reportNull$$$0(3);
            }
            return currentFile;
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/equalsAndHashcode/EqualsAndHashcode$GenerateEqualsHashcodeFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "currentFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/equalsAndHashcode/EqualsAndHashcode$GenerateEqualsHashcodeFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getElementToMakeWritable";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

