/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java19api;

import com.intellij.codeInsight.daemon.impl.analysis.JavaModuleGraphUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.AddUsesDirectiveFix;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.JavaBundle;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiUsesStatement;
import com.intellij.psi.impl.source.resolve.reference.impl.JavaReflectionReferenceUtil;
import org.jetbrains.annotations.NotNull;

public class Java9UndeclaredServiceUsageInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        PsiFile file;
        if (holder == null) {
            Java9UndeclaredServiceUsageInspection.$$$reportNull$$$0(0);
        }
        if ((file = holder.getFile()) instanceof PsiJavaFile && ((PsiJavaFile)file).getLanguageLevel().isAtLeast(LanguageLevel.JDK_1_9)) {
            return new JavaElementVisitor(){

                public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
                    Java9UndeclaredServiceUsageInspection.checkMethodCall(expression2, holder);
                    super.visitMethodCallExpression(expression2);
                }
            };
        }
        PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
        if (psiElementVisitor == null) {
            Java9UndeclaredServiceUsageInspection.$$$reportNull$$$0(1);
        }
        return psiElementVisitor;
    }

    private static void checkMethodCall(@NotNull PsiMethodCallExpression methodCall, @NotNull ProblemsHolder holder) {
        PsiClass containingClass;
        PsiMethod method;
        PsiElement resolved;
        String referenceName;
        if (methodCall == null) {
            Java9UndeclaredServiceUsageInspection.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            Java9UndeclaredServiceUsageInspection.$$$reportNull$$$0(3);
        }
        if (("load".equals(referenceName = methodCall.getMethodExpression().getReferenceName()) || "loadInstalled".equals(referenceName)) && (resolved = methodCall.getMethodExpression().resolve()) instanceof PsiMethod && (method = (PsiMethod)resolved).hasModifierProperty("static") && (containingClass = method.getContainingClass()) != null && "java.util.ServiceLoader".equals(containingClass.getQualifiedName())) {
            Java9UndeclaredServiceUsageInspection.checkServiceUsage(methodCall, holder);
        }
    }

    private static void checkServiceUsage(@NotNull PsiMethodCallExpression methodCall, @NotNull ProblemsHolder holder) {
        PsiJavaModule module;
        String qualifiedName;
        PsiClass psiClass;
        if (methodCall == null) {
            Java9UndeclaredServiceUsageInspection.$$$reportNull$$$0(4);
        }
        if (holder == null) {
            Java9UndeclaredServiceUsageInspection.$$$reportNull$$$0(5);
        }
        PsiExpression[] arguments = methodCall.getArgumentList().getExpressions();
        PsiExpression argument = null;
        JavaReflectionReferenceUtil.ReflectiveType serviceType = null;
        for (int i = 0; i < arguments.length && serviceType == null; ++i) {
            argument = arguments[i];
            serviceType = JavaReflectionReferenceUtil.getReflectiveType(argument);
        }
        if (serviceType != null && serviceType.isExact() && (psiClass = serviceType.getPsiClass()) != null && (qualifiedName = psiClass.getQualifiedName()) != null && (module = JavaModuleGraphUtil.findDescriptorByElement((PsiElement)argument)) != null && Java9UndeclaredServiceUsageInspection.isUndeclaredUsage(module, psiClass)) {
            holder.registerProblem((PsiElement)argument, JavaBundle.message((String)"inspection.undeclared.service.usage.message", (Object[])new Object[]{qualifiedName}), new LocalQuickFix[]{new AddUsesDirectiveFix(module, qualifiedName)});
        }
    }

    private static boolean isUndeclaredUsage(PsiJavaModule module, @NotNull PsiClass serviceClass) {
        if (serviceClass == null) {
            Java9UndeclaredServiceUsageInspection.$$$reportNull$$$0(6);
        }
        for (PsiUsesStatement usesStatement : module.getUses()) {
            PsiClassType usedClass = usesStatement.getClassType();
            if (usedClass == null || !serviceClass.equals(usedClass.resolve())) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/java19api/Java9UndeclaredServiceUsageInspection";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCall";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/java19api/Java9UndeclaredServiceUsageInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkMethodCall";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkServiceUsage";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isUndeclaredUsage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

