/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.optionalToIf;

import com.intellij.codeInspection.optionalToIf.Operation;
import com.intellij.codeInspection.optionalToIf.OptionalToIfContext;
import com.intellij.codeInspection.streamToLoop.ChainVariable;
import com.intellij.codeInspection.streamToLoop.FunctionHelper;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class SourceOperation
implements Operation {
    final PsiType myType;
    final String mySourceName;

    @Contract(pure=true)
    SourceOperation(@NotNull PsiType type2, @Nullable String sourceName) {
        if (type2 == null) {
            SourceOperation.$$$reportNull$$$0(0);
        }
        this.myType = type2;
        this.mySourceName = sourceName;
    }

    @Nullable
    static SourceOperation create(@NotNull String name2, @NotNull PsiType type2, PsiExpression @NotNull [] args) {
        if (name2 == null) {
            SourceOperation.$$$reportNull$$$0(1);
        }
        if (type2 == null) {
            SourceOperation.$$$reportNull$$$0(2);
        }
        if (args == null) {
            SourceOperation.$$$reportNull$$$0(3);
        }
        if ("empty".equals(name2) && args.length == 0) {
            return new Empty(type2);
        }
        if ("of".equals(name2) && args.length == 1) {
            return new Of(type2, args[0]);
        }
        if ("ofNullable".equals(name2) && args.length == 1) {
            return new OfNullable(type2, args[0]);
        }
        return null;
    }

    @Override
    @NotNull
    public ChainVariable getOutVar(@NotNull ChainVariable inVar) {
        if (inVar == null) {
            SourceOperation.$$$reportNull$$$0(4);
        }
        return this.mySourceName == null ? new ChainVariable(this.myType) : new ChainVariable(this.myType, this.mySourceName);
    }

    @Nullable
    private static String getSourceName(@NotNull PsiExpression source) {
        PsiReference reference;
        if (source == null) {
            SourceOperation.$$$reportNull$$$0(5);
        }
        if ((reference = (PsiReference)ObjectUtils.tryCast((Object)source, PsiReference.class)) == null) {
            return null;
        }
        PsiVariable variable = (PsiVariable)ObjectUtils.tryCast((Object)reference.resolve(), PsiVariable.class);
        return variable == null ? null : variable.getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inVar";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/optionalToIf/SourceOperation";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getOutVar";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getSourceName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class Empty
    extends SourceOperation {
        Empty(PsiType type2) {
            super(type2, null);
        }

        @Override
        public void preprocessVariables(@NotNull ChainVariable inVar, @NotNull ChainVariable outVar, @NotNull OptionalToIfContext context) {
            if (inVar == null) {
                Empty.$$$reportNull$$$0(0);
            }
            if (outVar == null) {
                Empty.$$$reportNull$$$0(1);
            }
            if (context == null) {
                Empty.$$$reportNull$$$0(2);
            }
            outVar.addBestNameCandidate("empty");
        }

        @Override
        @Nullable
        public String generate(@NotNull ChainVariable inVar, @NotNull ChainVariable outVar, @NotNull String code, @NotNull OptionalToIfContext context) {
            if (inVar == null) {
                Empty.$$$reportNull$$$0(3);
            }
            if (outVar == null) {
                Empty.$$$reportNull$$$0(4);
            }
            if (code == null) {
                Empty.$$$reportNull$$$0(5);
            }
            if (context == null) {
                Empty.$$$reportNull$$$0(6);
            }
            return outVar.getDeclaration("null") + context.generateNotNullCondition(outVar.getName(), code);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inVar";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outVar";
                    break;
                }
                case 2: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "code";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/optionalToIf/SourceOperation$Empty";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "preprocessVariables";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "generate";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class OfNullable
    extends SourceOperation {
        private PsiExpression myArg;

        @Contract(pure=true)
        OfNullable(PsiType type2, PsiExpression arg) {
            super(type2, SourceOperation.getSourceName(arg));
            this.myArg = arg;
        }

        @Override
        public void rename(@NotNull String oldName, @NotNull String newName, @NotNull OptionalToIfContext context) {
            if (oldName == null) {
                OfNullable.$$$reportNull$$$0(0);
            }
            if (newName == null) {
                OfNullable.$$$reportNull$$$0(1);
            }
            if (context == null) {
                OfNullable.$$$reportNull$$$0(2);
            }
            this.myArg = FunctionHelper.replaceVarReference(this.myArg, oldName, newName, context);
        }

        @Override
        @Nullable
        public String generate(@NotNull ChainVariable inVar, @NotNull ChainVariable outVar, @NotNull String code, @NotNull OptionalToIfContext context) {
            if (inVar == null) {
                OfNullable.$$$reportNull$$$0(3);
            }
            if (outVar == null) {
                OfNullable.$$$reportNull$$$0(4);
            }
            if (code == null) {
                OfNullable.$$$reportNull$$$0(5);
            }
            if (context == null) {
                OfNullable.$$$reportNull$$$0(6);
            }
            if (SourceOperation.getSourceName(this.myArg) != null) {
                return context.generateNotNullCondition(outVar.getName(), code);
            }
            return outVar.getDeclaration(this.myArg.getText()) + context.generateNotNullCondition(outVar.getName(), code);
        }

        @Override
        public void preprocessVariables(@NotNull ChainVariable inVar, @NotNull ChainVariable outVar, @NotNull OptionalToIfContext context) {
            if (inVar == null) {
                OfNullable.$$$reportNull$$$0(7);
            }
            if (outVar == null) {
                OfNullable.$$$reportNull$$$0(8);
            }
            if (context == null) {
                OfNullable.$$$reportNull$$$0(9);
            }
            if (SourceOperation.getSourceName(this.myArg) == null) {
                FunctionHelper.suggestFromExpression(outVar, context.getProject(), this.myArg);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newName";
                    break;
                }
                case 2: 
                case 6: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inVar";
                    break;
                }
                case 4: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outVar";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "code";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/optionalToIf/SourceOperation$OfNullable";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "rename";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "generate";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "preprocessVariables";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class Of
    extends SourceOperation {
        private PsiExpression myArg;

        @Contract(pure=true)
        Of(@NotNull PsiType type2, @NotNull PsiExpression arg) {
            if (type2 == null) {
                Of.$$$reportNull$$$0(0);
            }
            if (arg == null) {
                Of.$$$reportNull$$$0(1);
            }
            super(type2, SourceOperation.getSourceName(arg));
            this.myArg = arg;
        }

        @Override
        public void rename(@NotNull String oldName, @NotNull String newName, @NotNull OptionalToIfContext context) {
            if (oldName == null) {
                Of.$$$reportNull$$$0(2);
            }
            if (newName == null) {
                Of.$$$reportNull$$$0(3);
            }
            if (context == null) {
                Of.$$$reportNull$$$0(4);
            }
            this.myArg = FunctionHelper.replaceVarReference(this.myArg, oldName, newName, context);
        }

        @Override
        @Nullable
        public String generate(@NotNull ChainVariable inVar, @NotNull ChainVariable outVar, @NotNull String code, @NotNull OptionalToIfContext context) {
            if (inVar == null) {
                Of.$$$reportNull$$$0(5);
            }
            if (outVar == null) {
                Of.$$$reportNull$$$0(6);
            }
            if (code == null) {
                Of.$$$reportNull$$$0(7);
            }
            if (context == null) {
                Of.$$$reportNull$$$0(8);
            }
            if (SourceOperation.getSourceName(this.myArg) != null) {
                return "if(" + outVar.getName() + " == null) throw new java.lang.NullPointerException();" + code;
            }
            return outVar.getDeclaration(this.myArg.getText()) + "if(" + outVar.getName() + " == null) throw new java.lang.NullPointerException();" + code;
        }

        @Override
        public void preprocessVariables(@NotNull ChainVariable inVar, @NotNull ChainVariable outVar, @NotNull OptionalToIfContext context) {
            if (inVar == null) {
                Of.$$$reportNull$$$0(9);
            }
            if (outVar == null) {
                Of.$$$reportNull$$$0(10);
            }
            if (context == null) {
                Of.$$$reportNull$$$0(11);
            }
            if (SourceOperation.getSourceName(this.myArg) == null) {
                FunctionHelper.suggestFromExpression(outVar, context.getProject(), this.myArg);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arg";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newName";
                    break;
                }
                case 4: 
                case 8: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 5: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inVar";
                    break;
                }
                case 6: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outVar";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "code";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/optionalToIf/SourceOperation$Of";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "rename";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "generate";
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "preprocessVariables";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

