/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.optionalToIf;

import com.intellij.codeInspection.optionalToIf.Operation;
import com.intellij.codeInspection.optionalToIf.OptionalToIfContext;
import com.intellij.codeInspection.streamToLoop.ChainVariable;
import com.intellij.codeInspection.streamToLoop.FunctionHelper;
import com.intellij.psi.PsiExpression;
import com.siyeh.ig.psiutils.SideEffectChecker;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class TerminalOperation
implements Operation {
    TerminalOperation() {
    }

    @Override
    @NotNull
    public ChainVariable getOutVar(@NotNull ChainVariable inVar) {
        if (inVar == null) {
            TerminalOperation.$$$reportNull$$$0(0);
        }
        ChainVariable chainVariable = inVar;
        if (chainVariable == null) {
            TerminalOperation.$$$reportNull$$$0(1);
        }
        return chainVariable;
    }

    @Nullable
    static TerminalOperation create(String name2, PsiExpression[] args) {
        if ("get".equals(name2) && args.length == 0) {
            return new Get();
        }
        if ("orElse".equals(name2) && args.length == 1) {
            return new OrElse(args[0].getText());
        }
        if ("ifPresentOrElse".equals(name2) && args.length == 2) {
            FunctionHelper ifPresentFn = FunctionHelper.create(args[0], 1);
            if (ifPresentFn == null) {
                return null;
            }
            FunctionHelper orElseFn = FunctionHelper.create(args[1], 0);
            return orElseFn == null ? null : new IfPresentOrElse(ifPresentFn, orElseFn);
        }
        if ("ifPresent".equals(name2) && args.length == 1) {
            FunctionHelper fn = FunctionHelper.create(args[0], 1);
            return fn == null ? null : new IfPresent(fn);
        }
        if (("isPresent".equals(name2) || "isEmpty".equals(name2)) && args.length == 0) {
            return new IsPresent("isEmpty".equals(name2));
        }
        if ("orElseGet".equals(name2) && args.length == 1) {
            FunctionHelper myFn = FunctionHelper.create(args[0], 0);
            return myFn == null ? null : new OrElseGet(myFn);
        }
        if ("orElseThrow".equals(name2)) {
            if (args.length == 0) {
                return new OrElseThrow(null);
            }
            FunctionHelper myFn = args.length == 1 ? FunctionHelper.create(args[0], 0) : null;
            return myFn == null ? null : new OrElseThrow(myFn);
        }
        if ("stream".equals(name2) && args.length == 0) {
            return new Stream();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inVar";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/optionalToIf/TerminalOperation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/optionalToIf/TerminalOperation";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutVar";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getOutVar";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class Stream
    extends TerminalOperation {
        Stream() {
        }

        @Override
        @Nullable
        public String generate(@NotNull ChainVariable inVar, @NotNull ChainVariable outVar, @NotNull String code, @NotNull OptionalToIfContext context) {
            if (inVar == null) {
                Stream.$$$reportNull$$$0(0);
            }
            if (outVar == null) {
                Stream.$$$reportNull$$$0(1);
            }
            if (code == null) {
                Stream.$$$reportNull$$$0(2);
            }
            if (context == null) {
                Stream.$$$reportNull$$$0(3);
            }
            context.setInitializer("java.util.stream.Stream.empty()");
            return context.createResult("java.util.stream.Stream.of(" + outVar.getName() + ")");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "inVar";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "outVar";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "code";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInspection/optionalToIf/TerminalOperation$Stream";
            objectArray[2] = "generate";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class OrElseThrow
    extends TerminalOperation {
        private final FunctionHelper myFn;

        OrElseThrow(FunctionHelper fn) {
            this.myFn = fn;
        }

        @Override
        @Nullable
        public String generate(@NotNull ChainVariable inVar, @NotNull ChainVariable outVar, @NotNull String code, @NotNull OptionalToIfContext context) {
            if (inVar == null) {
                OrElseThrow.$$$reportNull$$$0(0);
            }
            if (outVar == null) {
                OrElseThrow.$$$reportNull$$$0(1);
            }
            if (code == null) {
                OrElseThrow.$$$reportNull$$$0(2);
            }
            if (context == null) {
                OrElseThrow.$$$reportNull$$$0(3);
            }
            if (this.myFn == null) {
                context.setElseBranch("throw new java.util.NoSuchElementException(\"No value present\");");
            } else {
                this.myFn.transform(context, new String[0]);
                context.setElseBranch("throw " + this.myFn.getStatementText());
            }
            return context.createResult(outVar.getName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "inVar";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "outVar";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "code";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInspection/optionalToIf/TerminalOperation$OrElseThrow";
            objectArray[2] = "generate";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class OrElseGet
    extends TerminalOperation {
        private final FunctionHelper myFn;

        OrElseGet(FunctionHelper fn) {
            this.myFn = fn;
        }

        @Override
        @NotNull
        public ChainVariable getOutVar(@NotNull ChainVariable inVar) {
            if (inVar == null) {
                OrElseGet.$$$reportNull$$$0(0);
            }
            return new ChainVariable(inVar.getType());
        }

        @Override
        public void preprocessVariables(@NotNull ChainVariable inVar, @NotNull ChainVariable outVar, @NotNull OptionalToIfContext context) {
            if (inVar == null) {
                OrElseGet.$$$reportNull$$$0(1);
            }
            if (outVar == null) {
                OrElseGet.$$$reportNull$$$0(2);
            }
            if (context == null) {
                OrElseGet.$$$reportNull$$$0(3);
            }
            outVar.addBestNameCandidate("result");
        }

        @Override
        @Nullable
        public String generate(@NotNull ChainVariable inVar, @NotNull ChainVariable outVar, @NotNull String code, @NotNull OptionalToIfContext context) {
            if (inVar == null) {
                OrElseGet.$$$reportNull$$$0(4);
            }
            if (outVar == null) {
                OrElseGet.$$$reportNull$$$0(5);
            }
            if (code == null) {
                OrElseGet.$$$reportNull$$$0(6);
            }
            if (context == null) {
                OrElseGet.$$$reportNull$$$0(7);
            }
            this.myFn.transform(context, new String[0]);
            if (!SideEffectChecker.mayHaveSideEffects(this.myFn.getExpression())) {
                context.setInitializer(this.myFn.getText());
                return context.createResult(inVar.getName());
            }
            context.addBeforeStep(outVar.getDeclaration("null"));
            context.addAfterStep("if (" + outVar.getName() + " == null) {\n" + outVar.getName() + " = " + this.myFn.getStatementText() + "}" + context.createResult(outVar.getName()));
            return outVar.getName() + " = " + inVar.getName() + ";";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inVar";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outVar";
                    break;
                }
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "code";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/optionalToIf/TerminalOperation$OrElseGet";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getOutVar";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "preprocessVariables";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "generate";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class IsPresent
    extends TerminalOperation {
        private final boolean myIsInverted;

        IsPresent(boolean isInverted) {
            this.myIsInverted = isInverted;
        }

        @Override
        @Nullable
        public String generate(@NotNull ChainVariable inVar, @NotNull ChainVariable outVar, @NotNull String code, @NotNull OptionalToIfContext context) {
            if (inVar == null) {
                IsPresent.$$$reportNull$$$0(0);
            }
            if (outVar == null) {
                IsPresent.$$$reportNull$$$0(1);
            }
            if (code == null) {
                IsPresent.$$$reportNull$$$0(2);
            }
            if (context == null) {
                IsPresent.$$$reportNull$$$0(3);
            }
            context.setInitializer(String.valueOf(this.myIsInverted));
            return context.createResult(String.valueOf(!this.myIsInverted));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "inVar";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "outVar";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "code";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInspection/optionalToIf/TerminalOperation$IsPresent";
            objectArray[2] = "generate";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class IfPresentOrElse
    extends TerminalOperation {
        private final FunctionHelper myIfPresentFn;
        private final FunctionHelper myElseFn;

        @Contract(pure=true)
        IfPresentOrElse(FunctionHelper ifPresentFn, FunctionHelper elseFn) {
            this.myIfPresentFn = ifPresentFn;
            this.myElseFn = elseFn;
        }

        @Override
        public void preprocessVariables(@NotNull ChainVariable inVar, @NotNull ChainVariable outVar, @NotNull OptionalToIfContext context) {
            if (inVar == null) {
                IfPresentOrElse.$$$reportNull$$$0(0);
            }
            if (outVar == null) {
                IfPresentOrElse.$$$reportNull$$$0(1);
            }
            if (context == null) {
                IfPresentOrElse.$$$reportNull$$$0(2);
            }
            this.myIfPresentFn.preprocessVariable(context, outVar, 0);
            outVar.addBestNameCandidate("result");
        }

        @Override
        @NotNull
        public ChainVariable getOutVar(@NotNull ChainVariable inVar) {
            if (inVar == null) {
                IfPresentOrElse.$$$reportNull$$$0(3);
            }
            return new ChainVariable(inVar.getType());
        }

        @Override
        @Nullable
        public String generate(@NotNull ChainVariable inVar, @NotNull ChainVariable outVar, @NotNull String code, @NotNull OptionalToIfContext context) {
            if (inVar == null) {
                IfPresentOrElse.$$$reportNull$$$0(4);
            }
            if (outVar == null) {
                IfPresentOrElse.$$$reportNull$$$0(5);
            }
            if (code == null) {
                IfPresentOrElse.$$$reportNull$$$0(6);
            }
            if (context == null) {
                IfPresentOrElse.$$$reportNull$$$0(7);
            }
            this.myElseFn.transform(context, new String[0]);
            this.myIfPresentFn.transform(context, outVar.getName());
            context.addBeforeStep(outVar.getDeclaration("null"));
            context.addAfterStep("if (" + outVar.getName() + " == null) {\n{" + this.myElseFn.getStatementText() + "}}else {\n{" + this.myIfPresentFn.getStatementText() + "}}\n");
            return outVar.getName() + " = " + inVar.getName() + ";";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inVar";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outVar";
                    break;
                }
                case 2: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "code";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/optionalToIf/TerminalOperation$IfPresentOrElse";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "preprocessVariables";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getOutVar";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "generate";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class IfPresent
    extends TerminalOperation {
        private final FunctionHelper myFn;

        IfPresent(FunctionHelper fn) {
            this.myFn = fn;
        }

        @Override
        public void preprocessVariables(@NotNull ChainVariable inVar, @NotNull ChainVariable outVar, @NotNull OptionalToIfContext context) {
            if (inVar == null) {
                IfPresent.$$$reportNull$$$0(0);
            }
            if (outVar == null) {
                IfPresent.$$$reportNull$$$0(1);
            }
            if (context == null) {
                IfPresent.$$$reportNull$$$0(2);
            }
            this.myFn.preprocessVariable(context, inVar, 0);
        }

        @Override
        @Nullable
        public String generate(@NotNull ChainVariable inVar, @NotNull ChainVariable outVar, @NotNull String code, @NotNull OptionalToIfContext context) {
            if (inVar == null) {
                IfPresent.$$$reportNull$$$0(3);
            }
            if (outVar == null) {
                IfPresent.$$$reportNull$$$0(4);
            }
            if (code == null) {
                IfPresent.$$$reportNull$$$0(5);
            }
            if (context == null) {
                IfPresent.$$$reportNull$$$0(6);
            }
            this.myFn.transform(context, inVar.getName());
            return "{\n" + this.myFn.getStatementText() + "}\n";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inVar";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outVar";
                    break;
                }
                case 2: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "code";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/optionalToIf/TerminalOperation$IfPresent";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "preprocessVariables";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "generate";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class OrElse
    extends TerminalOperation {
        private final String myArg;

        @Contract(pure=true)
        OrElse(String arg) {
            this.myArg = arg;
        }

        @Override
        @Nullable
        public String generate(@NotNull ChainVariable inVar, @NotNull ChainVariable outVar, @NotNull String code, @NotNull OptionalToIfContext context) {
            if (inVar == null) {
                OrElse.$$$reportNull$$$0(0);
            }
            if (outVar == null) {
                OrElse.$$$reportNull$$$0(1);
            }
            if (code == null) {
                OrElse.$$$reportNull$$$0(2);
            }
            if (context == null) {
                OrElse.$$$reportNull$$$0(3);
            }
            context.setInitializer(this.myArg);
            return context.createResult(outVar.getName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "inVar";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "outVar";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "code";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInspection/optionalToIf/TerminalOperation$OrElse";
            objectArray[2] = "generate";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class Get
    extends TerminalOperation {
        Get() {
        }

        @Override
        @Nullable
        public String generate(@NotNull ChainVariable inVar, @NotNull ChainVariable outVar, @NotNull String code, @NotNull OptionalToIfContext context) {
            if (inVar == null) {
                Get.$$$reportNull$$$0(0);
            }
            if (outVar == null) {
                Get.$$$reportNull$$$0(1);
            }
            if (code == null) {
                Get.$$$reportNull$$$0(2);
            }
            if (context == null) {
                Get.$$$reportNull$$$0(3);
            }
            context.setElseBranch("throw new java.util.NoSuchElementException(\"No value present\");");
            return context.createResult(outVar.getName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "inVar";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "outVar";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "code";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInspection/optionalToIf/TerminalOperation$Get";
            objectArray[2] = "generate";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

