/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefJavaElement;
import com.intellij.codeInspection.reference.RefJavaElementImpl;
import com.intellij.codeInspection.reference.RefJavaManager;
import com.intellij.codeInspection.reference.RefJavaUtil;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefMethodImpl;
import com.intellij.codeInspection.reference.RefParameter;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.util.ObjectUtils;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UDeclarationKt;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.UResolvableKt;
import org.jetbrains.uast.UTypeReferenceExpression;

public class RefParameterImpl
extends RefJavaElementImpl
implements RefParameter {
    private static final int USED_FOR_READING_MASK = 65536;
    private static final int USED_FOR_WRITING_MASK = 131072;
    private final short myIndex;
    private Object myActualValueTemplate;
    private int myUsageCount;

    RefParameterImpl(UParameter parameter2, PsiElement psi, int index, RefManager manager, RefMethod refMethod) {
        super((UDeclaration)parameter2, psi, manager);
        this.myIndex = (short)index;
        this.myActualValueTemplate = VALUE_UNDEFINED;
        RefElementImpl owner2 = (RefElementImpl)refMethod;
        if (owner2 != null) {
            owner2.add((RefEntity)this);
        }
        if (this.myIndex == 0 && "$receiver".equals(this.getName())) {
            this.setUsedForReading();
        }
    }

    public void parameterReferenced(boolean forWriting) {
        if (forWriting) {
            this.setUsedForWriting();
        } else {
            this.setUsedForReading();
        }
    }

    public boolean isUsedForReading() {
        return this.checkFlag(65536L);
    }

    private void setUsedForReading() {
        this.setFlag(true, 65536L);
    }

    public int getUsageCount() {
        return this.myUsageCount;
    }

    public boolean isUsedForWriting() {
        return this.checkFlag(131072L);
    }

    private void setUsedForWriting() {
        this.setFlag(true, 131072L);
    }

    public void accept(@NotNull RefVisitor visitor2) {
        if (visitor2 == null) {
            RefParameterImpl.$$$reportNull$$$0(0);
        }
        if (visitor2 instanceof RefJavaVisitor) {
            ApplicationManager.getApplication().runReadAction(() -> ((RefJavaVisitor)visitor2).visitParameter((RefParameter)this));
        } else {
            super.accept(visitor2);
        }
    }

    public int getIndex() {
        return this.myIndex;
    }

    public void buildReferences() {
        RefJavaUtil refUtil = RefJavaUtil.getInstance();
        UParameter parameter2 = this.getUastElement();
        if (parameter2 != null) {
            List annotations = parameter2.getUAnnotations();
            refUtil.addReferencesTo((UDeclaration)parameter2, (RefJavaElement)this, annotations.toArray(UElementKt.EMPTY_ARRAY));
            UTypeReferenceExpression typeReference2 = parameter2.getTypeReference();
            refUtil.addReferencesTo((UDeclaration)parameter2, (RefJavaElement)this, new UElement[]{typeReference2});
        }
    }

    void clearTemplateValue() {
        this.myActualValueTemplate = VALUE_IS_NOT_CONST;
    }

    void updateTemplateValue(UExpression expression2, @Nullable PsiElement accessPlace) {
        ++this.myUsageCount;
        if (this.myActualValueTemplate == VALUE_IS_NOT_CONST) {
            return;
        }
        Object newTemplate = RefParameterImpl.getAccessibleExpressionValue(expression2, () -> accessPlace == null ? this.getContainingFile() : accessPlace);
        if (this.myActualValueTemplate == VALUE_UNDEFINED) {
            this.myActualValueTemplate = newTemplate;
        } else if (!Comparing.equal((Object)this.myActualValueTemplate, (Object)newTemplate)) {
            this.myActualValueTemplate = VALUE_IS_NOT_CONST;
        }
    }

    @Nullable
    public Object getActualConstValue() {
        return this.myActualValueTemplate;
    }

    protected void initialize() {
    }

    public String getExternalName() {
        return (String)ReadAction.compute(() -> {
            UParameter parameter2 = this.getUastElement();
            LOG.assertTrue(parameter2 != null);
            return PsiFormatUtil.getExternalName((PsiModifierListOwner)((PsiModifierListOwner)parameter2.getJavaPsi()));
        });
    }

    public UParameter getUastElement() {
        RefMethod method = (RefMethod)ObjectUtils.tryCast((Object)this.getOwner(), RefMethod.class);
        if (method == null) {
            return null;
        }
        UMethod uMethod = (UMethod)ObjectUtils.tryCast((Object)method.getUastElement(), UMethod.class);
        if (uMethod == null) {
            return null;
        }
        List parameters2 = uMethod.getUastParameters();
        if (parameters2.size() <= this.getIndex()) {
            return null;
        }
        return (UParameter)parameters2.get(this.getIndex());
    }

    @Nullable
    public static Object getAccessibleExpressionValue(UExpression expression2, Supplier<? extends PsiElement> accessPlace) {
        UReferenceExpression referenceExpression;
        UElement resolved;
        if (expression2 instanceof UReferenceExpression && (resolved = UResolvableKt.resolveToUElement((UResolvable)(referenceExpression = (UReferenceExpression)expression2))) instanceof UField) {
            UField uField = (UField)resolved;
            PsiElement element = accessPlace.get();
            if (uField.isStatic() && uField.isFinal()) {
                if (element == null || !RefParameterImpl.isAccessible(uField, element)) {
                    return VALUE_IS_NOT_CONST;
                }
                UDeclaration containingClass = UDeclarationKt.getContainingDeclaration((UElement)uField);
                if (containingClass instanceof UClass && ((UClass)containingClass).getQualifiedName() != null) {
                    return uField;
                }
            }
        }
        if (expression2 instanceof ULiteralExpression) {
            Object value2 = ((ULiteralExpression)expression2).getValue();
            if (value2 == null) {
                return null;
            }
            PsiElement sourcePsi = Objects.requireNonNull(expression2.getSourcePsi());
            return value2 instanceof String ? "\"" + StringUtil.unquoteString((String)sourcePsi.getText()) + "\"" : value2;
        }
        Object constValue = expression2.evaluate();
        return constValue == null ? VALUE_IS_NOT_CONST : (constValue instanceof String ? "\"" + constValue + "\"" : constValue);
    }

    private static boolean isAccessible(@NotNull UField field, @NotNull PsiElement place) {
        UDeclaration fieldContainingClass;
        if (field == null) {
            RefParameterImpl.$$$reportNull$$$0(1);
        }
        if (place == null) {
            RefParameterImpl.$$$reportNull$$$0(2);
        }
        if (!((fieldContainingClass = UDeclarationKt.getContainingDeclaration((UElement)field)) instanceof UClass)) {
            return false;
        }
        String qName = ((UClass)fieldContainingClass).getQualifiedName();
        if (qName == null) {
            return false;
        }
        String fieldQName = qName + "." + field.getName();
        return PsiResolveHelper.SERVICE.getInstance((Project)place.getProject()).resolveReferencedVariable(fieldQName, place) != null;
    }

    @Nullable
    static RefElement parameterFromExternalName(RefManager manager, String fqName) {
        String method;
        RefMethod refMethod;
        int idx = fqName.lastIndexOf(32);
        if (idx > 0 && (refMethod = RefMethodImpl.methodFromExternalName(manager, method = fqName.substring(0, idx))) != null) {
            UMethod element = (UMethod)ObjectUtils.tryCast((Object)refMethod.getUastElement(), UMethod.class);
            if (element == null) {
                return null;
            }
            List parameters2 = element.getUastParameters();
            int paramIdx = 0;
            String paramName = fqName.substring(idx + 1);
            for (UParameter parameter2 : parameters2) {
                String name2 = parameter2.getName();
                if (name2 != null && name2.equals(paramName)) {
                    return ((RefJavaManager)manager.getExtension(RefJavaManager.MANAGER)).getParameterReference(parameter2, paramIdx, refMethod);
                }
                ++paramIdx;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/reference/RefParameterImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "accept";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isAccessible";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

