/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.testOnly;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.TestFrameworks;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.RemoveAnnotationQuickFix;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.impl.light.LightModifierList;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestOnlyInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final List<String> ourModifiersDescending = Arrays.asList("public", "protected", "packageLocal", "private");

    @NotNull
    public String getShortName() {
        return "TestOnlyProblems";
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = TestOnlyInspection.getGeneralGroupName();
        if (string == null) {
            TestOnlyInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder h, boolean isOnTheFly) {
        if (h == null) {
            TestOnlyInspection.$$$reportNull$$$0(1);
        }
        return new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
                TestOnlyInspection.validate((PsiElement)expression2.getMethodExpression(), (PsiMember)expression2.resolveMethod(), h);
            }

            public void visitNewExpression(PsiNewExpression expression2) {
                PsiJavaCodeReferenceElement reference = expression2.getClassOrAnonymousClassReference();
                if (reference != null && TestOnlyInspection.validate((PsiElement)reference, (PsiMember)expression2.resolveMethod(), h)) {
                    TestOnlyInspection.validate((PsiElement)reference, (PsiMember)ObjectUtils.tryCast((Object)reference.resolve(), PsiMember.class), h);
                }
            }

            public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression2) {
                PsiElement resolve2 = expression2.resolve();
                if (resolve2 instanceof PsiMethod) {
                    TestOnlyInspection.validate((PsiElement)expression2, (PsiMember)((PsiMethod)resolve2), h);
                }
            }

            public void visitReferenceExpression(PsiReferenceExpression reference) {
                PsiElement resolve2 = reference.resolve();
                if (resolve2 instanceof PsiField) {
                    TestOnlyInspection.validate((PsiElement)reference, (PsiMember)((PsiField)resolve2), h);
                }
            }

            public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                if (reference.getParent() instanceof PsiNewExpression || reference.getParent() instanceof PsiAnonymousClass || PsiTreeUtil.getParentOfType((PsiElement)reference, PsiImportStatementBase.class) != null) {
                    return;
                }
                PsiElement resolve2 = reference.resolve();
                if (resolve2 instanceof PsiClass) {
                    TestOnlyInspection.validate((PsiElement)reference, (PsiMember)((PsiClass)resolve2), h);
                }
            }

            public void visitElement(@NotNull PsiElement element) {
                PsiAnnotation vft;
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (element instanceof PsiMember && (vft = TestOnlyInspection.findVisibleForTestingAnnotation((PsiMember)element)) != null && TestOnlyInspection.isDirectlyTestOnly((PsiMember)element)) {
                    PsiElement toHighlight = null;
                    if (element instanceof PsiNameIdentifierOwner) {
                        toHighlight = ((PsiNameIdentifierOwner)element).getNameIdentifier();
                    }
                    if (toHighlight == null) {
                        toHighlight = element;
                    }
                    h.registerProblem(toHighlight, JavaAnalysisBundle.message((String)"visible.for.testing.makes.little.sense.on.test.only.code", (Object[])new Object[0]), new LocalQuickFix[]{new RemoveAnnotationQuickFix(vft, (PsiModifierListOwner)element)});
                }
                super.visitElement(element);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/testOnly/TestOnlyInspection$1", "visitElement"));
            }
        };
    }

    private static boolean validate(@NotNull PsiElement place, @Nullable PsiMember member, ProblemsHolder h) {
        if (place == null) {
            TestOnlyInspection.$$$reportNull$$$0(2);
        }
        if (member == null) {
            return true;
        }
        PsiAnnotation vft = TestOnlyInspection.findVisibleForTestingAnnotation(member);
        if (vft == null && !TestOnlyInspection.isAnnotatedAsTestOnly(member)) {
            return true;
        }
        if (TestOnlyInspection.isInsideTestOnlyMethod(place) || TestOnlyInspection.isInsideTestOnlyField(place) || TestOnlyInspection.isInsideTestClass(place) || TestOnlyInspection.isUnderTestSources(place)) {
            return true;
        }
        if (vft != null) {
            String modifier = TestOnlyInspection.getAccessModifierWithoutTesting(vft);
            if (modifier == null) {
                modifier = TestOnlyInspection.getNextLowerAccessLevel(member);
            }
            LightModifierList modList = new LightModifierList(member.getManager(), (Language)JavaLanguage.INSTANCE, modifier);
            if (JavaResolveUtil.isAccessible(member, member.getContainingClass(), modList, place, null, null)) {
                return true;
            }
        }
        TestOnlyInspection.reportProblem(place, member, h);
        return false;
    }

    private static String getNextLowerAccessLevel(@NotNull PsiMember member) {
        if (member == null) {
            TestOnlyInspection.$$$reportNull$$$0(3);
        }
        int methodModifier = ContainerUtil.indexOf(ourModifiersDescending, arg_0 -> ((PsiMember)member).hasModifierProperty(arg_0));
        int minModifier = ourModifiersDescending.size() - 1;
        if (member instanceof PsiMethod) {
            for (PsiMethod superMethod : ((PsiMethod)member).findSuperMethods()) {
                minModifier = Math.min(minModifier, ContainerUtil.indexOf(ourModifiersDescending, arg_0 -> ((PsiMethod)superMethod).hasModifierProperty(arg_0)));
            }
        }
        return ourModifiersDescending.get(Math.min(minModifier, methodModifier + 1));
    }

    @Nullable
    private static String getAccessModifierWithoutTesting(PsiAnnotation anno) {
        PsiElement target;
        PsiAnnotationMemberValue ref = anno.findAttributeValue("visibility");
        if (ref instanceof PsiReferenceExpression && (target = ((PsiReferenceExpression)ref).resolve()) instanceof PsiEnumConstant) {
            String name2 = ((PsiEnumConstant)target).getName();
            return "PRIVATE".equals(name2) ? "private" : ("PROTECTED".equals(name2) ? "protected" : "packageLocal");
        }
        return null;
    }

    @Nullable
    private static PsiAnnotation findVisibleForTestingAnnotation(@NotNull PsiMember member) {
        PsiAnnotation anno;
        if (member == null) {
            TestOnlyInspection.$$$reportNull$$$0(4);
        }
        return (anno = AnnotationUtil.findAnnotation((PsiModifierListOwner)member, (String[])new String[]{"com.google.common.annotations.VisibleForTesting"})) != null ? anno : AnnotationUtil.findAnnotation((PsiModifierListOwner)member, (String[])new String[]{"com.android.annotations.VisibleForTesting"});
    }

    private static boolean isInsideTestOnlyMethod(PsiElement e) {
        return TestOnlyInspection.isAnnotatedAsTestOnly((PsiMember)TestOnlyInspection.getTopLevelParentOfType(e, PsiMethod.class));
    }

    private static boolean isInsideTestOnlyField(PsiElement e) {
        return TestOnlyInspection.isAnnotatedAsTestOnly((PsiMember)TestOnlyInspection.getTopLevelParentOfType(e, PsiField.class));
    }

    private static boolean isAnnotatedAsTestOnly(@Nullable PsiMember m) {
        if (m == null) {
            return false;
        }
        return TestOnlyInspection.isDirectlyTestOnly(m) || TestOnlyInspection.isAnnotatedAsTestOnly((PsiMember)m.getContainingClass());
    }

    private static boolean isDirectlyTestOnly(@NotNull PsiMember m) {
        if (m == null) {
            TestOnlyInspection.$$$reportNull$$$0(5);
        }
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)m, (String)"org.jetbrains.annotations.TestOnly", (int)2);
    }

    private static boolean isInsideTestClass(PsiElement e) {
        PsiClass c = TestOnlyInspection.getTopLevelParentOfType(e, PsiClass.class);
        return c != null && TestFrameworks.getInstance().isTestClass(c);
    }

    private static <T extends PsiElement> T getTopLevelParentOfType(PsiElement e, Class<T> c) {
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)e, c);
        if (parent == null) {
            return null;
        }
        PsiElement next;
        while ((next = PsiTreeUtil.getParentOfType((PsiElement)parent, c)) != null) {
            parent = next;
        }
        return (T)parent;
    }

    private static boolean isUnderTestSources(PsiElement e) {
        ProjectRootManager rm = ProjectRootManager.getInstance((Project)e.getProject());
        VirtualFile f = e.getContainingFile().getVirtualFile();
        return f != null && rm.getFileIndex().isInTestSourceContent(f);
    }

    private static void reportProblem(PsiElement e, PsiMember target, ProblemsHolder h) {
        String message2 = JavaAnalysisBundle.message((String)(target instanceof PsiClass ? "inspection.test.only.problems.test.only.class.reference" : (target instanceof PsiField ? "inspection.test.only.problems.test.only.field.reference" : "inspection.test.only.problems.test.only.method.call")), (Object[])new Object[0]);
        h.registerProblem(e, message2, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/testOnly/TestOnlyInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "h";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/testOnly/TestOnlyInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getNextLowerAccessLevel";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findVisibleForTestingAnnotation";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyTestOnly";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

