/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.unusedImport;

import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalSimpleInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.unusedImport.ImportsAreUsedVisitor;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.fixes.DeleteImportFix;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class UnusedImportInspection
extends GlobalSimpleInspectionTool {
    @NonNls
    public static final String SHORT_NAME = "UNUSED_IMPORT";

    public void checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, @NotNull ProblemsHolder problemsHolder, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        if (file == null) {
            UnusedImportInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            UnusedImportInspection.$$$reportNull$$$0(1);
        }
        if (problemsHolder == null) {
            UnusedImportInspection.$$$reportNull$$$0(2);
        }
        if (globalContext == null) {
            UnusedImportInspection.$$$reportNull$$$0(3);
        }
        if (problemDescriptionsProcessor == null) {
            UnusedImportInspection.$$$reportNull$$$0(4);
        }
        if (!(file instanceof PsiJavaFile) || FileTypeUtils.isInServerPageFile((PsiElement)file)) {
            return;
        }
        PsiJavaFile javaFile = (PsiJavaFile)file;
        ImportsAreUsedVisitor visitor2 = new ImportsAreUsedVisitor(javaFile);
        javaFile.accept((PsiElementVisitor)visitor2);
        for (PsiImportStatementBase unusedImportStatement : visitor2.getUnusedImportStatements()) {
            PsiJavaCodeReferenceElement reference = unusedImportStatement.getImportReference();
            if (reference == null || reference.multiResolve(false).length <= 0 || PsiTreeUtil.skipWhitespacesForward((PsiElement)unusedImportStatement) instanceof PsiErrorElement) continue;
            problemsHolder.registerProblem((PsiElement)unusedImportStatement, InspectionGadgetsBundle.message("unused.import.problem.descriptor", new Object[0]), new LocalQuickFix[]{new DeleteImportFix()});
        }
    }

    @NotNull
    public String getShortName() {
        return SHORT_NAME;
    }

    public boolean worksInBatchModeOnly() {
        return false;
    }

    public static String getDisplayNameText() {
        return JavaAnalysisBundle.message((String)"unused.import.display.name", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "problemsHolder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "globalContext";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "problemDescriptionsProcessor";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInspection/unusedImport/UnusedImportInspection";
        objectArray[2] = "checkFile";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

