/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.util;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.util.SpecialAnnotationsUtilBase;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.ClassFilter;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.SeparatorFactory;
import com.intellij.ui.SortedListModel;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.util.IconUtil;
import com.intellij.util.IncorrectOperationException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.jetbrains.annotations.NotNull;

public class SpecialAnnotationsUtil {
    public static JPanel createSpecialAnnotationsListControl(List<String> list, String borderTitle) {
        return SpecialAnnotationsUtil.createSpecialAnnotationsListControl(list, borderTitle, false);
    }

    public static JPanel createSpecialAnnotationsListControl(List<String> list, String borderTitle, boolean acceptPatterns) {
        return SpecialAnnotationsUtil.createSpecialAnnotationsListControl(list, borderTitle, acceptPatterns, (Condition<? super PsiClass>)((Condition)aClass -> aClass.isAnnotationType()));
    }

    public static JPanel createSpecialAnnotationsListControl(final List<String> list, String borderTitle, boolean acceptPatterns, Condition<? super PsiClass> isApplicable) {
        final SortedListModel listModel = new SortedListModel(Comparator.naturalOrder());
        for (String s : list) {
            listModel.add((Object)s);
        }
        listModel.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                this.listChanged();
            }

            private void listChanged() {
                list.clear();
                for (int i = 0; i < listModel.getSize(); ++i) {
                    list.add(listModel.getElementAt(i));
                }
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                this.listChanged();
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                this.listChanged();
            }
        });
        return SpecialAnnotationsUtil.createSpecialAnnotationsListControl(borderTitle, acceptPatterns, isApplicable, (SortedListModel<? super String>)listModel);
    }

    public static JPanel createSpecialAnnotationsListControl(String borderTitle, boolean acceptPatterns, Condition<? super PsiClass> isApplicable, final SortedListModel<? super String> listModel) {
        JBList injectionList = new JBList(listModel);
        injectionList.setSelectionMode(1);
        ToolbarDecorator toolbarDecorator = ToolbarDecorator.createDecorator((JList)injectionList).setAddAction(new AnActionButtonRunnable((JList)injectionList, isApplicable, listModel){
            final /* synthetic */ JList val$injectionList;
            final /* synthetic */ Condition val$isApplicable;
            final /* synthetic */ SortedListModel val$listModel;
            {
                this.val$injectionList = jList;
                this.val$isApplicable = condition2;
                this.val$listModel = sortedListModel;
            }

            public void run(AnActionButton button) {
                Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)this.val$injectionList));
                if (project == null) {
                    project = ProjectManager.getInstance().getDefaultProject();
                }
                TreeClassChooser chooser = TreeClassChooserFactory.getInstance((Project)project).createWithInnerClassesScopeChooser(JavaBundle.message((String)"special.annotations.list.annotation.class", (Object[])new Object[0]), GlobalSearchScope.allScope((Project)project), new ClassFilter(){

                    public boolean isAccepted(PsiClass aClass) {
                        return val$isApplicable.value((Object)aClass);
                    }
                }, null);
                chooser.showDialog();
                PsiClass selected = chooser.getSelected();
                if (selected != null) {
                    this.val$listModel.add((Object)selected.getQualifiedName());
                }
            }
        }).setAddActionName(JavaBundle.message((String)"special.annotations.list.add.annotation.class", (Object[])new Object[0])).disableUpDownActions();
        if (acceptPatterns) {
            toolbarDecorator.setAddIcon(IconUtil.getAddClassIcon()).addExtraAction(new AnActionButton(JavaBundle.message((String)"special.annotations.list.annotation.pattern", (Object[])new Object[0]), IconUtil.getAddPatternIcon()){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    String selectedPattern;
                    if (e == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if ((selectedPattern = Messages.showInputDialog((String)JavaBundle.message((String)"special.annotations.list.annotation.pattern", (Object[])new Object[0]), (String)JavaBundle.message((String)"special.annotations.list.annotation.pattern", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon())) != null) {
                        listModel.add((Object)selectedPattern);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInspection/util/SpecialAnnotationsUtil$3", "actionPerformed"));
                }
            }).setButtonComparator(new String[]{JavaBundle.message((String)"special.annotations.list.add.annotation.class", (Object[])new Object[0]), JavaBundle.message((String)"special.annotations.list.annotation.pattern", (Object[])new Object[0]), "Remove"});
        }
        if (borderTitle == null) {
            return toolbarDecorator.createPanel();
        }
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)SeparatorFactory.createSeparator((String)borderTitle, null), "North");
        panel2.add((Component)toolbarDecorator.createPanel(), "Center");
        return panel2;
    }

    public static IntentionAction createAddToSpecialAnnotationsListIntentionAction(final String text2, final String family, final List<String> targetList, final String qualifiedName) {
        return new IntentionAction(){

            @NotNull
            public String getText() {
                String string = text2;
                if (string == null) {
                    4.$$$reportNull$$$0(0);
                }
                return string;
            }

            @NotNull
            public String getFamilyName() {
                String string = family;
                if (string == null) {
                    4.$$$reportNull$$$0(1);
                }
                return string;
            }

            public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
                if (project == null) {
                    4.$$$reportNull$$$0(2);
                }
                return true;
            }

            public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
                if (project == null) {
                    4.$$$reportNull$$$0(3);
                }
                SpecialAnnotationsUtilBase.doQuickFixInternal(project, targetList, qualifiedName);
            }

            public boolean startInWriteAction() {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 2: 
                    case 3: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 2: 
                    case 3: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInspection/util/SpecialAnnotationsUtil$4";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getText";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInspection/util/SpecialAnnotationsUtil$4";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "isAvailable";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "invoke";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }
}

