/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.options;

import com.intellij.DynamicBundle;
import com.intellij.codeInsight.NullableNotNullDialog;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerConfigurationImpl;
import com.intellij.compiler.CompilerWorkspaceConfiguration;
import com.intellij.compiler.MalformedPatternException;
import com.intellij.compiler.impl.javaCompiler.javac.JavacConfiguration;
import com.intellij.compiler.options.ComparingUtils;
import com.intellij.compiler.options.CompilerOptionsFilter;
import com.intellij.compiler.server.BuildManager;
import com.intellij.ide.PowerSaveMode;
import com.intellij.openapi.compiler.JavaCompilerBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class CompilerUIConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    private static final Logger LOG = Logger.getInstance(CompilerUIConfigurable.class);
    private static final Set<CompilerOptionsFilter.Setting> EXTERNAL_BUILD_SETTINGS = EnumSet.of(CompilerOptionsFilter.Setting.EXTERNAL_BUILD, new CompilerOptionsFilter.Setting[]{CompilerOptionsFilter.Setting.AUTO_MAKE, CompilerOptionsFilter.Setting.PARALLEL_COMPILATION, CompilerOptionsFilter.Setting.REBUILD_MODULE_ON_DEPENDENCY_CHANGE, CompilerOptionsFilter.Setting.HEAP_SIZE, CompilerOptionsFilter.Setting.COMPILER_VM_OPTIONS});
    private final Set<CompilerOptionsFilter.Setting> myDisabledSettings;
    private JPanel myPanel;
    private final Project myProject;
    private RawCommandLineEditor myResourcePatternsField;
    private JCheckBox myCbClearOutputDirectory;
    private JCheckBox myCbAssertNotNull;
    private JBLabel myPatternLegendLabel;
    private JCheckBox myCbAutoShowFirstError;
    private JCheckBox myCbDisplayNotificationPopup;
    private JCheckBox myCbEnableAutomake;
    private JCheckBox myCbParallelCompilation;
    private JTextField myHeapSizeField;
    private JTextField mySharedVMOptionsField;
    private JTextField myVMOptionsField;
    private JLabel myHeapSizeLabel;
    private JLabel mySharedVMOptionsLabel;
    private JLabel myVMOptionsLabel;
    private JCheckBox myCbRebuildOnDependencyChange;
    private JLabel myResourcePatternsLabel;
    private JLabel myEnableAutomakeLegendLabel;
    private JLabel myParallelCompilationLegendLabel;
    private JButton myConfigureAnnotations;
    private JLabel myWarningLabel;
    private JPanel myAssertNotNullPanel;

    public CompilerUIConfigurable(@NotNull Project project) {
        if (project == null) {
            CompilerUIConfigurable.$$$reportNull$$$0(0);
        }
        this.$$$setupUI$$$();
        this.myDisabledSettings = EnumSet.noneOf(CompilerOptionsFilter.Setting.class);
        this.myProject = project;
        this.myPatternLegendLabel.setText(XmlStringUtil.wrapInHtml((CharSequence)"Use <b>;</b> to separate patterns and <b>!</b> to negate a pattern. Accepted wildcards: <b>?</b> &mdash; exactly one symbol; <b>*</b> &mdash; zero or more symbols; <b>/</b> &mdash; path separator; <b>/**/</b> &mdash; any number of directories; <i>&lt;dir_name&gt;</i>:<i>&lt;pattern&gt;</i> &mdash; restrict to source roots with the specified name"));
        this.myWarningLabel.setText(JavaCompilerBundle.message((String)"settings.warning", (Object[])new Object[0]));
        this.myWarningLabel.setFont(this.myWarningLabel.getFont().deriveFont(1));
        this.myPatternLegendLabel.setForeground((Color)new JBColor((Color)Gray._50, (Color)Gray._130));
        this.tweakControls(project);
        this.myVMOptionsField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                CompilerUIConfigurable.this.mySharedVMOptionsField.setEnabled(e.getDocument().getLength() == 0);
                CompilerUIConfigurable.this.myHeapSizeField.setEnabled(ContainerUtil.find((Iterable)ParametersListUtil.parse((String)CompilerUIConfigurable.this.myVMOptionsField.getText()), s -> StringUtil.startsWithIgnoreCase((String)s, (String)"-Xmx")) == null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/compiler/options/CompilerUIConfigurable$1", "textChanged"));
            }
        });
        this.myConfigureAnnotations.addActionListener(e -> {
            NullableNotNullDialog.showDialogWithInstrumentationOptions((Component)this.myPanel);
            this.myCbAssertNotNull.setSelected(!NullableNotNullManager.getInstance((Project)this.myProject).getInstrumentedNotNulls().isEmpty());
        });
    }

    private void tweakControls(@NotNull Project project) {
        if (project == null) {
            CompilerUIConfigurable.$$$reportNull$$$0(1);
        }
        CompilerOptionsFilter[] managers = (CompilerOptionsFilter[])CompilerOptionsFilter.EP_NAME.getExtensions();
        boolean showExternalBuildSetting = true;
        for (CompilerOptionsFilter compilerOptionsFilter : managers) {
            showExternalBuildSetting = compilerOptionsFilter.isAvailable(CompilerOptionsFilter.Setting.EXTERNAL_BUILD, project);
            if (showExternalBuildSetting) continue;
            this.myDisabledSettings.add(CompilerOptionsFilter.Setting.EXTERNAL_BUILD);
            break;
        }
        block1: for (CompilerOptionsFilter.Setting setting : CompilerOptionsFilter.Setting.values()) {
            if (!showExternalBuildSetting && EXTERNAL_BUILD_SETTINGS.contains((Object)setting)) {
                this.myDisabledSettings.add(setting);
                continue;
            }
            for (CompilerOptionsFilter manager : managers) {
                if (manager.isAvailable(setting, project)) continue;
                this.myDisabledSettings.add(setting);
                continue block1;
            }
        }
        HashMap<CompilerOptionsFilter.Setting, Collection<Object>> hashMap = new HashMap<CompilerOptionsFilter.Setting, Collection<Object>>();
        hashMap.put(CompilerOptionsFilter.Setting.RESOURCE_PATTERNS, ContainerUtil.newArrayList((Object[])new JComponent[]{this.myResourcePatternsLabel, this.myResourcePatternsField, this.myPatternLegendLabel}));
        hashMap.put(CompilerOptionsFilter.Setting.CLEAR_OUTPUT_DIR_ON_REBUILD, Collections.singleton(this.myCbClearOutputDirectory));
        hashMap.put(CompilerOptionsFilter.Setting.ADD_NOT_NULL_ASSERTIONS, Collections.singleton(this.myAssertNotNullPanel));
        hashMap.put(CompilerOptionsFilter.Setting.AUTO_SHOW_FIRST_ERROR_IN_EDITOR, Collections.singleton(this.myCbAutoShowFirstError));
        hashMap.put(CompilerOptionsFilter.Setting.DISPLAY_NOTIFICATION_POPUP, Collections.singleton(this.myCbDisplayNotificationPopup));
        hashMap.put(CompilerOptionsFilter.Setting.AUTO_MAKE, ContainerUtil.newArrayList((Object[])new JComponent[]{this.myCbEnableAutomake, this.myEnableAutomakeLegendLabel}));
        hashMap.put(CompilerOptionsFilter.Setting.PARALLEL_COMPILATION, ContainerUtil.newArrayList((Object[])new JComponent[]{this.myCbParallelCompilation, this.myParallelCompilationLegendLabel}));
        hashMap.put(CompilerOptionsFilter.Setting.REBUILD_MODULE_ON_DEPENDENCY_CHANGE, ContainerUtil.newArrayList((Object[])new JComponent[]{this.myCbRebuildOnDependencyChange}));
        hashMap.put(CompilerOptionsFilter.Setting.HEAP_SIZE, ContainerUtil.newArrayList((Object[])new JComponent[]{this.myHeapSizeLabel, this.myHeapSizeField}));
        hashMap.put(CompilerOptionsFilter.Setting.COMPILER_VM_OPTIONS, ContainerUtil.newArrayList((Object[])new JComponent[]{this.myVMOptionsLabel, this.myVMOptionsField, this.mySharedVMOptionsLabel, this.mySharedVMOptionsField}));
        for (CompilerOptionsFilter.Setting setting : this.myDisabledSettings) {
            Collection collection = (Collection)hashMap.get((Object)setting);
            if (collection == null) continue;
            for (JComponent component : collection) {
                component.setVisible(false);
            }
        }
    }

    public void reset() {
        CompilerConfigurationImpl configuration = (CompilerConfigurationImpl)CompilerConfiguration.getInstance((Project)this.myProject);
        CompilerWorkspaceConfiguration workspaceConfiguration = CompilerWorkspaceConfiguration.getInstance((Project)this.myProject);
        this.myCbAutoShowFirstError.setSelected(workspaceConfiguration.AUTO_SHOW_ERRORS_IN_EDITOR);
        this.myCbDisplayNotificationPopup.setSelected(workspaceConfiguration.DISPLAY_NOTIFICATION_POPUP);
        this.myCbClearOutputDirectory.setSelected(workspaceConfiguration.CLEAR_OUTPUT_DIRECTORY);
        this.myCbAssertNotNull.setSelected(configuration.isAddNotNullAssertions());
        this.myCbEnableAutomake.setSelected(workspaceConfiguration.MAKE_PROJECT_ON_SAVE);
        this.myCbParallelCompilation.setSelected(workspaceConfiguration.PARALLEL_COMPILATION);
        this.myCbRebuildOnDependencyChange.setSelected(workspaceConfiguration.REBUILD_ON_DEPENDENCY_CHANGE);
        int javacPreferred = JavacConfiguration.getOptions((Project)this.myProject, JavacConfiguration.class).MAXIMUM_HEAP_SIZE;
        this.myHeapSizeField.setText(String.valueOf(configuration.getBuildProcessHeapSize(javacPreferred)));
        String options = workspaceConfiguration.COMPILER_PROCESS_ADDITIONAL_VM_OPTIONS;
        this.myVMOptionsField.setText(options == null ? "" : options.trim());
        this.mySharedVMOptionsField.setText(configuration.getBuildProcessVMOptions());
        configuration.convertPatterns();
        this.myResourcePatternsField.setText(CompilerUIConfigurable.patternsToString(configuration.getResourceFilePatterns()));
        if (PowerSaveMode.isEnabled()) {
            this.myEnableAutomakeLegendLabel.setText(JavaCompilerBundle.message((String)"disabled.in.power.save.mode", (Object[])new Object[0]));
            this.myEnableAutomakeLegendLabel.setFont(this.myEnableAutomakeLegendLabel.getFont().deriveFont(1));
        } else {
            this.myEnableAutomakeLegendLabel.setText(JavaCompilerBundle.message((String)"only.works.while.not.running.debugging", (Object[])new Object[0]));
            this.myEnableAutomakeLegendLabel.setFont(this.myEnableAutomakeLegendLabel.getFont().deriveFont(0));
        }
    }

    private static String patternsToString(String[] patterns) {
        StringBuilder extensionsString = new StringBuilder();
        for (int idx = 0; idx < patterns.length; ++idx) {
            if (idx > 0) {
                extensionsString.append(";");
            }
            extensionsString.append(patterns[idx]);
        }
        return extensionsString.toString();
    }

    public void apply() throws ConfigurationException {
        CompilerConfigurationImpl configuration = (CompilerConfigurationImpl)CompilerConfiguration.getInstance((Project)this.myProject);
        CompilerWorkspaceConfiguration workspaceConfiguration = CompilerWorkspaceConfiguration.getInstance((Project)this.myProject);
        if (!this.myDisabledSettings.contains((Object)CompilerOptionsFilter.Setting.AUTO_SHOW_FIRST_ERROR_IN_EDITOR)) {
            workspaceConfiguration.AUTO_SHOW_ERRORS_IN_EDITOR = this.myCbAutoShowFirstError.isSelected();
        }
        if (!this.myDisabledSettings.contains((Object)CompilerOptionsFilter.Setting.DISPLAY_NOTIFICATION_POPUP)) {
            workspaceConfiguration.DISPLAY_NOTIFICATION_POPUP = this.myCbDisplayNotificationPopup.isSelected();
        }
        if (!this.myDisabledSettings.contains((Object)CompilerOptionsFilter.Setting.CLEAR_OUTPUT_DIR_ON_REBUILD)) {
            workspaceConfiguration.CLEAR_OUTPUT_DIRECTORY = this.myCbClearOutputDirectory.isSelected();
        }
        if (!this.myDisabledSettings.contains((Object)CompilerOptionsFilter.Setting.EXTERNAL_BUILD)) {
            if (!this.myDisabledSettings.contains((Object)CompilerOptionsFilter.Setting.AUTO_MAKE)) {
                workspaceConfiguration.MAKE_PROJECT_ON_SAVE = this.myCbEnableAutomake.isSelected();
            }
            if (!this.myDisabledSettings.contains((Object)CompilerOptionsFilter.Setting.PARALLEL_COMPILATION)) {
                workspaceConfiguration.PARALLEL_COMPILATION = this.myCbParallelCompilation.isSelected();
            }
            if (!this.myDisabledSettings.contains((Object)CompilerOptionsFilter.Setting.REBUILD_MODULE_ON_DEPENDENCY_CHANGE)) {
                workspaceConfiguration.REBUILD_ON_DEPENDENCY_CHANGE = this.myCbRebuildOnDependencyChange.isSelected();
            }
            if (!this.myDisabledSettings.contains((Object)CompilerOptionsFilter.Setting.HEAP_SIZE)) {
                try {
                    configuration.setBuildProcessHeapSize(Integer.parseInt(this.myHeapSizeField.getText().trim()));
                }
                catch (NumberFormatException ignored) {
                    LOG.info((Throwable)ignored);
                }
            }
            if (!this.myDisabledSettings.contains((Object)CompilerOptionsFilter.Setting.COMPILER_VM_OPTIONS)) {
                workspaceConfiguration.COMPILER_PROCESS_ADDITIONAL_VM_OPTIONS = this.myVMOptionsField.getText().trim();
                configuration.setBuildProcessVMOptions(this.mySharedVMOptionsField.getText().trim());
            }
        }
        if (!this.myDisabledSettings.contains((Object)CompilerOptionsFilter.Setting.ADD_NOT_NULL_ASSERTIONS)) {
            configuration.setAddNotNullAssertions(this.myCbAssertNotNull.isSelected());
        }
        if (!this.myDisabledSettings.contains((Object)CompilerOptionsFilter.Setting.RESOURCE_PATTERNS)) {
            configuration.removeResourceFilePatterns();
            String extensionString = this.myResourcePatternsField.getText().trim();
            CompilerUIConfigurable.applyResourcePatterns(extensionString, configuration);
        }
        BuildManager.getInstance().clearState(this.myProject);
    }

    public static void applyResourcePatterns(String extensionString, CompilerConfigurationImpl configuration) throws ConfigurationException {
        StringTokenizer tokenizer = new StringTokenizer(extensionString, ";", false);
        ArrayList<String[]> errors = new ArrayList<String[]>();
        while (tokenizer.hasMoreTokens()) {
            String namePattern = tokenizer.nextToken();
            try {
                configuration.addResourceFilePattern(namePattern);
            }
            catch (MalformedPatternException e) {
                errors.add(new String[]{namePattern, e.getLocalizedMessage()});
            }
        }
        if (errors.size() > 0) {
            StringBuilder pattersnsWithErrors = new StringBuilder();
            for (Object e : errors) {
                String[] pair2 = (String[])e;
                pattersnsWithErrors.append("\n");
                pattersnsWithErrors.append(pair2[0]);
                pattersnsWithErrors.append(": ");
                pattersnsWithErrors.append(pair2[1]);
            }
            throw new ConfigurationException(JavaCompilerBundle.message((String)"error.compiler.configurable.malformed.patterns", (Object[])new Object[]{pattersnsWithErrors.toString()}), JavaCompilerBundle.message((String)"bad.resource.patterns.dialog.title", (Object[])new Object[0]));
        }
    }

    public boolean isModified() {
        CompilerWorkspaceConfiguration workspaceConfiguration = CompilerWorkspaceConfiguration.getInstance((Project)this.myProject);
        boolean isModified = !this.myDisabledSettings.contains((Object)CompilerOptionsFilter.Setting.AUTO_SHOW_FIRST_ERROR_IN_EDITOR) && ComparingUtils.isModified(this.myCbAutoShowFirstError, workspaceConfiguration.AUTO_SHOW_ERRORS_IN_EDITOR);
        isModified |= !this.myDisabledSettings.contains((Object)CompilerOptionsFilter.Setting.DISPLAY_NOTIFICATION_POPUP) && ComparingUtils.isModified(this.myCbDisplayNotificationPopup, workspaceConfiguration.DISPLAY_NOTIFICATION_POPUP);
        isModified |= !this.myDisabledSettings.contains((Object)CompilerOptionsFilter.Setting.AUTO_MAKE) && ComparingUtils.isModified(this.myCbEnableAutomake, workspaceConfiguration.MAKE_PROJECT_ON_SAVE);
        isModified |= !this.myDisabledSettings.contains((Object)CompilerOptionsFilter.Setting.PARALLEL_COMPILATION) && ComparingUtils.isModified(this.myCbParallelCompilation, workspaceConfiguration.PARALLEL_COMPILATION);
        isModified |= !this.myDisabledSettings.contains((Object)CompilerOptionsFilter.Setting.REBUILD_MODULE_ON_DEPENDENCY_CHANGE) && ComparingUtils.isModified(this.myCbRebuildOnDependencyChange, workspaceConfiguration.REBUILD_ON_DEPENDENCY_CHANGE);
        isModified |= !this.myDisabledSettings.contains((Object)CompilerOptionsFilter.Setting.COMPILER_VM_OPTIONS) && ComparingUtils.isModified(this.myVMOptionsField, workspaceConfiguration.COMPILER_PROCESS_ADDITIONAL_VM_OPTIONS);
        CompilerConfigurationImpl compilerConfiguration = (CompilerConfigurationImpl)CompilerConfiguration.getInstance((Project)this.myProject);
        isModified |= !this.myDisabledSettings.contains((Object)CompilerOptionsFilter.Setting.HEAP_SIZE) && ComparingUtils.isModified(this.myHeapSizeField, compilerConfiguration.getBuildProcessHeapSize(0));
        isModified |= !this.myDisabledSettings.contains((Object)CompilerOptionsFilter.Setting.COMPILER_VM_OPTIONS) && ComparingUtils.isModified(this.mySharedVMOptionsField, compilerConfiguration.getBuildProcessVMOptions());
        isModified |= !this.myDisabledSettings.contains((Object)CompilerOptionsFilter.Setting.ADD_NOT_NULL_ASSERTIONS) && ComparingUtils.isModified(this.myCbAssertNotNull, compilerConfiguration.isAddNotNullAssertions());
        isModified |= !this.myDisabledSettings.contains((Object)CompilerOptionsFilter.Setting.CLEAR_OUTPUT_DIR_ON_REBUILD) && ComparingUtils.isModified(this.myCbClearOutputDirectory, workspaceConfiguration.CLEAR_OUTPUT_DIRECTORY);
        return isModified |= !this.myDisabledSettings.contains((Object)CompilerOptionsFilter.Setting.RESOURCE_PATTERNS) && ComparingUtils.isModified(this.myResourcePatternsField, CompilerUIConfigurable.patternsToString(compilerConfiguration.getResourceFilePatterns()));
    }

    public String getDisplayName() {
        return JavaCompilerBundle.message((String)"configurable.CompilerUIConfigurable.display.name", (Object[])new Object[0]);
    }

    public String getHelpTopic() {
        return null;
    }

    @NotNull
    public String getId() {
        return "compiler.general";
    }

    public JComponent createComponent() {
        return this.myPanel;
    }

    private void createUIComponents() {
        this.myResourcePatternsField = new RawCommandLineEditor(ParametersListUtil.COLON_LINE_PARSER, ParametersListUtil.COLON_LINE_JOINER);
        this.myResourcePatternsField.setDialogCaption("Resource patterns");
        this.myHeapSizeField = new JTextField();
        this.myHeapSizeField.setPreferredSize(new Dimension(JBUIScale.scale((int)50), this.myHeapSizeField.getPreferredSize().height));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JButton jButton;
        JCheckBox jCheckBox;
        JPanel jPanel;
        JLabel jLabel2;
        JTextField jTextField;
        JTextField jTextField2;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JLabel jLabel3;
        JLabel jLabel4;
        JCheckBox jCheckBox4;
        JLabel jLabel5;
        JLabel jLabel6;
        JCheckBox jCheckBox5;
        JCheckBox jCheckBox6;
        JCheckBox jCheckBox7;
        JBLabel jBLabel;
        JLabel jLabel7;
        JPanel jPanel2;
        this.createUIComponents();
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(13, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, 1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myResourcePatternsLabel = jLabel7 = new JLabel();
        this.$$$loadLabelText$$$(jLabel7, DynamicBundle.getBundle((String)"messages/JavaCompilerBundle", CompilerUIConfigurable.class).getString("label.option.resource.patterns.text"));
        jPanel3.add((Component)jLabel7, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        RawCommandLineEditor rawCommandLineEditor = this.myResourcePatternsField;
        rawCommandLineEditor.setFocusable(true);
        rawCommandLineEditor.setText("");
        jPanel3.add((Component)rawCommandLineEditor, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myPatternLegendLabel = jBLabel = new JBLabel();
        jBLabel.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel.setFontColor(UIUtil.FontColor.BRIGHTER);
        jBLabel.setText("label");
        jPanel3.add((Component)jBLabel, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 3, null, null, null, 1));
        this.myCbClearOutputDirectory = jCheckBox7 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox7, DynamicBundle.getBundle((String)"messages/JavaCompilerBundle", CompilerUIConfigurable.class).getString("label.option.clear.output.directory.on.rebuild"));
        jPanel2.add((Component)jCheckBox7, new GridConstraints(1, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.myCbAutoShowFirstError = jCheckBox6 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox6, DynamicBundle.getBundle((String)"messages/JavaCompilerBundle", CompilerUIConfigurable.class).getString("label.option.autoshow.first.error"));
        jPanel2.add((Component)jCheckBox6, new GridConstraints(3, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.myCbEnableAutomake = jCheckBox5 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox5, DynamicBundle.getBundle((String)"messages/JavaCompilerBundle", CompilerUIConfigurable.class).getString("settings.build.project.automatically"));
        jPanel2.add((Component)jCheckBox5, new GridConstraints(5, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myHeapSizeLabel = jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, DynamicBundle.getBundle((String)"messages/JavaCompilerBundle", CompilerUIConfigurable.class).getString("settings.build.process.heap.size"));
        jPanel2.add((Component)jLabel6, new GridConstraints(8, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JTextField jTextField3 = this.myHeapSizeField;
        jPanel2.add((Component)jTextField3, new GridConstraints(8, 1, 1, 2, 8, 0, 6, 0, null, null, null));
        this.myVMOptionsLabel = jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, DynamicBundle.getBundle((String)"messages/JavaCompilerBundle", CompilerUIConfigurable.class).getString("settings.user.local.build.process.vm.options"));
        jPanel2.add((Component)jLabel5, new GridConstraints(10, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCbParallelCompilation = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, DynamicBundle.getBundle((String)"messages/JavaCompilerBundle", CompilerUIConfigurable.class).getString("settings.compile.independent.modules.in.parallel"));
        jPanel2.add((Component)jCheckBox4, new GridConstraints(6, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myParallelCompilationLegendLabel = jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, DynamicBundle.getBundle((String)"messages/JavaCompilerBundle", CompilerUIConfigurable.class).getString("settings.parallel.module.compile.may.require.larger.heap.size"));
        jPanel2.add((Component)jLabel4, new GridConstraints(6, 1, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myEnableAutomakeLegendLabel = jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/JavaCompilerBundle", CompilerUIConfigurable.class).getString("settings.auto.build.only.works.while.not.running"));
        jPanel2.add((Component)jLabel3, new GridConstraints(5, 1, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myCbRebuildOnDependencyChange = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, DynamicBundle.getBundle((String)"messages/JavaCompilerBundle", CompilerUIConfigurable.class).getString("settings.rebuild.module.on.dependency.change"));
        jPanel2.add((Component)jCheckBox3, new GridConstraints(7, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbDisplayNotificationPopup = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/JavaCompilerBundle", CompilerUIConfigurable.class).getString("label.option.display.notification.popup"));
        jPanel2.add((Component)jCheckBox2, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myVMOptionsField = jTextField2 = new JTextField();
        jPanel2.add((Component)jTextField2, new GridConstraints(10, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.mySharedVMOptionsField = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(9, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.mySharedVMOptionsLabel = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/JavaCompilerBundle", CompilerUIConfigurable.class).getString("settings.shared.build.process.vm.options"));
        jPanel2.add((Component)jLabel2, new GridConstraints(9, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAssertNotNullPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(2, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myCbAssertNotNull = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/JavaCompilerBundle", CompilerUIConfigurable.class).getString("add.notnull.assertions"));
        jPanel.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myConfigureAnnotations = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, DynamicBundle.getBundle((String)"messages/JavaCompilerBundle", CompilerUIConfigurable.class).getString("settings.configure.annotations"));
        jPanel.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myWarningLabel = jLabel = new JLabel();
        jLabel.setText("Label");
        jPanel2.add((Component)jLabel, new GridConstraints(12, 0, 1, 3, 8, 0, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(11, 2, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "com/intellij/compiler/options/CompilerUIConfigurable";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "tweakControls";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

