/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.server;

import com.intellij.compiler.server.BuilderMessageHandler;
import com.intellij.compiler.server.CustomBuilderMessageHandler;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.containers.ContainerUtil;
import io.netty.channel.Channel;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.jps.api.CmdlineProtoUtil;
import org.jetbrains.jps.api.CmdlineRemoteProto;

public abstract class DefaultMessageHandler
implements BuilderMessageHandler {
    private static final Logger LOG = Logger.getInstance(DefaultMessageHandler.class);
    private final Project myProject;
    private final ExecutorService myTaskExecutor = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"DefaultMessageHandler Pool");

    protected DefaultMessageHandler(Project project) {
        this.myProject = project;
    }

    @Override
    public void buildStarted(@NotNull UUID sessionId) {
        if (sessionId == null) {
            DefaultMessageHandler.$$$reportNull$$$0(0);
        }
    }

    @Override
    public final void handleBuildMessage(Channel channel, UUID sessionId, CmdlineRemoteProto.Message.BuilderMessage msg) {
        switch (msg.getType()) {
            case BUILD_EVENT: {
                CmdlineRemoteProto.Message.BuilderMessage.BuildEvent event = msg.getBuildEvent();
                if (event.getEventType() == CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.Type.CUSTOM_BUILDER_MESSAGE && event.hasCustomBuilderMessage()) {
                    CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.CustomBuilderMessage message2 = event.getCustomBuilderMessage();
                    if (!this.myProject.isDisposed()) {
                        ((CustomBuilderMessageHandler)this.myProject.getMessageBus().syncPublisher(CustomBuilderMessageHandler.TOPIC)).messageReceived(message2.getBuilderId(), message2.getMessageType(), message2.getMessageText());
                    }
                }
                this.handleBuildEvent(sessionId, event);
                break;
            }
            case COMPILE_MESSAGE: {
                CmdlineRemoteProto.Message.BuilderMessage.CompileMessage compileMessage = msg.getCompileMessage();
                this.handleCompileMessage(sessionId, compileMessage);
                if (compileMessage.getKind() != CmdlineRemoteProto.Message.BuilderMessage.CompileMessage.Kind.INTERNAL_BUILDER_ERROR) break;
                LOG.error("Internal build error:\n" + compileMessage.getText());
                break;
            }
            case CONSTANT_SEARCH_TASK: {
                CmdlineRemoteProto.Message.BuilderMessage.ConstantSearchTask task = msg.getConstantSearchTask();
                this.handleConstantSearchTask(channel, sessionId, task);
            }
        }
    }

    protected abstract void handleCompileMessage(UUID var1, CmdlineRemoteProto.Message.BuilderMessage.CompileMessage var2);

    protected abstract void handleBuildEvent(UUID var1, CmdlineRemoteProto.Message.BuilderMessage.BuildEvent var2);

    private void handleConstantSearchTask(Channel channel, UUID sessionId, CmdlineRemoteProto.Message.BuilderMessage.ConstantSearchTask task) {
        if (((Boolean)ReadAction.compute(() -> !this.myProject.isDisposed() && DumbService.getInstance((Project)this.myProject).isSuspendedDumbMode())).booleanValue()) {
            LOG.debug("Constant search wasn't performed because of suspended dumb mode, so waiting for it to finish within a timeout makes little sense");
            DefaultMessageHandler.notifyConstantSearchFinished(channel, sessionId, task.getOwnerClassName(), task.getFieldName(), null);
            return;
        }
        CancellablePromise search = ReadAction.nonBlocking(() -> this.doHandleConstantSearchTask(sessionId, task)).inSmartMode(this.myProject).submit((Executor)this.myTaskExecutor);
        ScheduledFuture<?> cancelByTimeout = AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> {
            LOG.debug("Total constant search time exceeded time limit for this build session");
            search.cancel();
        }, 1L, TimeUnit.MINUTES);
        search.onProcessed(affectedPaths -> {
            cancelByTimeout.cancel(false);
            DefaultMessageHandler.notifyConstantSearchFinished(channel, sessionId, task.getOwnerClassName(), task.getFieldName(), affectedPaths);
        });
    }

    @Nullable(value="when no reliable search can be performed via PSI")
    private @Nullable(value="when no reliable search can be performed via PSI") Set<String> doHandleConstantSearchTask(UUID sessionId, CmdlineRemoteProto.Message.BuilderMessage.ConstantSearchTask task) {
        Set<String> affectedPaths;
        block10: {
            String ownerClassName = task.getOwnerClassName();
            String fieldName = task.getFieldName();
            int accessFlags = task.getAccessFlags();
            boolean accessChanged = task.getIsAccessChanged();
            boolean isRemoved = task.getIsFieldRemoved();
            affectedPaths = Collections.synchronizedSet(new HashSet());
            String qualifiedName = ownerClassName.replace('$', '.');
            this.handleCompileMessage(sessionId, CmdlineProtoUtil.createCompileProgressMessageResponse((String)("Searching for usages of changed/removed constants for class " + qualifiedName)).getCompileMessage());
            Object[] classes2 = JavaPsiFacade.getInstance((Project)this.myProject).findClasses(qualifiedName, GlobalSearchScope.allScope((Project)this.myProject));
            try {
                if (isRemoved) {
                    if (classes2.length > 0) {
                        for (Object aClass2 : classes2) {
                            if (this.performRemovedConstantSearch((PsiClass)aClass2, fieldName, accessFlags, affectedPaths)) continue;
                            return null;
                        }
                    } else if (!this.performRemovedConstantSearch(null, fieldName, accessFlags, affectedPaths)) {
                        return null;
                    }
                    break block10;
                }
                if (classes2.length > 0) {
                    List changedFields = ContainerUtil.mapNotNull((Object[])classes2, aClass -> aClass.findFieldByName(fieldName, false));
                    if (changedFields.isEmpty()) {
                        LOG.debug("Constant search task: field " + fieldName + " not found in classes " + qualifiedName);
                        return null;
                    }
                    for (PsiField changedField : changedFields) {
                        if (!accessChanged && DefaultMessageHandler.isPrivate(accessFlags) || this.affectDirectUsages(changedField, accessChanged, affectedPaths)) continue;
                        return null;
                    }
                    break block10;
                }
                LOG.debug("Constant search task: class " + qualifiedName + " not found");
                return null;
            }
            catch (Throwable e) {
                LOG.debug("Constant search task: failed with message " + e.getMessage());
                return null;
            }
        }
        return affectedPaths;
    }

    private static void notifyConstantSearchFinished(Channel channel, UUID sessionId, String ownerClassName, String fieldName, @Nullable Set<String> affectedPaths) {
        CmdlineRemoteProto.Message.ControllerMessage.ConstantSearchResult.Builder builder = CmdlineRemoteProto.Message.ControllerMessage.ConstantSearchResult.newBuilder();
        builder.setOwnerClassName(ownerClassName);
        builder.setFieldName(fieldName);
        builder.setIsSuccess(affectedPaths != null);
        if (affectedPaths != null) {
            builder.addAllPath(affectedPaths);
            LOG.debug("Constant search task: " + affectedPaths.size() + " affected files found");
        } else {
            LOG.debug("Constant search task: unsuccessful");
        }
        channel.writeAndFlush((Object)CmdlineProtoUtil.toMessage((UUID)sessionId, (CmdlineRemoteProto.Message.ControllerMessage)((CmdlineRemoteProto.Message.ControllerMessage)CmdlineRemoteProto.Message.ControllerMessage.newBuilder().setType(CmdlineRemoteProto.Message.ControllerMessage.Type.CONSTANT_SEARCH_RESULT).setConstantSearchResult((CmdlineRemoteProto.Message.ControllerMessage.ConstantSearchResult)builder.build()).build())));
    }

    private boolean performRemovedConstantSearch(@Nullable PsiClass aClass, String fieldName, int fieldAccessFlags, final Set<? super String> affectedPaths) {
        PsiSearchHelper psiSearchHelper = PsiSearchHelper.getInstance((Project)this.myProject);
        final Ref result = new Ref((Object)Boolean.TRUE);
        final PsiFile fieldContainingFile = aClass != null ? aClass.getContainingFile() : null;
        SearchScope searchScope = this.getSearchScope(aClass, fieldAccessFlags);
        if (DefaultMessageHandler.containsUnloadedModules(searchScope)) {
            LOG.debug("Constant search tasks: there may be usages of " + (aClass != null ? aClass.getQualifiedName() + "::" : "") + fieldName + " in unloaded modules");
            return false;
        }
        DefaultMessageHandler.processIdentifiers(psiSearchHelper, (PsiElementProcessor<? super PsiIdentifier>)new PsiElementProcessor<PsiIdentifier>(){

            public boolean execute(@NotNull PsiIdentifier identifier) {
                if (identifier == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    VirtualFile vFile;
                    PsiFile usageFile;
                    PsiClass ownerClass;
                    PsiElement parent = identifier.getParent();
                    if (parent instanceof PsiReferenceExpression && (ownerClass = DefaultMessageHandler.getOwnerClass(parent)) != null && ownerClass.getQualifiedName() != null && (usageFile = ownerClass.getContainingFile()) != null && !usageFile.equals(fieldContainingFile) && (vFile = usageFile.getOriginalFile().getVirtualFile()) != null) {
                        affectedPaths.add(vFile.getPath());
                    }
                    return true;
                }
                catch (PsiInvalidElementAccessException ignored) {
                    result.set((Object)Boolean.FALSE);
                    LOG.debug("Constant search task: PIEAE thrown while searching of usages of removed constant");
                    return false;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "com/intellij/compiler/server/DefaultMessageHandler$1", "execute"));
            }
        }, fieldName, searchScope);
        return (Boolean)result.get();
    }

    private SearchScope getSearchScope(PsiClass aClass, int fieldAccessFlags) {
        PsiFile containingFile;
        GlobalSearchScope searchScope = GlobalSearchScope.projectScope((Project)this.myProject);
        if (aClass != null && DefaultMessageHandler.isPackageLocal(fieldAccessFlags) && (containingFile = aClass.getContainingFile()) instanceof PsiJavaFile) {
            String packageName = ((PsiJavaFile)containingFile).getPackageName();
            PsiPackage aPackage = JavaPsiFacade.getInstance((Project)this.myProject).findPackage(packageName);
            if (aPackage != null) {
                searchScope = PackageScope.packageScope((PsiPackage)aPackage, (boolean)false);
                searchScope = searchScope.intersectWith(aClass.getUseScope());
            }
        }
        return searchScope;
    }

    private static void processIdentifiers(PsiSearchHelper helper, @NotNull PsiElementProcessor<? super PsiIdentifier> processor, @NotNull String identifier, @NotNull SearchScope searchScope) {
        if (processor == null) {
            DefaultMessageHandler.$$$reportNull$$$0(1);
        }
        if (identifier == null) {
            DefaultMessageHandler.$$$reportNull$$$0(2);
        }
        if (searchScope == null) {
            DefaultMessageHandler.$$$reportNull$$$0(3);
        }
        TextOccurenceProcessor processor1 = (element, offsetInElement) -> !(element instanceof PsiIdentifier) || processor.execute((PsiElement)((PsiIdentifier)element));
        SearchScope javaScope = searchScope instanceof GlobalSearchScope ? GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)((GlobalSearchScope)searchScope), (FileType[])new FileType[]{JavaFileType.INSTANCE}) : searchScope;
        helper.processElementsWithWord(processor1, javaScope, identifier, (short)1, true, false);
    }

    private boolean affectDirectUsages(PsiField psiField, boolean ignoreAccessScope, Set<? super String> affectedPaths) throws ProcessCanceledException {
        Collection<PsiReferenceExpression> references;
        PsiFile fieldContainingFile = psiField.getContainingFile();
        HashSet<PsiFile> processedFiles = new HashSet<PsiFile>();
        if (fieldContainingFile != null) {
            processedFiles.add(fieldContainingFile);
        }
        if ((references = this.doFindReferences(psiField, ignoreAccessScope)) == null) {
            return false;
        }
        for (PsiReferenceExpression ref : references) {
            VirtualFile vFile;
            PsiElement usage = ref.getElement();
            PsiFile containingPsi = usage.getContainingFile();
            if (containingPsi == null || !processedFiles.add(containingPsi) || (vFile = containingPsi.getOriginalFile().getVirtualFile()) == null) continue;
            affectedPaths.add(vFile.getPath());
        }
        return true;
    }

    @Nullable(value="returns null if search failed")
    private @Nullable(value="returns null if search failed") Collection<PsiReferenceExpression> doFindReferences(final PsiField psiField, boolean ignoreAccessScope) {
        final SmartList result = new SmartList();
        SearchScope searchScope = (ignoreAccessScope ? psiField.getContainingFile() : psiField).getUseScope();
        if (DefaultMessageHandler.containsUnloadedModules(searchScope)) {
            PsiClass aClass = psiField.getContainingClass();
            LOG.debug("Constant search tasks: there may be usages of " + (aClass != null ? aClass.getQualifiedName() + "::" : "") + psiField.getName() + " in unloaded modules");
            return null;
        }
        DefaultMessageHandler.processIdentifiers(PsiSearchHelper.getInstance((Project)this.myProject), (PsiElementProcessor<? super PsiIdentifier>)new PsiElementProcessor<PsiIdentifier>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean execute(@NotNull PsiIdentifier identifier) {
                PsiReferenceExpression refExpression;
                PsiElement parent;
                if (identifier == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((parent = identifier.getParent()) instanceof PsiReferenceExpression && (refExpression = (PsiReferenceExpression)parent).isReferenceTo((PsiElement)psiField)) {
                    SmartList smartList = result;
                    synchronized (smartList) {
                        result.add((Object)refExpression);
                    }
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "com/intellij/compiler/server/DefaultMessageHandler$2", "execute"));
            }
        }, psiField.getName(), searchScope);
        return result;
    }

    @Nullable
    private static PsiClass getOwnerClass(PsiElement element) {
        while (!(element instanceof PsiFile)) {
            if (element instanceof PsiClass && element.getParent() instanceof PsiJavaFile) {
                PsiClass psiClass = (PsiClass)element;
                if (JspPsiUtil.isInJspFile((PsiElement)psiClass)) {
                    return null;
                }
                PsiFile containingFile = psiClass.getContainingFile();
                if (containingFile == null) {
                    return null;
                }
                return JavaLanguage.INSTANCE.equals(containingFile.getLanguage()) ? psiClass : null;
            }
            element = element.getParent();
        }
        return null;
    }

    private static boolean containsUnloadedModules(SearchScope scope) {
        if (scope instanceof LocalSearchScope) {
            return false;
        }
        if (scope instanceof GlobalSearchScope) {
            return !((GlobalSearchScope)scope).getUnloadedModulesBelongingToScope().isEmpty();
        }
        return true;
    }

    private static boolean isPackageLocal(int flags) {
        return (1 & flags) == 0 && (4 & flags) == 0 && (2 & flags) == 0;
    }

    private static boolean isPrivate(int flags) {
        return (2 & flags) != 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
        }
        objectArray2[1] = "com/intellij/compiler/server/DefaultMessageHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildStarted";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "processIdentifiers";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

