/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.server.impl;

import com.intellij.compiler.server.BuildProcessParametersProvider;
import com.intellij.compiler.server.CompileServerPlugin;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PluginPathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.io.URLUtil;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildProcessClasspathManager {
    private static final Logger LOG = Logger.getInstance(BuildProcessClasspathManager.class);
    private volatile List<String> myCompileServerPluginsClasspath;
    private static final Map<String, String> OLD_TO_NEW_MODULE_NAME = new LinkedHashMap<String, String>();

    public BuildProcessClasspathManager(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            BuildProcessClasspathManager.$$$reportNull$$$0(0);
        }
        CompileServerPlugin.EP_NAME.addExtensionPointListener(() -> {
            this.myCompileServerPluginsClasspath = null;
        }, parentDisposable);
    }

    @NotNull
    public List<String> getBuildProcessPluginsClasspath(Project project) {
        List<String> staticClasspath = this.getStaticClasspath();
        List<String> dynamicClasspath = BuildProcessClasspathManager.getDynamicClasspath(project);
        if (dynamicClasspath.isEmpty()) {
            List<String> list = staticClasspath;
            if (list == null) {
                BuildProcessClasspathManager.$$$reportNull$$$0(1);
            }
            return list;
        }
        dynamicClasspath.addAll(staticClasspath);
        List<String> list = dynamicClasspath;
        if (list == null) {
            BuildProcessClasspathManager.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    private List<String> getStaticClasspath() {
        List<String> cp = this.myCompileServerPluginsClasspath;
        if (cp == null) {
            this.myCompileServerPluginsClasspath = cp = Collections.unmodifiableList(BuildProcessClasspathManager.computeCompileServerPluginsClasspath());
        }
        List<String> list = cp;
        if (list == null) {
            BuildProcessClasspathManager.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    private static List<String> computeCompileServerPluginsClasspath() {
        ArrayList<String> classpath = new ArrayList<String>();
        for (CompileServerPlugin serverPlugin : (CompileServerPlugin[])CompileServerPlugin.EP_NAME.getExtensions()) {
            PluginId pluginId = serverPlugin.getPluginDescriptor().getPluginId();
            IdeaPluginDescriptor plugin = PluginManagerCore.getPlugin((PluginId)pluginId);
            LOG.assertTrue(plugin != null, (Object)pluginId);
            File baseFile = plugin.getPath();
            if (baseFile.isFile()) {
                classpath.add(baseFile.getPath());
                continue;
            }
            if (!baseFile.isDirectory()) continue;
            block3: for (String relativePath : StringUtil.split((String)serverPlugin.getClasspath(), (String)";")) {
                File jarFile = new File(baseFile, "lib/" + relativePath);
                if (jarFile.exists()) {
                    classpath.add(jarFile.getPath());
                    continue;
                }
                File classesDir = new File(baseFile, "classes");
                if (classesDir.isDirectory()) {
                    classpath.add(classesDir.getPath());
                    continue;
                }
                if (PluginManagerCore.isRunningFromSources()) {
                    File libraryFile;
                    File moduleDir;
                    File baseOutputDir;
                    String moduleName = FileUtilRt.getNameWithoutExtension((String)PathUtil.getFileName((String)relativePath));
                    if (OLD_TO_NEW_MODULE_NAME.containsKey(moduleName)) {
                        moduleName = OLD_TO_NEW_MODULE_NAME.get(moduleName);
                    }
                    if ((baseOutputDir = baseFile.getParentFile()).getName().equals("test")) {
                        baseOutputDir = new File(baseOutputDir.getParentFile(), "production");
                    }
                    if ((moduleDir = new File(baseOutputDir, moduleName)).isDirectory()) {
                        classpath.add(moduleDir.getPath());
                        continue;
                    }
                    File pluginDir = BuildProcessClasspathManager.getPluginDir(plugin);
                    if (pluginDir != null && (libraryFile = new File(pluginDir, "lib/" + PathUtil.getFileName((String)relativePath))).exists()) {
                        classpath.add(libraryFile.getPath());
                        continue;
                    }
                    try {
                        Enumeration<URL> urls = BuildProcessClasspathManager.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
                        while (urls.hasMoreElements()) {
                            Pair parts = URLUtil.splitJarUrl((String)urls.nextElement().getFile());
                            if (parts == null || !relativePath.equals(PathUtil.getFileName((String)((String)parts.first)))) continue;
                            classpath.add((String)parts.first);
                            continue block3;
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                LOG.error("Cannot add '" + relativePath + "' from '" + plugin.getName() + ' ' + plugin.getVersion() + "' to compiler classpath");
            }
        }
        ArrayList<String> arrayList = classpath;
        if (arrayList == null) {
            BuildProcessClasspathManager.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Nullable
    private static File getPluginDir(@NotNull IdeaPluginDescriptor plugin) {
        File extraDirFile;
        if (plugin == null) {
            BuildProcessClasspathManager.$$$reportNull$$$0(5);
        }
        String pluginDirName = StringUtil.getShortName((String)plugin.getPluginId().getIdString());
        String extraDir = System.getProperty("idea.external.build.development.plugins.dir");
        if (extraDir != null && (extraDirFile = new File(extraDir, pluginDirName)).isDirectory()) {
            return extraDirFile;
        }
        File pluginHome = PluginPathManager.getPluginHome((String)pluginDirName);
        if (!pluginHome.isDirectory() && StringUtil.isCapitalized((String)pluginDirName)) {
            pluginHome = PluginPathManager.getPluginHome((String)StringUtil.decapitalize((String)pluginDirName));
        }
        return pluginHome.isDirectory() ? pluginHome : null;
    }

    @NotNull
    private static List<String> getDynamicClasspath(Project project) {
        ArrayList<String> classpath = new ArrayList<String>();
        for (BuildProcessParametersProvider provider : BuildProcessParametersProvider.EP_NAME.getExtensionList((AreaInstance)project)) {
            classpath.addAll(provider.getClassPath());
        }
        ArrayList<String> arrayList = classpath;
        if (arrayList == null) {
            BuildProcessClasspathManager.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @NotNull
    public static List<String> getLauncherClasspath(Project project) {
        ArrayList<String> classpath = new ArrayList<String>();
        for (BuildProcessParametersProvider provider : BuildProcessParametersProvider.EP_NAME.getExtensionList((AreaInstance)project)) {
            classpath.addAll(provider.getLauncherClassPath());
        }
        ArrayList<String> arrayList = classpath;
        if (arrayList == null) {
            BuildProcessClasspathManager.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    static {
        OLD_TO_NEW_MODULE_NAME.put("android-jps-plugin", "intellij.android.jps");
        OLD_TO_NEW_MODULE_NAME.put("ant-jps-plugin", "intellij.ant.jps");
        OLD_TO_NEW_MODULE_NAME.put("aspectj-jps-plugin", "intellij.aspectj.jps");
        OLD_TO_NEW_MODULE_NAME.put("devkit-jps-plugin", "intellij.devkit.jps");
        OLD_TO_NEW_MODULE_NAME.put("eclipse-jps-plugin", "intellij.eclipse.jps");
        OLD_TO_NEW_MODULE_NAME.put("error-prone-jps-plugin", "intellij.errorProne.jps");
        OLD_TO_NEW_MODULE_NAME.put("flex-jps-plugin", "intellij.flex.jps");
        OLD_TO_NEW_MODULE_NAME.put("gradle-jps-plugin", "intellij.gradle.jps");
        OLD_TO_NEW_MODULE_NAME.put("grails-jps-plugin", "intellij.groovy.grails.jps");
        OLD_TO_NEW_MODULE_NAME.put("groovy-jps-plugin", "intellij.groovy.jps");
        OLD_TO_NEW_MODULE_NAME.put("gwt-jps-plugin", "intellij.gwt.jps");
        OLD_TO_NEW_MODULE_NAME.put("google-app-engine-jps-plugin", "intellij.java.googleAppEngine.jps");
        OLD_TO_NEW_MODULE_NAME.put("ui-designer-jps-plugin", "intellij.java.guiForms.jps");
        OLD_TO_NEW_MODULE_NAME.put("intellilang-jps-plugin", "intellij.java.langInjection.jps");
        OLD_TO_NEW_MODULE_NAME.put("dmServer-jps-plugin", "intellij.javaee.appServers.dmServer.jps");
        OLD_TO_NEW_MODULE_NAME.put("weblogic-jps-plugin", "intellij.javaee.appServers.weblogic.jps");
        OLD_TO_NEW_MODULE_NAME.put("webSphere-jps-plugin", "intellij.javaee.appServers.websphere.jps");
        OLD_TO_NEW_MODULE_NAME.put("jpa-jps-plugin", "intellij.javaee.jpa.jps");
        OLD_TO_NEW_MODULE_NAME.put("javaee-jps-plugin", "intellij.javaee.jps");
        OLD_TO_NEW_MODULE_NAME.put("javaFX-jps-plugin", "intellij.javaFX.jps");
        OLD_TO_NEW_MODULE_NAME.put("maven-jps-plugin", "intellij.maven.jps");
        OLD_TO_NEW_MODULE_NAME.put("osmorc-jps-plugin", "intellij.osgi.jps");
        OLD_TO_NEW_MODULE_NAME.put("ruby-chef-jps-plugin", "intellij.ruby.chef.jps");
        OLD_TO_NEW_MODULE_NAME.put("android-common", "intellij.android.common");
        OLD_TO_NEW_MODULE_NAME.put("build-common", "intellij.android.buildCommon");
        OLD_TO_NEW_MODULE_NAME.put("android-rt", "intellij.android.rt");
        OLD_TO_NEW_MODULE_NAME.put("sdk-common", "android.sdktools.sdk-common");
        OLD_TO_NEW_MODULE_NAME.put("sdklib", "android.sdktools.sdklib");
        OLD_TO_NEW_MODULE_NAME.put("layoutlib-api", "android.sdktools.layoutlib-api");
        OLD_TO_NEW_MODULE_NAME.put("repository", "android.sdktools.repository");
        OLD_TO_NEW_MODULE_NAME.put("manifest-merger", "android.sdktools.manifest-merger");
        OLD_TO_NEW_MODULE_NAME.put("common-eclipse-util", "intellij.eclipse.common");
        OLD_TO_NEW_MODULE_NAME.put("flex-shared", "intellij.flex.shared");
        OLD_TO_NEW_MODULE_NAME.put("groovy-rt-constants", "intellij.groovy.constants.rt");
        OLD_TO_NEW_MODULE_NAME.put("grails-compiler-patch", "intellij.groovy.grails.compilerPatch");
        OLD_TO_NEW_MODULE_NAME.put("appEngine-runtime", "intellij.java.googleAppEngine.runtime");
        OLD_TO_NEW_MODULE_NAME.put("common-javaFX-plugin", "intellij.javaFX.common");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/server/impl/BuildProcessClasspathManager";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugin";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/server/impl/BuildProcessClasspathManager";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildProcessPluginsClasspath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStaticClasspath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "computeCompileServerPluginsClasspath";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDynamicClasspath";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLauncherClasspath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPluginDir";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

