/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger;

import com.intellij.debugger.DebugEnvironment;
import com.intellij.debugger.impl.AlternativeJreClassFinder;
import com.intellij.debugger.impl.DebuggerManagerImpl;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.JavaCommandLine;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RemoteState;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopes;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultDebugEnvironment
implements DebugEnvironment {
    private final GlobalSearchScope mySearchScope;
    private final RemoteConnection myRemoteConnection;
    private final long myPollTimeout;
    private final ExecutionEnvironment environment;
    private final RunProfileState state;
    private final boolean myNeedParametersSet;

    public DefaultDebugEnvironment(@NotNull ExecutionEnvironment environment, @NotNull RunProfileState state, RemoteConnection remoteConnection, boolean pollConnection) {
        if (environment == null) {
            DefaultDebugEnvironment.$$$reportNull$$$0(0);
        }
        if (state == null) {
            DefaultDebugEnvironment.$$$reportNull$$$0(1);
        }
        this(environment, state, remoteConnection, pollConnection ? 30000L : 0L);
    }

    public DefaultDebugEnvironment(@NotNull ExecutionEnvironment environment, @NotNull RunProfileState state, RemoteConnection remoteConnection, long pollTimeout) {
        if (environment == null) {
            DefaultDebugEnvironment.$$$reportNull$$$0(2);
        }
        if (state == null) {
            DefaultDebugEnvironment.$$$reportNull$$$0(3);
        }
        this.environment = environment;
        this.state = state;
        this.myRemoteConnection = remoteConnection;
        this.myPollTimeout = pollTimeout;
        this.mySearchScope = DefaultDebugEnvironment.createSearchScope(environment.getProject(), environment.getRunProfile());
        this.myNeedParametersSet = remoteConnection.isServerMode() && remoteConnection.isUseSockets() && "0".equals(remoteConnection.getApplicationAddress());
    }

    private static GlobalSearchScope createSearchScope(final @NotNull Project project, @Nullable RunProfile runProfile) {
        GlobalSearchScope scope;
        if (project == null) {
            DefaultDebugEnvironment.$$$reportNull$$$0(4);
        }
        if ((scope = GlobalSearchScopes.executionScope((Project)project, (RunProfile)runProfile)).equals(GlobalSearchScope.allScope((Project)project))) {
            return new DelegatingGlobalSearchScope(scope){
                final ProjectFileIndex myProjectFileIndex;
                final Comparator<VirtualFile> myScopeComparator;
                {
                    super(arg0);
                    this.myProjectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
                    this.myScopeComparator = Comparator.comparing(arg_0 -> ((ProjectFileIndex)this.myProjectFileIndex).isInSourceContent(arg_0)).thenComparing(arg_0 -> ((ProjectFileIndex)this.myProjectFileIndex).isInLibrarySource(arg_0)).thenComparing((x$0, x$1) -> super.compare(x$0, x$1));
                }

                public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
                    if (file1 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (file2 == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return this.myScopeComparator.compare(file1, file2);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "file1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "file2";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/debugger/DefaultDebugEnvironment$1";
                    objectArray[2] = "compare";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
        }
        return scope;
    }

    @Override
    public ExecutionResult createExecutionResult() throws ExecutionException {
        if (this.myNeedParametersSet && this.state instanceof JavaCommandLine) {
            DebuggerManagerImpl.createDebugParameters(((JavaCommandLine)this.state).getJavaParameters(), true, 0, this.myRemoteConnection.getApplicationAddress(), false);
        }
        return this.state.execute(this.environment.getExecutor(), this.environment.getRunner());
    }

    @Override
    @NotNull
    public GlobalSearchScope getSearchScope() {
        GlobalSearchScope globalSearchScope = this.mySearchScope;
        if (globalSearchScope == null) {
            DefaultDebugEnvironment.$$$reportNull$$$0(5);
        }
        return globalSearchScope;
    }

    @Override
    public boolean isRemote() {
        return this.state instanceof RemoteState;
    }

    @Override
    public RemoteConnection getRemoteConnection() {
        return this.myRemoteConnection;
    }

    @Override
    public long getPollTimeout() {
        return this.myPollTimeout;
    }

    @Override
    public String getSessionName() {
        return this.environment.getRunProfile().getName();
    }

    @Override
    @Nullable
    public Sdk getAlternativeJre() {
        return AlternativeJreClassFinder.getAlternativeJre(this.environment.getRunProfile());
    }

    @Override
    @Nullable
    public Sdk getRunJre() {
        if (this.state instanceof JavaCommandLine) {
            try {
                return ((JavaCommandLine)this.state).getJavaParameters().getJdk();
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
        return ProjectRootManager.getInstance((Project)this.environment.getProject()).getProjectSdk();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/DefaultDebugEnvironment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/DefaultDebugEnvironment";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createSearchScope";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

