/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger;

import com.intellij.debugger.DebugEnvironment;
import com.intellij.debugger.DebugUIEnvironment;
import com.intellij.debugger.DefaultDebugEnvironment;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.actions.CloseAction;
import com.intellij.ide.actions.ContextHelpAction;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultDebugUIEnvironment
implements DebugUIEnvironment {
    private final ExecutionEnvironment myExecutionEnvironment;
    private final DebugEnvironment myModelEnvironment;

    public DefaultDebugUIEnvironment(@NotNull ExecutionEnvironment environment, RunProfileState state, RemoteConnection remoteConnection, boolean pollConnection) {
        if (environment == null) {
            DefaultDebugUIEnvironment.$$$reportNull$$$0(0);
        }
        this.myExecutionEnvironment = environment;
        this.myModelEnvironment = new DefaultDebugEnvironment(environment, state, remoteConnection, pollConnection);
    }

    @Override
    public DebugEnvironment getEnvironment() {
        return this.myModelEnvironment;
    }

    @Override
    @Nullable
    public RunContentDescriptor getReuseContent() {
        return this.myExecutionEnvironment.getContentToReuse();
    }

    @Override
    public Icon getIcon() {
        return this.getRunProfile().getIcon();
    }

    @Override
    public void initActions(RunContentDescriptor content, DefaultActionGroup actionGroup) {
        Executor executor = this.myExecutionEnvironment.getExecutor();
        actionGroup.add(ActionManager.getInstance().getAction("Rerun"), Constraints.FIRST);
        actionGroup.add((AnAction)new CloseAction(executor, content, this.myExecutionEnvironment.getProject()));
        actionGroup.add((AnAction)new ContextHelpAction(executor.getHelpId()));
    }

    @Override
    @NotNull
    public RunProfile getRunProfile() {
        RunProfile runProfile = this.myExecutionEnvironment.getRunProfile();
        if (runProfile == null) {
            DefaultDebugUIEnvironment.$$$reportNull$$$0(1);
        }
        return runProfile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/DefaultDebugUIEnvironment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/DefaultDebugUIEnvironment";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunProfile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

