/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ThreadDescriptorImpl;
import com.intellij.openapi.actionSystem.AnActionEvent;
import org.jetbrains.annotations.NotNull;

public class FreezeThreadAction
extends DebuggerAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        DebuggerTreeNodeImpl[] selectedNode;
        if (e == null) {
            FreezeThreadAction.$$$reportNull$$$0(0);
        }
        if ((selectedNode = FreezeThreadAction.getSelectedNodes(e.getDataContext())) == null) {
            return;
        }
        DebuggerContextImpl debuggerContext = FreezeThreadAction.getDebuggerContext(e.getDataContext());
        final DebugProcessImpl debugProcess = debuggerContext.getDebugProcess();
        for (final DebuggerTreeNodeImpl debuggerTreeNode : selectedNode) {
            ThreadDescriptorImpl threadDescriptor = (ThreadDescriptorImpl)debuggerTreeNode.getDescriptor();
            final ThreadReferenceProxyImpl thread = threadDescriptor.getThreadReference();
            if (threadDescriptor.isFrozen()) continue;
            debugProcess.getManagerThread().schedule(new DebuggerCommandImpl(){

                @Override
                protected void action() throws Exception {
                    debugProcess.createFreezeThreadCommand(thread).run();
                    debuggerTreeNode.calcValue();
                }
            });
        }
    }

    public void update(@NotNull AnActionEvent e) {
        DebuggerTreeNodeImpl[] selectedNode;
        if (e == null) {
            FreezeThreadAction.$$$reportNull$$$0(1);
        }
        if ((selectedNode = FreezeThreadAction.getSelectedNodes(e.getDataContext())) == null) {
            return;
        }
        DebugProcessImpl debugProcess = FreezeThreadAction.getDebuggerContext(e.getDataContext()).getDebugProcess();
        boolean visible = false;
        if (debugProcess != null) {
            visible = true;
            for (DebuggerTreeNodeImpl aSelectedNode : selectedNode) {
                NodeDescriptorImpl threadDescriptor = aSelectedNode.getDescriptor();
                if (threadDescriptor instanceof ThreadDescriptorImpl && !((ThreadDescriptorImpl)threadDescriptor).isSuspended()) continue;
                visible = false;
                break;
            }
        }
        e.getPresentation().setVisible(visible);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/debugger/actions/FreezeThreadAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

