/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.BasicStepMethodFilter;
import com.intellij.debugger.engine.BreakpointStepMethodFilter;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiStatement;
import com.intellij.util.Range;
import org.jetbrains.annotations.Nullable;

public class AnonymousClassMethodFilter
extends BasicStepMethodFilter
implements BreakpointStepMethodFilter {
    @Nullable
    private final SourcePosition myBreakpointPosition;
    private final int myLastStatementLine;

    public AnonymousClassMethodFilter(PsiMethod psiMethod, Range<Integer> lines) {
        super(psiMethod, lines);
        PsiStatement[] statements;
        PsiCodeBlock body2;
        SourcePosition firstStatementPosition = null;
        SourcePosition lastStatementPosition = null;
        PsiElement navigationElement = psiMethod.getNavigationElement();
        if (navigationElement instanceof PsiMethod) {
            psiMethod = (PsiMethod)navigationElement;
        }
        if ((body2 = psiMethod.getBody()) != null && (statements = body2.getStatements()).length > 0 && (firstStatementPosition = SourcePosition.createFromElement((PsiElement)statements[0])) != null) {
            PsiStatement lastStatement = statements[statements.length - 1];
            lastStatementPosition = SourcePosition.createFromOffset((PsiFile)firstStatementPosition.getFile(), (int)lastStatement.getTextRange().getEndOffset());
        }
        this.myBreakpointPosition = firstStatementPosition;
        this.myLastStatementLine = lastStatementPosition != null ? lastStatementPosition.getLine() : -1;
    }

    @Override
    @Nullable
    public SourcePosition getBreakpointPosition() {
        return this.myBreakpointPosition;
    }

    @Override
    public int getLastStatementLine() {
        return this.myLastStatementLine;
    }
}

