/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.AnonymousClassMethodFilter;
import com.intellij.debugger.engine.BreakpointStepMethodFilter;
import com.intellij.debugger.engine.ConstructorStepMethodFilter;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.RequestHint;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.ui.breakpoints.StepIntoBreakpoint;
import com.intellij.psi.PsiMethod;
import com.intellij.util.Range;
import com.sun.jdi.ObjectReference;

public class ClassInstanceMethodFilter
extends ConstructorStepMethodFilter {
    private final BreakpointStepMethodFilter myMethodFilter;

    public ClassInstanceMethodFilter(PsiMethod psiMethod, Range<Integer> lines) {
        super(psiMethod.getContainingClass(), lines);
        this.myMethodFilter = new AnonymousClassMethodFilter(psiMethod, this.getCallingExpressionLines());
    }

    @Override
    public int onReached(SuspendContextImpl context, RequestHint hint) {
        StackFrameProxyImpl proxy = context.getFrameProxy();
        if (proxy != null) {
            try {
                StepIntoBreakpoint breakpoint;
                ObjectReference reference = proxy.thisObject();
                if (reference != null && (breakpoint = DebuggerManagerEx.getInstanceEx(context.getDebugProcess().getProject()).getBreakpointManager().addStepIntoBreakpoint(this.myMethodFilter)) != null) {
                    breakpoint.addInstanceFilter(reference.uniqueID());
                    breakpoint.setInstanceFiltersEnabled(true);
                    DebugProcessImpl.prepareAndSetSteppingBreakpoint(context, breakpoint, hint, true);
                    return -100;
                }
            }
            catch (EvaluateException evaluateException) {
                // empty catch block
            }
        }
        return 0;
    }
}

