/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.render.Renderer;
import com.intellij.debugger.ui.tree.render.ToStringRenderer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.evaluate.XValueCompactPresentation;
import com.intellij.xdebugger.impl.ui.tree.XValueExtendedPresentation;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueTextRendererImpl;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaValuePresentation
extends XValueExtendedPresentation
implements XValueCompactPresentation {
    protected final ValueDescriptorImpl myValueDescriptor;

    public JavaValuePresentation(ValueDescriptorImpl valueDescriptor) {
        this.myValueDescriptor = valueDescriptor;
    }

    @Nullable
    public String getType() {
        return this.myValueDescriptor.getIdLabel();
    }

    public void renderValue(@NotNull XValuePresentation.XValueTextRenderer renderer) {
        if (renderer == null) {
            JavaValuePresentation.$$$reportNull$$$0(0);
        }
        this.renderValue(renderer, null);
    }

    public void renderValue(@NotNull XValuePresentation.XValueTextRenderer renderer, @Nullable XValueNodeImpl node) {
        if (renderer == null) {
            JavaValuePresentation.$$$reportNull$$$0(1);
        }
        boolean compact = node != null;
        String valueText = this.myValueDescriptor.getValueText();
        EvaluateException exception = this.myValueDescriptor.getEvaluateException();
        if (exception != null) {
            String errorMessage = exception.getMessage();
            if (valueText.endsWith(errorMessage)) {
                renderer.renderValue(valueText.substring(0, valueText.length() - errorMessage.length()));
            }
            renderer.renderError(errorMessage);
        } else {
            JavaValue container;
            if (compact && node.getValueContainer() instanceof JavaValue && (container = (JavaValue)node.getValueContainer()).getDescriptor().isArray()) {
                String typeName;
                ArrayReference value2 = (ArrayReference)container.getDescriptor().getValue();
                ArrayType type2 = (ArrayType)container.getDescriptor().getType();
                if (type2 != null && (TypeConversionUtil.isPrimitive((String)(typeName = type2.componentTypeName())) || "java.lang.String".equals(typeName))) {
                    int size = value2.length();
                    int max = Math.min(size, "java.lang.String".equals(typeName) ? 5 : 10);
                    List<Value> values = value2.getValues(0, max);
                    ArrayList<String> vals = new ArrayList<String>(max);
                    for (int i = 0; i < values.size(); ++i) {
                        vals.add(StringUtil.first((String)values.get(i).toString(), (int)15, (boolean)true));
                    }
                    String more = "";
                    if (vals.size() < size) {
                        more = ", + " + (size - vals.size()) + " more";
                    }
                    renderer.renderValue("{" + StringUtil.join(vals, (String)", ") + more + "}");
                    return;
                }
            }
            if (this.myValueDescriptor.isString()) {
                renderer.renderStringValue(valueText, "\"", 1000);
                return;
            }
            String value3 = JavaValuePresentation.truncateToMaxLength(valueText);
            Renderer lastRenderer = this.myValueDescriptor.getLastLabelRenderer();
            if (lastRenderer instanceof ToStringRenderer) {
                if (!((ToStringRenderer)lastRenderer).isShowValue(this.myValueDescriptor, this.myValueDescriptor.getStoredEvaluationContext())) {
                    return;
                }
                value3 = StringUtil.wrapWithDoubleQuote((String)value3);
            }
            renderer.renderValue(value3);
        }
    }

    @NotNull
    public String getSeparator() {
        boolean emptyAfterSeparator = !this.myValueDescriptor.isShowIdLabel() && this.isValueEmpty();
        String declaredType = this.myValueDescriptor.getDeclaredTypeLabel();
        if (!StringUtil.isEmpty((String)declaredType)) {
            String string = emptyAfterSeparator ? declaredType : declaredType + " " + " = ";
            if (string == null) {
                JavaValuePresentation.$$$reportNull$$$0(2);
            }
            return string;
        }
        return emptyAfterSeparator ? "" : " = ";
    }

    public boolean isModified() {
        return this.myValueDescriptor.isDirty();
    }

    private boolean isValueEmpty() {
        MyEmptyContainerChecker checker = new MyEmptyContainerChecker();
        this.renderValue((XValuePresentation.XValueTextRenderer)new XValueTextRendererImpl((ColoredTextContainer)checker));
        return checker.isEmpty;
    }

    private static String truncateToMaxLength(@NotNull String value2) {
        if (value2 == null) {
            JavaValuePresentation.$$$reportNull$$$0(3);
        }
        return value2.substring(0, Math.min(value2.length(), 1000));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/engine/JavaValuePresentation";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/engine/JavaValuePresentation";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeparator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "renderValue";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "truncateToMaxLength";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyEmptyContainerChecker
    implements ColoredTextContainer {
        boolean isEmpty = true;

        private MyEmptyContainerChecker() {
        }

        public void append(@NotNull String fragment, @NotNull SimpleTextAttributes attributes) {
            if (fragment == null) {
                MyEmptyContainerChecker.$$$reportNull$$$0(0);
            }
            if (attributes == null) {
                MyEmptyContainerChecker.$$$reportNull$$$0(1);
            }
            if (!fragment.isEmpty()) {
                this.isEmpty = false;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fragment";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "attributes";
                    break;
                }
            }
            objectArray[1] = "com/intellij/debugger/engine/JavaValuePresentation$MyEmptyContainerChecker";
            objectArray[2] = "append";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

