/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.BreakpointStepMethodFilter;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.openapi.application.ReadAction;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.util.Range;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import org.jetbrains.annotations.Nullable;

public class LambdaMethodFilter
implements BreakpointStepMethodFilter {
    private final PsiLambdaExpression myLambda;
    private final int myLambdaOrdinal;
    @Nullable
    private final SourcePosition myFirstStatementPosition;
    private final int myLastStatementLine;
    private final Range<Integer> myCallingExpressionLines;

    public LambdaMethodFilter(PsiLambdaExpression lambda2, int expressionOrdinal, Range<Integer> callingExpressionLines) {
        this.myLambda = lambda2;
        this.myLambdaOrdinal = expressionOrdinal;
        this.myCallingExpressionLines = callingExpressionLines;
        SourcePosition firstStatementPosition = null;
        SourcePosition lastStatementPosition = null;
        PsiElement body2 = lambda2.getBody();
        if (body2 instanceof PsiCodeBlock) {
            PsiStatement[] statements = ((PsiCodeBlock)body2).getStatements();
            if (statements.length > 0 && (firstStatementPosition = SourcePosition.createFromElement((PsiElement)statements[0])) != null) {
                PsiStatement lastStatement = statements[statements.length - 1];
                lastStatementPosition = SourcePosition.createFromOffset((PsiFile)firstStatementPosition.getFile(), (int)lastStatement.getTextRange().getEndOffset());
            }
        } else if (body2 != null) {
            firstStatementPosition = SourcePosition.createFromElement((PsiElement)body2);
        }
        this.myFirstStatementPosition = firstStatementPosition;
        this.myLastStatementLine = lastStatementPosition != null ? lastStatementPosition.getLine() : -1;
    }

    public int getLambdaOrdinal() {
        return this.myLambdaOrdinal;
    }

    @Override
    @Nullable
    public SourcePosition getBreakpointPosition() {
        return this.myFirstStatementPosition;
    }

    @Override
    public int getLastStatementLine() {
        return this.myLastStatementLine;
    }

    @Override
    public boolean locationMatches(DebugProcessImpl process2, Location location) {
        SourcePosition position;
        Method method = location.method();
        if (DebuggerUtilsEx.isLambda(method) && (!process2.getVirtualMachineProxy().canGetSyntheticAttribute() || method.isSynthetic()) && (position = process2.getPositionManager().getSourcePosition(location)) != null) {
            return (Boolean)ReadAction.compute(() -> DebuggerUtilsEx.inTheMethod(position, (PsiElement)this.myLambda));
        }
        return false;
    }

    @Override
    @Nullable
    public Range<Integer> getCallingExpressionLines() {
        return this.myCallingExpressionLines;
    }
}

