/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.engine.FieldReferringObject;
import com.intellij.debugger.engine.ReferringObject;
import com.intellij.debugger.engine.SimpleReferringObject;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.util.containers.ContainerUtil;
import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ReferringObjectsProvider {
    public static final ReferringObjectsProvider BASIC_JDI = new ReferringObjectsProvider(){

        @Override
        @NotNull
        public List<ReferringObject> getReferringObjects(@NotNull EvaluationContextImpl evaluationContext, @NotNull ObjectReference value2, long limit) {
            if (evaluationContext == null) {
                1.$$$reportNull$$$0(0);
            }
            if (value2 == null) {
                1.$$$reportNull$$$0(1);
            }
            List list = ContainerUtil.map(value2.referringObjects(limit), x -> this.asReferringObject((ObjectReference)x, value2));
            if (list == null) {
                1.$$$reportNull$$$0(2);
            }
            return list;
        }

        private ReferringObject asReferringObject(@NotNull ObjectReference referrer, @NotNull ObjectReference referee) {
            Field field;
            if (referrer == null) {
                1.$$$reportNull$$$0(3);
            }
            if (referee == null) {
                1.$$$reportNull$$$0(4);
            }
            if ((field = this.findField(referee, referrer)) != null) {
                return new FieldReferringObject(referrer, field);
            }
            return new SimpleReferringObject(referrer);
        }

        @Nullable
        private Field findField(@NotNull Value value2, @NotNull ObjectReference reference) {
            if (value2 == null) {
                1.$$$reportNull$$$0(5);
            }
            if (reference == null) {
                1.$$$reportNull$$$0(6);
            }
            for (Field field : reference.referenceType().allFields()) {
                if (reference.getValue(field) != value2) continue;
                return field;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "evaluationContext";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/debugger/engine/ReferringObjectsProvider$1";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "referrer";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "referee";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/debugger/engine/ReferringObjectsProvider$1";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReferringObjects";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getReferringObjects";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "asReferringObject";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "findField";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };

    @NotNull
    public List<ReferringObject> getReferringObjects(@NotNull EvaluationContextImpl var1, @NotNull ObjectReference var2, long var3) throws EvaluateException;
}

