/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.AssignmentEvaluator;
import com.intellij.debugger.engine.evaluation.expression.DisableGC;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.ForStatementEvaluatorBase;
import com.intellij.debugger.engine.evaluation.expression.IdentityEvaluator;
import com.intellij.debugger.engine.evaluation.expression.MethodEvaluator;
import com.intellij.debugger.engine.evaluation.expression.Modifier;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;

public class ForeachStatementEvaluator
extends ForStatementEvaluatorBase {
    private final Evaluator myIterationParameterEvaluator;
    private final Evaluator myIterableEvaluator;
    private Evaluator myConditionEvaluator;
    private Evaluator myNextEvaluator;
    private int myArrayLength = -1;
    private int myCurrentIndex = 0;
    private Modifier myModifier;

    public ForeachStatementEvaluator(Evaluator iterationParameterEvaluator, Evaluator iterableEvaluator, Evaluator bodyEvaluator, String labelName) {
        super(labelName, bodyEvaluator);
        this.myIterationParameterEvaluator = iterationParameterEvaluator;
        this.myIterableEvaluator = DisableGC.create(iterableEvaluator);
    }

    @Override
    public Modifier getModifier() {
        return this.myModifier;
    }

    @Override
    protected Object evaluateInitialization(EvaluationContextImpl context, Object value2) throws EvaluateException {
        final Object iterable = this.myIterableEvaluator.evaluate(context);
        if (!(iterable instanceof ObjectReference)) {
            throw new EvaluateException("Unable to do foreach for" + iterable);
        }
        IdentityEvaluator iterableEvaluator = new IdentityEvaluator((Value)iterable);
        if (iterable instanceof ArrayReference) {
            this.myCurrentIndex = 0;
            this.myArrayLength = ((ArrayReference)iterable).length();
            this.myNextEvaluator = new AssignmentEvaluator(this.myIterationParameterEvaluator, new Evaluator(){

                @Override
                public Object evaluate(EvaluationContextImpl context) throws EvaluateException {
                    return ((ArrayReference)iterable).getValue(ForeachStatementEvaluator.this.myCurrentIndex++);
                }
            });
        } else {
            Object iterator = new MethodEvaluator(iterableEvaluator, null, "iterator", null, new Evaluator[0]).evaluate(context);
            IdentityEvaluator iteratorEvaluator = new IdentityEvaluator((Value)iterator);
            this.myConditionEvaluator = new MethodEvaluator(iteratorEvaluator, null, "hasNext", null, new Evaluator[0]);
            this.myNextEvaluator = new AssignmentEvaluator(this.myIterationParameterEvaluator, new MethodEvaluator(iteratorEvaluator, null, "next", null, new Evaluator[0]));
        }
        return value2;
    }

    private boolean isArray() {
        return this.myArrayLength > -1;
    }

    @Override
    protected Object evaluateCondition(EvaluationContextImpl context) throws EvaluateException {
        if (this.isArray()) {
            return this.myCurrentIndex < this.myArrayLength;
        }
        Object res = this.myConditionEvaluator.evaluate(context);
        this.myModifier = this.myConditionEvaluator.getModifier();
        return res;
    }

    @Override
    protected void evaluateBody(EvaluationContextImpl context) throws EvaluateException {
        this.myNextEvaluator.evaluate(context);
        super.evaluateBody(context);
    }
}

