/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.TypeEvaluator;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;

class InstanceofEvaluator
implements Evaluator {
    private static final Logger LOG = Logger.getInstance(InstanceofEvaluator.class);
    private final Evaluator myOperandEvaluator;
    private final TypeEvaluator myTypeEvaluator;

    InstanceofEvaluator(Evaluator operandEvaluator, TypeEvaluator typeEvaluator) {
        this.myOperandEvaluator = operandEvaluator;
        this.myTypeEvaluator = typeEvaluator;
    }

    @Override
    public Object evaluate(EvaluationContextImpl context) throws EvaluateException {
        Value value2 = (Value)this.myOperandEvaluator.evaluate(context);
        if (value2 == null) {
            return context.getDebugProcess().getVirtualMachineProxy().mirrorOf(false);
        }
        if (!(value2 instanceof ObjectReference)) {
            throw EvaluateExceptionUtil.createEvaluateException((String)JavaDebuggerBundle.message((String)"evaluation.error.object.reference.expected", (Object[])new Object[0]));
        }
        try {
            return context.getDebugProcess().getVirtualMachineProxy().mirrorOf(DebuggerUtilsImpl.instanceOf(((ObjectReference)value2).referenceType(), this.myTypeEvaluator.evaluate(context)));
        }
        catch (Exception e) {
            LOG.debug((Throwable)e);
            throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
        }
    }

    public String toString() {
        return this.myOperandEvaluator + " instanceof " + this.myTypeEvaluator;
    }
}

